<?php
/*
 * Copyright (c) 2025 AltumCode (https://altumcode.com/)
 *
 * This software is licensed exclusively by AltumCode and is sold only via https://altumcode.com/.
 * Unauthorized distribution, modification, or use of this software without a valid license is not permitted and may be subject to applicable legal actions.
 *
 * 🌍 View all other existing AltumCode projects via https://altumcode.com/
 * 📧 Get in touch for support or general queries via https://altumcode.com/contact
 * 📤 Download the latest version via https://altumcode.com/downloads
 *
 * 🐦 X/Twitter: https://x.com/AltumCode
 * 📘 Facebook: https://facebook.com/altumcode
 * 📸 Instagram: https://instagram.com/altumcode
 */

return [
    'direction' => 'ltr',

    'global.submit' => 'Submit',
    'global.create' => 'Create',
    'global.delete' => 'Delete',
    'global.edit' => 'Edit',
    'global.view' => 'View',
    'global.duplicate' => 'Duplicate',
    'global.transfer' => 'Transfer',
    'global.reset' => 'Reset',
    'global.share' => 'Share',
    'global.share_via' => 'Share via %s',
    'global.cancel' => 'Cancel',
    'global.update' => 'Update',
    'global.enable' => 'Enable',
    'global.hidden' => 'Hidden',
    'global.login' => 'Login',
    'global.language' => 'Language',
    'global.choose_language' => 'Choose language',
    'global.choose_currency' => 'Choose currency',
    'global.theme_style' => 'Switch to %s (CMD/CTRL + I)',
    'global.theme_style_light' => 'Light',
    'global.theme_style_dark' => 'Dark',
    'global.close' => 'Close',
    'global.search' => 'Search',
    'global.no_data' => 'No data available',
    'global.unknown' => 'Unknown',
    'global.none' => 'None',
    'global.yes' => 'Yes',
    'global.no' => 'No',
    'global.status' => 'Status',
    'global.active' => 'Active',
    'global.disabled' => 'Disabled',
    'global.all' => 'All',
    'global.order' => 'Order',
    'global.download' => 'Download',
    'global.download_as' => 'Download as %s',
    'global.export' => 'Export',
    'global.export_to' => 'Export to %s',
    'global.captcha_placeholder' => 'Captcha text',
    'global.loading' => 'Loading..',
    'global.view_more' => 'View more',
    'global.view_x_more' => 'View %s more..',
    'global.clipboard_copy' => 'Copy to clipboard',
    'global.clipboard_copied' => 'Copied!',
    'global.terms_and_conditions' => 'Terms and Conditions',
    'global.privacy_policy' => 'Privacy Policy',
    'global.delete_file' => 'Delete uploaded file',
    'global.remove_selected_file' => 'Remove selected file',
    'global.bulk_actions' => 'Bulk actions',
    'global.unlimited' => 'Unlimited',
    'global.duplicated' => 'Duplicated',
    'global.datetime' => 'Created on',
    'global.last_datetime' => 'Updated on',
    'global.datetime_tooltip' => 'Created on %s',
    'global.last_datetime_tooltip' => 'Updated on %s',
    'global.device' => 'Device',
    'global.device.desktop' => 'Desktop',
    'global.device.tablet' => 'Tablet',
    'global.device.mobile' => 'Mobile',
    'global.continent' => 'Continent',
    'global.continents' => 'Continents',
    'global.country' => 'Country',
    'global.countries' => 'Countries',
    'global.city' => 'City',
    'global.cities' => 'Cities',
    'global.os_name' => 'Operating system',
    'global.browser_name' => 'Browser',
    'global.browser_language' => 'Browser language',
    'global.ip' => 'IP',
    'global.name' => 'Name',
    'global.description' => 'Description',
    'global.title' => 'Title',
    'global.email' => 'Email',
    'global.email_placeholder' => 'hello@example.com',
    'global.password' => 'Password',
    'global.user' => 'User',
    'global.image' => 'Image',
    'global.icon' => 'Icon',
    'global.icon_placeholder' => 'fas fa-bolt',
    'global.icon_help' => '<a href="https://fontawesome.com/search?o=r&m=free" target="_blank">FontAwesome</a> icon class.',
    'global.url' => 'URL',
    'global.url_placeholder' => 'https://example.com/',
    'global.url_slug_placeholder' => 'example',
    'global.host' => 'Host',
    'global.host_placeholder' => 'example.com',
    'global.admin_impersonate_user_help' => 'Logged in as',
    'global.admin_impersonate_user_logout' => 'Exit',
    'global.spintax_help' => 'You can also use Spintax format, as such: <code>{Hi|Hey|Hello}</code> to randomize words or phrases.',
    'global.team_delegate_access_help' => 'Logged in as %1$s via %2$s team.',
    'global.team_delegate_access_logout' => 'Exit',
    'global.update_x' => 'Edit %s',
    'global.mb' => 'MB',
    'global.details' => 'Details',
    'global.type' => 'Type',
    'global.view_all' => 'View all',
    'global.select_all' => 'Select all',
    'global.deselect_all' => 'Deselect all',
    'global.show' => 'Show',
    'global.hide' => 'Hide',
    'global.chart_help' => 'Chart automatically refreshes every %1$s hours. Data from the last %2$s days.',
    'global.id' => 'Entry number (ID)',
    'global.variables' => 'You can use the following dynamic variables: %s.',
    'global.translate' => 'Translate',
    'global.scroll_top' => 'Scroll top',
    'global.scroll_bottom' => 'Scroll bottom',
    'global.no_chart_data' => 'No data available',
    'global.no_chart_data_help' => 'There is not enough data to generate a chart.',
    'global.image_error' => 'Image error',
    'global.spotlight.search_placeholder' => '🔎 Search & go to a page...',
    'global.spotlight.tooltip' => 'Spotlight search (CMD/CTRL + K)',
    'global.drag_and_drop' => 'Drag & drop to reorder',
    'global.crop' => 'Crop image',
    'global.crop_selection' => 'Crop selection',
    'global.no_crop' => 'Continue without cropping',

    'global.custom_css' => 'Custom CSS',
    'global.custom_css_placeholder' => 'body { background: blue !important; }',
    'global.custom_css_help' => 'Your CSS code to modify the already existing page style.',
    'global.custom_js' => 'Custom JS',
    'global.custom_js_help' => 'Your custom JS code to enhance the capability of your page.',
    'global.custom_js_placeholder' => '<script>console.log(`Hello world`);</script>',

    'global.info_message.user_plan_is_expired' => 'Your current plan has expired and your access is now limited.',
    'global.info_message.plan_feature_no_access' => 'Your current plan does not allow you to access this feature.',
    'global.info_message.plan_upgrade' => 'Upgrade your plan 🔐',
    'global.info_message.plan_feature_limit' => 'Your have exceeded the limits of your current plan.',
    'global.info_message.plan_feature_limit_info' => '%1$s out of %2$s used <br /> %3$s remaining',
    'global.info_message.team_no_access' => 'Your team access does not allow you to use this feature.',
    'global.info_message.team_limit' => 'Only the team owner can access this page.',

    'global.success_message.create1' => '%s has been successfully created.',
    'global.success_message.create2' => 'Successfully created.',
    'global.success_message.update1' => '%s has been successfully updated.',
    'global.success_message.update2' => 'Successfully updated.',
    'global.success_message.delete1' => '%s has been successfully deleted.',
    'global.success_message.delete2' => 'Successfully deleted.',

    'global.error_message.directory_not_writable' => 'Directory <strong>%s</strong> is not writable. Please set the CHMOD permissions so this folder can be written.',
    'global.error_message.file_not_writable' => 'File <strong>%s</strong> is not writable . Please set the CHMOD permissions so this file can be written.',
    'global.error_message.empty_fields' => 'You must fill all the required fields.',
    'global.error_message.empty_field' => 'This field is required, you must fill it.',
    'global.error_message.invalid_file_type' => 'You are not allowed to upload files of this type.',
    'global.error_message.file_upload' => 'Something happened while uploading the file and we could not process it.',
    'global.error_message.invalid_csrf_token' => 'The action could not be finished because the protector has expired, please try again.',
    'global.error_message.basic' => 'We could not perform this action.',
    'global.error_message.file_size_limit' => 'The uploaded file is too big, the maximum file size you are allowed to upload is %s MB.',
    'global.error_message.password_length' => 'The password must be between 6 and 64 characters.',
    'global.error_message.passwords_not_matching' => 'The entered passwords do not match.',
    'global.error_message.invalid_email' => 'The entered email is invalid.',
    'global.error_message.invalid_captcha' => 'The entered captcha code is invalid.',
    'global.error_message.function_required' => '<code>%s</code> is required, but your server does not have it enabled. Contact your server administrator.',
    'global.error_message.limit_try_again' => 'You reached the limit. Try again in %1$s %2$s.',

    'global.menu.logout' => 'Logout',
    'global.menu.admin' => 'Admin panel',

    'global.accessibility.toggle_navigation' => 'Toggle navigation',
    'global.accessibility.logo_alt' => 'Website logo',
    'global.accessibility.captcha_alt' => 'Captcha',
    'global.accessibility.captcha_input' => 'Captcha field',
    'global.accessibility.whitelisted_file_extensions' => '%s allowed.',
    'global.accessibility.file_size_limit' => '%s MB maximum.',
    'global.accessibility.admin_file_size_limit_help' => 'You are not able to set a higher limit than your actual server upload limit.',

    'global.pagination.previous' => 'Previous',
    'global.pagination.next' => 'Next',
    'global.pagination.results' => 'Showing %1$s-%2$s out of %3$s results.',

    'global.filters.header' => 'Filters',
    'global.filters.reset' => 'Reset',
    'global.filters.clear' => 'Clear filters',
    'global.filters.search' => 'Search',
    'global.filters.search_by' => 'Search by',
    'global.filters.order_by' => 'Order by',
    'global.filters.order_by_datetime' => 'Created datetime',
    'global.filters.order_by_last_datetime' => 'Updated datetime',
    'global.filters.order_type' => 'Order type',
    'global.filters.order_type_asc' => 'Ascending',
    'global.filters.order_type_desc' => 'Descending',
    'global.filters.results_per_page' => 'Results per page',
    'global.filters.no_data' => 'No filtered data found',
    'global.filters.no_data_help' => 'No matches found for your filter.',

    'global.date.datetime_readable_format' => '%1$s %2$s, %3$s',
    'global.date.datetime_small_format' => '%1$s %2$s, %3$s',
    'global.date.datetime_small_readable_format' => '%1$s %2$s',
    'global.date.datetime_ymd_format' => '%1$s-%2$s-%3$s',
    'global.date.datetime_his_format' => '%1$s:%2$s:%3$s',
    'global.date.datetime_ymd_his_format' => '%1$s-%2$s-%3$s %4$s:%5$s:%6$s',
    'global.date.now' => 'now',
    'global.date.cancel' => 'Cancel',
    'global.date.apply' => 'Apply',
    'global.date.from' => 'From',
    'global.date.to' => 'To',
    'global.date.custom' => 'Custom',
    'global.date.today' => 'Today',
    'global.date.yesterday' => 'Yesterday',
    'global.date.last_7_days' => 'Last 7 days',
    'global.date.last_30_days' => 'Last 30 days',
    'global.date.this_month' => 'This month',
    'global.date.last_month' => 'Last month',
    'global.date.all_time' => 'All time',
    'global.date.short_milliseconds' => 'ms',
    'global.date.short_seconds' => 's',
    'global.date.second' => 'second',
    'global.date.seconds' => 'seconds',
    'global.date.minute' => 'minute',
    'global.date.minutes' => 'minutes',
    'global.date.hour' => 'hour',
    'global.date.hours' => 'hours',
    'global.date.day' => 'day',
    'global.date.days' => 'days',
    'global.date.week' => 'week',
    'global.date.weeks' => 'weeks',
    'global.date.month' => 'month',
    'global.date.months' => 'months',
    'global.date.year' => 'year',
    'global.date.years' => 'years',
    'global.date.time_ago' => '%1$s %2$s ago',
    'global.date.time_until' => '%1$s %2$s',

    'global.date.long_days.1' => 'Monday',
    'global.date.long_days.2' => 'Tuesday',
    'global.date.long_days.3' => 'Wednesday',
    'global.date.long_days.4' => 'Thursday',
    'global.date.long_days.5' => 'Friday',
    'global.date.long_days.6' => 'Saturday',
    'global.date.long_days.7' => 'Sunday',

    'global.date.short_days.1' => 'Mon',
    'global.date.short_days.2' => 'Tue',
    'global.date.short_days.3' => 'Wed',
    'global.date.short_days.4' => 'Thu',
    'global.date.short_days.5' => 'Fri',
    'global.date.short_days.6' => 'Sat',
    'global.date.short_days.7' => 'Sun',

    'global.date.long_months.1' => 'January',
    'global.date.long_months.2' => 'February',
    'global.date.long_months.3' => 'March',
    'global.date.long_months.4' => 'April',
    'global.date.long_months.5' => 'May',
    'global.date.long_months.6' => 'June',
    'global.date.long_months.7' => 'July',
    'global.date.long_months.8' => 'August',
    'global.date.long_months.9' => 'September',
    'global.date.long_months.10' => 'October',
    'global.date.long_months.11' => 'November',
    'global.date.long_months.12' => 'December',

    'global.date.short_months.1' => 'Jan',
    'global.date.short_months.2' => 'Feb',
    'global.date.short_months.3' => 'Mar',
    'global.date.short_months.4' => 'Apr',
    'global.date.short_months.5' => 'May',
    'global.date.short_months.6' => 'Jun',
    'global.date.short_months.7' => 'Jul',
    'global.date.short_months.8' => 'Aug',
    'global.date.short_months.9' => 'Sep',
    'global.date.short_months.10' => 'Oct',
    'global.date.short_months.11' => 'Nov',
    'global.date.short_months.12' => 'Dec',

    'global.number.decimal_point' => '.',
    'global.number.thousands_separator' => ',',

    'global.emails.copyright' => 'Copyright © %1$s %2$s.',
    'global.emails.anti_phishing_code' => 'Anti phishing code: %s',
    'global.emails.is_broadcast' => 'You are receiving this email because you have subscribed to our newsletter broadcasts. You can %sUnsubscribe here%s at any point in time.',

    'global.emails.user_welcome.subject' => 'Welcome to {{WEBSITE_TITLE}}',
    'global.emails.user_welcome.body' => 'Hello, <strong>{{NAME}}</strong>!<br /><br />Welcome to our website community, we\'re excited to have you on board!<br /><br />Get started by visiting our <a href="{{URL}}">homepage</a> or your <a href="{{DASHBOARD_LINK}}">dashboard</a>.<br /><br />Regards,<br />The {{WEBSITE_TITLE}} team.',

    'global.emails.user_activation.subject' => 'Confirm your new account - {{WEBSITE_TITLE}}',
    'global.emails.user_activation.body' => 'Hello, <strong>{{NAME}}</strong>,<br /><br />We are glad you joined us! <br /><br />One more step and your account is ready,<br /><br />Click the link below in order to join <strong>{{WEBSITE_TITLE}}</strong><br /><br /><a href="{{ACTIVATION_LINK}}" class="cta">Activate account</a><br /><br />Regards,<br />The {{WEBSITE_TITLE}} team.',

    'global.emails.user_pending_email.subject' => 'Confirm your email address change - {{WEBSITE_TITLE}}',
    'global.emails.user_pending_email.body' => 'Hello, <strong>{{NAME}}</strong>,<br /><br />You have requested to change your email address from {{CURRENT_EMAIL}} to {{NEW_EMAIL}}. <br /><br />Please click on the link below to confirm your new email address. <br /><br /><a href="{{ACTIVATION_LINK}}" class="cta">Confirm email address change</a><br /><br />Regards,<br />The {{WEBSITE_TITLE}} team.',

    'global.emails.user_lost_password.subject' => 'Reset your password - {{WEBSITE_TITLE}}',
    'global.emails.user_lost_password.body' => 'Hello, <strong>{{NAME}}</strong>,<br /><br />This is your reset password link:<br /><br /><a href="{{LOST_PASSWORD_LINK}}" class="cta">Reset password</a><br /><br />If you did not request this, you can ignore it.<br /><br />Regards,<br />The {{WEBSITE_TITLE}} team.',

    'global.emails.user_payment.subject' => 'Payment received - {{WEBSITE_TITLE}}',
    'global.emails.user_payment.body' => 'Hello, <strong>{{NAME}}</strong>,<br /><br />This is a confirmation that your payment has been received by us.<br /><br />You\'ve paid for the <strong>{{PLAN_NAME}}</strong> plan until <strong>{{PLAN_EXPIRATION_DATE}}</strong>.<br /><br />You can also check all the <a href="{{USER_PAYMENTS_LINK}}">payments</a> you made, <a href="{{USER_PLAN_LINK}}">change your plan</a> or <a href="{{USER_PLAN_LINK}}">cancel it</a>.<br /><br />Regards,<br />The {{WEBSITE_TITLE}} team.',

    'global.emails.user_plan_expiry_reminder.subject' => 'Your plan is expiring in {{DAYS_UNTIL_EXPIRATION}} days - {{WEBSITE_TITLE}}',
    'global.emails.user_plan_expiry_reminder.body' => 'Hello, <strong>{{NAME}}</strong>,<br /><br />This is a simple reminder that your <strong>{{PLAN_NAME}} plan</strong> is going to expire in <strong>{{DAYS_UNTIL_EXPIRATION}} days</strong>.<br /><br />You must renew your plan if you wish to continue using our website with all the features you have.<br /><br /><a href="{{USER_PLAN_RENEW_LINK}}" class="cta">Renew plan</a><br /><br />Regards,<br />The {{WEBSITE_TITLE}} team.',

    'global.emails.user_plan_expired.subject' => 'Your plan has expired - {{WEBSITE_TITLE}}',
    'global.emails.user_plan_expired.body' => 'Hello, <strong>{{NAME}}</strong>,<br /><br />Your <strong>{{PLAN_NAME}} plan</strong> has expired as you haven\'t renewed your membership.<br /><br />If you wish to continue using our website with all the features you had, you will need to renew your membership.<br /><br /><a href="{{USER_PLAN_RENEW_LINK}}" class="cta">Renew plan</a><br /><br />Regards,<br />The {{WEBSITE_TITLE}} team.',

    'global.emails.user_deletion_reminder.subject' => 'Your account will be deleted in {{DAYS_UNTIL_DELETION}} days - {{WEBSITE_TITLE}}',
    'global.emails.user_deletion_reminder.body' => 'Hello, <strong>{{NAME}}</strong>,<br /><br />This is a simple email to remind you that your account is going to be deleted in {{DAYS_UNTIL_DELETION}} days because your account has been inactive.<br /><br />If you wish to cancel this deletion, simply login with your account and the deletion process will be stopped.<br /><br /><a href="{{LOGIN_LINK}}">Login & stop deletion</a><br /><br />Regards,<br />The {{WEBSITE_TITLE}} team.',

    'global.emails.auto_delete_inactive_users.subject' => 'Your account has been deleted - {{WEBSITE_TITLE}}',
    'global.emails.auto_delete_inactive_users.body' => 'Hello, <strong>{{NAME}}</strong>,<br /><br />This is a simple email to let you know that your account has been deleted because of being inactive for more than {{INACTIVITY_DAYS}} days.<br /><br />If you wish to re-gain access, you would need to sign-up another account with us.<br /><br /><a href="{{REGISTER_LINK}}" class="cta">Register again</a><br /><br />Regards,<br />The {{WEBSITE_TITLE}} team.',

    'global.emails.user_affiliate_withdrawal_approved.subject' => 'Affiliate withdrawal approved - {{WEBSITE_TITLE}}',
    'global.emails.user_affiliate_withdrawal_approved.body' => 'Hello, <strong>{{NAME}}</strong>,<br /><br />This is a confirmation that your recent affiliate withdrawal of <strong>{{AMOUNT}} {{CURRENCY}}</strong> has been approved and your payment was sent for processing.<br /><br />Regards,<br />The {{WEBSITE_TITLE}} team.',

    'global.emails.team_member_create.subject' => 'You\'ve been invited to \'{{TEAM:NAME}}\' team - {{WEBSITE_TITLE}}',
    'global.emails.team_member_create.body_login' => 'Hello,<br /><br />You have been invited by <strong>{{USER:NAME}}</strong> ({{USER:EMAIL}}) to join the <strong>{{TEAM:NAME}}</strong> team on {{WEBSITE_TITLE}}.<br /><br />Click here to <a href="{{LOGIN_LINK}}">login and accept the invitation</a>.<br /><br />Regards,<br />The {{WEBSITE_TITLE}} team.',
    'global.emails.team_member_create.body_register' => 'Hello,<br /><br />You have been invited by <strong>{{USER:NAME}}</strong> ({{USER:EMAIL}}) to join the <strong>{{TEAM:NAME}}</strong> team on {{WEBSITE_TITLE}}.<br /><br />Click here to <a href="{{REGISTER_LINK}}">register and accept the invitation</a>.<br /><br />Regards,<br />The {{WEBSITE_TITLE}} team.',

    'global.emails.admin_new_user_notification.subject' => 'New user registered - {{WEBSITE_TITLE}}',
    'global.emails.admin_new_user_notification.body' => 'Welcome to <strong>{{NAME}}</strong> ({{EMAIL}}) to your website!',

    'global.emails.admin_delete_user_notification.subject' => 'User deleted his account - {{WEBSITE_TITLE}}',
    'global.emails.admin_delete_user_notification.body' => 'All data of <strong>{{NAME}}</strong> ({{EMAIL}}) has been deleted.',

    'global.emails.admin_new_payment_notification.subject' => 'New payment via {{PROCESSOR}} of {{TOTAL_AMOUNT}} {{CURRENCY}} - {{WEBSITE_TITLE}}',
    'global.emails.admin_new_payment_notification.body' => '<strong>{{NAME}}</strong> ({{EMAIL}}) user just paid <strong>{{TOTAL_AMOUNT}} {{CURRENCY}}</strong> to your website!<br /><br />Here\'s to more earnings!',

    'global.emails.admin_new_affiliate_withdrawal_notification.subject' => 'New affiliate withdrawal request for {{TOTAL_AMOUNT}} {{CURRENCY}} - {{WEBSITE_TITLE}}',
    'global.emails.admin_new_affiliate_withdrawal_notification.body' => '<strong>{{NAME}}</strong> ({{EMAIL}}) user just submitted an affiliate withdrawal request for <strong>{{TOTAL_AMOUNT}} {{CURRENCY}}</strong> with the following note: "{{AFFILIATE_WITHDRAWAL_NOTE}}".<br /><br /><a href="{{ADMIN_AFFILIATE_WITHDRAWAL_LINK}}">View affiliate withdrawal</a>',

    'global.emails.admin_new_domain_notification.subject' => 'New custom domain is pending approval - {{WEBSITE_TITLE}}',
    'global.emails.admin_new_domain_notification.body' => '<strong>{{NAME}}</strong> ({{EMAIL}}) user\'s custom domain ({{DOMAIN_HOST}}) is now pending approval.<br /><br /> <a href="{{ADMIN_DOMAIN_UPDATE_LINK}}">View domain</a>',

    'global.emails.admin_contact.subject' => '{{SUBJECT}} - {{NAME}} - {{WEBSITE_TITLE}}',
    'global.emails.admin_contact.body' => '<strong>{{NAME}}</strong> - {{EMAIL}} has sent you the following message:<br /><br />{{MESSAGE}}',


    'global.notifications.new_user.title' => 'New user!',
    'global.notifications.new_user.description' => '<strong>%1$s</strong> (%2$s) has signed up successfully.',

    'global.notifications.delete_user.title' => 'User deleted!',
    'global.notifications.delete_user.description' => '<strong>%1$s</strong> (%2$s) has deleted his account.',

    'global.notifications.new_payment.title' => 'New payment!',
    'global.notifications.new_payment.description' => '<strong>%1$s</strong> (%2$s) user just paid <strong>%3$s %4$s</strong> via %5$s.',

    'global.notifications.new_affiliate_withdrawal.title' => 'New affiliate withdrawal request!',
    'global.notifications.new_affiliate_withdrawal.description' => '<strong>%1$s</strong> (%2$s) user just submitted an affiliate withdrawal request for <strong>%3$s %4$s</strong>.',

    'global.notifications.new_newsletter_subscriber.title' => 'New newsletter subscriber!',
    'global.notifications.new_newsletter_subscriber.description' => '<strong>%1$s</strong> (%2$s) has subscribed successfully.',


    'global.cookie_consent.menu' => 'Cookies',
    'global.cookie_consent.header' => 'We use cookies 🍪',
    'global.cookie_consent.subheader' => 'Hi, this website uses essential cookies to ensure its proper operation and tracking cookies to understand how you interact with it. The latter will be set only after consent.',
    'global.cookie_consent.modal.preferences.header' => 'Cookie preferences',
    'global.cookie_consent.modal.header' => 'Cookie usage 📢',
    'global.cookie_consent.modal.subheader' => 'We use cookies to ensure the basic functionalities of the website and to enhance your online experience. You can choose for each category to opt-in/out whenever you want. For more details relative to cookies and other sensitive data, please read the full <a href="%s" class="cc-link">privacy policy</a>.',
    'global.cookie_consent.modal.necessary.header' => 'Strictly necessary cookies',
    'global.cookie_consent.modal.necessary.subheader' => 'These cookies are essential for the proper functioning of my website. Without these cookies, the website would not work properly.',
    'global.cookie_consent.modal.analytics.header' => 'Performance and Analytics cookies',
    'global.cookie_consent.modal.analytics.subheader' => 'These cookies allow the website to remember the choices you have made in the past.',
    'global.cookie_consent.modal.targeting.header' => 'Advertisement and Targeting cookies',
    'global.cookie_consent.modal.targeting.subheader' => 'These cookies collect information about how you use the website, which pages you visited and which links you clicked on. All of the data is anonymized and cannot be used to identify you.',
    'global.cookie_consent.accept_all' => 'Accept all',
    'global.cookie_consent.reject_all' => 'Reject all',
    'global.cookie_consent.customize' => 'Customize',
    'global.cookie_consent.save' => 'Save settings',

    'global.footer.copyright' => 'Copyright &copy; %1$s %2$s.',

    'global.plan_settings.annual_price_savings' => 'You save %s by purchasing the annual plan',
    'global.plan_settings.monitors_limit' => '%s monitors',
    'global.plan_settings.monitors_check_intervals' => 'Check intervals: %s',
    'global.plan_settings.monitors_ping_servers' => '%s Ping locations',
    'global.plan_settings.monitors_ping_servers_help' => 'Use any of the following ping locations for your monitoring: %s',
    'global.plan_settings.heartbeats_limit' => '%s heartbeats',
    'global.plan_settings.domain_names_limit' => '%s domain names',
    'global.plan_settings.dns_monitors_limit' => '%s DNS monitors',
    'global.plan_settings.dns_monitors_check_intervals' => 'DNS check intervals: %s',
    'global.plan_settings.server_monitors_limit' => '%s server monitors',
    'global.plan_settings.server_monitors_check_intervals' => 'Server check intervals: %s',
    'global.plan_settings.status_pages_limit' => '%s status pages',
    'global.plan_settings.projects_limit' => '%s projects',
    'global.plan_settings.domains_limit' => '%s custom domains',
    'global.plan_settings.teams_limit' => '%s teams',
    'global.plan_settings.team_members_limit' => '%s team members',
    'global.plan_settings.notification_handlers_limit' => 'Multiple notification handlers',
    'global.plan_settings.notification_handlers_email_limit' => '%s email handlers',
    'global.plan_settings.notification_handlers_webhook_limit' => '%s webhook handlers',
    'global.plan_settings.notification_handlers_slack_limit' => '%s Slack handlers',
    'global.plan_settings.notification_handlers_discord_limit' => '%s Discord handlers',
    'global.plan_settings.notification_handlers_microsoft_teams_limit' => '%s Microsoft Teams handlers',
    'global.plan_settings.notification_handlers_twilio_limit' => '%s SMS handlers',
    'global.plan_settings.notification_handlers_twilio_call_limit' => '%s Phone call handlers',
    'global.plan_settings.notification_handlers_telegram_limit' => '%s Telegram handlers',
    'global.plan_settings.notification_handlers_whatsapp_limit' => '%s Whatsapp handlers',
    'global.plan_settings.notification_handlers_x_limit' => '%s X handlers',
    'global.plan_settings.notification_handlers_push_subscriber_id_limit' => '%s Push subscribers handlers',
    'global.plan_settings.notification_handlers_internal_notification_limit' => '%s Internal notifications',
    'global.plan_settings.logs_retention' => '%s data retention',
    'global.plan_settings.statistics_retention' => '%s status pages statistics retention',
    'global.plan_settings.additional_domains' => '%s additional domains',
    'global.plan_settings.additional_domains_help' => 'You get to choose from other domains when creating your status page. %s',
    'global.plan_settings.password_protection_is_enabled' => 'Password protection',
    'global.plan_settings.password_protection_is_enabled_help' => 'Your status pages can be password protected if needed.',
    'global.plan_settings.analytics_is_enabled' => 'Included analytics',
    'global.plan_settings.analytics_is_enabled_help' => 'Great status page analytics to see how many visitors you get.',
    'global.plan_settings.qr_is_enabled' => 'QR code builder',
    'global.plan_settings.qr_is_enabled_help' => 'Custom Status Page QR code builder.',
    'global.plan_settings.removable_branding_is_enabled' => 'Removable branding',
    'global.plan_settings.removable_branding_is_enabled_help' => 'Your status pages will not have any of our branding on them anymore.',
    'global.plan_settings.custom_url_is_enabled' => 'Custom back-half URL',
    'global.plan_settings.custom_url_is_enabled_help' => 'You will be able to customize the link URL of your status pages.',
    'global.plan_settings.search_engine_block_is_enabled' => 'Block search engine indexing',
    'global.plan_settings.search_engine_block_is_enabled_help' => 'You will be able to block SE (like Google) from indexing your status pages.',
    'global.plan_settings.custom_css_is_enabled' => 'Custom CSS',
    'global.plan_settings.custom_css_is_enabled_help' => 'Add your custom CSS code to modify the already existing page style.',
    'global.plan_settings.custom_js_is_enabled' => 'Custom JS',
    'global.plan_settings.custom_js_is_enabled_help' => 'Add your custom JS code to enhance the capability of your page.',
    'global.plan_settings.email_reports_is_enabled' => 'Email reports',
    'global.plan_settings.email_reports_is_enabled_help' => 'Get frequent email updates about your monitors.',
    'global.plan_settings.custom_pwa_is_enabled' => 'Custom PWA app',
    'global.plan_settings.custom_pwa_is_enabled_help' => 'Generate a custom PWA app for all of your vcard pages.',
    'global.plan_settings.api_is_enabled' => 'API access',
    'global.plan_settings.api_is_enabled_help' => 'Get access to use the REST API.',
    'global.plan_settings.white_labeling_is_enabled' => 'White labeling',
    'global.plan_settings.white_labeling_is_enabled_help' => 'White label your whole account title, logo, favicon and footer.',
    'global.plan_settings.affiliate_commission_percentage' => '%s affiliate percentage',
    'global.plan_settings.affiliate_commission_percentage_help' => 'The percentage amount that you can earn with the affiliate program.',
    'global.plan_settings.no_ads' => 'No ads',
    'global.plan_settings.no_ads_help' => 'No ads for everything related to your account and experience.',
    'global.plan_settings.export' => '%s export features',


    'pwa_install.header' => 'Install our app 🪄',
    'pwa_install.or' => 'or',
    'pwa_install.subheader.desktop' => 'click on the <code>%s</code> icon in the top right of the address bar.',
    'pwa_install.subheader.android_chrome' => 'tap on the <code>%s</code> menu and then tap the <code>%s Add to Home screen</code> menu item.',
    'pwa_install.subheader.ios' => 'tap on the <code>%s</code> icon and then tap the <code>%s Add to Home Screen</code> menu item.',
    'pwa_install.subheader.ios_safari' => 'click on the <code>File > Add to Dock</code> menu item of the browser.',


    'push_notifications_modal.menu' => 'Push notifications',
    'push_notifications_modal.header' => 'Push notifications',
    'push_notifications_modal.subheader' => 'You can subscribe to our web push notifications if you want to receive helpful content and non-spam promotions from us.',
    'push_notifications_modal.subscribe' => 'Subscribe',
    'push_notifications_modal.unsubscribe' => 'Unsubscribe',
    'push_notifications_modal.denied' => 'You have denied or disabled push notifications. You must enable them again from the browser settings in order to be able to subscribe.',
    'push_notifications_modal.incompatible' => 'Your browser window is incompatible with receiving push notifications.',


    'ad_blocker_detector_modal.header' => 'Ad blocker detected',
    'ad_blocker_detector_modal.subheader' => 'We serve ads so we can keep our website running. Please disable your ad blockers.',
    'ad_blocker_detector_modal.button' => 'I\'ve disabled the ad blocker',


    'duplicate_modal.header' => 'Duplicate',
    'duplicate_modal.subheader' => 'Easily duplicate this resource with a click of a button.',


    'delete_modal.header' => 'Delete',
    'delete_modal.subheader1' => 'Deleting <strong>%s</strong> cannot be undone.',
    'delete_modal.subheader2' => 'Deleting this cannot be undone.',


    'transfer_modal.header' => 'Transfer ownership',
    'transfer_modal.subheader1' => 'Transfer <strong>%s</strong> to another user account.',
    'transfer_modal.subheader2' => 'Transfer this resource to another user account.',
    'transfer_modal.success_message' => 'The ownership of %1$s has been transferred from %2$s to %3$s',


    'statistics_reset_modal.header' => 'Clear statistics',
    'statistics_reset_modal.subheader' => 'Clear the current selected statistics. This action cannot be undone.',

    'x_reset_modal.header' => 'Reset',
    'x_reset_modal.subheader' => 'Reset the state of the resource and clear all it\'s associated logs or statistics. This action cannot be undone.',


    'bulk_download_modal.header' => 'Download in bulk',
    'bulk_download_modal.subheader' => 'You\'ve selected multiple entries to be downloaded, this may take a while for the ZIP to be generated.',


    'bulk_delete_modal.header' => 'Delete in bulk',
    'bulk_delete_modal.subheader' => 'You\'ve selected multiple entries to be deleted, this may take a while & it action cannot be undone.',
    'bulk_delete_modal.success_message' => 'The bulk deletion process was performed successfully.',


    'page.breadcrumb' => 'Page',
    'page.print' => 'Print',
    'page.estimated_reading_time' => '%s read',
    'page.total_views' => '%s views',


    'pages.title' => 'Pages',
    'pages.header' => 'Resources center',
    'pages.subheader' => 'Here you can find useful page resources depending on your needs.',
    'pages.index.breadcrumb' => 'Pages',
    'pages.index.popular_pages' => 'Popular pages',
    'pages.index.pages_categories.header' => 'Categories',
    'pages.index.pages_categories.total_pages' => '%s available pages',
    'pages.pages_category.breadcrumb' => 'Pages category',
    'pages.no_data' => 'There are resources yet',
    'pages.no_data_help' => 'We still got some work to do for our resources section',


    'blog.title' => 'Blog',
    'blog.title_search' => 'Search for \'%s\' - Blog',
    'blog.breadcrumb' => 'Blog',
    'blog.menu' => 'Blog',
    'blog.header' => 'Blog',
    'blog.header_search' => 'Blog - Search for \'%s\'',
    'blog.subheader' => 'Discover insights through our curated blog posts.',
    'blog.rss' => 'RSS Feed',
    'blog.categories' => 'Categories',
    'blog.popular' => 'Popular posts',
    'blog.total_views' => '%s views',
    'blog.estimated_reading_time' => '%s read',
    'blog.blog_post.title' => '%s - Blog',
    'blog.blog_posts_category.title' => '%s - Category - Blog',
    'blog.rating' => '%1$s of %2$s ratings',
    'blog.no_data' => 'There are no blog posts yet',
    'blog.no_data_help' => 'We still got some writing to do for our blog post',


    'plan.breadcrumb' => 'Choose plan',
    'plan.title' => 'Plan',
    'plan.menu' => 'Pricing',
    'plan.header_new' => 'Choose your plan',
    'plan.subheader_new' => 'Select the most convenient plan for you.',
    'plan.header_renew' => 'Renew or change your plan',
    'plan.subheader_renew' => 'Select one plan to renew or change your subscription.',
    'plan.header_upgrade' => 'Upgrade your plan',
    'plan.subheader_upgrade' => 'Select one package to upgrade your subscription.',

    'plan.custom_plan.monthly' => 'Monthly',
    'plan.custom_plan.quarterly' => 'Quarterly',
    'plan.custom_plan.biannual' => 'Biannual',
    'plan.custom_plan.annual' => 'Annual',
    'plan.custom_plan.lifetime' => 'Lifetime',

    'plans.choose' => 'Choose plan',
    'plans.renew' => 'Renew plan',
    'plans.trial' => 'Try for %s days',
    'plans.contact' => 'Contact us',
    'plans.lifetime' => 'Lifetime',

    'plan.why.header' => 'Why us?',
    'plan.why.subheader' => '',
    'plan.why.one.header' => 'Customer service',
    'plan.why.one.subheader' => 'Our support team will help you with any questions you may have regarding our service.',
    'plan.why.two.header' => 'Privacy',
    'plan.why.two.subheader' => 'You control all the data that you bring within your account on our website.',
    'plan.why.three.header' => 'Quality',
    'plan.why.three.subheader' => 'We focus on delivering the best experience to you, as we fully understand how valuable time is.',

    'plan.faq.header' => 'Frequently asked questions',
    'plan.faq.one.question' => 'What forms of payment do you accept?',
    'plan.faq.one.answer' => 'We accept payments via credit cards, PayPal & crypto as well.',
    'plan.faq.two.question' => 'Can I cancel my subscription?',
    'plan.faq.two.answer' => 'Yes, you definitely can cancel your subscription and, you will still have access to all the features that you already paid for until the end of paid date range.',
    'plan.faq.three.question' => 'Will I get an invoice?',
    'plan.faq.three.answer' => 'Yes, an invoice will be automatically generated for you after any payments from your account.',
    'plan.faq.four.question' => 'Can I have a refund?',
    'plan.faq.four.answer' => 'We do offer refunds in case something goes wrong or you change your mind, simply contact us if needed.',


    'pay_billing.breadcrumb' => 'Billing',
    'pay_billing.title' => 'Billing',
    'pay_billing.header' => 'Fill in your billing details',
    'pay_billing.subheader' => 'We require your billing details for generating proper invoices & for tax handling, provide valid billing details only.',
    'pay_billing.submit' => 'Update & continue to %s checkout',


    'pay.breadcrumb' => '%s plan',
    'pay.title' => 'Pay - %s',
    'pay.attention_title' => '✨Checkout ready 🔥',
    'pay.plan_details' => 'What you\'ll get',
    'pay.accept' => 'By continuing with your order you confirm that you read, understand & agree to the %1$s and %2$s of the site.',

    'pay.free.free_already' => 'You already have the free plan activated.',
    'pay.free.other_plan_not_expired' => 'Your current plan is not expired yet, you will get the free plan after it expires.',

    'pay.trial.header' => 'Start the %s plan',
    'pay.trial.subheader' => 'You are almost there, no strings attached.',
    'pay.trial.trial_start' => 'Start my %s days trial',
    'pay.trial.trial_skip' => 'Skip trial',

    'pay.custom_plan.header' => 'Purchase the %s plan',
    'pay.custom_plan.subheader' => 'You are almost there, complete the following form and checkout.',
    'pay.custom_plan.paypal' => 'PayPal',
    'pay.custom_plan.stripe' => 'Stripe',
    'pay.custom_plan.offline_payment' => 'Offline payment',
    'pay.custom_plan.coinbase' => 'Coinbase',
    'pay.custom_plan.payu' => 'PayU',
    'pay.custom_plan.iyzico' => 'Iyzico',
    'pay.custom_plan.paystack' => 'Paystack',
    'pay.custom_plan.razorpay' => 'Razorpay',
    'pay.custom_plan.mollie' => 'Mollie',
    'pay.custom_plan.yookassa' => 'Yookassa',
    'pay.custom_plan.crypto_com' => 'Crypto.com',
    'pay.custom_plan.paddle' => 'Paddle',
    'pay.custom_plan.mercadopago' => 'MercadoPago',
    'pay.custom_plan.midtrans' => 'Midtrans',
    'pay.custom_plan.flutterwave' => 'Flutterwave',
    'pay.custom_plan.lemonsqueezy' => 'Lemonsqueezy',
    'pay.custom_plan.myfatoorah' => 'Myfatoorah',
    'pay.custom_plan.payment_frequency' => 'Payment frequency',
    'pay.custom_plan.monthly' => 'Monthly payments',
    'pay.custom_plan.quarterly' => 'Quarterly payments',
    'pay.custom_plan.biannual' => 'Biannual payments',
    'pay.custom_plan.annual' => 'Annual payments',
    'pay.custom_plan.annual_savings' => '%1$s %2$s',
    'pay.custom_plan.lifetime' => 'Lifetime deal',
    'pay.custom_plan.lifetime_help' => 'One time payment',
    'pay.custom_plan.code_button' => 'Use discount code',
    'pay.custom_plan.code' => 'Code',
    'pay.custom_plan.payment_processor' => 'Payment method',
    'pay.custom_plan.no_processor' => 'There are no payment processors available at the moment.',
    'pay.custom_plan.offline_payment_instructions' => 'Payment instructions',
    'pay.custom_plan.offline_payment_proof' => 'Proof of payment',
    'pay.custom_plan.payment_type' => 'Type of payment',
    'pay.custom_plan.one_time_type' => 'One time payment',
    'pay.custom_plan.recurring_type' => 'Recurring payment',

    'pay.custom_plan.summary.header' => 'Order summary',
    'pay.custom_plan.summary.plan' => 'Plan',
    'pay.custom_plan.summary.payment_frequency' => 'Frequency',
    'pay.custom_plan.summary.monthly' => 'Monthly',
    'pay.custom_plan.summary.monthly_help' => 'Every 30 days',
    'pay.custom_plan.summary.quarterly' => 'Quarterly',
    'pay.custom_plan.summary.quarterly_help' => 'Every 90 days',
    'pay.custom_plan.summary.biannual' => 'Biannual',
    'pay.custom_plan.summary.biannual_help' => 'Every 180 days',
    'pay.custom_plan.summary.annual' => 'Yearly',
    'pay.custom_plan.summary.annual_help' => 'Every 365 days',
    'pay.custom_plan.summary.lifetime' => 'Lifetime',
    'pay.custom_plan.summary.lifetime_help' => '',
    'pay.custom_plan.summary.payment_processor' => 'Paid with',
    'pay.custom_plan.summary.payment_type' => 'Type',
    'pay.custom_plan.summary.one_time' => 'One time',
    'pay.custom_plan.summary.one_time_help' => '',
    'pay.custom_plan.summary.recurring' => 'Recurring',
    'pay.custom_plan.summary.recurring_help' => 'Automatic billing',
    'pay.custom_plan.summary.plan_price' => 'Price',
    'pay.custom_plan.summary.discount' => 'Discount',
    'pay.custom_plan.summary.tax_inclusive' => 'Inclusive',
    'pay.custom_plan.summary.tax_exclusive' => 'Exclusive',
    'pay.custom_plan.summary.total' => 'Total',
    'pay.custom_plan.pay' => 'Checkout',
    'pay.custom_plan.code_redeemable' => 'Redeem %s days for free.',

    'pay.success_message.code' => 'Applied code for %s.',

    'pay.error_message.code_invalid' => 'This code is invalid.',
    'pay.error_message.code_used' => 'You have already used this code.',
    'pay.error_message.canceled_payment' => 'It seems you\'ve canceled the payment for some reason.',
    'pay.error_message.failed_payment' => 'Something didn\'t work quite right, please try again and if this persists contact the site admin.',
    'pay.error_message.offline_payment_proof_missing' => 'You must upload a payment proof before submitting the payment order.',

    'pay_thank_you.title' => 'Thank you',
    'pay_thank_you.header' => 'Thank you!',
    'pay_thank_you.button' => 'Go to my dashboard',
    'pay_thank_you.plan_trial_start' => 'Your %s day trial period just started!',
    'pay_thank_you.plan_redeemed' => 'You redeemed %s days!',
    'pay_thank_you.plan_custom_will_start' => 'Your payment was sent and your new membership will be activated!',
    'pay_thank_you.plan_custom_pending' => 'Your payment order was sent and your new membership will be activated if the proof will be accepted!',


    'account.title' => 'Account',
    'account.menu' => 'Account',

    'account.plan.header' => '%s plan',
    'account.plan.subheader' => 'ends on %s',
    'account.plan.upgrade_plan' => 'Upgrade plan',
    'account.plan.renew_plan' => 'Renew or change plan',

    'account.settings.header' => 'Settings',
    'account.settings.subheader' => 'Main settings of your account.',
    'account.settings.avatar' => 'Avatar',
    'account.settings.timezone' => 'Timezone',
    'account.settings.timezone_help' => 'Your preferred way of displaying dates.',
    'account.settings.anti_phishing_code' => 'Anti phishing code',
    'account.settings.anti_phishing_code_help' => 'You\'ll get this code on each email that we send you, so you\'ll know it\'s a valid email from us.',
    'account.settings.is_newsletter_subscribed' => 'Newsletter subscribed',
    'account.settings.is_newsletter_subscribed_help' => 'Receive a few emails per month with updates & discount campaigns we may run. We won\'t spam you.',
    'account.settings.referral_key' => 'Referral key',

    'account.billing.header' => 'Billing details',
    'account.billing.subheader' => 'These billing details are used when generating invoices after a successful payment.',
    'account.billing.subscription_id_active' => 'You have an active subscription, you can\'t change the billing details until the subscription expires or is cancelled.',
    'account.billing.type' => 'Type',
    'account.billing.type_personal' => 'Personal',
    'account.billing.type_business' => 'Business',
    'account.billing.name' => 'Name',
    'account.billing.address' => 'Address',
    'account.billing.county' => 'County',
    'account.billing.zip' => 'ZIP',
    'account.billing.phone' => 'Phone',
    'account.billing.tax_id' => 'Tax ID',
    'account.billing.notes' => 'Additional notes',
    'account.billing.notes_help' => 'Here you can write additional data that you want to have on your invoices.',

    'account.change_password.header' => 'Change password',
    'account.change_password.subheader' => 'If you do not want to change your password, do not fill any of those fields below.',
    'account.change_password.current_password' => 'Current password',
    'account.change_password.current_password_help' => 'If you do not know your current password, you mut logout and use the lost password functionality to reset it.',
    'account.change_password.new_password' => 'New password',
    'account.change_password.repeat_password' => 'Repeat password',

    'account.twofa.header' => 'Two-factor authentication',
    'account.twofa.subheader' => 'Use a mobile authentication app to get a verification code to enter every time you log in.',
    'account.twofa.is_enabled' => 'Enable Two-factor authentication',
    'account.twofa.qr' => '1. Scan QR Code',
    'account.twofa.qr_help' => 'Open your authentication app (ex: Authy, Google Authenticator) on your mobile device and scan the QR code using your camera.',
    'account.twofa.secret' => 'Can\'t scan the QR Code?',
    'account.twofa.secret_help' => 'Copy the following secret code into your app for a manual setup.',
    'account.twofa.verify' => '2. Enter freshly generated token',
    'account.twofa.verify_help' => 'To confirm that you setup your code properly, enter the 6-digit token from your mobile app.',

    'account.info_message.user_pending_email' => 'An email confirmation was sent to the new email address. Make sure to check and confirm it via email.',
    'account.error_message.invalid_current_password' => 'Your current password is not valid.',
    'account.error_message.twofa_check' => 'The token that you entered is not valid.',
    'account.error_message.referral_key_exists' => 'This referral key is already in use.',
    'account.success_message.account_updated' => 'Your account was updated.',
    'account.success_message.password_updated' => 'Your account password was updated.',


    'account_preferences.title' => 'Preferences',
    'account_preferences.menu' => 'Preferences',
    'account_preferences.header' => 'Preferences',
    'account_preferences.subheader' => 'Here you can set different preferences for your account related to the site usage.',
    'account_preferences.success_message' => 'Your account preferences have been updated.',
    'account_preferences.avatar' => 'Avatar',
    'account_preferences.tracking_settings' => 'Tracking settings',
    'account_preferences.excluded_ips' => 'Excluded IPs',
    'account_preferences.excluded_ips_help' => 'Exclude IPs from being tracked. Comma separated values.',
    'account_preferences.default_settings' => 'Default settings',
    'account_preferences.default_results_per_page' => 'Default results per page',
    'account_preferences.default_order_type' => 'Default results order',
    'account_preferences.default_order_by_x' => '%s default order by',
    'account_preferences.white_labeling' => 'White labeling settings',
    'account_preferences.white_label_title' => 'White label title',
    'account_preferences.white_label_logo_light' => 'White label logo light',
    'account_preferences.white_label_logo_dark' => 'White label logo dark',
    'account_preferences.white_label_favicon' => 'White label favicon',
    'account_preferences.dashboard' => 'Dashboard settings',
    'account_preferences.dashboard_features' => 'Dashboard features',


    'account_delete.title' => 'Delete account',
    'account_delete.menu' => 'Delete account',
    'account_delete.header' => 'Delete account',
    'account_delete.subheader' => 'By deleting the account, all of your stored data will be deleted. This action is irreversible once done.',
    'account_delete.current_password' => 'Current Password',
    'account_delete.error_message.invalid_current_password' => 'Your current password is not valid.',
    'account_delete.success_message' => 'Your account was fully deleted. We\'re sorry to see you go.',


    'account_redeem_code.title' => 'Redeem code',
    'account_redeem_code.menu' => 'Redeem code',
    'account_redeem_code.header' => 'Redeem code',
    'account_redeem_code.subheader' => 'If you own a redeeming code for a particular plan, you can redeem it right here.',
    'account_redeem_code.plan_id' => 'Plan',
    'account_redeem_code.code' => 'Code',
    'account_redeem_code.success_message' => 'You redeemed %1$s days of the %2$s plan.',
    'account_redeem_code.success_message_lifetime' => 'You redeemed the %2$s plan for lifetime.',
    'account_redeem_code.info_message' => 'Your current plan will be overwritten if you redeem a code that is different than your already existing plan.',
    'account_redeem_code.error_message.code_invalid' => 'This code is invalid.',
    'account_redeem_code.error_message.code_used' => 'You have already used this code.',


    'account_plan.title' => 'Account Plan',
    'account_plan.menu' => 'Plan',
    'account_plan.header' => 'Account Plan',

    'account_plan.plan.renews' => 'Plan will renew on %1$s via %2$s (%3$s %4$s)',
    'account_plan.plan.expires' => 'Plan ends on %s',
    'account_plan.plan.lifetime' => 'Plan is for lifetime, it does not expire.',

    'account_plan.cancel.header' => 'Cancel subscription',
    'account_plan.cancel.subheader' => 'By cancelling your subscription no further payments will be made. You will still have access to your features that you paid for until the expiration date.',
    'account_plan.cancel.cancel' => 'Cancel subscription',
    'account_plan.cancel.confirm_message' => 'Are you sure you want to cancel your subscription?',
    'account_plan.cancel.reason' => 'Cancelled from %s',

    'account_plan.success_message.subscription_canceled' => 'Your recurring subscription was canceled.',


    'account_payments.title' => 'Account payments',
    'account_payments.menu' => 'Payments',
    'account_payments.header' => 'Account payments',
    'account_payments.subheader' => 'All the payments made on your account.',

    'account_payments.payment_processor' => 'Processor',
    'account_payments.total_amount' => 'Total amount',
    'account_payments.plan_id' => 'Plan',
    'account_payments.invoice' => 'Invoice',
    'account_payments.status_pending' => 'Pending approval',
    'account_payments.status_approved' => 'Approved',
    'account_payments.no_data' => 'No payments found',

    'account_payments.processor' => 'Processor',
    'account_payments.type_one_time' => 'One time',
    'account_payments.type_recurring' => 'Recurring',
    'account_payments.frequency' => 'Frequency',
    'account_payments.order_by_total_amount' => 'Total amount',


    'account_logs.title' => 'Account logs',
    'account_logs.menu' => 'Logs',
    'account_logs.header' => 'Account logs',
    'account_logs.subheader' => 'A list of your most important recorded activity.',

    'account_logs.logs.no_data' => 'Your account has no recorded logs',
    'account_logs.logs.no_data_help' => 'Here you will be able to find important log entries regarding your account.',


    'account_api.title' => 'Account API',
    'account_api.menu' => 'API',
    'account_api.header' => 'API',
    'account_api.subheader' => 'Do not share your API key with unauthorized people.',
    'account_api.api_key' => 'API Key',
    'account_api.button' => 'Regenerate API Key',
    'account_api.success_message' => 'Your API key was regenerated successfully.',


    'teams_system.title' => 'Teams system',
    'teams_system.menu' => 'Teams',
    'teams_system.breadcrumb' => 'Teams system',
    'teams_system.header' => 'Teams system',


    'teams.title' => 'My teams',
    'teams.menu' => 'My teams',
    'teams.breadcrumb' => 'My teams',
    'teams.header' => ' My teams',
    'teams.subheader' => 'Create, invite and manage your teams.',
    'teams.create' => 'Create team',
    'teams.table.members' => 'Members',
    'teams.team' => 'Team',
    'teams.no_data' => 'There are no teams available',
    'teams.no_data_help' => 'Start by creating your first team & invite people.',


    'team.breadcrumb' => 'Team',
    'team.title' => 'Team - %s',
    'team.header' => '%s team',


    'team_create.breadcrumb' => 'Create team',
    'team_create.title' => 'Create team',
    'team_create.header' => 'Create team',


    'team_update.breadcrumb' => 'Update team',
    'team_update.title' => 'Update team',
    'team_update.header' => 'Update team',


    'team_members.create' => 'Invite member',
    'team_members.access' => '%s permissions',
    'team_members.access_help' => 'Set what permissions you want to hand out to the user.',
    'team_members.access.read' => 'View',
    'team_members.access.create' => 'Create',
    'team_members.access.update' => 'Update',
    'team_members.access.delete' => 'Delete',
    'team_members.table.member' => 'Member',
    'team_members.table.status_invited' => 'Invited',
    'team_members.table.status_accepted' => 'Accepted',
    'team_members.table.datetime' => 'Invited',
    'team_members.info_message.access' => 'The invited user will not have access to any account related pages, such as the account settings, payments, logs...etc.',
    'team_members.error_message.email_exists' => 'This email is already invited.',
    'team_members.no_data' => 'There are no team members available',
    'team_members.no_data_help' => 'Start by inviting your first member.',


    'team_member_create.breadcrumb' => 'Invite team member',
    'team_member_create.title' => 'Invite team member - %s',
    'team_member_create.header' => 'Invite team member',
    'team_member_create.submit' => 'Invite via Email',
    'team_member_create.success_message' => '%s has been successfully invited.',


    'team_member_update.breadcrumb' => 'Update team member',
    'team_member_update.title' => 'Update team member - %s',
    'team_member_update.header' => 'Update team member',


    'teams_member.title' => 'Teams\' member',
    'teams_member.menu' => 'Teams\' member',
    'teams_member.breadcrumb' => 'Teams\' member',
    'teams_member.header' => ' Teams member',
    'teams_member.subheader' => 'Manage the teams you\'re invited / a member of.',
    'teams_member.table.team' => 'Team',
    'teams_member.table.datetime' => 'Invited',
    'teams_member.no_data' => 'There are no teams available',
    'teams_member.no_data_help' => 'You\'re not invited to any team yet.',


    'teams_member_delete_modal.header' => 'Leave team',
    'teams_member_delete_modal.subheader' => 'This action cannot be undone.',


    'teams_member_join_modal.menu' => 'Join team',
    'teams_member_join_modal.header' => 'Join team',
    'teams_member_join_modal.subheader' => 'Accept & join the invitation of the team.',


    'teams_member_login_modal.menu' => 'Login',
    'teams_member_login_modal.header' => 'Login team',
    'teams_member_login_modal.subheader' => 'Log into the team and start managing it.',


    'referrals.title' => 'Referrals',
    'referrals.menu' => 'Referrals',

    'referrals.invite.header' => 'Invite people',
    'referrals.invite.subheader_once' => 'Invite people to %s with the following link and get %s from their first payment to the platform.',
    'referrals.invite.subheader_forever' => 'Invite people to %s with the following link and get %s from all their payments to the platform.',
    'referrals.invite.referral_key' => 'Referral link',
    'referrals.invite.referral_key_help' => 'You can add the %s parameter to any link of our website.',

    'referrals.statistics.header' => 'Statistics',
    'referrals.statistics.referrals' => 'Referrals',
    'referrals.statistics.referrals_help' => 'People who have signed up using your referral link.',
    'referrals.statistics.converted_referrals' => 'Paying referrals',
    'referrals.statistics.converted_referrals_help' => 'People who have signed up & paid for a plan at least once.',
    'referrals.statistics.pending_affiliate_commissions' => 'Pending commissions',
    'referrals.statistics.pending_affiliate_commissions_help' => 'All payments are held for 30 days for proper confirmation before they are approved.',
    'referrals.statistics.approved_affiliate_commissions' => 'Approved commissions',
    'referrals.statistics.approved_affiliate_commissions_help' => 'All payments that have been approved, which are ready to be withdrawn.',

    'referrals.withdraw.header' => 'Withdraw',
    'referrals.withdraw.subheader' => 'Once you reach at least %s, you can create a withdrawal request.',
    'referrals.withdraw.amount' => 'Amount',
    'referrals.withdraw.is_paid_paid' => 'Paid',
    'referrals.withdraw.is_paid_pending' => 'Pending',
    'referrals.withdraw.success_message' => 'Your withdrawal request has been sent for approval and processing.',


    'sso.menu' => 'Go to %s',


    'invoice.title' => 'Invoice %s',
    'invoice.print' => 'Print',
    'invoice.invoice' => 'Invoice',
    'invoice.invoice_nr' => 'Invoice Nr',
    'invoice.invoice_date' => 'Date',
    'invoice.vendor' => 'Vendor',
    'invoice.customer' => 'Customer',
    'invoice.notes' => 'Additional notes',
    'invoice.name' => 'Name',
    'invoice.address' => 'Address',
    'invoice.county' => 'County',
    'invoice.zip' => 'ZIP',
    'invoice.phone' => 'Phone',
    'invoice.tax_id' => 'Tax ID',

    'invoice.item' => 'Item',
    'invoice.amount' => 'Amount',
    'invoice.plan' => '%s Plan',
    'invoice.frequency' => '%s access.',
    'invoice.frequency.monthly' => '30 days',
    'invoice.frequency.quarterly' => '90 days',
    'invoice.frequency.biannual' => '180 days',
    'invoice.frequency.annual' => '1 year',
    'invoice.frequency.lifetime' => 'Lifetime',
    'invoice.code' => 'Discount',
    'invoice.code_help' => 'Code used: %s',
    'invoice.total' => 'Total',
    'invoice.paid_via' => 'Paid via %s',


    'maintenance.title' => 'Maintenance mode',
    'maintenance.header' => 'Maintenance mode',
    'maintenance.subheader' => 'We are doing some maintenance work, we\'ll be back soon.',


    'login.menu' => 'Sign in',
    'login.title' => 'Sign in',
    'login.header' => 'Sign in',
    'login.twofa_token' => 'Two-factor token',
    'login.remember_me' => 'Remember me',
    'login.remember_me_help' => 'A browser cookie will be used to remember you for %s days on this browser.',
    'login.login' => 'Login',
    'login.verify' => 'Verify',
    'login.register' => 'Don\'t have an account? %s',
    'login.register_help' => 'Register',
    'login.lost_password' => 'Lost password',
    'login.resend_activation' => 'Resend activation',
    'login.facebook' => 'Sign in with Facebook',
    'login.google' => 'Sign in with Google',
    'login.twitter' => 'Sign in with X',
    'login.discord' => 'Sign in with Discord',
    'login.linkedin' => 'Sign in with LinkedIn',
    'login.microsoft' => 'Sign in with Microsoft',
    'login.info_message.twofa_token' => 'Two-factor authentication is required.',
    'login.info_message.logged_in' => 'Welcome back, %s.',
    'login.error_message.twofa_token' => 'Your two-factor authentication token is invalid.',
    'login.error_message.wrong_login_credentials' => 'Your login combination is invalid.',
    'login.error_message.user_not_active' => 'Your account is not confirmed or banned.',
    'login.error_message.email_is_null' => 'Your social account doesn\'t have an email associated with it.',


    'lost_password.title' => 'Lost password',
    'lost_password.header' => 'Lost password',
    'lost_password.subheader' => 'We will send you an email with a magic recovery link to reset your password.',
    'lost_password.return' => 'Return to Login',
    'lost_password.submit' => 'Send me a recovery link',
    'lost_password.success_message' => 'We\'ve emailed you the password reset link.',


    'resend_activation.title' => 'Resend activation',
    'resend_activation.header' => 'Resend activation email',
    'resend_activation.subheader' => 'Mails can get lost, but we can send you another activation email for your account.',
    'resend_activation.return' => 'Return to Login',
    'resend_activation.submit' => 'Send me the activation email',
    'resend_activation.success_message' => 'We\'ve emailed you the activation link.',


    'reset_password.title' => 'Set a new password',
    'reset_password.header' => 'Set a new password',
    'reset_password.subheader' => 'For better security, make sure your new password is strong.',
    'reset_password.return' => 'Return to Login',
    'reset_password.new_password' => 'New password',
    'reset_password.repeat_password' => 'Repeat your new password',
    'reset_password.submit' => 'Set password',
    'reset_password.success_message' => 'Your new password is set.',


    'activate_user.user_activation' => 'Your account has been confirmed and is now active.',
    'activate_user.user_pending_email' => 'Your new email address has been confirmed.',


    'register.title' => 'Sign up',
    'register.menu' => 'Sign up',
    'register.header' => 'Sign up',
    'register.repeat_password' => 'Repeat Password',
    'register.accept' => 'I confirm that I have read and understood the %1$s and %2$s of the site.',
    'register.is_newsletter_subscribed' => 'I agree receive a few emails per month from the newsletter. You can unsubscribe at any time.',
    'register.register' => 'Register',
    'register.login' => 'Already have an account? %s',
    'register.login_help' => 'Sign in',
    'register.error_message.name_length' => 'Name must be between 1 and 64 characters.',
    'register.error_message.email_exists' => 'This email address is already in use.',
    'register.error_message.blacklisted_domain' => 'This email domain has been blacklisted.',
    'register.error_message.blacklisted_country' => 'Your country has been blacklisted.',
    'register.success_message.registration' => 'We\'ve emailed you the activation link.',
    'register.success_message.login' => 'Welcome to our platform, we are grateful to have you here.',


    'dashboard.breadcrumb' => 'Dashboard',
    'dashboard.title' => 'Dashboard',
    'dashboard.menu' => 'Dashboard',
    'dashboard.header' => 'Dashboard',
    'dashboard.monitors.header' => 'Latest monitors',
    'dashboard.heartbeats.header' => 'Latest heartbeats',
    'dashboard.status_pages.header' => 'Latest status pages',
    'dashboard.domain_names.header' => 'Latest domain names',
    'dashboard.dns_monitors.header' => 'Latest DNS monitors',
    'dashboard.server_monitors.header' => 'Latest server monitors',


    'index.breadcrumb' => 'Home',
    'index.menu' => 'Home',
    'index.title' => 'Uptime Monitoring & Status Pages',
    'index.meta_description' => '',
    'index.meta_keywords' => '',
    'index.header' => 'Uptime Monitoring.',
    'index.subheader' => 'Fully-featured & reliable monitoring solution.<br />Websites, servers, domain names, DNS servers & more...',
    'index.get_started' => 'Get started',
    'index.example' => 'Example',
    'index.monitors_image_alt' => 'Screenshot of the app uptime monitor page',
    'index.heartbeats_image_alt' => 'Screenshot of the app heartbeat monitor page',
    'index.domain_names_image_alt' => 'Screenshot of the app domain names list page',
    'index.dns_monitors_image_alt' => 'Screenshot of the app DNS monitor page',
    'index.server_monitors_image_alt' => 'Screenshot of the app server monitor page',
    'index.status_pages_image_alt' => 'Screenshot of the app status page example',
    'index.incidents_image_alt' => 'Screenshot of the app monitors incidents page',
    'index.ping_servers_image_alt' => 'Screenshot of the app ping servers feature',
    'index.custom_requests_image_alt' => 'Screenshot of the app monitor custom HTTP requests feature',
    'index.custom_responses_image_alt' => 'Screenshot of the app monitor custom HTTP responses feature',
    'index.email_notifications_image_alt' => 'Screenshot of the app email alerts feature',
    'index.projects_image_alt' => 'Screenshot of the app projects feature page',
    'index.domains_image_alt' => 'Screenshot of the app custom domains page',

    'index.notifications_handlers.header' => 'Get notified with ease',
    'index.notifications_handlers.subheader' => 'Countless notification integrations for all your needs.',

    'index.api.name' => 'API system',
    'index.api.header' => 'Developer ready',
    'index.api.subheader' => 'Fully featured & easy to use API system for developers.',

    'index.feature.one' => 'Custom domains',
    'index.feature.two' => '%s notification integrations',
    'index.feature.three' => 'Status pages',

    'index.monitors.header' => 'Uptime monitors',
    'index.monitors.subheader' => 'Uptime track your websites, servers and ports availability with ease.',

    'index.heartbeats.header' => 'Heartbeats',
    'index.heartbeats.subheader' => 'Keep track of your Cron jobs and make sure they are actually running.',

    'index.domain_names.header' => 'Domain names',
    'index.domain_names.subheader' => 'Monitor domain names expiration dates and SSL certificates.',

    'index.dns_monitors.header' => 'DNS Monitors',
    'index.dns_monitors.subheader' => 'Get notified when your domain DNS changes, track with ease.',

    'index.server_monitors.header' => 'Server monitors',
    'index.server_monitors.subheader' => 'Keep track of your resources on your devices.',
    'index.server_monitors.cpu' => 'CPU usage and load',
    'index.server_monitors.ram' => 'RAM usage',
    'index.server_monitors.disk' => 'Disk usage',
    'index.server_monitors.notifications' => 'Custom usage alerts',

    'index.status_pages.header' => 'Status pages',
    'index.status_pages.subheader' => 'Display your monitor\'s stats transparently and beautifully to your visitors.',
    'index.status_pages.tracking' => 'Visitors & pageviews analytics',
    'index.status_pages.password' => 'Password protected',
    'index.status_pages.fast' => 'Lightweight, fast & SEO optimized',
    'index.status_pages.advanced' => 'Advanced analytics & customizable pages',

    'index.incidents.header' => 'Incidents',
    'index.incidents.subheader' => 'Get notified instantly when checks fail.',
    'index.incidents.custom' => 'Custom failed checks triggers',
    'index.incidents.notifications' => 'Multiple channels at once',
    'index.incidents.why' => 'Understand why it failed',
    'index.incidents.comment' => 'Leave notes for the incidents',

    'index.tools.header' => '%s useful tools',
    'index.tools.subheader' => 'Web utility tools. Fast, reliable and easy to use.',

    'index.ping_servers.header' => 'Multiple locations',
    'index.ping_servers.subheader' => 'We check your monitors from multiple locations around the world.',

    'index.custom_request.header' => 'Custom HTTP requests',
    'index.custom_request.subheader' => 'Request method, request body, basic auth & custom request headers.',

    'index.custom_response.header' => 'Custom HTTP responses',
    'index.custom_response.subheader' => 'Set & expect a certain response from your monitors.',

    'index.notifications.header' => 'Beautiful email notifications',
    'index.notifications.subheader' => 'Get instant notifications when your tracked services go up or down.',

    'index.custom_domains.header' => 'Custom domains',
    'index.custom_domains.subheader' => 'Connect your own domain or use our predefined ones.',

    'index.projects.header' => 'Projects',
    'index.projects.subheader' => 'Easiest way to categorize your managed resources.',
    'index.stats' => 'We did <span class=\'text-primary-400\'>%1$s checks</span> for a total of <span class=\'text-primary-400\'>%2$s monitors</span>.<br /><br />We also host <span class=\'text-blue-200\'>%3$s status pages</span>.',

    'index.pricing.header' => 'Simple, transparent pricing.',
    'index.pricing.subheader' => 'Choose the plan that is right for you and your budget.',

    'index.cta.header' => 'Get started',
    'index.cta.subheader' => 'Track the uptime of your servers & display their stats on a status page.',
    'index.cta.pricing' => 'Pricing',
    'index.cta.register' => 'Sign up',

    'index.blog.header' => 'Latest %1$sblog%2$s posts',

    'index.testimonials.header' => 'Here\'s what people are saying',
    'index.testimonials.one.text' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit.Ornare ex. Vivamus eu ex non orci condimentum placerat ac ac nisi. Nam velit libero, hendrerit vitae auctor eget, congue ut ante.',
    'index.testimonials.one.name' => 'Andrea',
    'index.testimonials.one.attribute' => 'Writer Magazine',
    'index.testimonials.two.text' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent finibus vestibulum porta. Sed id eros quam. Nunc at nisi vel arcu placerat gravida.',
    'index.testimonials.two.name' => 'George',
    'index.testimonials.two.attribute' => 'Lorem Ipsum Founder',
    'index.testimonials.three.text' => 'Praesent finibus vestibulum porta. Sed id eros quam. Proin lacinia ipsum porttitor, sollicitudin est in, ornare ex. Vivamus eu ex non orci condimentum placerat ac ac nisi. Nam velit libero, hendrerit vitae auctor eget, congue ut ante.',
    'index.testimonials.three.name' => 'Calvin',
    'index.testimonials.three.attribute' => 'SAAS Lorem Owner',

    'index.faq.header' => '%1$sAnswers%2$s for your common %1$squestions%2$s',
    'index.faq.one.question' => 'How do you edit this?',
    'index.faq.one.answer' => 'All the FAQ section can be edited from the admin panel - languages section.',
    'index.faq.two.question' => 'Lorem ipsum dolor sit amet',
    'index.faq.two.answer' => 'Lorem ipsum dolor sit amet, vim eu quem nonumes omittam. Mutat facete patrioque et est, nusquam abhorreant definiebas te sit, albucius urbanitas pro ad. Ne nemore officiis sed. Cu mundi docendi qui, nam nonumes maluisset constituto an, vix ea solum accusamus consequuntur.',
    'index.faq.three.question' => 'Virtute feugiat ocurreret ad cum',
    'index.faq.three.answer' => 'Virtute feugiat ocurreret ad cum, pro in posse ullum adversarium, te qui stet graece antiopam. Amet omnesque indoctum ut mel, ea eam sonet saperet nostrum. Te modus delectus mel, pri populo definitionem ne, an eam hinc labitur inciderint. Novum vivendum gloriatur ex nec, ad vocibus eleifend deterruisset pro, mutat voluptaria repudiandae eum ea. Ipsum soluta cotidieque sea ut, aliquando scripserit no has, iisque impetus erroribus pro ad. Case labitur scaevola vis ut, clita meliore te eos.',
    'index.faq.four.question' => 'Mel iusto putant feugiat et',
    'index.faq.four.answer' => 'Mel iusto putant feugiat et, qui alii virtute eu. Diceret corrumpit mei an. Ius ei congue iudico, ex quo delectus indoctum. Mnesarchum reprehendunt pro ex, ea vix amet maluisset, in autem omnes consectetuer eum.',


    'api.error_message.no_bearer' => 'The request is missing the Bearer Authentication header.',
    'api.error_message.no_access' => 'You do not have access to the API.',
    'api.error_message.rate_limit' => 'You reached the limit of requests in one minute, please wait.',
    'api.error_message.not_found' => 'The resource you are looking for does not exist.',


    'api_documentation.menu' => 'API Documentation',
    'api_documentation.breadcrumb' => 'API Documentation',
    'api_documentation.title' => 'API Documentation',
    'api_documentation.title_dynamic' => '%s - API Documentation',
    'api_documentation.header' => 'API Documentation',
    'api_documentation.subheader' => 'This is the documentation for the available API endpoints, which are built around the <strong>REST architecture</strong>. All the API endpoints will return a <strong>JSON response</strong> with the standard <strong>HTTP response codes</strong> and need a <strong>Bearer Authentication via an API Key</strong>.',
    'api_documentation.endpoint' => 'Endpoint',
    'api_documentation.example' => 'Example',
    'api_documentation.response' => 'Response example',
    'api_documentation.api_key' => 'API Key',
    'api_documentation.base_url' => 'Base URL',
    'api_documentation.parameters' => 'Parameters',
    'api_documentation.required' => 'Required',
    'api_documentation.optional' => 'Optional',
    'api_documentation.string' => 'String',
    'api_documentation.int' => 'Integer',
    'api_documentation.float' => 'Float',
    'api_documentation.boolean' => 'Boolean',
    'api_documentation.file' => 'File',
    'api_documentation.array' => 'Array',
    'api_documentation.read_all' => 'Retrieve all',
    'api_documentation.read' => 'Retrieve one',
    'api_documentation.create' => 'Create',
    'api_documentation.update' => 'Update',
    'api_documentation.delete' => 'Delete',
    'api_documentation.allowed_values' => 'Allowed values: %s',
    'api_documentation.available_when' => 'Available when: %s',
    'api_documentation.timezone_info' => 'All API endpoint results work with the <strong>%s timezone</strong> unless specified otherwise.',

    'api_documentation.authentication.header' => 'Authentication',
    'api_documentation.authentication.subheader' => 'All the API endpoints require an API key sent by the <strong>Bearer Authentication method.</strong>',

    'api_documentation.filters.page' => 'The page number that you want results from. Defaults to <code>1</code>.',
    'api_documentation.filters.results_per_page' => 'How many results you want per page. Allowed values are: %1$s. Defaults to <code>%2$s</code>.',
    'api_documentation.filters.search' => 'The search string.',
    'api_documentation.filters.search_by' => 'What field are you searching by. Allowed values are: %s.',
    'api_documentation.filters.order_by' => 'What field to order the results by. Allowed values are: %s.',
    'api_documentation.filters.order_by_type' => 'The ordering of the results. Allowed values are: <code>ASC</code> for ascending ordering, and <code>DESC</code> for descending ordering.',


    'api_documentation.team_members' => 'Team members',
    'api_documentation.teams_member' => 'Teams\' member',
    'api_documentation.user' => 'User',

    'api_documentation.statistics' => 'Status page statistics',
    'api_documentation.statistics.start_date' => 'Start date in <code>Y-m-d</code> format.',
    'api_documentation.statistics.end_date' => 'End date in <code>Y-m-d</code> format.',

    'api_documentation.notification_handlers' => 'Notification handlers',
    'api_documentation.notifications_handlers_ids' => 'Notification handler ids',


    'contact.breadcrumb' => 'Contact',
    'contact.title' => 'Contact',
    'contact.menu' => 'Contact',
    'contact.header' => 'Contact us',
    'contact.subheader' => 'Get in touch with us via email.',
    'contact.email' => 'Email address',
    'contact.name' => 'Full name',
    'contact.subject' => 'Subject',
    'contact.message' => 'Message',
    'contact.success_message' => 'Your message was sent! We\'ll get back to you shortly.',


    'internal_notifications.breadcrumb' => 'Notifications',
    'internal_notifications.title' => 'Notifications',
    'internal_notifications.menu' => 'Notifications',
    'internal_notifications.header' => 'Notifications',
    'internal_notifications.subheader' => 'All your recent account related notifications.',
    'internal_notifications.no_data' => 'No notifications available',


    'affiliate.breadcrumb' => 'Affiliate',
    'affiliate.title' => 'Affiliate',
    'affiliate.menu' => 'Affiliate',
    'affiliate.header' => 'The affiliates program',
    'affiliate.subheader' => 'Easiest way to earn commission from people that you bring to the platform.',

    'affiliate.commission_percentage.header' => '%s commission',
    'affiliate.commission_percentage.subheader_once' => 'Earn commission from the first payment of any user that you bring to the platform.',
    'affiliate.commission_percentage.subheader_forever' => 'Earn commission from all of the payments of any user that you bring to the platform.',

    'affiliate.minimum_withdrawal_amount.header' => '%s minimum withdrawal',
    'affiliate.minimum_withdrawal_amount.subheader' => 'Once your approved balance reaches the minimum withdrawal amount, you can request a withdrawal.',

    'affiliate.how.header' => 'How does it work?',
    'affiliate.how.one' => 'Sign up',
    'affiliate.how.one_help' => 'Simply register for an account on our platform.',
    'affiliate.how.two' => 'Share your link',
    'affiliate.how.two_help' => 'Start promoting your referral link and bring new users.',
    'affiliate.how.three' => 'Start earning',
    'affiliate.how.three_help' => 'Once your referred users start paying, you\'ll get paid as well.',
    'affiliate.how.four' => 'Withdraw your money',
    'affiliate.how.four_help' => 'Request a withdrawal and you\'ll get paid.',

    'affiliate.cta.header' => 'Start earning money 💰',
    'affiliate.cta.subheader' => 'Create an account and start in just a few minutes.',
    'affiliate.cta.register' => 'Sign up',


    'not_found.title' => 'Not found',
    'not_found.header' => 'Page not found',
    'not_found.subheader' => 'Sorry, we couldn\'t find the page you\'re looking for.',
    'not_found.button' => 'Go back home',


    's_status_page.breadcrumb' => 'Status page',
    's_status_page.resources_status_ok' => 'All systems operational.',
    's_status_page.resources_status_not_ok' => 'We\'re experiencing some trouble.',
    's_status_page.total_not_ok_checks' => '%s failed checks',

    's_status_page.password.title' => 'Password protected status page',
    's_status_page.password.header' => 'Password protected status page',
    's_status_page.password.subheader' => 'You must input the correct password to see the content of the status page. Your password will be remembered for 30 days.',
    's_status_page.password.error_message' => 'The password is incorrect.',
    's_status_page.no_logs' => 'There are no logs available for this date range.',
    's_status_page.timezone' => '🗺️ Data based on the %s timezone.',
    's_status_page.auto_refresh' => '🔄 Page automatically refreshes every %s minutes.',
    's_status_page.toggle_fullscreen' => 'Toggle fullscreen',
    's_status_page.report' => 'Report page',
    's_status_page.report.subject' => 'Report %s page',
    's_status_page.report.message' => 'Write a specific and detailed reason for reporting the page.',

    's_monitor.breadcrumb' => '%s monitor',
    's_monitor.title' => '%1$s - %2$s',
    's_monitor.header' => '%s monitor',
    's_monitor.monitor_status_ok' => '%s is operational.',
    's_monitor.monitor_status_not_ok' => '%s is experiencing some trouble.',
    's_monitor.last_check_datetime' => 'Last checked %s.',
    's_monitor.total_monitor_logs' => '📶 Data based on %s checks.',
    's_monitor.monitor_logs_no_data' => 'There are no logged checks in this time period.',


    's_heartbeat.breadcrumb' => '%s heartbeat',
    's_heartbeat.title' => '%1$s - %2$s',
    's_heartbeat.header' => '%s heartbeat',
    's_heartbeat.heartbeat_status_ok' => '%s is operational.',
    's_heartbeat.heartbeat_status_not_ok' => '%s is experiencing some trouble.',
    's_heartbeat.last_run_datetime' => 'Last ping %s.',
    's_heartbeat.total_heartbeat_logs' => '📶 Data based on %s pings.',
    's_heartbeat.heartbeat_logs_no_data' => 'There are no logged pings in this time period.',


    'incidents.breadcrumb' => 'Incidents',
    'incidents.menu' => 'Incidents',
    'incidents.title' => 'Incidents',
    'incidents.header' => 'Incidents',
    'incidents.subheader' => 'Investigate all the detected issues of your resources.',
    'incidents.start_datetime' => 'Started',
    'incidents.end_datetime' => 'Ended',
    'incidents.end_datetime_null' => 'Ongoing incident!',
    'incidents.last_failed_check_datetime' => 'Last failed check',
    'incidents.length' => 'Length',
    'incidents.comment' => 'Comment',
    'incidents.error' => 'Error',
    'incidents.x_failed_checks' => '%s failed checks',
    'incidents.failed_checks' => 'Failed checks',
    'incidents.no_data_date_range' => 'There are no incidents in this date range.',
    'incidents.solved' => 'Solved',
    'incidents.unsolved' => 'Unsolved',
    'incidents.events' => 'Events',
    'incidents.events.solved' => 'Incident has been solved.',
    'incidents.events.second_error' => 'Issue confirmed after %s seconds',
    'incidents.events.first_error' => 'First issue detected',
    'incidents.events.in_between_errors' => 'Failed %s more checks.',
    'incidents.events.notification_handler' => 'Notified via %s.',
    'incidents.events.no_notification_handlers' => 'No notification handlers set.',
    'incidents.no_data' => 'There are no issues found',
    'incidents.no_data_help' => 'Here you will find all the issues that by your resources.',

    'incident_comment_modal.header' => 'Set incident comment',
    'incident_comment_modal.subheader' => 'Set a note to describe what the incident was about.',


    'incident.breadcrumb' => 'Incident',
    'incident.title' => 'Incident',
    'incident.header' => '%s incident',


    'monitors.breadcrumb' => 'Uptime monitors',
    'monitors.title' => 'Uptime monitors',
    'monitors.menu' => 'Uptime monitors',
    'monitors.header' => 'Uptime monitors',
    'monitors.subheader' => 'A monitor is a process of constantly checking a server or website.',
    'monitors.create' => 'Create monitor',
    'monitors.table.monitor' => 'Monitor',
    'monitors.filters.ping_servers_ids' => 'Ping server',
    'monitors.filters.type' => 'Monitor type',
    'monitors.filters.type_website' => 'Website',
    'monitors.filters.type_ping' => 'Ping',
    'monitors.filters.type_port' => 'Port',
    'monitors.filters.order_by_last_check_datetime' => 'Last checked datetime',
    'monitors.filters.order_by_uptime' => 'Uptime',
    'monitors.filters.order_by_average_response_time' => 'Response time',
    'monitors.no_data' => 'There are no created monitors',
    'monitors.no_data_help' => 'Start by configuring your first monitor.',


    'monitor.breadcrumb' => 'Uptime monitor',
    'monitor.title' => 'Uptime monitor - %s',
    'monitor.menu' => 'Uptime monitor',
    'monitor.header' => '%s uptime monitor',
    'monitor.uptime' => 'Uptime',
    'monitor.downtime' => 'Downtime',
    'monitor.average_response_time' => 'Avg. response time',
    'monitor.total_incidents' => 'Incidents',
    'monitor.downtime_tooltip' => '%s downtime',
    'monitor.last_check_datetime' => 'Last checked',
    'monitor.currently_up_for' => 'Currently up for',
    'monitor.currently_down_for' => 'Currently down for',
    'monitor.check_interval_seconds_tooltip' => 'Checked every %s seconds',
    'monitor.last_not_ok_datetime_tooltip' => 'Last incident on %s',
    'monitor.last_ok_datetime_tooltip' => 'Last up on %s',
    'monitor.total_checks_tooltip' => 'Based on %s total checks',
    'monitor.total_ok_checks_tooltip' => 'Based on %s ok checks',
    'monitor.is_enabled_paused' => 'Monitor is paused',
    'monitor.is_ok' => 'Monitor is up',
    'monitor.is_not_ok' => 'Monitor is down',
    'monitor.pending_check' => 'Pending first check',
    'monitor.response_time_label' => 'Response time',
    'monitor.is_ok_label' => 'Monitor is online',

    'monitor.checks.header' => 'Monitor checks',
    'monitor.checks.last_checks' => 'Last monitor checks',
    'monitor.checks.response_time' => 'Response time',
    'monitor.checks.response_status_code' => 'Response status code',
    'monitor.checks.datetime' => 'Date',
    'monitor.checks.higher_than_average' => '%s higher than the %s average',
    'monitor.checks.lower_than_average' => '%s lower than the %s average',
    'monitor.checks.no_data' => 'There are no logged checks in this time period.',
    'monitor.checks.error' => 'Error',
    'monitor.checks.error.response_header' => 'Response headers do not match the expected ones.',
    'monitor.checks.error.response_status_code' => 'Response status code does not match the expected one.',
    'monitor.checks.error.response_body' => 'Response body does not match the expected one.',
    'monitor.checks.error.ping_failed' => 'Target is unreachable or not responding to ping.',
    'monitor.checks.error.parse_error' => 'Ping response received but could not determine response time.',
    'monitor.checks.error.socket_connect_failed' => 'Unable to establish a socket connection to the target host.',
    'monitor.checks.error.socket_no_response' => 'No response received from the target host via socket connection.',
    'monitor.checks.error.socket_create_failed' => 'Failed to create a network socket for the ping request.',
    'monitor.checks.error.connection_failed' => 'Connection has failed: %s.',
    'monitor.checks.response_body' => 'Response body',

    'monitor.ping_servers_checks.header' => 'Ping locations',
    'monitor.ping_servers_checks.lowest_response_time' => 'Lowest resp. time',
    'monitor.ping_servers_checks.average_response_time' => 'Avg. resp. time',
    'monitor.ping_servers_checks.highest_response_time' => 'Highest resp. time',
    'monitor.ping_servers_checks.ping_server' => 'Location',
    'monitor.ping_servers_checks.total_ok_checks' => '%s ok checks',
    'monitor.ping_servers_checks.no_data' => 'There are no logged checks in this time period.',
    'monitor.ping_servers_checks.self_location' => '%s server location',

    'monitor.input.type' => 'Ping Protocol',
    'monitor.input.type_website' => 'HTTP(s)',
    'monitor.input.type_website_help' => 'Ideal for monitoring websites, APIs and web services.',
    'monitor.input.type_ping' => 'Ping (ICMP)',
    'monitor.input.type_ping_help' => 'Ideal for monitoring a server.',
    'monitor.input.type_port' => 'Host / Port',
    'monitor.input.type_port_help' => 'Ideal for monitoring databases, POP or SMTP servers.',
    'monitor.input.target' => 'Target',
    'monitor.input.target_port' => 'Port',
    'monitor.input.ping_ipv' => 'IP version',
    'monitor.input.is_enabled' => 'Monitoring is active',
    'monitor.input.advanced' => 'Advanced settings',
    'monitor.input.ping_servers_ids' => 'Ping locations',
    'monitor.input.ping_servers_ids_help' => 'Select the servers that you want to be used to ping your target.',
    'monitor.input.is_ok_notifications' => 'Notifications',
    'monitor.input.is_ok_notifications_help' => 'Get notified when your monitor goes down or back up.',
    'monitor.input.email_reports_is_enabled' => 'Email reports',
    'monitor.input.email_reports_is_enabled_help' => 'Receive frequent email reports about your monitor\'s uptime.',
    'monitor.input.cache_buster_is_enabled' => 'Cache buster',
    'monitor.input.cache_buster_is_enabled_help' => 'Apply a randomized query parameter to the end of the monitored URL to prevent potential cached results. Example: <code>?cache_buster=12345678</code>',
    'monitor.input.verify_ssl_is_enabled' => 'Verify secure connection',
    'monitor.input.verify_ssl_is_enabled_help' => 'Verify the connection of the site and make sure the SSL certificate is secured. You should only disable this for testing purposes.',
    'monitor.input.timeout_seconds' => 'Request timeout',
    'monitor.input.check_interval_seconds' => 'Check interval',
    'monitor.input.check_interval_seconds_help' => 'How often we will check your monitor.',
    'monitor.input.custom_request' => 'Custom request',
    'monitor.input.request_method' => 'Request method',
    'monitor.input.follow_redirects' => 'Follow redirect responses',
    'monitor.input.follow_redirects_help' => 'The potential redirects will be followed until reaching the destination location (up to 5 maximum redirects).',
    'monitor.input.request_body' => 'Request body',
    'monitor.input.request_body_help' => 'You can send your own custom body, form data format or JSON.',
    'monitor.input.request_basic_auth_username' => 'Basic auth username',
    'monitor.input.request_basic_auth_password' => 'Basic auth password',
    'monitor.input.request_headers' => 'Custom request headers',
    'monitor.input.request_header_name' => 'Header name',
    'monitor.input.request_header_value' => 'Header value',
    'monitor.input.request_header_add' => 'Add request header',
    'monitor.input.custom_response' => 'Custom response',
    'monitor.input.custom_response_help' => 'Only adjust these if you want to make sure your website answers with your particular settings.',
    'monitor.input.response_status_code' => 'Response status code(s)',
    'monitor.input.response_status_code_help' => 'The required status code(s) that the response of the request needs to answer with. Comma separated values.',
    'monitor.input.response_body' => 'Response body',
    'monitor.input.response_body_help' => 'In case you expect a certain string to exist in the response of your server.',
    'monitor.input.response_headers' => 'Custom response headers',
    'monitor.input.response_header_name' => 'Header name',
    'monitor.input.response_header_value' => 'Header value',
    'monitor.input.response_header_add' => 'Add response header',
    'monitor.error_message.invalid_target_url' => 'Make sure to insert a valid URL, such as: https://domain.com/',

    'monitor.no_data' => 'We are processing your monitor',
    'monitor.no_data_help' => '%s\'s first check is incoming.',

    'monitor.simple_notification.is_ok' => '%1$s (%2$s) monitor is now UP 🟢.%3$sView details: %4$s 🔗.',
    'monitor.simple_notification.is_not_ok' => '%1$s (%2$s) monitor is now DOWN 🔴.%3$sView details: %4$s 🔗.',
    'monitor.push_notification.is_ok.title' => 'Monitor is UP 🟢',
    'monitor.push_notification.is_not_ok.title' => 'Monitor is DOWN 🔴',
    'monitor.push_notification.description' => '%1$s (%2$s)',


    'monitor_log.breadcrumb' => 'Monitor check',
    'monitor_log.title' => 'Monitor check - %s',
    'monitor_log.header' => '%s monitor check',


    'monitor_logs.breadcrumb' => 'Monitor checks',
    'monitor_logs.title' => 'Monitor checks - %s',
    'monitor_logs.menu' => 'Monitor checks',
    'monitor_logs.header' => '%s monitor checks',
    'monitor_logs.filters.ping_server_id' => 'Ping server',
    'monitor_logs.filters.is_ok' => 'Up',
    'monitor_logs.filters.is_not_ok' => 'Down',


    'monitor_create.breadcrumb' => 'Create monitor',
    'monitor_create.title' => 'Create monitor',
    'monitor_create.header' => 'Create a new monitor',
    'monitor_create.success_message' => 'Your new monitor has been created and is now pending its first check.',


    'monitor_update.breadcrumb' => 'Edit monitor',
    'monitor_update.title' => 'Edit monitor - %s',


    'status_pages.breadcrumb' => 'Status pages',
    'status_pages.title' => 'Status pages',
    'status_pages.menu' => 'Status pages',
    'status_pages.header' => 'Status pages',
    'status_pages.subheader' => 'Share status updates from your monitors or heartbeats via a public or private page.',
    'status_pages.create' => 'Create status page',
    'status_pages.external_url' => 'View status page',
    'status_pages.no_data' => 'There are no created status pages',
    'status_pages.no_data_help' => 'Start by creating your first status page.',

    'status_pages.table.status_page' => 'Status page',
    'status_pages.table.pageviews' => 'Pageviews',


    'status_page.breadcrumb' => 'Status page',
    'status_page.domain_id' => 'Domain',
    'status_page.domain_id_help' => 'Select the domain that you\'d like to use to create your status page with.',
    'status_page.is_main_status_page' => 'Exclusive status page for this custom domain',
    'status_page.is_main_status_page_help' => 'Make this status page to be accessible via the index of this custom domain. Other status pages won\'t be able to be associated with this domain after.',
    'status_page.url' => 'URL Alias',
    'status_page.url_help' => 'The main URL that your status page is going to be able accessed from.',
    'status_page.theme' => 'Theme',
    'status_page.description_help' => 'Short description of your status page.',
    'status_page.monitors_ids' => 'Uptime monitors',
    'status_page.monitors_ids_help' => 'Select the monitors that you want to be shown in this status page.',
    'status_page.heartbeats_ids' => 'Uptime heartbeats',
    'status_page.heartbeats_ids_help' => 'Select the heartbeats that you want to be shown in this status page.',
    'status_page.advanced' => 'Advanced',
    'status_page.password_help' => 'Require visitors to enter a password to see the content of the status page.',
    'status_page.timezone' => 'Timezone',
    'status_page.timezone_help' => 'Main timezone of the status page.',
    'status_page.is_enabled' => 'Status page is active',
    'status_page.is_se_visible' => 'Search engine visibility',
    'status_page.is_se_visible_help' => 'If disabled, the status page will not be indexed by search engines, such as Google or Bing.',
    'status_page.is_removed_branding' => 'Remove branding',
    'status_page.is_removed_branding_help' => 'Enabling this feature will remove our website\'s branding.',
    'status_page.socials' => 'Socials',
    'status_page.website' => 'Website',
    'status_page.website_placeholder' => 'https://yourwebsite.com/',
    'status_page.email' => 'Email',
    'status_page.email_placeholder' => 'hello@example.com',
    'status_page.facebook' => 'Facebook',
    'status_page.facebook_placeholder' => 'your-facebook-page-name',
    'status_page.x' => 'X',
    'status_page.x_placeholder' => 'your-x-username',
    'status_page.youtube' => 'YouTube',
    'status_page.youtube_placeholder' => 'Channel ID',
    'status_page.instagram' => 'Instagram',
    'status_page.instagram_placeholder' => 'your-instagram-username',
    'status_page.threads' => 'Threads',
    'status_page.threads_placeholder' => 'your-threads-username',
    'status_page.customizations' => 'Customizations',
    'status_page.logo' => 'Logo',
    'status_page.logo_help' => 'Your status page logo, recommended 1:1 ratio for the logo.',
    'status_page.favicon' => 'Favicon',
    'status_page.favicon_help' => 'Your status page favicon, recommended 1:1 ratio for the favicon.',
    'status_page.seo' => 'Seo',
    'status_page.title' => 'Page title',
    'status_page.title_help' => 'Completely change the page title to a custom one that you are setting here.',
    'status_page.meta_description' => 'Meta description',
    'status_page.meta_description_help' => 'Set a custom meta description to rank better in search engines.',
    'status_page.meta_keywords' => 'Meta keywords',
    'status_page.opengraph' => 'Opengraph image',
    'status_page.font_family' => 'Font family',
    'status_page.font_size' => 'Font size',
    'status_page.display_share_buttons' => 'Display share buttons',
    'status_page.display_header_text' => 'Display header text',
    'status_page.auto_refresh' => 'Auto refresh',
    'status_page.auto_refresh_help' => 'Set 0 to disable.',
    'status_page.pwa_header' => 'PWA',
    'status_page.pwa_help' => 'Generate an installable Progressive Web App (PWA) that works like a native app on your devices for your status page page.',
    'status_page.pwa_is_enabled' => 'Enable custom PWA app',
    'status_page.pwa_is_enabled_help' => 'Disable to use the main website PWA app (no personalized experience for your users).',
    'status_page.pwa_display_install_bar' => 'Display installation bar',
    'status_page.pwa_display_install_bar_help' => 'Display helper bar that tells your users how to install & access the PWA app.',
    'status_page.pwa_theme_color' => 'Theme color',
    'status_page.pwa_display_install_bar_delay' => 'Delay until bar shows up',
    'status_page.pwa_icon' => 'PWA icon',
    'status_page.pwa_icon_help' => 'Make sure it\'s an icon of 512x512 with transparent background.',

    'status_page.error_message.url_exists' => 'This custom URL already exists.',
    'status_page.error_message.url_minimum_characters' => 'This custom URL is too small. Make sure it has at least %s characters.',
    'status_page.error_message.url_maximum_characters' => 'This custom URL is too big. Make sure it has maximum %s characters.',
    'status_page.error_message.blacklisted_domain' => 'This domain is blacklisted.',
    'status_page.error_message.blacklisted_keyword' => 'This custom URL is blacklisted.',


    'status_page_create.breadcrumb' => 'Create status page',
    'status_page_create.title' => 'Create status page',
    'status_page_create.header' => 'Create a new status page',
    'status_page_create.info' => 'You can set up more details about the status page after the creation.',


    'status_page_update.breadcrumb' => 'Edit status page',
    'status_page_update.title' => 'Edit status page - %s',


    'status_page_statistics.breadcrumb' => 'Statistics',
    'status_page_statistics.title' => 'Status page statistics - %s',
    'status_page_statistics.menu' => 'Statistics',
    'status_page_statistics.header' => '%s statistics',
    'status_page_statistics.pageviews' => 'Pageviews',
    'status_page_statistics.visitors' => 'Visitors',

    'status_page_statistics.overview' => 'Overview',
    'status_page_statistics.overview_help' => '',
    'status_page_statistics.entries' => 'Entries',
    'status_page_statistics.entries_help' => 'All the entries that have been logged in a compact list.',
    'status_page_statistics.latest' => 'Latest entries',
    'status_page_statistics.data_preview' => 'Data preview',
    'status_page_statistics.data_preview_info' => 'Widgets data is based on the last %s entries. Click View more to see all the widget data.',
    'status_page_statistics.continent_code_help' => 'Discover the continents that your visitors are from',
    'status_page_statistics.country_help' => 'Discover the countries that your visitors are from.',
    'status_page_statistics.city_name_from_country' => 'Cities of %s',
    'status_page_statistics.city_name_help' => 'Discover the cities that your visitors are from.',
    'status_page_statistics.os' => 'Operating systems',
    'status_page_statistics.os_help' => 'Discover the operating systems that your visitors are using.',
    'status_page_statistics.browser' => 'Browsers',
    'status_page_statistics.browser_help' => 'Discover the browsers that your visitors are using.',
    'status_page_statistics.language' => 'Languages',
    'status_page_statistics.language_help' => 'Discover the browser languages that your visitors are having.',
    'status_page_statistics.device' => 'Devices',
    'status_page_statistics.device_help' => 'Discover the devices that your visitors are using.',
    'status_page_statistics.referrer_host' => 'Referrers',
    'status_page_statistics.referrer_path' => '%s referrer paths',
    'status_page_statistics.referrer_help' => 'Discover where your traffic is coming from.',
    'status_page_statistics.referrer_direct' => 'Direct',
    'status_page_statistics.referrer_qr' => 'QR Code',
    'status_page_statistics.utms' => 'UTMs',
    'status_page_statistics.utms_help' => 'Discover how your UTM marketing campaigns are performing.',
    'status_page_statistics.utm_medium' => '%s utm mediums',
    'status_page_statistics.utm_campaign' => '%s / %s utm sources',
    'status_page_statistics.hour' => 'Visit hours',
    'status_page_statistics.hour_help' => 'Discover at what hours of the day your visitors are most active.',
    'status_page_statistics.table.os' => 'OS',
    'status_page_statistics.table.device' => 'Device',
    'status_page_statistics.table.browser' => 'Browser',
    'status_page_statistics.table.referrer' => 'Referrer',
    'status_page_statistics.no_data' => 'There are no statistics available for this date range',
    'status_page_statistics.no_data_help' => 'Wait for new traffic or change your date range.',


    'status_page_qr.breadcrumb' => 'Status page QR',
    'status_page_qr.title' => 'Status page QR code - %s',
    'status_page_qr.menu' => 'QR Code',
    'status_page_qr.header' => '%s status page QR code',
    'status_page_qr.subheader' => 'This QR code is meant to be downloaded, printed and placed onto where your status page customers can see and access it.',

    'status_page_qr.configurator.foreground_color' => 'Foreground color',
    'status_page_qr.configurator.background_color' => 'Background color',
    'status_page_qr.configurator.corner_radius' => 'Corner radius',
    'status_page_qr.configurator.type' => 'QR Type',
    'status_page_qr.configurator.type_normal' => 'Normal',
    'status_page_qr.configurator.type_text' => 'Insert custom text',
    'status_page_qr.configurator.type_image' => 'Insert custom logo',
    'status_page_qr.configurator.text' => 'Custom text',
    'status_page_qr.configurator.text_color' => 'Text color',
    'status_page_qr.configurator.text_size' => 'Text size',
    'status_page_qr.configurator.image_size' => 'Image size',
    'status_page_qr.configurator.ecc' => 'Error correction capability',
    'status_page_qr.configurator.ecc_l' => 'L - low (7%)',
    'status_page_qr.configurator.ecc_m' => 'M - medium (15%)',
    'status_page_qr.configurator.ecc_q' => 'Q - high (25%)',
    'status_page_qr.configurator.ecc_h' => 'H - best (30%)',
    'status_page_qr.print' => 'Print',


    'heartbeats.breadcrumb' => 'Heartbeats',
    'heartbeats.title' => 'Heartbeats',
    'heartbeats.menu' => 'Heartbeats',
    'heartbeats.header' => 'Heartbeats',
    'heartbeats.subheader' => 'A heartbeat helps you track your CRON jobs to make sure they run when they are expected to.',
    'heartbeats.create' => 'Create heartbeat',
    'heartbeats.last_run_datetime' => 'Last run %s',
    'heartbeats.filters.order_by_last_run_datetime' => 'Last run datetime',
    'heartbeats.filters.order_by_uptime' => 'Uptime',
    'heartbeats.table.heartbeat' => 'Heartbeat',
    'heartbeats.no_data' => 'There are no created heartbeats',
    'heartbeats.no_data_help' => 'Start by configuring your first heartbeat.',


    'heartbeat.breadcrumb' => 'Heartbeat',
    'heartbeat.title' => 'Heartbeat - %s',
    'heartbeat.menu' => 'Heartbeat',
    'heartbeat.header' => '%s heartbeat',
    'heartbeat.code' => 'Send a <strong>GET</strong> or <strong>POST</strong> request to URL below each time your cronjob runs.',
    'heartbeat.code_execute' => 'Send heartbeat manually',
    'heartbeat.uptime' => 'Uptime',
    'heartbeat.downtime' => 'Downtime',
    'heartbeat.total_incidents' => 'Incidents',
    'heartbeat.downtime_tooltip' => '%s downtime',
    'heartbeat.last_run_datetime' => 'Last run',
    'heartbeat.currently_up_for' => 'Currently up for',
    'heartbeat.currently_down_for' => 'Currently down for',
    'heartbeat.run_interval_seconds_tooltip' => 'Expected to run every %1$s %2$s',
    'heartbeat.last_missed_datetime_tooltip' => 'Last incident on %s',
    'heartbeat.last_run_datetime_tooltip' => 'Last up on %s',
    'heartbeat.total_runs_tooltip' => 'Based on %s total runs',
    'heartbeat.total_missed_runs_tooltip' => 'Based on %s missed runs',
    'heartbeat.pending_run' => 'Pending first run',
    'heartbeat.is_enabled_paused' => 'Heartbeat is paused',
    'heartbeat.is_ok' => 'Heartbeat is up',
    'heartbeat.is_not_ok' => 'Heartbeat is down',
    'heartbeat.checks.error' => 'Error',
    'heartbeat.checks.error.missed' => 'Heartbeat missed at expected time',

    'heartbeat.input.run_interval' => 'Expect a heartbeat every',
    'heartbeat.input.run_interval_grace' => 'Grace period',
    'heartbeat.input.run_interval_grace_help' => 'The time that your cronjob takes to execute, approximately.',
    'heartbeat.input.is_enabled' => 'Heartbeat is active',
    'heartbeat.input.advanced' => 'Advanced settings',
    'heartbeat.input.is_ok_notifications' => 'Notifications',
    'heartbeat.input.is_ok_notifications_help' => 'Get notified when your heartbeat goes down or back up.',
    'heartbeat.input.email_reports_is_enabled' => 'Email reports',
    'heartbeat.input.email_reports_is_enabled_help' => 'Receive frequent email reports about your heartbeat\'s uptime.',
    'heartbeat.input.timeout_seconds' => 'Request timeout',
    'heartbeat.input.check_interval_seconds' => 'Check interval',
    'heartbeat.input.check_interval_seconds_help' => 'How often we will check your heartbeat.',

    'heartbeat.no_data' => 'We are waiting for your first CRON run',
    'heartbeat.no_data_help' => '%s\'s first run is expected!',

    'heartbeat.simple_notification.is_ok' => '%1$s heartbeat is now UP 🟢.%2$sView details: %3$s 🔗.',
    'heartbeat.simple_notification.is_not_ok' => '%1$s heartbeat is now DOWN 🔴.%2$sView details: %3$s 🔗.',
    'heartbeat.push_notification.is_ok.title' => 'Heartbeat is UP 🟢',
    'heartbeat.push_notification.is_not_ok.title' => 'Heartbeat is DOWN 🔴',
    'heartbeat.push_notification.description' => '%1$s (%2$s)',


    'heartbeat_create.breadcrumb' => 'Create heartbeat',
    'heartbeat_create.title' => 'Create heartbeat',
    'heartbeat_create.header' => 'Create a new heartbeat',
    'heartbeat_create.success_message' => 'Your new heartbeat has been created and is now waiting for the first run.',


    'heartbeat_update.breadcrumb' => 'Edit heartbeat',
    'heartbeat_update.title' => 'Edit heartbeat - %s',


    'server_monitors.breadcrumb' => 'Server monitors',
    'server_monitors.title' => 'Server monitors',
    'server_monitors.menu' => 'Server monitors',
    'server_monitors.header' => 'Server monitors',
    'server_monitors.subheader' => 'Track your server resources with ease.',
    'server_monitors.create' => 'Create server monitor',
    'server_monitors.last_log_datetime' => 'Last log %s',
    'server_monitors.filters.order_by_last_log_datetime' => 'Last log datetime',
    'server_monitors.table.server_monitor' => 'Server monitor',
    'server_monitors.no_data' => 'There are no created server monitors',
    'server_monitors.no_data_help' => 'Start by setting up your first monitor.',


    'server_monitor.breadcrumb' => 'Server monitor',
    'server_monitor.title' => 'Server monitor - %s',
    'server_monitor.menu' => 'Server monitor',
    'server_monitor.header' => '%s server monitor',
    'server_monitor.total_logs' => 'Total logs',
    'server_monitor.last_log_datetime' => 'Last log',
    'server_monitor.uptime' => 'Server uptime',
    'server_monitor.network' => 'Network',
    'server_monitor.network_total_download' => 'Total download',
    'server_monitor.network_total_upload' => 'Total upload',
    'server_monitor.network_total_help' => 'Calculated since last startup',
    'server_monitor.network_download' => 'Download',
    'server_monitor.network_upload' => 'Upload',
    'server_monitor.cpu_architecture' => 'CPU Architecture',
    'server_monitor.kernel_name' => 'Kernel name',
    'server_monitor.kernel_version' => 'Kernel version',
    'server_monitor.kernel_release' => 'Kernel release',
    'server_monitor.os_name' => 'OS name',
    'server_monitor.os_version' => 'OS version',
    'server_monitor.cpu_usage' => 'CPU usage',
    'server_monitor.ram_usage' => 'RAM usage',
    'server_monitor.ram_total' => 'RAM total',
    'server_monitor.disk_usage' => 'Disk usage',
    'server_monitor.disk_total' => 'Disk total',
    'server_monitor.cpu_cores_x' => '%s cores',
    'server_monitor.cpu_load' => 'CPU load',
    'server_monitor.cpu_load_1' => 'CPU load 1 minute avg',
    'server_monitor.cpu_load_5' => 'CPU load 5 minutes avg',
    'server_monitor.cpu_load_15' => 'CPU load 15 minute avg',
    'server_monitor.is_enabled' => 'Server monitor is receiving data',
    'server_monitor.is_enabled_paused' => 'Server monitor is paused',
    'server_monitor.pending_log' => 'Server monitor is expecting data',
    'server_monitor.input.server_check_interval_seconds' => 'Check interval',
    'server_monitor.input.server_check_interval_seconds_help' => 'How often will we receive data from your server. If you change this value, you must reinstall the tracking code.',
    'server_monitor.input.target' => 'Identifier',
    'server_monitor.input.target_placeholder' => '12.85.123.987',
    'server_monitor.input.is_enabled' => 'Server monitor is active',
    'server_monitor.input.advanced' => 'Advanced settings',
    'server_monitor.input.notifications' => 'Notifications',
    'server_monitor.input.notifications_help' => 'Get notified when your server usage changes.',
    'server_monitor.input.alerts' => 'Alerts',
    'server_monitor.input.alert_add' => 'Add new alert',
    'server_monitor.input.alert_metric' => 'Metric',
    'server_monitor.input.alert_rule' => 'Rule',
    'server_monitor.input.alert_rule.is_higher' => 'Is higher than',
    'server_monitor.input.alert_rule.is_lower' => 'Is lower than',
    'server_monitor.input.alert_value' => 'Value',
    'server_monitor.input.alert_trigger' => 'Trigger after X checks',
    'server_monitor.input.alert_trigger_help' => 'Only trigger alert rule if the past X checks meet the same rule.',
    'server_monitor.no_data' => 'We are waiting for your first data',
    'server_monitor.no_data_help' => '%s\'s first data is expected!',
    'server_monitor.no_logs' => 'There are no logs on this date',
    'server_monitor.no_logs_help' => 'We\'ve found no data logged on this date for your server monitor.',
    'server_monitor.simple_notification.alert' => '%1$s (%2$s) server monitor %3$s is now at %4$s%%.%5$sView details: %6$s 🔗.',
    'server_monitor.push_notification.title' => '%1$s (%2$s) server monitor',
    'server_monitor.push_notification.description' => '%1$s is now at %2$s%%',

    'server_monitor_install_modal.header' => 'Install code',
    'server_monitor_install_modal.linux' => 'Linux',
    'server_monitor_install_modal.linux_help' => 'Copy & run this code in the terminal of your Linux server.<br /> Your server language must be set to English.',
    'server_monitor_install_modal.macos' => 'MacOS',
    'server_monitor_install_modal.macos_help' => 'Copy & run this code in the terminal of your Mac.<br /> It requires MacOS Big Sur or later & language to be set to English.',
    'server_monitor_install_modal.windows' => 'Windows',
    'server_monitor_install_modal.windows_help' => 'Copy & run this code in PowerShell with admin permissions.<br /> This tracking code requires Windows 10 or 11 & will only track usage of your C drive.',


    'server_monitor_uninstall_modal.header' => 'Uninstall code',
    'server_monitor_uninstall_modal.subheader' => 'You must copy and run this code in the terminal of your Linux server.',


    'server_monitor_create.breadcrumb' => 'Create server monitor',
    'server_monitor_create.title' => 'Create server monitor',
    'server_monitor_create.header' => 'Create a new server monitor',
    'server_monitor_create.success_message' => 'Your new server monitor has been created and is now waiting for the first run.',


    'server_monitor_update.breadcrumb' => 'Edit server monitor',
    'server_monitor_update.title' => 'Edit server monitor - %s',


    'domain_names.breadcrumb' => 'Domain names',
    'domain_names.title' => 'Domain names',
    'domain_names.menu' => 'Domain names',
    'domain_names.header' => 'Domain names',
    'domain_names.subheader' => 'Track the domain name availability and SSL certificate.',
    'domain_names.create' => 'Create domain name',
    'domain_names.table.domain_name' => 'Domain name',
    'domain_names.no_data' => 'There are no created domain names',
    'domain_names.no_data_help' => 'Start by configuring your first domain name.',

    'domain_name.breadcrumb' => 'Domain name',
    'domain_name.title' => 'Domain name - %s',
    'domain_name.menu' => 'Domain name',
    'domain_name.header' => '%s domain name',
    'domain_name.last_check_datetime' => 'Last checked datetime',
    'domain_name.next_check_datetime' => 'Next check in about %s',

    'domain_name.not_registered' => 'This domain is not registered yet.',
    'domain_name.whois' => 'Whois',
    'domain_name.whois_start_datetime' => 'Registered on',
    'domain_name.whois_updated_datetime' => 'Updated on',
    'domain_name.whois_end_datetime' => 'Expires on',
    'domain_name.ssl' => 'SSL',
    'domain_name.ssl_start_datetime' => 'Issued on',
    'domain_name.ssl_end_datetime' => 'Expiring on',
    'domain_name.x_time_left' => '%s left',
    'domain_name.expired_on' => 'Expired on',
    'domain_name.ssl_organization' => 'Organization',
    'domain_name.ssl_common_name' => 'Common name',
    'domain_name.ssl_signature_type' => 'Signature',
    'domain_name.registrar' => 'Registrar',
    'domain_name.total_checks' => 'Total checks',
    'domain_name.nameservers' => 'Nameservers',
    'domain_name.pending_check' => 'Pending check',
    'domain_name.is_enabled_paused' => 'Domain name is paused',
    'domain_name.no_data' => 'We are processing your domain name',
    'domain_name.no_data_help' => '%s\'s first check is incoming.',
    'domain_name.no_data_simple' => 'No data',

    'domain_name.input.name' => 'Name',
    'domain_name.input.target' => 'Domain name',
    'domain_name.input.target_placeholder' => 'example.com',
    'domain_name.input.is_enabled' => 'Domain name checking is active',
    'domain_name.input.advanced' => 'Advanced settings',
    'domain_name.input.whois_notifications' => 'Domain name expiration notifications',
    'domain_name.input.whois_notifications_timing' => 'When to get notified',
    'domain_name.input.whois_notifications_timing_input' => '%s before',
    'domain_name.input.ssl_port' => 'SSL port',
    'domain_name.input.ssl_notifications' => 'SSL expiration notifications',
    'domain_name.input.ssl_notifications_timing' => 'When to get notified',
    'domain_name.input.ssl_notifications_timing_input' => '%s before',


    'domain_name.email_notifications.ssl.title' => 'Your %1$s (%2$s) SSL Certificate is expiring in %3$s days',
    'domain_name.email_notifications.ssl.p1' => 'The %1$s (%2$s) domain name triggered an alert because the SSL Certificate is expiring in %3$s days (%4$s %5$s).',

    'domain_name.email_notifications.whois.title' => 'Your %1$s (%2$s) domain name is expiring in %3$s days',
    'domain_name.email_notifications.whois.p1' => 'The %1$s (%2$s) domain name triggered an alert because it is expiring in %3$s days (%4$s %5$s).',
    'domain_name.email_notifications.notice' => 'You\'re receiving these emails because you activated email reports. You can unsubscribe from the %sdomain name settings%s page.',

    'domain_name.simple_notification.ssl' => 'The %1$s (%2$s) domain name SSL is expiring in %3$s days (%4$s %5$s).%6$sView details: %7$s 🔗.',
    'domain_name.simple_notification.whois' => 'The %1$s (%2$s) domain name is expiring in %3$s days (%4$s %5$s).%6$sView details: %7$s 🔗.',

    'domain_name.push_notification.ssl.title' => 'SSL is expiring',
    'domain_name.push_notification.whois.title' => 'Domain is expiring',
    'domain_name.push_notification.description' => '%1$s (%2$s) is expiring in %3$s days',


    'domain_name_create.breadcrumb' => 'Create domain name',
    'domain_name_create.title' => 'Create domain name',
    'domain_name_create.header' => 'Create a new domain name',
    'domain_name_create.success_message' => 'Your new domain name has been created and is now waiting for the first run.',


    'domain_name_update.breadcrumb' => 'Edit domain name',
    'domain_name_update.title' => 'Edit domain name - %s',


    'dns_monitor_logs.breadcrumb' => 'DNS monitor changes',
    'dns_monitor_logs.title' => 'DNS monitor changes - %s',
    'dns_monitor_logs.menu' => 'DNS monitor changes',
    'dns_monitor_logs.header' => '%s monitor changes',


    'dns_monitors.breadcrumb' => 'DNS monitors',
    'dns_monitors.title' => 'DNS monitors',
    'dns_monitors.menu' => 'DNS monitors',
    'dns_monitors.header' => 'DNS monitors',
    'dns_monitors.subheader' => 'A DNS monitor helps you track your DNS values of any domain and get notified of changes.',
    'dns_monitors.create' => 'Create DNS monitor',
    'dns_monitors.table.dns_monitor' => 'DNS monitor',
    'dns_monitors.no_data' => 'There are no created DNS monitors',
    'dns_monitors.no_data_help' => 'Start by adding your first domain to monitor.',


    'dns_monitor.breadcrumb' => 'DNS Monitor',
    'dns_monitor.title' => 'DNS Monitor - %s',
    'dns_monitor.menu' => 'DNS Monitor',
    'dns_monitor.header' => '%s DNS monitor',
    'dns_monitor.pending_check' => 'Pending first check',
    'dns_monitor.total_checks' => 'Total checks',
    'dns_monitor.total_changes' => 'Total changes',
    'dns_monitor.last_check_datetime' => 'Last check',
    'dns_monitor.last_change_datetime' => 'Last change',
    'dns_monitor.dns_check_interval_seconds_tooltip' => 'Checked every %s seconds',
    'dns_monitor.is_enabled_paused' => 'DNS Monitor is paused',
    'dns_monitor.error_message' => 'We could not retrieve any DNS records for your given host.',
    'dns_monitor.type' => 'Type',
    'dns_monitor.host' => 'Host',
    'dns_monitor.ttl' => 'TTL',
    'dns_monitor.target' => 'Target',
    'dns_monitor.ipv6' => 'IPv6',
    'dns_monitor.priority' => 'Priority',
    'dns_monitor.entries' => 'Entries',
    'dns_monitor.mname' => 'MNAME',
    'dns_monitor.rname' => 'RNAME',
    'dns_monitor.serial' => 'Serial',
    'dns_monitor.refresh' => 'Refresh',
    'dns_monitor.retry' => 'Retry',
    'dns_monitor.expire' => 'Expire',
    'dns_monitor.minimum_ttl' => 'Min. TTL',
    'dns_monitor.flags' => 'Flags',
    'dns_monitor.tag' => 'Tag',
    'dns_monitor.value' => 'Value',
    'dns_monitor.ns' => 'Nameserver',
    'dns_monitor.x_records' => '%s records',

    'dns_monitor.logs.header' => 'DNS monitor changes',
    'dns_monitor.logs.last_checks' => 'Last DNS monitor changes',
    'dns_monitor.logs.datetime' => 'Date',
    'dns_monitor.logs.no_data' => 'There are no logged changes.',

    'dns_monitor.input.target' => 'Domain name',
    'dns_monitor.input.target_placeholder' => 'example.com',
    'dns_monitor.input.dns_check_interval_seconds' => 'Check interval',
    'dns_monitor.input.dns_check_interval_seconds_help' => 'How often we will check your DNS.',
    'dns_monitor.input.dns_types' => 'DNS types',
    'dns_monitor.input.dns_types_help' => 'Select the DNS types you want to query.',
    'dns_monitor.input.is_enabled' => 'DNS Monitor is active',
    'dns_monitor.input.advanced' => 'Advanced settings',
    'dns_monitor.input.notifications' => 'Notifications',
    'dns_monitor.input.notifications_help' => 'Get notified when your DNS changes.',
    'dns_monitor.no_data' => 'We are processing your DNS monitor',
    'dns_monitor.no_data_help' => '%s\'s first check is incoming.',
    'dns_monitor.no_dns_data' => 'We did not find any DNS data for your domain',
    'dns_monitor.no_dns_data_help' => 'This domain is most likely not registered yet.',
    'dns_monitor.added' => 'Added',
    'dns_monitor.removed' => 'Removed',
    'dns_monitor.changed' => 'Changed',
    'dns_monitor.old' => 'Old',
    'dns_monitor.new' => 'New',
    'dns_monitor.simple_notification' => 'The %1$s (%2$s) DNS monitor values have changed.%3$sView details: %4$s 🔗.',
    'dns_monitor.push_notification.title' => 'DNS values changed',
    'dns_monitor.push_notification.description' => '%1$s (%2$s) values changed',

    'dns_monitor_create.breadcrumb' => 'Create DNS monitor',
    'dns_monitor_create.title' => 'Create DNS monitor',
    'dns_monitor_create.header' => 'Create a new DNS monitor',
    'dns_monitor_create.success_message' => 'Your new DNS monitor has been created and is now waiting for the first run.',


    'dns_monitor_update.breadcrumb' => 'Edit DNS monitor',
    'dns_monitor_update.title' => 'Edit DNS monitor - %s',


    'tools.breadcrumb' => 'Web tools',
    'tools.title' => 'Web tools',
    'tools.tool_title' => '%s',
    'tools.tool_title_submission' => '%1$s - %2$s',
    'tools.menu' => 'Tools',
    'tools.header' => 'Tools',
    'tools.subheader' => 'Extra web tools that are helpful and related to the services we provide.',
    'tools.total_views' => 'Total views',
    'tools.total_submissions' => 'Total submissions',
    'tools.popular_tools' => 'Popular tools',
    'tools.similar_tools' => 'Similar tools',
    'tools.share' => 'Share',
    'tools.result' => 'Result',
    'tools.rating' => '%1$s of %2$s ratings',
    'tools.last_submissions' => 'Last submissions',
    'tools.no_data' => 'We haven\'t found any tool named like that.',
    'tools.extra_content' => 'Additional page content: Editable from the admin panel -> languages -> choose or create language -> translate app page.',
    'tools.error_message.url' => 'We could not retrieve any details for your given URL.',

    'tools.dns_lookup.name' => 'DNS Lookup',
    'tools.dns_lookup.description' => 'Find A, AAAA, CNAME, MX, NS, TXT, SOA DNS records of a host.',
    'tools.dns_lookup.meta_keywords' => '',
    'tools.dns_lookup.host' => 'Host',
    'tools.dns_lookup.error_message' => 'We could not retrieve any DNS records for your given host.',
    'tools.dns_lookup.result.host' => 'Host',
    'tools.dns_lookup.result.ttl' => 'TTL',
    'tools.dns_lookup.result.target' => 'Target',
    'tools.dns_lookup.result.ipv6' => 'IPv6',
    'tools.dns_lookup.result.priority' => 'Priority',
    'tools.dns_lookup.result.entries' => 'Entries',
    'tools.dns_lookup.result.mname' => 'MNAME',
    'tools.dns_lookup.result.rname' => 'RNAME',
    'tools.dns_lookup.result.serial' => 'Serial',
    'tools.dns_lookup.result.refresh' => 'Refresh',
    'tools.dns_lookup.result.retry' => 'Retry',
    'tools.dns_lookup.result.expire' => 'Expire',
    'tools.dns_lookup.result.minimum_ttl' => 'Min. TTL',
    'tools.dns_lookup.result.flags' => 'Flags',
    'tools.dns_lookup.result.tag' => 'Tag',
    'tools.dns_lookup.result.value' => 'Value',
    'tools.dns_lookup.result.ns' => 'Nameserver',
    'tools.dns_lookup.result.x_records' => '%s records',
    'tools.dns_lookup.extra_content' => '',

    'tools.ip_lookup.name' => 'IP Lookup',
    'tools.ip_lookup.description' => 'Get approximate IP details.',
    'tools.ip_lookup.meta_keywords' => '',
    'tools.ip_lookup.error_message' => 'We could not retrieve any details for your given IP.',
    'tools.ip_lookup.result.latitude' => 'Latitude',
    'tools.ip_lookup.result.longitude' => 'Longitude',
    'tools.ip_lookup.result.timezone' => 'Timezone',
    'tools.ip_lookup.extra_content' => '',

    'tools.ssl_lookup.name' => 'SSL Lookup',
    'tools.ssl_lookup.description' => 'Get all possible details about an SSL certificate.',
    'tools.ssl_lookup.meta_keywords' => '',
    'tools.ssl_lookup.host' => 'Host',
    'tools.ssl_lookup.port' => 'Port',
    'tools.ssl_lookup.error_message' => 'We could not retrieve any details for your given host.',
    'tools.ssl_lookup.result.organization' => 'Organization',
    'tools.ssl_lookup.result.common_name' => 'Common name',
    'tools.ssl_lookup.result.start_datetime' => 'Issued on',
    'tools.ssl_lookup.result.end_datetime' => 'Expiring on',
    'tools.ssl_lookup.result.signature_type' => 'Signature type',
    'tools.ssl_lookup.extra_content' => '',

    'tools.whois_lookup.name' => 'Whois Lookup',
    'tools.whois_lookup.description' => 'Get all possible details about a domain name.',
    'tools.whois_lookup.meta_keywords' => '',
    'tools.whois_lookup.domain_name' => 'Domain name',
    'tools.whois_lookup.error_message' => 'We could not retrieve any details for your given domain name.',
    'tools.whois_lookup.result.nameservers' => 'Nameservers',
    'tools.whois_lookup.result.registrar' => 'Registrar',
    'tools.whois_lookup.result.start_datetime' => 'Issued on',
    'tools.whois_lookup.result.end_datetime' => 'Expiring on',
    'tools.whois_lookup.result.updated_datetime' => 'Updated on',
    'tools.whois_lookup.extra_content' => '',

    'tools.ping.name' => 'Ping',
    'tools.ping.description' => 'Ping a website, server or port.',
    'tools.ping.meta_keywords' => '',
    'tools.ping.ping_server_id' => 'Ping location',
    'tools.ping.type' => 'Ping Protocol',
    'tools.ping.type_website' => 'HTTP(s)',
    'tools.ping.type_website_help' => 'Ideal for monitoring websites, APIs and web services.',
    'tools.ping.type_ping' => 'Ping (ICMP)',
    'tools.ping.type_ping_help' => 'Ideal for monitoring a server.',
    'tools.ping.type_port' => 'Host / Port',
    'tools.ping.type_port_help' => 'Ideal for monitoring databases, POP or SMTP servers.',
    'tools.ping.target_url' => 'URL',
    'tools.ping.target_host' => 'Host',
    'tools.ping.target_port' => 'Port',
    'tools.ping.error_message' => 'We could not retrieve any details for your given domain name.',
    'tools.ping.result.ping_server_id' => 'Ping Server',
    'tools.ping.result.is_ok' => 'Online',
    'tools.ping.result.is_not_ok' => 'Offline',
    'tools.ping.result.response_time' => 'Response time',
    'tools.ping.result.response_status_code' => 'Response status code',
    'tools.ping.result.error' => 'Error',
    'tools.ping.extra_content' => '',

    'tools.website_text_extractor.name' => 'Website text extractor',
    'tools.website_text_extractor.description' => 'Extract all the text of a website from the source code of the page.',
    'tools.website_text_extractor.meta_keywords' => '',
    'tools.website_text_extractor.error_message' => 'We could not retrieve any details for your given domain name.',
    'tools.website_text_extractor.extra_content' => '',

    'tools.google_cache_checker.name' => 'Google cache checker',
    'tools.google_cache_checker.description' => 'Check if the URL is cached or not by Google.',
    'tools.google_cache_checker.meta_keywords' => '',
    'tools.google_cache_checker.result' => 'Result',
    'tools.google_cache_checker.result.cached' => 'This URL is cached (%s).',
    'tools.google_cache_checker.result.not_cached' => 'This URL is not cached.',
    'tools.google_cache_checker.extra_content' => '',

    'tools.ttfb_checker.name' => 'TTFB checker',
    'tools.ttfb_checker.description' => 'Verify the time to first byte of any website.',
    'tools.ttfb_checker.meta_keywords' => '',
    'tools.ttfb_checker.result' => 'Time to first byte',
    'tools.ttfb_checker.extra_content' => '',

    'tools.website_page_size_checker.name' => 'Website page size checker',
    'tools.website_page_size_checker.description' => 'Check the total size of a web page, including all resources, for performance analysis.',
    'tools.website_page_size_checker.meta_keywords' => '',
    'tools.website_page_size_checker.result' => 'Page size',
    'tools.website_page_size_checker.extra_content' => '',

    'tools.meta_tags_checker.name' => 'Meta tags checker',
    'tools.meta_tags_checker.description' => 'Get & verify the meta tags of any website.',
    'tools.meta_tags_checker.meta_keywords' => '',
    'tools.meta_tags_checker.extra_content' => '',

    'tools.website_hosting_checker.name' => 'Website hosting checker',
    'tools.website_hosting_checker.description' => 'Get the web-host of a given website.',
    'tools.website_hosting_checker.meta_keywords' => '',
    'tools.website_hosting_checker.host' => 'Host',
    'tools.website_hosting_checker.error_message' => 'We could not retrieve any details for your given host.',
    'tools.website_hosting_checker.result.isp' => 'ISP',
    'tools.website_hosting_checker.result.org' => 'Organization',
    'tools.website_hosting_checker.result.latitude' => 'Latitude',
    'tools.website_hosting_checker.result.longitude' => 'Longitude',
    'tools.website_hosting_checker.result.timezone' => 'Timezone',
    'tools.website_hosting_checker.extra_content' => '',

    'tools.http_headers_lookup.name' => 'HTTP headers lookup',
    'tools.http_headers_lookup.description' => 'Get all the HTTP headers that an URL returns for a typical GET request.',
    'tools.http_headers_lookup.meta_keywords' => '',
    'tools.http_headers_lookup.extra_content' => '',

    'tools.http2_checker.name' => 'HTTP/2 Checker',
    'tools.http2_checker.description' => 'Check whether a website is using the new HTTP/2 protocol or not.',
    'tools.http2_checker.meta_keywords' => '',
    'tools.http2_checker.success_message.disabled' => 'HTTP/2 is disabled.',
    'tools.http2_checker.success_message.enabled' => 'HTTP/2 is enabled.',
    'tools.http2_checker.extra_content' => '',

    'tools.brotli_checker.name' => 'Brotli Checker',
    'tools.brotli_checker.description' => 'Check whether a website is using the Brotli Compression algorithm or not.',
    'tools.brotli_checker.meta_keywords' => '',
    'tools.brotli_checker.success_message.disabled' => 'Brotli is disabled.',
    'tools.brotli_checker.success_message.enabled' => 'Brotli is enabled.',
    'tools.brotli_checker.extra_content' => '',

    'tools.url_redirect_checker.name' => 'URL redirect checker',
    'tools.url_redirect_checker.description' => 'Check for 301 & 302 redirects of a specific URL. It will check for up to 10 redirects.',
    'tools.url_redirect_checker.meta_keywords' => '',
    'tools.url_redirect_checker.status_code' => 'Status code',
    'tools.url_redirect_checker.result' => 'Result',
    'tools.url_redirect_checker.extra_content' => '',

    'tools.reverse_ip_lookup.name' => 'Reverse IP Lookup',
    'tools.reverse_ip_lookup.description' => 'Take an IP and try to look for the domain/host associated with it.',
    'tools.reverse_ip_lookup.meta_keywords' => '',
    'tools.reverse_ip_lookup.error_message' => 'We could not retrieve any details for your given IP.',
    'tools.reverse_ip_lookup.extra_content' => '',


    'domains.breadcrumb' => 'Custom domains',
    'domains.title' => 'Custom domains',
    'domains.menu' => 'Custom domains',
    'domains.header' => 'Custom domains',
    'domains.subheader' => 'Here you can add your own custom domain to use with your status pages.',
    'domains.create' => 'Connect domain',
    'domains.domain_id' => 'Domain',

    'domains.table.host' => 'Domain',
    'domains.table.is_enabled_pending' => 'Pending',
    'domains.table.is_enabled_active' => 'Active',

    'domains.help' => 'Your domain or subdomain must have an A record pointing to %1$s or CNAME record pointing to %2$s.',
    'domains.host' => 'Domain or subdomain',
    'domains.custom_index_url' => 'Custom index URL',
    'domains.custom_index_url_help' => 'Redirect to a specific URL when visitors land on the index of the domain, in case you don\'t want to use the custom domain for a single status page.',
    'domains.custom_not_found_url' => 'Custom 404 not found URL',
    'domains.custom_not_found_url_help' => 'Redirect to a specific URL when visitors land on a not found page of the domain.',
    'domains.no_data' => 'There are no custom domains added',
    'domains.no_data_help' => 'Start by linking your first custom domain.',
    'domains.error_message.host_exists' => 'This custom domain already exists.',


    'domain_create.breadcrumb' => 'Connect custom domain',
    'domain_create.title' => 'Connect custom domain',
    'domain_create.menu' => 'Connect custom domain',
    'domain_create.header' => 'Connect custom domain',
    'domain_create.success_message' => 'Your custom domain has been submitted for approval and processing.',


    'domain_update.breadcrumb' => 'Edit custom domain',
    'domain_update.title' => 'Edit custom domain',
    'domain_update.menu' => 'Edit custom domain',
    'domain_update.header' => 'Edit custom domain',
    'domain_update.success_message' => 'Your custom domain update has been submitted for approval and processing.',


    'domain_delete_modal.header' => 'Delete domain',
    'domain_delete_modal.subheader' => 'By deleting the domain, all the data associated with the domain will be lost, including all the status pages associated with it. This action cannot be undone.',


    'projects.title' => 'Projects',
    'projects.menu' => 'Projects',
    'projects.breadcrumb' => 'Projects',
    'projects.header' => 'Projects',
    'projects.subheader' => 'The easiest way to categorize your resources.',
    'projects.create' => 'Create project',
    'projects.project_id' => 'Project',
    'projects.project_id_help' => 'A project will help you categorize your resources.',
    'projects.color' => 'Color',
    'projects.color_help' => 'The color is used to help differentiate projects.',
    'projects.no_data' => 'There are no projects for now',
    'projects.no_data_help' => 'Start by creating your first project.',


    'project_create.breadcrumb' => 'Create a new project',
    'project_create.title' => 'Create a new project',
    'project_create.header' => 'Create a new project',


    'project_update.breadcrumb' => 'Edit project',
    'project_update.title' => 'Edit project',
    'project_update.header' => 'Edit project',


    'notification_handlers.title' => 'Notification handlers',
    'notification_handlers.menu' => 'Notification handlers',
    'notification_handlers.breadcrumb' => 'Notification handlers',
    'notification_handlers.header' => 'Notification handlers',
    'notification_handlers.subheader' => 'How do you want to get notified when certain events happen?',
    'notification_handlers.create' => 'Create notification handler',
    'notification_handlers.test' => 'Test integration',
    'notification_handlers.test_title' => 'This is a test message.',
    'notification_handlers.test_description' => 'This is the test description for the notification handler.',
    'notification_handlers.test.subject' => 'Notification handler test - {{WEBSITE_TITLE}}',
    'notification_handlers.test.body' => 'This is the test description for the notification handler.',
    'notification_handlers.success_message_test' => 'The test has been successful.',
    'notification_handlers.error_message_test' => 'The test has failed.',

    'notification_handlers.type' => 'Notification type',
    'notification_handlers.type_x' => 'X tweet',
    'notification_handlers.type_email' => 'Email',
    'notification_handlers.type_webhook' => 'Webhook',
    'notification_handlers.type_slack' => 'Slack',
    'notification_handlers.type_microsoft_teams' => 'Microsoft Teams',
    'notification_handlers.type_discord' => 'Discord',
    'notification_handlers.type_telegram' => 'Telegram',
    'notification_handlers.type_twilio' => 'SMS',
    'notification_handlers.type_twilio_call' => 'Phone call',
    'notification_handlers.type_whatsapp' => 'Whatsapp',
    'notification_handlers.type_google_chat' => 'Google chat',
    'notification_handlers.type_internal_notification' => 'Internal notification',
    'notification_handlers.type_push_subscriber_id' => 'Push notification',
    'notification_handlers.push_subscriber_id' => 'Push subscriber',
    'notification_handlers.push_subscriber_id_help' => 'Select one device that you have subscribed with.',
    'notification_handlers.email' => 'Email',
    'notification_handlers.email_help' => 'Receive email notifications.',
    'notification_handlers.webhook' => 'Webhook URL',
    'notification_handlers.webhook_help' => 'Receive POST calls notifications to your specified webhook URL.',
    'notification_handlers.slack' => 'Slack webhook URL',
    'notification_handlers.slack_help' => 'Receive Slack notifications for your specified Slack channel via webhooks. <a href="https://slack.com/apps/A0F7XDUAZ-incoming-webhooks" target="_blank">Get Slack webhook URL</a>.',
    'notification_handlers.discord' => 'Discord webhook URL',
    'notification_handlers.discord_help' => 'Receive Discord notifications for your specified Discord channel via webhooks.',
    'notification_handlers.microsoft_teams' => 'Microsoft Teams webhook URL',
    'notification_handlers.microsoft_teams_help' => 'Receive Microsoft Teams notifications for your specified channel via webhooks. <a href="https://learn.microsoft.com/en-us/microsoftteams/platform/webhooks-and-connectors/how-to/add-incoming-webhook?tabs=dotnet" target="_blank">Get Microsoft Teams webhook URL</a>.',
    'notification_handlers.telegram' => 'Telegram API Token',
    'notification_handlers.telegram_help' => 'The token for the HTTP API that you received after creating the bot on Telegram.',
    'notification_handlers.telegram_chat_id' => 'Telegram Chat ID',
    'notification_handlers.telegram_chat_id_help' => 'Where the bot should send the messages to.',
    'notification_handlers.twilio' => 'Phone number',
    'notification_handlers.twilio_help' => 'Example of valid phone number: +15558675310.',
    'notification_handlers.twilio_call' => 'Phone number',
    'notification_handlers.twilio_call_help' => 'Example of valid phone number: +15558675310.',
    'notification_handlers.whatsapp' => 'Whatsapp number',
    'notification_handlers.whatsapp_help' => 'Example of valid phone number: 15558675310. Only numbers.',
    'notification_handlers.google_chat' => 'Google chat webhook URL',
    'notification_handlers.google_chat_help' => 'Receive Google chat notifications for your specified space via webhooks.',
    'notification_handlers.x_consumer_key' => 'X consumer key',
    'notification_handlers.x_consumer_secret' => 'X consumer secret',
    'notification_handlers.x_access_token' => 'X access token',
    'notification_handlers.x_access_token_secret' => 'X access token secret',
    'notification_handlers.internal_notification_help' => 'Get notified internally via the notifications system near in the menu bar.',
    'notification_handlers.is_enabled' => 'Notification handler is active',
    'notification_handlers.no_data' => 'There are no notification handlers for now',
    'notification_handlers.no_data_help' => 'Start by creating your first notification handler.',


    'notification_handler_create.breadcrumb' => 'Create a new notification handler',
    'notification_handler_create.title' => 'Create a new notification handler',
    'notification_handler_create.header' => 'Create a new notification handler',


    'notification_handler_update.breadcrumb' => 'Edit notification handler',
    'notification_handler_update.title' => 'Edit notification handler',
    'notification_handler_update.header' => 'Edit notification handler',


    'cron.server_monitor.title' => '%1$s alert - %2$s is now at %3$s%%!',
    'cron.server_monitor.p1' => 'One of your server monitor\'s alerts has been triggered.',
    'cron.server_monitor.alert_trigger' => 'Trigger',
    'cron.server_monitor.alert_trigger_value' => 'After %s checks that meet the rule.',
    'cron.server_monitor.current_metric_value' => 'Current %s value',
    'cron.server_monitor.button' => 'View details',
    'cron.server_monitor.notice' => 'You\'re receiving these emails because you activated email reports. You can unsubscribe from the %sresource settings%s page at any point in time.',

    'cron.dns_monitor.title' => '%s DNS monitor update!',
    'cron.dns_monitor.p1' => 'Your DNS monitor has been updated. Here are all the values that changed.',
    'cron.dns_monitor.button' => 'View details',
    'cron.dns_monitor.notice' => 'You\'re receiving these emails because you activated email reports. You can unsubscribe from the %sresource settings%s page at any point in time.',

    'cron.is_ok.title' => 'Good: %s is back UP!',
    'cron.is_ok.p1' => 'Great news! Your resource is back up 🟢.',
    'cron.is_ok.button' => 'View details',
    'cron.is_ok.notice' => 'You\'re receiving these emails because you activated email reports. You can unsubscribe from the %sresource settings%s page at any point in time.',
    'cron.is_ok.start_datetime' => 'Started',
    'cron.is_ok.end_datetime' => 'Ended',
    'cron.is_ok.length' => 'Length',

    'cron.is_not_ok.title' => 'Alert: %s is DOWN!',
    'cron.is_not_ok.p1' => 'Bad news! Your resource is down 🔴.',
    'cron.is_not_ok.button' => 'View details',
    'cron.is_not_ok.notice' => 'You\'re receiving these emails because you activated email reports. You can unsubscribe from the %sresource settings%s page at any point in time.',
    'cron.is_not_ok.start_datetime' => 'Started',
    'cron.is_not_ok.reason' => 'Reason',

    'cron.monitor_email_report.title' => '\'{{MONITOR:NAME}}\' monitor stats between {{START_DATE}} and {{END_DATE}} - {{WEBSITE_TITLE}}',
    'cron.monitor_email_report.p1' => 'Quick and simple stat reporting for the %1$s (%2$s) monitor.',
    'cron.monitor_email_report.datetime_range' => 'Stats from',
    'cron.monitor_email_report.uptime' => 'Uptime',
    'cron.monitor_email_report.average_response_time' => 'Avg. response time',
    'cron.monitor_email_report.total_monitor_logs' => 'Total checks',
    'cron.monitor_email_report.total_ok_checks' => 'Total good checks',
    'cron.monitor_email_report.total_not_ok_checks' => 'Total failed checks',
    'cron.monitor_email_report.button' => 'View monitor',
    'cron.monitor_email_report.notice' => 'You\'re receiving these emails because you activated email reports. You can unsubscribe from the %smonitor settings%s page at any point in time.',

    'cron.heartbeat_email_report.title' => '\'{{HEARTBEAT:NAME}}\' heartbeat stats between {{START_DATE}} and {{END_DATE}} - {{WEBSITE_TITLE}}',
    'cron.heartbeat_email_report.p1' => 'Quick and simple stat reporting for the %s heartbeat.',
    'cron.heartbeat_email_report.datetime_range' => 'Stats from',
    'cron.heartbeat_email_report.uptime' => 'Uptime',
    'cron.heartbeat_email_report.total_runs' => 'Total runs',
    'cron.heartbeat_email_report.total_missed_runs' => 'Total missed runs',
    'cron.heartbeat_email_report.button' => 'View heartbeat',
    'cron.heartbeat_email_report.notice' => 'You\'re receiving these emails because you activated email reports. You can unsubscribe from the %heartbeat settings%s page at any point in time.',
];
