<?php
/*
 * Copyright (c) 2025 AltumCode (https://altumcode.com/)
 *
 * This software is licensed exclusively by AltumCode and is sold only via https://altumcode.com/.
 * Unauthorized distribution, modification, or use of this software without a valid license is not permitted and may be subject to applicable legal actions.
 *
 * 🌍 View all other existing AltumCode projects via https://altumcode.com/
 * 📧 Get in touch for support or general queries via https://altumcode.com/contact
 * 📤 Download the latest version via https://altumcode.com/downloads
 *
 * 🐦 X/Twitter: https://x.com/AltumCode
 * 📘 Facebook: https://facebook.com/altumcode
 * 📸 Instagram: https://instagram.com/altumcode
 */

defined('ALTUMCODE') || die();

$pro_notifications = \Altum\Plugin::is_active('pro-notifications') && file_exists(\Altum\Plugin::get('pro-notifications')->path . 'pro_notifications.php') ? include \Altum\Plugin::get('pro-notifications')->path . 'pro_notifications.php' : [];

/* Current available type of notifications and its defaults */
return array_merge(
    [
        'INFORMATIONAL' => [
            'type' => 'default',
            'notification_color' => '#ec4899', 'notification_background_color' => '#fce7f3',

            'title' => l('notification.informational.title_default'),
            'description' => l('notification.informational.description_default'),
            'image' => l('notification.informational.image_default'),
            'image_alt' => '',
            'url'   => '',
            'url_new_tab' => true,

            'trigger_all_pages' => true,
            'triggers' => [],
            'display_trigger' => 'delay',
            'display_trigger_value' => 2,
            'display_frequency' => 'all_time',
            'display_delay_type_after_close' => 'time_on_site',
            'display_delay_value_after_close' => 21600,
            'display_mobile' => true,
            'display_desktop' => true,
            'display_continents' => [],
            'display_countries' => [],
            'display_languages' => [],
            'display_operating_systems' => [],
            'display_browsers' => [],
            'display_cities' => [],
            'schedule' => false,
            'start_date' => null,
            'end_date' => null,

            'direction' => l('direction'),
            'display_duration' => 5,
            'display_position' => 'bottom_left',
            'display_close_button' => false,
            'display_branding' => true,

            'title_color' => '#000000',
            'description_color' => '#000000',
            'background_color' => '#fff',
            'background_pattern' => false,
            'background_pattern_svg' => '',

            'border_radius' => 'rounded',
            'border_color' => '#000000',
            'border_width' => 0,
            'internal_padding' => 12,
            'background_blur' => 0,
            'shadow' => 'feather',
            'shadow_color' => '#000000',

            'on_animation' => 'fadeIn',
            'off_animation' => 'fadeOut',
            'hover_animation' => '',
            'animation' => '',
            'animation_interval' => '3',
            'font' => 'inherit',
            'close_button_color' => '#808080',
            'custom_css' => '',
        ],

        'COUPON' => [
            'type' => 'default',
            'notification_color' => '#f03e78', 'notification_background_color' => '#fbe1ef',

            'title' => l('notification.coupon.title_default'),
            'description' => l('notification.coupon.description_default'),
            'image' => l('notification.coupon.image_default'),
            'image_alt' => '',
            'coupon_code' => l('notification.coupon.coupon_code_default'),
            'button_url'   => '',
            'url_new_tab' => true,
            'button_text'  => l('notification.coupon.button_text_default'),

            'trigger_all_pages' => true,
            'triggers' => [],
            'display_trigger' => 'delay',
            'display_trigger_value' => 2,
            'display_frequency' => 'all_time',
            'display_delay_type_after_close' => 'time_on_site',
            'display_delay_value_after_close' => 21600,
            'display_mobile' => true,
            'display_desktop' => true,
            'display_continents' => [],
            'display_countries' => [],
            'display_languages' => [],
            'display_operating_systems' => [],
            'display_browsers' => [],
            'display_cities' => [],
            'schedule' => false,
            'start_date' => null,
            'end_date' => null,

            'direction' => l('direction'),
            'display_duration' => 5,
            'display_position' => 'bottom_left',
            'display_close_button' => false,
            'display_branding' => true,

            'title_color' => '#000000',
            'description_color' => '#000000',
            'background_color' => '#fff',
            'background_pattern' => false,
            'background_pattern_svg' => '',
            'button_background_color' => '#2a70ff',
            'button_color' => '#fff',
            'border_radius' => 'rounded',
            'border_color' => '#000000',
            'border_width' => 0,
            'internal_padding' => 12,
            'background_blur' => 0,
            'shadow' => 'feather',
            'shadow_color' => '#000000',

            'on_animation' => 'fadeIn',
            'off_animation' => 'fadeOut',
            'hover_animation' => '',
            'animation' => '',
            'animation_interval' => '3',
            'font' => 'inherit',
            'close_button_color' => '#808080',
            'custom_css' => '',
        ],

        'LIVE_COUNTER' => [
            'type' => 'default',
            'notification_color' => '#f43f5e', 'notification_background_color' => '#ffe4e6',

            'description' => l('notification.live_counter.description_default'),
            'last_activity' => 15,
            'url'   => '',
            'url_new_tab' => true,

            'trigger_all_pages' => true,
            'triggers' => [],
            'display_trigger' => 'delay',

            'direction' => l('direction'),
            'display_trigger_value' => 2,
            'display_duration' => 5,
            'display_position' => 'bottom_left',
            'display_minimum_activity' => 0,
            'display_frequency' => 'all_time',
            'display_delay_type_after_close' => 'time_on_site',
            'display_delay_value_after_close' => 21600,
            'display_close_button' => false,
            'display_branding' => true,
            'display_mobile' => true,
            'display_desktop' => true,
            'display_continents' => [],
            'display_countries' => [],
            'display_languages' => [],
            'display_operating_systems' => [],
            'display_browsers' => [],
            'display_cities' => [],
            'schedule' => false,
            'start_date' => null,
            'end_date' => null,

            'number_color' => '#fff',
            'number_background_color' => '#FF2D9D',
            'description_color' => '#000000',
            'background_color' => '#fff',
            'background_pattern' => false,
            'background_pattern_svg' => '',
            'border_radius' => 'rounded',
            'border_color' => '#000000',
            'border_width' => 0,
            'internal_padding' => 12,
            'background_blur' => 0,
            'shadow' => 'feather',
            'shadow_color' => '#000000',

            'on_animation' => 'fadeIn',
            'off_animation' => 'fadeOut',
            'hover_animation' => '',
            'animation' => '',
            'animation_interval' => '3',
            'font' => 'inherit',
            'close_button_color' => '#808080',
            'custom_css' => '',
            'pulse_background_color' => '#17bf21',
        ],

        'EMAIL_COLLECTOR' => [
            'type' => 'default',
            'notification_color' => '#ef4444', 'notification_background_color' => '#fee2e2',

            'title' => l('notification.email_collector.title_default'),
            'description' => l('notification.email_collector.description_default'),
            'name_placeholder' => l('notification.email_collector.name_placeholder_default'),
            'email_placeholder' => l('notification.email_collector.email_placeholder_default'),
            'button_text' => l('notification.email_collector.button_text_default'),
            'show_agreement' => false,
            'agreement_text' => l('notification.email_collector.agreement_text_default'),
            'agreement_url' => '',
            'thank_you_url' => '',

            'trigger_all_pages' => true,
            'triggers' => [],
            'display_trigger' => 'delay',
            'display_trigger_value' => 2,
            'display_frequency' => 'all_time',
            'display_delay_type_after_close' => 'time_on_site',
            'display_delay_value_after_close' => 21600,
            'display_mobile' => true,
            'display_desktop' => true,
            'display_continents' => [],
            'display_countries' => [],
            'display_languages' => [],
            'display_operating_systems' => [],
            'display_browsers' => [],
            'display_cities' => [],
            'schedule' => false,
            'start_date' => null,
            'end_date' => null,

            'direction' => l('direction'),
            'display_duration' => 5,
            'display_position' => 'bottom_left',
            'display_close_button' => false,
            'display_branding' => true,

            'title_color' => '#000000',
            'description_color' => '#535353',
            'background_color' => '#fff',
            'background_pattern' => false,
            'background_pattern_svg' => '',
            'button_background_color' => '#272727',
            'button_color' => '#fff',
            'border_radius' => 'rounded',
            'border_color' => '#000000',
            'border_width' => 0,
            'internal_padding' => 12,
            'background_blur' => 0,
            'shadow' => 'feather',
            'shadow_color' => '#000000',

            'on_animation' => 'fadeIn',
            'off_animation' => 'fadeOut',
            'hover_animation' => '',
            'animation' => '',
            'animation_interval' => '3',
            'font' => 'inherit',
            'close_button_color' => '#808080',
            'custom_css' => '',
        ],

        'CONVERSIONS' => [
            'type' => 'default',
            'notification_color' => '#f2512e', 'notification_background_color' => '#fed8c9',

            'title' => l('notification.conversions.title_default'),
            'description' => l('notification.conversions.description_default'),
            'image' => l('notification.conversions.image_default'),
            'image_alt' => '',
            'url'   => '',
            'display_time' => true,
            'url_new_tab' => true,
            'conversions_count' => 1,
            'in_between_delay' => 3,
            'order' => 'descending',

            'trigger_all_pages' => true,
            'triggers' => [],
            'display_trigger' => 'delay',
            'display_trigger_value' => 2,
            'display_frequency' => 'all_time',
            'display_delay_type_after_close' => 'time_on_site',
            'display_delay_value_after_close' => 21600,
            'display_mobile' => true,
            'display_desktop' => true,
            'display_continents' => [],
            'display_countries' => [],
            'display_languages' => [],
            'display_operating_systems' => [],
            'display_browsers' => [],
            'display_cities' => [],
            'schedule' => false,
            'start_date' => null,
            'end_date' => null,


            'direction' => l('direction'),
            'display_minimum_activity' => 0,
            'display_duration' => 5,
            'display_position' => 'bottom_left',
            'display_close_button' => false,
            'display_branding' => true,

            'title_color' => '#000000',
            'date_color' => '#808080',
            'description_color' => '#000000',
            'background_color' => '#fff',
            'background_pattern' => false,
            'background_pattern_svg' => '',
            'border_radius' => 'rounded',
            'border_color' => '#000000',
            'border_width' => 0,
            'internal_padding' => 12,
            'background_blur' => 0,
            'shadow' => 'feather',
            'shadow_color' => '#000000',

            'on_animation' => 'fadeIn',
            'off_animation' => 'fadeOut',
            'hover_animation' => '',
            'animation' => '',
            'animation_interval' => '3',
            'font' => 'inherit',
            'close_button_color' => '#808080',
            'custom_css' => '',

            'data_trigger_auto' => false,
            'data_triggers_auto' => []
        ],

        'CONVERSIONS_COUNTER' => [
            'type' => 'default',
            'notification_color' => '#f97316', 'notification_background_color' => '#ffedd5',

            'title' => l('notification.conversions_counter.title_default'),
            'last_activity' => 2,
            'url' => '',
            'url_new_tab' => true,

            'trigger_all_pages' => true,
            'triggers' => [],
            'display_trigger' => 'delay',

            'direction' => l('direction'),
            'display_trigger_value' => 2,
            'display_duration' => 5,
            'display_position' => 'bottom_left',
            'display_minimum_activity' => 0,
            'display_frequency' => 'all_time',
            'display_delay_type_after_close' => 'time_on_site',
            'display_delay_value_after_close' => 21600,
            'display_close_button' => false,
            'display_branding' => true,
            'display_mobile' => true,
            'display_desktop' => true,
            'display_continents' => [],
            'display_countries' => [],
            'display_languages' => [],
            'display_operating_systems' => [],
            'display_browsers' => [],
            'display_cities' => [],
            'schedule' => false,
            'start_date' => null,
            'end_date' => null,

            'number_color' => '#fff',
            'number_background_color' => '#5b83ff',
            'title_color' => '#000000',
            'background_color' => '#fff',
            'background_pattern' => false,
            'background_pattern_svg' => '',
            'border_radius' => 'rounded',
            'border_color' => '#000000',
            'border_width' => 0,
            'internal_padding' => 12,
            'background_blur' => 0,
            'shadow' => 'feather',
            'shadow_color' => '#000000',

            'on_animation' => 'fadeIn',
            'off_animation' => 'fadeOut',
            'hover_animation' => '',
            'animation' => '',
            'animation_interval' => '3',
            'font' => 'inherit',
            'close_button_color' => '#808080',
            'custom_css' => '',

            'data_trigger_auto' => false,
            'data_triggers_auto' => []
        ],

        'VIDEO' => [
            'type' => 'default',
            'notification_color' => '#f59e0b', 'notification_background_color' => '#fef3c7',

            'title' => l('notification.video.title_default'),
            'video' => '',
            'video_autoplay' => false,
            'video_controls' => false,
            'video_loop' => false,
            'video_muted' => false,
            'button_url'   => '',
            'button_text'  => l('notification.video.button_text_default'),
            'url_new_tab' => '',

            'trigger_all_pages' => true,
            'triggers' => [],
            'display_trigger' => 'delay',
            'display_trigger_value' => 2,
            'display_frequency' => 'all_time',
            'display_delay_type_after_close' => 'time_on_site',
            'display_delay_value_after_close' => 21600,
            'display_mobile' => true,
            'display_desktop' => true,
            'display_continents' => [],
            'display_countries' => [],
            'display_languages' => [],
            'display_operating_systems' => [],
            'display_browsers' => [],
            'display_cities' => [],
            'schedule' => false,
            'start_date' => null,
            'end_date' => null,

            'direction' => l('direction'),
            'display_duration' => 5,
            'display_position' => 'bottom_left',
            'display_close_button' => false,
            'display_branding' => true,

            'title_color' => '#000000',
            'background_color' => '#fff',
            'background_pattern' => false,
            'background_pattern_svg' => '',
            'button_background_color' => '#000000',
            'button_color' => '#fff',
            'border_radius' => 'rounded',
            'border_color' => '#000000',
            'border_width' => 0,
            'internal_padding' => 12,
            'background_blur' => 0,
            'shadow' => 'feather',
            'shadow_color' => '#000000',

            'on_animation' => 'fadeIn',
            'off_animation' => 'fadeOut',
            'hover_animation' => '',
            'animation' => '',
            'animation_interval' => '3',
            'font' => 'inherit',
            'close_button_color' => '#808080',
            'custom_css' => '',
        ],

        'AUDIO' => [
            'type' => 'default',
            'notification_color' => '#e5b112', 'notification_background_color' => '#fef9c3',

            'title' => l('notification.audio.title_default'),
            'audio' => '',
            'audio_autoplay' => false,
            'audio_controls' => true,
            'audio_loop' => false,
            'audio_muted' => false,
            'button_url'   => '',
            'button_text'  => l('notification.audio.button_text_default'),
            'url_new_tab' => '',

            'trigger_all_pages' => true,
            'triggers' => [],
            'display_trigger' => 'delay',
            'display_trigger_value' => 2,
            'display_frequency' => 'all_time',
            'display_delay_type_after_close' => 'time_on_site',
            'display_delay_value_after_close' => 21600,
            'display_mobile' => true,
            'display_desktop' => true,
            'display_continents' => [],
            'display_countries' => [],
            'display_languages' => [],
            'display_operating_systems' => [],
            'display_browsers' => [],
            'display_cities' => [],
            'schedule' => false,
            'start_date' => null,
            'end_date' => null,

            'direction' => l('direction'),
            'display_duration' => 5,
            'display_position' => 'bottom_left',
            'display_close_button' => false,
            'display_branding' => true,

            'title_color' => '#000000',
            'background_color' => '#fff',
            'background_pattern' => false,
            'background_pattern_svg' => '',
            'button_background_color' => '#000000',
            'button_color' => '#fff',
            'border_radius' => 'rounded',
            'border_color' => '#000000',
            'border_width' => 0,
            'internal_padding' => 12,
            'background_blur' => 0,
            'shadow' => 'feather',
            'shadow_color' => '#000000',

            'on_animation' => 'fadeIn',
            'off_animation' => 'fadeOut',
            'hover_animation' => '',
            'animation' => '',
            'animation_interval' => '3',
            'font' => 'inherit',
            'close_button_color' => '#808080',
            'custom_css' => '',
        ],

        'SOCIAL_SHARE' => [
            'type' => 'default',
            'notification_color' => '#bea71b', 'notification_background_color' => '#fefec7',

            'title' => l('notification.social_share.title_default'),
            'description' => l('notification.social_share.description_default'),
            'share_url'   => '',
            'share_facebook' => true,
            'share_linkedin' => false,
            'share_pinterest' => false,
            'share_reddit' => true,
            'share_tumblr' => false,
            'share_x' => true,
            'share_whatsapp' => true,
            'share_telegram' => true,
            'share_threads' => true,

            'trigger_all_pages' => true,
            'triggers' => [],
            'display_trigger' => 'delay',
            'display_trigger_value' => 2,
            'display_frequency' => 'all_time',
            'display_delay_type_after_close' => 'time_on_site',
            'display_delay_value_after_close' => 21600,
            'display_mobile' => true,
            'display_desktop' => true,
            'display_continents' => [],
            'display_countries' => [],
            'display_languages' => [],
            'display_operating_systems' => [],
            'display_browsers' => [],
            'display_cities' => [],
            'schedule' => false,
            'start_date' => null,
            'end_date' => null,


            'direction' => l('direction'),
            'display_duration' => 5,
            'display_position' => 'bottom_left',
            'display_close_button' => false,
            'display_branding' => true,

            'title_color' => '#000000',
            'description_color' => '#000000',
            'background_color' => '#fff',
            'background_pattern' => false,
            'background_pattern_svg' => '',
            'border_radius' => 'rounded',
            'border_color' => '#000000',
            'border_width' => 0,
            'internal_padding' => 12,
            'background_blur' => 0,
            'shadow' => 'feather',
            'shadow_color' => '#000000',

            'on_animation' => 'fadeIn',
            'off_animation' => 'fadeOut',
            'hover_animation' => '',
            'animation' => '',
            'animation_interval' => '3',
            'font' => 'inherit',
            'close_button_color' => '#808080',
            'custom_css' => '',
        ],

        'REVIEWS' => [
            'type' => 'default',
            'notification_color' => '#6bac11', 'notification_background_color' => '#e3f99d',

            'url'   => '',
            'url_new_tab' => true,
            'reviews_count' => 1,
            'title' => l('notification.reviews.title_default'),
            'description' => l('notification.reviews.description_default'),
            'image' => l('notification.reviews.image_default'),
            'image_alt' => '',
            'stars' => 5,
            'in_between_delay' => 3,
            'order' => 'random',

            'trigger_all_pages' => true,
            'triggers' => [],
            'display_trigger' => 'delay',
            'display_trigger_value' => 2,
            'display_frequency' => 'all_time',
            'display_delay_type_after_close' => 'time_on_site',
            'display_delay_value_after_close' => 21600,
            'display_mobile' => true,
            'display_desktop' => true,
            'display_continents' => [],
            'display_countries' => [],
            'display_languages' => [],
            'display_operating_systems' => [],
            'display_browsers' => [],
            'display_cities' => [],
            'schedule' => false,
            'start_date' => null,
            'end_date' => null,

            'direction' => l('direction'),
            'display_duration' => 5,
            'display_position' => 'bottom_left',
            'display_close_button' => false,
            'display_branding' => true,

            'title_color' => '#000000',
            'description_color' => '#000000',
            'background_color' => '#fff',
            'background_pattern' => false,
            'background_pattern_svg' => '',
            'border_radius' => 'rounded',
            'border_color' => '#000000',
            'border_width' => 0,
            'internal_padding' => 12,
            'background_blur' => 0,
            'shadow' => 'feather',
            'shadow_color' => '#000000',

            'on_animation' => 'fadeIn',
            'off_animation' => 'fadeOut',
            'hover_animation' => '',
            'animation' => '',
            'animation_interval' => '3',
            'font' => 'inherit',
            'close_button_color' => '#808080',
            'custom_css' => '',
        ],

        'EMOJI_FEEDBACK' => [
            'type' => 'default',
            'notification_color' => '#22c55e', 'notification_background_color' => '#d1fae5',

            'title' => l('notification.emoji_feedback.title_default'),
            'show_angry' => true,
            'show_sad' => true,
            'show_neutral' => true,
            'show_happy' => true,
            'show_excited' => true,
            'thank_you_url' => '',

            'trigger_all_pages' => true,
            'triggers' => [],
            'display_trigger' => 'delay',
            'display_trigger_value' => 2,
            'display_frequency' => 'all_time',
            'display_delay_type_after_close' => 'time_on_site',
            'display_delay_value_after_close' => 21600,
            'display_mobile' => true,
            'display_desktop' => true,
            'display_continents' => [],
            'display_countries' => [],
            'display_languages' => [],
            'display_operating_systems' => [],
            'display_browsers' => [],
            'display_cities' => [],
            'schedule' => false,
            'start_date' => null,
            'end_date' => null,

            'direction' => l('direction'),
            'display_duration' => 5,
            'display_position' => 'bottom_left',
            'display_close_button' => false,
            'display_branding' => true,

            'title_color' => '#000000',
            'background_color' => '#fff',
            'background_pattern' => false,
            'background_pattern_svg' => '',
            'border_radius' => 'rounded',
            'border_color' => '#000000',
            'border_width' => 0,
            'internal_padding' => 12,
            'background_blur' => 0,
            'shadow' => 'feather',
            'shadow_color' => '#000000',

            'on_animation' => 'fadeIn',
            'off_animation' => 'fadeOut',
            'hover_animation' => '',
            'animation' => '',
            'animation_interval' => '3',
            'font' => 'inherit',
            'close_button_color' => '#808080',
            'custom_css' => '',
        ],

        'COOKIE_NOTIFICATION' => [
            'type' => 'default',
            'notification_color' => '#10b981', 'notification_background_color' => '#bbf7d0',

            'description' => l('notification.cookie_notification.description_default'),
            'image' => l('notification.cookie_notification.image_default'),
            'image_alt' => '',
            'url_text' => l('notification.cookie_notification.url_text_default'),
            'url' => '',
            'url_new_tab' => true,
            'button_text'  => l('notification.cookie_notification.button_text_default'),

            'trigger_all_pages' => true,
            'triggers' => [],
            'display_trigger' => 'delay',
            'display_trigger_value' => 2,
            'display_frequency' => 'all_time',
            'display_delay_type_after_close' => 'time_on_site',
            'display_delay_value_after_close' => 21600,
            'display_mobile' => true,
            'display_desktop' => true,
            'display_continents' => [],
            'display_countries' => [],
            'display_languages' => [],
            'display_operating_systems' => [],
            'display_browsers' => [],
            'display_cities' => [],
            'schedule' => false,
            'start_date' => null,
            'end_date' => null,

            'direction' => l('direction'),
            'display_duration' => 5,
            'display_position' => 'bottom_left',
            'display_close_button' => false,
            'display_branding' => true,

            'description_color' => '#000000',
            'background_color' => '#fff',
            'background_pattern' => false,
            'background_pattern_svg' => '',
            'button_background_color' => '#000000',
            'button_color' => '#fff',
            'border_radius' => 'rounded',
            'border_color' => '#000000',
            'border_width' => 0,
            'internal_padding' => 12,
            'background_blur' => 0,
            'shadow' => 'feather',
            'shadow_color' => '#000000',

            'on_animation' => 'fadeIn',
            'off_animation' => 'fadeOut',
            'hover_animation' => '',
            'animation' => '',
            'animation_interval' => '3',
            'font' => 'inherit',
            'close_button_color' => '#808080',
            'custom_css' => '',
        ],

        'SCORE_FEEDBACK' => [
            'type' => 'default',
            'notification_color' => '#14b8a6', 'notification_background_color' => '#ccfbf1',

            'title' => l('notification.score_feedback.title_default'),
            'description' => l('notification.score_feedback.description_default'),
            'thank_you_url' => '',

            'trigger_all_pages' => true,
            'triggers' => [],
            'display_trigger' => 'delay',
            'display_trigger_value' => 2,
            'display_frequency' => 'all_time',
            'display_delay_type_after_close' => 'time_on_site',
            'display_delay_value_after_close' => 21600,
            'display_mobile' => true,
            'display_desktop' => true,
            'display_continents' => [],
            'display_countries' => [],
            'display_languages' => [],
            'display_operating_systems' => [],
            'display_browsers' => [],
            'display_cities' => [],
            'schedule' => false,
            'start_date' => null,
            'end_date' => null,

            'direction' => l('direction'),
            'display_duration' => 5,
            'display_position' => 'bottom_left',
            'display_close_button' => false,
            'display_branding' => true,

            'title_color' => '#000000',
            'description_color' => '#000000',
            'background_color' => '#fff',
            'background_pattern' => false,
            'background_pattern_svg' => '',
            'button_background_color' => '#fc00802e',
            'button_color' => '#fc0080',
            'border_radius' => 'rounded',
            'border_color' => '#000000',
            'border_width' => 0,
            'internal_padding' => 12,
            'background_blur' => 0,
            'shadow' => 'feather',
            'shadow_color' => '#000000',

            'on_animation' => 'fadeIn',
            'off_animation' => 'fadeOut',
            'hover_animation' => '',
            'animation' => '',
            'animation_interval' => '3',
            'font' => 'inherit',
            'close_button_color' => '#808080',
            'custom_css' => '',
        ],

        'REQUEST_COLLECTOR' => [
            'type' => 'default',
            'notification_color' => '#0ea5e9', 'notification_background_color' => '#e0f2fe',

            'title' => l('notification.request_collector.title_default'),
            'description' => l('notification.request_collector.description_default'),
            'image' => l('notification.request_collector.image_default'),
            'image_alt' => '',
            'content_title' => l('notification.request_collector.content_title_default'),
            'content_description' => l('notification.request_collector.content_description_default'),
            'input_placeholder' => l('notification.request_collector.input_placeholder_default'),
            'button_text' => l('notification.request_collector.button_text_default'),
            'show_agreement' => false,
            'agreement_text' => l('notification.request_collector.agreement_text_default'),
            'agreement_url' => '',
            'thank_you_url' => '',

            'trigger_all_pages' => true,
            'triggers' => [],
            'display_trigger' => 'delay',
            'display_trigger_value' => 2,
            'display_frequency' => 'all_time',
            'display_delay_type_after_close' => 'time_on_site',
            'display_delay_value_after_close' => 21600,
            'display_mobile' => true,
            'display_desktop' => true,
            'display_continents' => [],
            'display_countries' => [],
            'display_languages' => [],
            'display_operating_systems' => [],
            'display_browsers' => [],
            'display_cities' => [],
            'schedule' => false,
            'start_date' => null,
            'end_date' => null,

            'direction' => l('direction'),
            'display_duration' => 5,
            'display_position' => 'bottom_left',
            'display_close_button' => false,
            'display_branding' => true,

            'title_color' => '#000000',
            'description_color' => '#000000',
            'content_title_color' => '#000000',
            'content_description_color' => '#000000',
            'background_color' => '#fff',
            'background_pattern' => false,
            'background_pattern_svg' => '',
            'button_background_color' => '#000000',
            'button_color' => '#fff',
            'border_radius' => 'rounded',
            'border_color' => '#000000',
            'border_width' => 0,
            'internal_padding' => 12,
            'background_blur' => 0,
            'shadow' => 'feather',
            'shadow_color' => '#000000',

            'on_animation' => 'fadeIn',
            'off_animation' => 'fadeOut',
            'hover_animation' => '',
            'animation' => '',
            'animation_interval' => '3',
            'font' => 'inherit',
            'close_button_color' => '#808080',
            'custom_css' => '',
        ],

        'COUNTDOWN_COLLECTOR' => [
            'type' => 'default',
            'notification_color' => '#0284c7', 'notification_background_color' => '#bae6fd',

            'title' => l('notification.countdown_collector.title_default'),
            'description' => l('notification.countdown_collector.description_default'),
            'content_title' => l('notification.countdown_collector.content_title_default'),
            'input_placeholder' => l('notification.countdown_collector.input_placeholder_default'),
            'button_text' => l('notification.countdown_collector.button_text_default'),
            'countdown_end_date' => (new \DateTime())->modify('+5 hours')->format('Y-m-d H:i:s'),
            'show_agreement' => false,
            'agreement_text' => l('notification.countdown_collector.agreement_text_default'),
            'agreement_url' => '',
            'thank_you_url' => '',

            'trigger_all_pages' => true,
            'triggers' => [],
            'display_trigger' => 'delay',
            'display_trigger_value' => 2,
            'display_frequency' => 'all_time',
            'display_delay_type_after_close' => 'time_on_site',
            'display_delay_value_after_close' => 21600,
            'display_mobile' => true,
            'display_desktop' => true,
            'display_continents' => [],
            'display_countries' => [],
            'display_languages' => [],
            'display_operating_systems' => [],
            'display_browsers' => [],
            'display_cities' => [],
            'schedule' => false,
            'start_date' => null,
            'end_date' => null,

            'direction' => l('direction'),
            'display_duration' => 5,
            'display_position' => 'bottom_left',
            'display_close_button' => false,
            'display_branding' => true,

            'title_color' => '#000000',
            'description_color' => '#000000',
            'content_title_color' => '#000000',
            'time_color' => '#fff',
            'time_background_color' => '#2ccaa2',
            'background_color' => '#fff',
            'background_pattern' => false,
            'background_pattern_svg' => '',
            'button_background_color' => '#000000',
            'button_color' => '#fff',
            'border_radius' => 'rounded',
            'border_color' => '#000000',
            'border_width' => 0,
            'internal_padding' => 12,
            'background_blur' => 0,
            'shadow' => 'feather',
            'shadow_color' => '#000000',

            'on_animation' => 'fadeIn',
            'off_animation' => 'fadeOut',
            'hover_animation' => '',
            'animation' => '',
            'animation_interval' => '3',
            'font' => 'inherit',
            'close_button_color' => '#808080',
            'custom_css' => '',
        ],

        'CUSTOM_HTML' => [
            'type' => 'default',
            'notification_color' => '#3b82f6', 'notification_background_color' => '#dbeafe',

            'html' => l('notification.custom_html.html_default'),

            'trigger_all_pages' => true,
            'triggers' => [],
            'display_trigger' => 'delay',
            'display_trigger_value' => 2,
            'display_frequency' => 'all_time',
            'display_delay_type_after_close' => 'time_on_site',
            'display_delay_value_after_close' => 21600,
            'display_mobile' => true,
            'display_desktop' => true,
            'display_continents' => [],
            'display_countries' => [],
            'display_languages' => [],
            'display_operating_systems' => [],
            'display_browsers' => [],
            'display_cities' => [],
            'schedule' => false,
            'start_date' => null,
            'end_date' => null,

            'direction' => l('direction'),
            'display_duration' => 5,
            'display_position' => 'bottom_left',
            'display_close_button' => false,
            'display_branding' => true,

            'background_color' => '#fff',
            'background_pattern' => false,
            'background_pattern_svg' => '',

            'border_radius' => 'rounded',
            'border_color' => '#000000',
            'border_width' => 0,
            'internal_padding' => 12,
            'background_blur' => 0,
            'shadow' => 'feather',
            'shadow_color' => '#000000',

            'on_animation' => 'fadeIn',
            'off_animation' => 'fadeOut',
            'hover_animation' => '',
            'animation' => '',
            'animation_interval' => '3',
            'font' => 'inherit',
            'close_button_color' => '#808080',
            'custom_css' => '',
        ],
    ],
    $pro_notifications
);
