<?php
/*
 * Copyright (c) 2025 AltumCode (https://altumcode.com/)
 *
 * This software is licensed exclusively by AltumCode and is sold only via https://altumcode.com/.
 * Unauthorized distribution, modification, or use of this software without a valid license is not permitted and may be subject to applicable legal actions.
 *
 * 🌍 View all other existing AltumCode projects via https://altumcode.com/
 * 📧 Get in touch for support or general queries via https://altumcode.com/contact
 * 📤 Download the latest version via https://altumcode.com/downloads
 *
 * 🐦 X/Twitter: https://x.com/AltumCode
 * 📘 Facebook: https://facebook.com/altumcode
 * 📸 Instagram: https://instagram.com/altumcode
 */

return [
    'direction' => 'ltr',

    'global.submit' => 'Submit',
    'global.create' => 'Create',
    'global.delete' => 'Delete',
    'global.edit' => 'Edit',
    'global.view' => 'View',
    'global.duplicate' => 'Duplicate',
    'global.transfer' => 'Transfer',
    'global.reset' => 'Reset',
    'global.share' => 'Share',
    'global.share_via' => 'Share via %s',
    'global.cancel' => 'Cancel',
    'global.update' => 'Update',
    'global.enable' => 'Enable',
    'global.hidden' => 'Hidden',
    'global.login' => 'Login',
    'global.language' => 'Language',
    'global.choose_language' => 'Choose language',
    'global.choose_currency' => 'Choose currency',
    'global.theme_style' => 'Switch to %s (CMD/CTRL + I)',
    'global.theme_style_light' => 'Light',
    'global.theme_style_dark' => 'Dark',
    'global.close' => 'Close',
    'global.search' => 'Search',
    'global.no_data' => 'No data available',
    'global.unknown' => 'Unknown',
    'global.none' => 'None',
    'global.yes' => 'Yes',
    'global.no' => 'No',
    'global.status' => 'Status',
    'global.active' => 'Active',
    'global.disabled' => 'Disabled',
    'global.all' => 'All',
    'global.order' => 'Order',
    'global.download' => 'Download',
    'global.download_as' => 'Download as %s',
    'global.export' => 'Export',
    'global.export_to' => 'Export to %s',
    'global.captcha_placeholder' => 'Captcha text',
    'global.loading' => 'Loading..',
    'global.view_more' => 'View more',
    'global.view_x_more' => 'View %s more..',
    'global.clipboard_copy' => 'Copy to clipboard',
    'global.clipboard_copied' => 'Copied!',
    'global.terms_and_conditions' => 'Terms and Conditions',
    'global.privacy_policy' => 'Privacy Policy',
    'global.delete_file' => 'Delete uploaded file',
    'global.remove_selected_file' => 'Remove selected file',
    'global.bulk_actions' => 'Bulk actions',
    'global.unlimited' => 'Unlimited',
    'global.duplicated' => 'Duplicated',
    'global.datetime' => 'Created on',
    'global.last_datetime' => 'Updated on',
    'global.datetime_tooltip' => 'Created on %s',
    'global.last_datetime_tooltip' => 'Updated on %s',
    'global.device' => 'Device',
    'global.device.desktop' => 'Desktop',
    'global.device.tablet' => 'Tablet',
    'global.device.mobile' => 'Mobile',
    'global.continent' => 'Continent',
    'global.continents' => 'Continents',
    'global.country' => 'Country',
    'global.countries' => 'Countries',
    'global.city' => 'City',
    'global.cities' => 'Cities',
    'global.os_name' => 'Operating system',
    'global.browser_name' => 'Browser',
    'global.browser_language' => 'Browser language',
    'global.ip' => 'IP',
    'global.name' => 'Name',
    'global.description' => 'Description',
    'global.title' => 'Title',
    'global.email' => 'Email',
    'global.email_placeholder' => 'hello@example.com',
    'global.password' => 'Password',
    'global.user' => 'User',
    'global.image' => 'Image',
    'global.icon' => 'Icon',
    'global.icon_placeholder' => 'fas fa-bolt',
    'global.icon_help' => '<a href="https://fontawesome.com/search?o=r&m=free" target="_blank">FontAwesome</a> icon class.',
    'global.url' => 'URL',
    'global.url_placeholder' => 'https://example.com/',
    'global.url_slug_placeholder' => 'example',
    'global.host' => 'Host',
    'global.host_placeholder' => 'example.com',
    'global.admin_impersonate_user_help' => 'Logged in as',
    'global.admin_impersonate_user_logout' => 'Exit',
    'global.spintax_help' => 'You can also use Spintax format, as such: <code>{Hi|Hey|Hello}</code> to randomize words or phrases.',
    'global.team_delegate_access_help' => 'Logged in as %1$s via %2$s team.',
    'global.team_delegate_access_logout' => 'Exit',
    'global.update_x' => 'Edit %s',
    'global.mb' => 'MB',
    'global.details' => 'Details',
    'global.type' => 'Type',
    'global.view_all' => 'View all',
    'global.select_all' => 'Select all',
    'global.deselect_all' => 'Deselect all',
    'global.show' => 'Show',
    'global.hide' => 'Hide',
    'global.chart_help' => 'Chart automatically refreshes every %1$s hours. Data from the last %2$s days.',
    'global.id' => 'Entry number (ID)',
    'global.variables' => 'You can use the following dynamic variables: %s.',
    'global.translate' => 'Translate',
    'global.scroll_top' => 'Scroll top',
    'global.scroll_bottom' => 'Scroll bottom',
    'global.no_chart_data' => 'No data available',
    'global.no_chart_data_help' => 'There is not enough data to generate a chart.',
    'global.image_error' => 'Image error',
    'global.spotlight.search_placeholder' => '🔎 Search & go to a page...',
    'global.spotlight.tooltip' => 'Spotlight search (CMD/CTRL + K)',
    'global.drag_and_drop' => 'Drag & drop to reorder',
    'global.crop' => 'Crop image',
    'global.crop_selection' => 'Crop selection',
    'global.no_crop' => 'Continue without cropping',
    'global.custom_css' => 'Custom CSS',
    'global.custom_css_placeholder' => '#notification_1 { font-weight: bold !important; }',
    'global.custom_css_help' => 'Your CSS code to modify the already existing style.',

    'global.info_message.confirm_delete' => 'Are you sure you want to delete this?',
    'global.info_message.user_plan_is_expired' => 'Your current plan has expired and your access is now limited.',
    'global.info_message.plan_feature_no_access' => 'Your current plan does not allow you to access this feature.',
    'global.info_message.plan_upgrade' => 'Upgrade your plan 🔐',
    'global.info_message.plan_feature_limit' => 'Your have exceeded the limits of your current plan.',
    'global.info_message.plan_feature_limit_info' => '%1$s out of %2$s used <br /> %3$s remaining',
    'global.info_message.team_no_access' => 'Your team access does not allow you to use this feature.',
    'global.info_message.team_limit' => 'Only the team owner can access this page.',

    'global.success_message.create1' => '%s has been successfully created.',
    'global.success_message.create2' => 'Successfully created.',
    'global.success_message.update1' => '%s has been successfully updated.',
    'global.success_message.update2' => 'Successfully updated.',
    'global.success_message.delete1' => '%s has been successfully deleted.',
    'global.success_message.delete2' => 'Successfully deleted.',

    'global.error_message.directory_not_writable' => 'Directory <strong>%s</strong> is not writable. Please set the CHMOD permissions so this folder can be written.',
    'global.error_message.file_not_writable' => 'File <strong>%s</strong> is not writable . Please set the CHMOD permissions so this file can be written.',
    'global.error_message.empty_fields' => 'You must fill all the required fields.',
    'global.error_message.empty_field' => 'This field is required, you must fill it.',
    'global.error_message.invalid_file_type' => 'You are not allowed to upload files of this type.',
    'global.error_message.file_upload' => 'Something happened while uploading the file and we could not process it.',
    'global.error_message.invalid_csrf_token' => 'The action could not be finished because the protector has expired, please try again.',
    'global.error_message.basic' => 'We could not perform this action.',
    'global.error_message.file_size_limit' => 'The uploaded file is too big, the maximum file size you are allowed to upload is %s MB.',
    'global.error_message.password_length' => 'The password must be between 6 and 64 characters.',
    'global.error_message.passwords_not_matching' => 'The entered passwords do not match.',
    'global.error_message.invalid_email' => 'The entered email is invalid.',
    'global.error_message.invalid_captcha' => 'The entered captcha code is invalid.',
    'global.error_message.function_required' => '<code>%s</code> is required, but your server does not have it enabled. Contact your server administrator.',
    'global.error_message.limit_try_again' => 'You reached the limit. Try again in %1$s %2$s.',

    'global.menu.logout' => 'Logout',
    'global.menu.admin' => 'Admin panel',

    'global.accessibility.toggle_navigation' => 'Toggle navigation',
    'global.accessibility.logo_alt' => 'Website logo',
    'global.accessibility.captcha_alt' => 'Captcha',
    'global.accessibility.captcha_input' => 'Captcha field',
    'global.accessibility.whitelisted_file_extensions' => '%s allowed.',
    'global.accessibility.file_size_limit' => '%s MB maximum.',
    'global.accessibility.admin_file_size_limit_help' => 'You are not able to set a higher limit than your actual server upload limit.',

    'global.pagination.previous' => 'Previous',
    'global.pagination.next' => 'Next',
    'global.pagination.results' => 'Showing %1$s-%2$s out of %3$s results.',

    'global.filters.header' => 'Filters',
    'global.filters.reset' => 'Reset',
    'global.filters.clear' => 'Clear filters',
    'global.filters.search' => 'Search',
    'global.filters.search_by' => 'Search by',
    'global.filters.order_by' => 'Order by',
    'global.filters.order_by_datetime' => 'Created datetime',
    'global.filters.order_by_last_datetime' => 'Updated datetime',
    'global.filters.order_type' => 'Order type',
    'global.filters.order_type_asc' => 'Ascending',
    'global.filters.order_type_desc' => 'Descending',
    'global.filters.results_per_page' => 'Results per page',
    'global.filters.no_data' => 'No filtered data found',
    'global.filters.no_data_help' => 'No matches found for your filter.',

    'global.date.datetime_readable_format' => '%1$s %2$s, %3$s',
    'global.date.datetime_small_format' => '%1$s %2$s, %3$s',
    'global.date.datetime_small_readable_format' => '%1$s %2$s',
    'global.date.datetime_ymd_format' => '%1$s-%2$s-%3$s',
    'global.date.datetime_his_format' => '%1$s:%2$s:%3$s',
    'global.date.datetime_ymd_his_format' => '%1$s-%2$s-%3$s %4$s:%5$s:%6$s',
    'global.date.now' => 'now',
    'global.date.cancel' => 'Cancel',
    'global.date.apply' => 'Apply',
    'global.date.from' => 'From',
    'global.date.to' => 'To',
    'global.date.custom' => 'Custom',
    'global.date.today' => 'Today',
    'global.date.yesterday' => 'Yesterday',
    'global.date.last_7_days' => 'Last 7 days',
    'global.date.last_30_days' => 'Last 30 days',
    'global.date.this_month' => 'This month',
    'global.date.last_month' => 'Last month',
    'global.date.all_time' => 'All time',
    'global.date.short_milliseconds' => 'ms',
    'global.date.short_seconds' => 's',
    'global.date.second' => 'second',
    'global.date.seconds' => 'seconds',
    'global.date.minute' => 'minute',
    'global.date.minutes' => 'minutes',
    'global.date.hour' => 'hour',
    'global.date.hours' => 'hours',
    'global.date.day' => 'day',
    'global.date.days' => 'days',
    'global.date.week' => 'week',
    'global.date.weeks' => 'weeks',
    'global.date.month' => 'month',
    'global.date.months' => 'months',
    'global.date.year' => 'year',
    'global.date.years' => 'years',
    'global.date.time_ago' => '%1$s %2$s ago',
    'global.date.time_until' => '%1$s %2$s',

    'global.date.long_days.1' => 'Monday',
    'global.date.long_days.2' => 'Tuesday',
    'global.date.long_days.3' => 'Wednesday',
    'global.date.long_days.4' => 'Thursday',
    'global.date.long_days.5' => 'Friday',
    'global.date.long_days.6' => 'Saturday',
    'global.date.long_days.7' => 'Sunday',

    'global.date.short_days.1' => 'Mon',
    'global.date.short_days.2' => 'Tue',
    'global.date.short_days.3' => 'Wed',
    'global.date.short_days.4' => 'Thu',
    'global.date.short_days.5' => 'Fri',
    'global.date.short_days.6' => 'Sat',
    'global.date.short_days.7' => 'Sun',

    'global.date.long_months.1' => 'January',
    'global.date.long_months.2' => 'February',
    'global.date.long_months.3' => 'March',
    'global.date.long_months.4' => 'April',
    'global.date.long_months.5' => 'May',
    'global.date.long_months.6' => 'June',
    'global.date.long_months.7' => 'July',
    'global.date.long_months.8' => 'August',
    'global.date.long_months.9' => 'September',
    'global.date.long_months.10' => 'October',
    'global.date.long_months.11' => 'November',
    'global.date.long_months.12' => 'December',

    'global.date.short_months.1' => 'Jan',
    'global.date.short_months.2' => 'Feb',
    'global.date.short_months.3' => 'Mar',
    'global.date.short_months.4' => 'Apr',
    'global.date.short_months.5' => 'May',
    'global.date.short_months.6' => 'Jun',
    'global.date.short_months.7' => 'Jul',
    'global.date.short_months.8' => 'Aug',
    'global.date.short_months.9' => 'Sep',
    'global.date.short_months.10' => 'Oct',
    'global.date.short_months.11' => 'Nov',
    'global.date.short_months.12' => 'Dec',

    'global.number.decimal_point' => '.',
    'global.number.thousands_separator' => ',',

    'global.emails.copyright' => 'Copyright © %1$s %2$s.',
    'global.emails.anti_phishing_code' => 'Anti phishing code: %s',
    'global.emails.is_broadcast' => 'You are receiving this email because you have subscribed to our newsletter broadcasts. You can %sUnsubscribe here%s at any point in time.',

    'global.emails.user_welcome.subject' => 'Welcome to {{WEBSITE_TITLE}}',
    'global.emails.user_welcome.body' => 'Hello, <strong>{{NAME}}</strong>!<br /><br />Welcome to our website community, we\'re excited to have you on board!<br /><br />Get started by visiting our <a href="{{URL}}">homepage</a> or your <a href="{{DASHBOARD_LINK}}">dashboard</a>.<br /><br />Regards,<br />The {{WEBSITE_TITLE}} team.',

    'global.emails.user_activation.subject' => 'Confirm your new account - {{WEBSITE_TITLE}}',
    'global.emails.user_activation.body' => 'Hello, <strong>{{NAME}}</strong>,<br /><br />We are glad you joined us! <br /><br />One more step and your account is ready,<br /><br />Click the link below in order to join <strong>{{WEBSITE_TITLE}}</strong><br /><br /><a href="{{ACTIVATION_LINK}}" class="cta">Activate account</a><br /><br />Regards,<br />The {{WEBSITE_TITLE}} team.',

    'global.emails.user_pending_email.subject' => 'Confirm your email address change - {{WEBSITE_TITLE}}',
    'global.emails.user_pending_email.body' => 'Hello, <strong>{{NAME}}</strong>,<br /><br />You have requested to change your email address from {{CURRENT_EMAIL}} to {{NEW_EMAIL}}. <br /><br />Please click on the link below to confirm your new email address. <br /><br /><a href="{{ACTIVATION_LINK}}" class="cta">Confirm email address change</a><br /><br />Regards,<br />The {{WEBSITE_TITLE}} team.',

    'global.emails.user_lost_password.subject' => 'Reset your password - {{WEBSITE_TITLE}}',
    'global.emails.user_lost_password.body' => 'Hello, <strong>{{NAME}}</strong>,<br /><br />This is your reset password link:<br /><br /><a href="{{LOST_PASSWORD_LINK}}" class="cta">Reset password</a><br /><br />If you did not request this, you can ignore it.<br /><br />Regards,<br />The {{WEBSITE_TITLE}} team.',

    'global.emails.user_payment.subject' => 'Payment received - {{WEBSITE_TITLE}}',
    'global.emails.user_payment.body' => 'Hello, <strong>{{NAME}}</strong>,<br /><br />This is a confirmation that your payment has been received by us.<br /><br />You\'ve paid for the <strong>{{PLAN_NAME}}</strong> plan until <strong>{{PLAN_EXPIRATION_DATE}}</strong>.<br /><br />You can also check all the <a href="{{USER_PAYMENTS_LINK}}">payments</a> you made, <a href="{{USER_PLAN_LINK}}">change your plan</a> or <a href="{{USER_PLAN_LINK}}">cancel it</a>.<br /><br />Regards,<br />The {{WEBSITE_TITLE}} team.',

    'global.emails.user_plan_expiry_reminder.subject' => 'Your plan is expiring in {{DAYS_UNTIL_EXPIRATION}} days - {{WEBSITE_TITLE}}',
    'global.emails.user_plan_expiry_reminder.body' => 'Hello, <strong>{{NAME}}</strong>,<br /><br />This is a simple reminder that your <strong>{{PLAN_NAME}} plan</strong> is going to expire in <strong>{{DAYS_UNTIL_EXPIRATION}} days</strong>.<br /><br />You must renew your plan if you wish to continue using our website with all the features you have.<br /><br /><a href="{{USER_PLAN_RENEW_LINK}}" class="cta">Renew plan</a><br /><br />Regards,<br />The {{WEBSITE_TITLE}} team.',

    'global.emails.user_plan_expired.subject' => 'Your plan has expired - {{WEBSITE_TITLE}}',
    'global.emails.user_plan_expired.body' => 'Hello, <strong>{{NAME}}</strong>,<br /><br />Your <strong>{{PLAN_NAME}} plan</strong> has expired as you haven\'t renewed your membership.<br /><br />If you wish to continue using our website with all the features you had, you will need to renew your membership.<br /><br /><a href="{{USER_PLAN_RENEW_LINK}}" class="cta">Renew plan</a><br /><br />Regards,<br />The {{WEBSITE_TITLE}} team.',

    'global.emails.user_deletion_reminder.subject' => 'Your account will be deleted in {{DAYS_UNTIL_DELETION}} days - {{WEBSITE_TITLE}}',
    'global.emails.user_deletion_reminder.body' => 'Hello, <strong>{{NAME}}</strong>,<br /><br />This is a simple email to remind you that your account is going to be deleted in {{DAYS_UNTIL_DELETION}} days because your account has been inactive.<br /><br />If you wish to cancel this deletion, simply login with your account and the deletion process will be stopped.<br /><br /><a href="{{LOGIN_LINK}}">Login & stop deletion</a><br /><br />Regards,<br />The {{WEBSITE_TITLE}} team.',

    'global.emails.auto_delete_inactive_users.subject' => 'Your account has been deleted - {{WEBSITE_TITLE}}',
    'global.emails.auto_delete_inactive_users.body' => 'Hello, <strong>{{NAME}}</strong>,<br /><br />This is a simple email to let you know that your account has been deleted because of being inactive for more than {{INACTIVITY_DAYS}} days.<br /><br />If you wish to re-gain access, you would need to sign-up another account with us.<br /><br /><a href="{{REGISTER_LINK}}" class="cta">Register again</a><br /><br />Regards,<br />The {{WEBSITE_TITLE}} team.',

    'global.emails.user_affiliate_withdrawal_approved.subject' => 'Affiliate withdrawal approved - {{WEBSITE_TITLE}}',
    'global.emails.user_affiliate_withdrawal_approved.body' => 'Hello, <strong>{{NAME}}</strong>,<br /><br />This is a confirmation that your recent affiliate withdrawal of <strong>{{AMOUNT}} {{CURRENCY}}</strong> has been approved and your payment was sent for processing.<br /><br />Regards,<br />The {{WEBSITE_TITLE}} team.',

    'global.emails.team_member_create.subject' => 'You\'ve been invited to \'{{TEAM:NAME}}\' team - {{WEBSITE_TITLE}}',
    'global.emails.team_member_create.body_login' => 'Hello,<br /><br />You have been invited by <strong>{{USER:NAME}}</strong> ({{USER:EMAIL}}) to join the <strong>{{TEAM:NAME}}</strong> team on {{WEBSITE_TITLE}}.<br /><br />Click here to <a href="{{LOGIN_LINK}}">login and accept the invitation</a>.<br /><br />Regards,<br />The {{WEBSITE_TITLE}} team.',
    'global.emails.team_member_create.body_register' => 'Hello,<br /><br />You have been invited by <strong>{{USER:NAME}}</strong> ({{USER:EMAIL}}) to join the <strong>{{TEAM:NAME}}</strong> team on {{WEBSITE_TITLE}}.<br /><br />Click here to <a href="{{REGISTER_LINK}}">register and accept the invitation</a>.<br /><br />Regards,<br />The {{WEBSITE_TITLE}} team.',

    'global.emails.user_data_send.subject' => 'New data collected for \'{{NOTIFICATION_NAME}}\' - {{WEBSITE_TITLE}}',
    'global.emails.user_data_send.body' => 'Here is everything we have collected from the <strong>{{CAMPAIGN_NAME}}</strong> campaign - <strong>{{NOTIFICATION_NAME}}</strong> notification.<br /><br />{{DATA}} Regards,<br />The {{WEBSITE_TITLE}} team.',

    'global.emails.user_notifications_impressions_limit.subject' => 'Notification impressions limit has been reached - {{WEBSITE_TITLE}}',
    'global.emails.user_notifications_impressions_limit.body' => 'Hello <strong>{{NAME}}</strong>,<br /><br />This is a friendly notice that your notification widgets have stopped displaying because you\'ve reached the limit of your plan.<br /><br />Your <strong>{{PLAN_NAME}}</strong> plan allows <strong>{{NOTIFICATIONS_IMPRESSIONS_LIMIT}}</strong> notification impressions per month.<br /><br /> To continue displaying notifications on your campaigns, please renew your plan or upgrade to a higher one.<br /><br /><a href="{{USER_PLAN_RENEW_LINK}}" class="cta">Renew/upgrade plan</a><br /><br /> Regards,<br /> The {{WEBSITE_TITLE}} team.',

    'global.emails.admin_new_user_notification.subject' => 'New user registered - {{WEBSITE_TITLE}}',
    'global.emails.admin_new_user_notification.body' => 'Welcome to <strong>{{NAME}}</strong> ({{EMAIL}}) to your website!',

    'global.emails.admin_delete_user_notification.subject' => 'User deleted his account - {{WEBSITE_TITLE}}',
    'global.emails.admin_delete_user_notification.body' => 'All data of <strong>{{NAME}}</strong> ({{EMAIL}}) has been deleted.',

    'global.emails.admin_new_payment_notification.subject' => 'New payment via {{PROCESSOR}} of {{TOTAL_AMOUNT}} {{CURRENCY}} - {{WEBSITE_TITLE}}',
    'global.emails.admin_new_payment_notification.body' => '<strong>{{NAME}}</strong> ({{EMAIL}}) user just paid <strong>{{TOTAL_AMOUNT}} {{CURRENCY}}</strong> to your website!<br /><br />Here\'s to more earnings!',

    'global.emails.admin_new_affiliate_withdrawal_notification.subject' => 'New affiliate withdrawal request for {{TOTAL_AMOUNT}} {{CURRENCY}} - {{WEBSITE_TITLE}}',
    'global.emails.admin_new_affiliate_withdrawal_notification.body' => '<strong>{{NAME}}</strong> ({{EMAIL}}) user just submitted an affiliate withdrawal request for <strong>{{TOTAL_AMOUNT}} {{CURRENCY}}</strong> with the following note: "{{AFFILIATE_WITHDRAWAL_NOTE}}".<br /><br /><a href="{{ADMIN_AFFILIATE_WITHDRAWAL_LINK}}">View affiliate withdrawal</a>',

    'global.emails.admin_new_domain_notification.subject' => 'New custom domain is pending approval - {{WEBSITE_TITLE}}',
    'global.emails.admin_new_domain_notification.body' => '<strong>{{NAME}}</strong> ({{EMAIL}}) user\'s custom domain ({{DOMAIN_HOST}}) is now pending approval.<br /><br /> <a href="{{ADMIN_DOMAIN_UPDATE_LINK}}">View domain</a>',

    'global.emails.admin_contact.subject' => '{{SUBJECT}} - {{NAME}} - {{WEBSITE_TITLE}}',
    'global.emails.admin_contact.body' => '<strong>{{NAME}}</strong> - {{EMAIL}} has sent you the following message:<br /><br />{{MESSAGE}}',


    'global.notifications.new_user.title' => 'New user!',
    'global.notifications.new_user.description' => '<strong>%1$s</strong> (%2$s) has signed up successfully.',

    'global.notifications.delete_user.title' => 'User deleted!',
    'global.notifications.delete_user.description' => '<strong>%1$s</strong> (%2$s) has deleted his account.',

    'global.notifications.new_payment.title' => 'New payment!',
    'global.notifications.new_payment.description' => '<strong>%1$s</strong> (%2$s) user just paid <strong>%3$s %4$s</strong> via %5$s.',

    'global.notifications.new_affiliate_withdrawal.title' => 'New affiliate withdrawal request!',
    'global.notifications.new_affiliate_withdrawal.description' => '<strong>%1$s</strong> (%2$s) user just submitted an affiliate withdrawal request for <strong>%3$s %4$s</strong>.',

    'global.notifications.new_newsletter_subscriber.title' => 'New newsletter subscriber!',
    'global.notifications.new_newsletter_subscriber.description' => '<strong>%1$s</strong> (%2$s) has subscribed successfully.',

    'global.notifications.user_notifications_impressions_limit.title' => 'Monthly impressions limit has been reached.',
    'global.notifications.user_notifications_impressions_limit.description' => 'To continue displaying notifications on your campaigns, please %srenew/upgrade%s your plan.',



    'global.cookie_consent.menu' => 'Cookies',
    'global.cookie_consent.header' => 'We use cookies 🍪',
    'global.cookie_consent.subheader' => 'Hi, this website uses essential cookies to ensure its proper operation and tracking cookies to understand how you interact with it. The latter will be set only after consent.',
    'global.cookie_consent.modal.preferences.header' => 'Cookie preferences',
    'global.cookie_consent.modal.header' => 'Cookie usage 📢',
    'global.cookie_consent.modal.subheader' => 'We use cookies to ensure the basic functionalities of the website and to enhance your online experience. You can choose for each category to opt-in/out whenever you want. For more details relative to cookies and other sensitive data, please read the full <a href="%s" class="cc-link">privacy policy</a>.',
    'global.cookie_consent.modal.necessary.header' => 'Strictly necessary cookies',
    'global.cookie_consent.modal.necessary.subheader' => 'These cookies are essential for the proper functioning of my website. Without these cookies, the website would not work properly.',
    'global.cookie_consent.modal.analytics.header' => 'Performance and Analytics cookies',
    'global.cookie_consent.modal.analytics.subheader' => 'These cookies allow the website to remember the choices you have made in the past.',
    'global.cookie_consent.modal.targeting.header' => 'Advertisement and Targeting cookies',
    'global.cookie_consent.modal.targeting.subheader' => 'These cookies collect information about how you use the website, which pages you visited and which links you clicked on. All of the data is anonymized and cannot be used to identify you.',
    'global.cookie_consent.accept_all' => 'Accept all',
    'global.cookie_consent.reject_all' => 'Reject all',
    'global.cookie_consent.customize' => 'Customize',
    'global.cookie_consent.save' => 'Save settings',

    'global.footer.copyright' => 'Copyright © %1$s %2$s.',

    'global.plan_settings.annual_price_savings' => 'You save %s by purchasing the annual plan',
    'global.plan_settings.custom_css_is_enabled' => 'Custom CSS',
    'global.plan_settings.custom_css_is_enabled_help' => 'Add your custom CSS code to modify the already existing notification style.',
    'global.plan_settings.no_ads' => 'No ads',
    'global.plan_settings.no_ads_help' => 'No ads for everything related to your account and experience.',
    'global.plan_settings.export' => '%s export features',
    'global.plan_settings.removable_branding' => 'Removable branding',
    'global.plan_settings.custom_branding' => 'Custom branding',
    'global.plan_settings.campaigns_limit' => '%s Campaigns',
    'global.plan_settings.notifications_limit' => '%s Notifications',
    'global.plan_settings.notifications_impressions_limit' => '%s impressions <span class="small text-muted">/ month</span>',
    'global.plan_settings.track_notifications_retention' => '%s statistics retention',
    'global.plan_settings.track_conversions_retention' => '%s conversions retention',
    'global.plan_settings.enabled_notifications_all' => 'All notifications enabled',
    'global.plan_settings.enabled_notifications_x' => '%s enabled notifications',
    'global.plan_settings.domains_limit' => '%s custom domains',
    'global.plan_settings.api_is_enabled' => 'API access',
    'global.plan_settings.api_is_enabled_help' => 'Get access to use the REST API.',
    'global.plan_settings.white_labeling_is_enabled' => 'White labeling',
    'global.plan_settings.white_labeling_is_enabled_help' => 'White label your whole account title, logo, favicon and footer.',
    'global.plan_settings.affiliate_commission_percentage' => '%s affiliate percentage',
    'global.plan_settings.affiliate_commission_percentage_help' => 'The percentage amount that you can earn with the affiliate program.',
    'global.plan_settings.teams_limit' => '%s teams',
    'global.plan_settings.team_members_limit' => '%s team members',
    'global.plan_settings.notification_handlers_limit' => 'Multiple notification handlers',
    'global.plan_settings.notification_handlers_email_limit' => '%s email handlers',
    'global.plan_settings.notification_handlers_webhook_limit' => '%s webhook handlers',
    'global.plan_settings.notification_handlers_slack_limit' => '%s Slack handlers',
    'global.plan_settings.notification_handlers_discord_limit' => '%s Discord handlers',
    'global.plan_settings.notification_handlers_microsoft_teams_limit' => '%s Microsoft Teams handlers',
    'global.plan_settings.notification_handlers_twilio_limit' => '%s SMS handlers',
    'global.plan_settings.notification_handlers_twilio_call_limit' => '%s Phone call handlers',
    'global.plan_settings.notification_handlers_telegram_limit' => '%s Telegram handlers',
    'global.plan_settings.notification_handlers_whatsapp_limit' => '%s Whatsapp handlers',
    'global.plan_settings.notification_handlers_x_limit' => '%s X handlers',
    'global.plan_settings.notification_handlers_push_subscriber_id_limit' => '%s Push subscribers handlers',
    'global.plan_settings.notification_handlers_internal_notification_limit' => '%s Internal notifications',
    'global.plan_settings.email_reports_is_enabled' => 'Email reports',
    'global.plan_settings.email_reports_is_enabled_weekly' => 'Weekly email reports',
    'global.plan_settings.email_reports_is_enabled_monthly' => 'Monthly email reports',

    'pwa_install.header' => 'Install our app 🪄',
    'pwa_install.or' => 'or',
    'pwa_install.subheader.desktop' => 'click on the <code>%s</code> icon in the top right of the address bar.',
    'pwa_install.subheader.android_chrome' => 'tap on the <code>%s</code> menu and then tap the <code>%s Add to Home screen</code> menu item.',
    'pwa_install.subheader.ios' => 'tap on the <code>%s</code> icon and then tap the <code>%s Add to Home Screen</code> menu item.',
    'pwa_install.subheader.ios_safari' => 'click on the <code>File > Add to Dock</code> menu item of the browser.',


    'push_notifications_modal.menu' => 'Push notifications',
    'push_notifications_modal.header' => 'Push notifications',
    'push_notifications_modal.subheader' => 'You can subscribe to our web push notifications if you want to receive helpful content and non-spam promotions from us.',
    'push_notifications_modal.subscribe' => 'Subscribe',
    'push_notifications_modal.unsubscribe' => 'Unsubscribe',
    'push_notifications_modal.denied' => 'You have denied or disabled push notifications. You must enable them again from the browser settings in order to be able to subscribe.',
    'push_notifications_modal.incompatible' => 'Your browser window is incompatible with receiving push notifications.',


    'ad_blocker_detector_modal.header' => 'Ad blocker detected',
    'ad_blocker_detector_modal.subheader' => 'We serve ads so we can keep our website running. Please disable your ad blockers.',
    'ad_blocker_detector_modal.button' => 'I\'ve disabled the ad blocker',


    'duplicate_modal.header' => 'Duplicate',
    'duplicate_modal.subheader' => 'Easily duplicate this resource with a click of a button.',


    'delete_modal.header' => 'Delete',
    'delete_modal.subheader1' => 'Deleting <strong>%s</strong> cannot be undone.',
    'delete_modal.subheader2' => 'Deleting this cannot be undone.',


    'transfer_modal.header' => 'Transfer ownership',
    'transfer_modal.subheader1' => 'Transfer <strong>%s</strong> to another user account.',
    'transfer_modal.subheader2' => 'Transfer this resource to another user account.',
    'transfer_modal.success_message' => 'The ownership of %1$s has been transferred from %2$s to %3$s',


    'statistics_reset_modal.header' => 'Clear statistics',
    'statistics_reset_modal.subheader' => 'Clear the current selected statistics. This action cannot be undone.',

    'x_reset_modal.header' => 'Reset',
    'x_reset_modal.subheader' => 'Reset the state of the resource and clear all it\'s associated logs or statistics. This action cannot be undone.',


    'bulk_download_modal.header' => 'Download in bulk',
    'bulk_download_modal.subheader' => 'You\'ve selected multiple entries to be downloaded, this may take a while for the ZIP to be generated.',


    'bulk_delete_modal.header' => 'Delete in bulk',
    'bulk_delete_modal.subheader' => 'You\'ve selected multiple entries to be deleted, this may take a while & it action cannot be undone.',
    'bulk_delete_modal.success_message' => 'The bulk deletion process was performed successfully.',


    'page.breadcrumb' => 'Page',
    'page.print' => 'Print',
    'page.estimated_reading_time' => '%s read',
    'page.total_views' => '%s views',


    'pages.title' => 'Pages',
    'pages.header' => 'Resources center',
    'pages.subheader' => 'Here you can find useful page resources depending on your needs.',
    'pages.index.breadcrumb' => 'Pages',
    'pages.index.popular_pages' => 'Popular pages',
    'pages.index.pages_categories.header' => 'Categories',
    'pages.index.pages_categories.total_pages' => '%s available pages',
    'pages.pages_category.breadcrumb' => 'Pages category',
    'pages.no_data' => 'There are resources yet',
    'pages.no_data_help' => 'We still got some work to do for our resources section',


    'blog.title' => 'Blog',
    'blog.title_search' => 'Search for \'%s\' - Blog',
    'blog.breadcrumb' => 'Blog',
    'blog.menu' => 'Blog',
    'blog.header' => 'Blog',
    'blog.header_search' => 'Blog - Search for \'%s\'',
    'blog.subheader' => 'Discover insights through our curated blog posts.',
    'blog.rss' => 'RSS Feed',
    'blog.categories' => 'Categories',
    'blog.popular' => 'Popular posts',
    'blog.total_views' => '%s views',
    'blog.estimated_reading_time' => '%s read',
    'blog.blog_post.title' => '%s - Blog',
    'blog.blog_posts_category.title' => '%s - Category - Blog',
    'blog.rating' => '%1$s of %2$s ratings',
    'blog.no_data' => 'There are no blog posts yet',
    'blog.no_data_help' => 'We still got some writing to do for our blog post',


    'plan.breadcrumb' => 'Choose plan',
    'plan.title' => 'Plan',
    'plan.header_new' => 'Choose your plan',
    'plan.subheader_new' => 'Select one plan to continue your subscription.',
    'plan.header_renew' => 'Renew your plan',
    'plan.subheader_renew' => 'Select one plan to renew your subscription.',
    'plan.header_upgrade' => 'Upgrade your plan',
    'plan.subheader_upgrade' => 'Select one plan to upgrade your subscription.',

    'plan.custom_plan.monthly' => 'Monthly',
    'plan.custom_plan.quarterly' => 'Quarterly',
    'plan.custom_plan.biannual' => 'Biannual',
    'plan.custom_plan.annual' => 'Annual',
    'plan.custom_plan.lifetime' => 'Lifetime',

    'plans.choose' => 'Choose plan',
    'plans.renew' => 'Renew plan',
    'plans.trial' => 'Try for %s days',
    'plans.contact' => 'Contact us',
    'plans.lifetime' => 'Lifetime',

    'plan.why.header' => 'Why us?',
    'plan.why.subheader' => '',
    'plan.why.one.header' => 'Customer service',
    'plan.why.one.subheader' => 'Our support team will help you with any questions you may have regarding our service.',
    'plan.why.two.header' => 'Privacy',
    'plan.why.two.subheader' => 'You control all the data that you bring within your account on our website.',
    'plan.why.three.header' => 'Quality',
    'plan.why.three.subheader' => 'We focus on delivering the best experience to you, as we fully understand how valuable time is.',

    'plan.faq.header' => 'Frequently asked questions',
    'plan.faq.one.question' => 'What forms of payment do you accept?',
    'plan.faq.one.answer' => 'We accept payments via credit cards, PayPal & crypto as well.',
    'plan.faq.two.question' => 'Can I cancel my subscription?',
    'plan.faq.two.answer' => 'Yes, you definitely can cancel your subscription and, you will still have access to all the features that you already paid for until the end of paid date range.',
    'plan.faq.three.question' => 'Will I get an invoice?',
    'plan.faq.three.answer' => 'Yes, an invoice will be automatically generated for you after any payments from your account.',
    'plan.faq.four.question' => 'Can I have a refund?',
    'plan.faq.four.answer' => 'We do offer refunds in case something goes wrong or you change your mind, simply contact us if needed.',


    'pay_billing.breadcrumb' => 'Billing',
    'pay_billing.title' => 'Billing',
    'pay_billing.header' => 'Fill in your billing details',
    'pay_billing.subheader' => 'We require your billing details for generating proper invoices & for tax handling, provide valid billing details only.',
    'pay_billing.submit' => 'Update & continue to %s checkout',


    'pay.breadcrumb' => '%s plan',
    'pay.title' => 'Pay - %s',
    'pay.attention_title' => '✨Checkout ready 🔥',
    'pay.plan_details' => 'What you\'ll get',
    'pay.accept' => 'By continuing with your order you confirm that you read, understand & agree to the %1$s and %2$s of the site.',

    'pay.free.free_already' => 'You already have the free plan activated.',
    'pay.free.other_plan_not_expired' => 'Your current plan is not expired yet, you will get the free plan after it expires.',

    'pay.trial.header' => 'Start the %s plan',
    'pay.trial.subheader' => 'You are almost there, no strings attached.',
    'pay.trial.trial_start' => 'Start my %s days trial',
    'pay.trial.trial_skip' => 'Skip trial',

    'pay.custom_plan.header' => 'Purchase the %s plan',
    'pay.custom_plan.subheader' => 'You are almost there, complete the following form and checkout.',
    'pay.custom_plan.paypal' => 'PayPal',
    'pay.custom_plan.stripe' => 'Stripe',
    'pay.custom_plan.offline_payment' => 'Offline payment',
    'pay.custom_plan.coinbase' => 'Coinbase',
    'pay.custom_plan.payu' => 'PayU',
    'pay.custom_plan.iyzico' => 'Iyzico',
    'pay.custom_plan.paystack' => 'Paystack',
    'pay.custom_plan.razorpay' => 'Razorpay',
    'pay.custom_plan.mollie' => 'Mollie',
    'pay.custom_plan.yookassa' => 'Yookassa',
    'pay.custom_plan.crypto_com' => 'Crypto.com',
    'pay.custom_plan.paddle' => 'Paddle',
    'pay.custom_plan.mercadopago' => 'MercadoPago',
    'pay.custom_plan.midtrans' => 'Midtrans',
    'pay.custom_plan.flutterwave' => 'Flutterwave',
    'pay.custom_plan.lemonsqueezy' => 'Lemonsqueezy',
    'pay.custom_plan.myfatoorah' => 'Myfatoorah',
    'pay.custom_plan.payment_frequency' => 'Payment frequency',
    'pay.custom_plan.monthly' => 'Monthly payments',
    'pay.custom_plan.quarterly' => 'Quarterly payments',
    'pay.custom_plan.biannual' => 'Biannual payments',
    'pay.custom_plan.annual' => 'Annual payments',
    'pay.custom_plan.annual_savings' => '%1$s %2$s',
    'pay.custom_plan.lifetime' => 'Lifetime deal',
    'pay.custom_plan.lifetime_help' => 'One time payment',
    'pay.custom_plan.code_button' => 'Use discount code',
    'pay.custom_plan.code' => 'Code',
    'pay.custom_plan.payment_processor' => 'Payment method',
    'pay.custom_plan.no_processor' => 'There are no payment processors available at the moment.',
    'pay.custom_plan.offline_payment_instructions' => 'Payment instructions',
    'pay.custom_plan.offline_payment_proof' => 'Proof of payment',
    'pay.custom_plan.payment_type' => 'Type of payment',
    'pay.custom_plan.one_time_type' => 'One time payment',
    'pay.custom_plan.recurring_type' => 'Recurring payment',

    'pay.custom_plan.summary.header' => 'Order summary',
    'pay.custom_plan.summary.plan' => 'Plan',
    'pay.custom_plan.summary.payment_frequency' => 'Frequency',
    'pay.custom_plan.summary.monthly' => 'Monthly',
    'pay.custom_plan.summary.monthly_help' => 'Every 30 days',
    'pay.custom_plan.summary.quarterly' => 'Quarterly',
    'pay.custom_plan.summary.quarterly_help' => 'Every 90 days',
    'pay.custom_plan.summary.biannual' => 'Biannual',
    'pay.custom_plan.summary.biannual_help' => 'Every 180 days',
    'pay.custom_plan.summary.annual' => 'Yearly',
    'pay.custom_plan.summary.annual_help' => 'Every 365 days',
    'pay.custom_plan.summary.lifetime' => 'Lifetime',
    'pay.custom_plan.summary.lifetime_help' => '',
    'pay.custom_plan.summary.payment_processor' => 'Paid with',
    'pay.custom_plan.summary.payment_type' => 'Type',
    'pay.custom_plan.summary.one_time' => 'One time',
    'pay.custom_plan.summary.one_time_help' => '',
    'pay.custom_plan.summary.recurring' => 'Recurring',
    'pay.custom_plan.summary.recurring_help' => 'Automatic billing',
    'pay.custom_plan.summary.plan_price' => 'Price',
    'pay.custom_plan.summary.discount' => 'Discount',
    'pay.custom_plan.summary.tax_inclusive' => 'Inclusive',
    'pay.custom_plan.summary.tax_exclusive' => 'Exclusive',
    'pay.custom_plan.summary.total' => 'Total',
    'pay.custom_plan.pay' => 'Checkout',
    'pay.custom_plan.code_redeemable' => 'Redeem %s days for free.',

    'pay.success_message.code' => 'Applied code for %s.',

    'pay.error_message.code_invalid' => 'This code is invalid.',
    'pay.error_message.code_used' => 'You have already used this code.',
    'pay.error_message.canceled_payment' => 'It seems you\'ve canceled the payment for some reason.',
    'pay.error_message.failed_payment' => 'Something didn\'t work quite right, please try again and if this persists contact the site admin.',
    'pay.error_message.offline_payment_proof_missing' => 'You must upload a payment proof before submitting the payment order.',

    'pay_thank_you.title' => 'Thank you',
    'pay_thank_you.header' => 'Thank you!',
    'pay_thank_you.button' => 'Go to my dashboard',
    'pay_thank_you.plan_trial_start' => 'Your %s day trial period just started!',
    'pay_thank_you.plan_redeemed' => 'You redeemed %s days!',
    'pay_thank_you.plan_custom_will_start' => 'Your payment was sent and your new membership will be activated!',
    'pay_thank_you.plan_custom_pending' => 'Your payment order was sent and your new membership will be activated if the proof will be accepted!',

    'account.title' => 'Account',
    'account.menu' => 'Account',

    'account.plan.header' => '%s plan',
    'account.plan.subheader' => 'ends on %s',
    'account.plan.upgrade_plan' => 'Upgrade plan',
    'account.plan.renew_plan' => 'Renew or change plan',
    'account.plan.renew' => 'Renew/Upgrade',

    'account.settings.header' => 'Settings',
    'account.settings.subheader' => 'Main settings of your account.',
    'account.settings.avatar' => 'Avatar',
    'account.settings.timezone' => 'Timezone',
    'account.settings.timezone_help' => 'Your preferred way of displaying dates.',
    'account.settings.anti_phishing_code' => 'Anti phishing code',
    'account.settings.anti_phishing_code_help' => 'You\'ll get this code on each email that we send you, so you\'ll know it\'s a valid email from us.',
    'account.settings.is_newsletter_subscribed' => 'Newsletter subscribed',
    'account.settings.is_newsletter_subscribed_help' => 'Receive a few emails per month with updates & discount campaigns we may run. We won\'t spam you.',
    'account.settings.referral_key' => 'Referral key',

    'account.billing.header' => 'Billing details',
    'account.billing.subheader' => 'These billing details are used when generating invoices after a successful payment.',
    'account.billing.subscription_id_active' => 'You have an active subscription, you can\'t change the billing details until the subscription expires or is cancelled.',
    'account.billing.type' => 'Type',
    'account.billing.type_personal' => 'Personal',
    'account.billing.type_business' => 'Business',
    'account.billing.name' => 'Name',
    'account.billing.address' => 'Address',
    'account.billing.county' => 'County',
    'account.billing.zip' => 'ZIP',
    'account.billing.phone' => 'Phone',
    'account.billing.tax_id' => 'Tax ID',
    'account.billing.notes' => 'Additional notes',
    'account.billing.notes_help' => 'Here you can write additional data that you want to have on your invoices.',

    'account.change_password.header' => 'Change password',
    'account.change_password.subheader' => 'If you do not want to change your password, do not fill any of those fields below.',
    'account.change_password.current_password' => 'Current password',
    'account.change_password.current_password_help' => 'If you do not know your current password, you mut logout and use the lost password functionality to reset it.',
    'account.change_password.new_password' => 'New password',
    'account.change_password.repeat_password' => 'Repeat password',

    'account.twofa.header' => 'Two-factor authentication',
    'account.twofa.subheader' => 'Use a mobile authentication app to get a verification code to enter every time you log in.',
    'account.twofa.is_enabled' => 'Enable Two-factor authentication',
    'account.twofa.qr' => '1. Scan QR Code',
    'account.twofa.qr_help' => 'Open your authentication app (ex: Authy, Google Authenticator) on your mobile device and scan the QR code using your camera.',
    'account.twofa.secret' => 'Can\'t scan the QR Code?',
    'account.twofa.secret_help' => 'Copy the following secret code into your app for a manual setup.',
    'account.twofa.verify' => '2. Enter freshly generated token',
    'account.twofa.verify_help' => 'To confirm that you setup your code properly, enter the 6-digit token from your mobile app.',

    'account.info_message.user_pending_email' => 'An email confirmation was sent to the new email address. Make sure to check and confirm it via email.',
    'account.error_message.invalid_current_password' => 'Your current password is not valid.',
    'account.error_message.twofa_check' => 'The token that you entered is not valid.',
    'account.error_message.referral_key_exists' => 'This referral key is already in use.',
    'account.success_message.account_updated' => 'Your account was updated.',
    'account.success_message.password_updated' => 'Your account password was updated.',


    'account_preferences.title' => 'Preferences',
    'account_preferences.menu' => 'Preferences',
    'account_preferences.header' => 'Preferences',
    'account_preferences.subheader' => 'Here you can set different preferences for your account related to the site usage.',
    'account_preferences.success_message' => 'Your account preferences have been updated.',
    'account_preferences.avatar' => 'Avatar',
    'account_preferences.tracking_settings' => 'Tracking settings',
    'account_preferences.excluded_ips' => 'Excluded IPs',
    'account_preferences.excluded_ips_help' => 'Exclude IPs from being tracked. Comma separated values.',
    'account_preferences.default_settings' => 'Default settings',
    'account_preferences.default_results_per_page' => 'Default results per page',
    'account_preferences.default_order_type' => 'Default results order',
    'account_preferences.default_order_by_x' => '%s default order by',
    'account_preferences.white_labeling' => 'White labeling settings',
    'account_preferences.white_label_title' => 'White label title',
    'account_preferences.white_label_logo_light' => 'White label logo light',
    'account_preferences.white_label_logo_dark' => 'White label logo dark',
    'account_preferences.white_label_favicon' => 'White label favicon',


    'account_delete.title' => 'Delete account',
    'account_delete.menu' => 'Delete account',
    'account_delete.header' => 'Delete account',
    'account_delete.subheader' => 'By deleting the account, all of your stored data will be deleted. This action is irreversible once done.',
    'account_delete.current_password' => 'Current Password',
    'account_delete.error_message.invalid_current_password' => 'Your current password is not valid.',
    'account_delete.success_message' => 'Your account was fully deleted. We\'re sorry to see you go.',


    'account_redeem_code.title' => 'Redeem code',
    'account_redeem_code.menu' => 'Redeem code',
    'account_redeem_code.header' => 'Redeem code',
    'account_redeem_code.subheader' => 'If you own a redeeming code for a particular plan, you can redeem it right here.',
    'account_redeem_code.plan_id' => 'Plan',
    'account_redeem_code.code' => 'Code',
    'account_redeem_code.success_message' => 'You redeemed %1$s days of the %2$s plan.',
    'account_redeem_code.success_message_lifetime' => 'You redeemed the %2$s plan for lifetime.',
    'account_redeem_code.info_message' => 'Your current plan will be overwritten if you redeem a code that is different than your already existing plan.',
    'account_redeem_code.error_message.code_invalid' => 'This code is invalid.',
    'account_redeem_code.error_message.code_used' => 'You have already used this code.',


    'account_plan.title' => 'Account Plan',
    'account_plan.menu' => 'Plan',
    'account_plan.header' => 'Account Plan',

    'account_plan.plan.renews' => 'Plan will renew on %1$s via %2$s (%3$s %4$s)',
    'account_plan.plan.expires' => 'Plan ends on %s',
    'account_plan.plan.lifetime' => 'Plan is for lifetime, it does not expire.',

    'account_plan.cancel.header' => 'Cancel subscription',
    'account_plan.cancel.subheader' => 'By cancelling your subscription no further payments will be made. You will still have access to your features that you paid for until the expiration date.',
    'account_plan.cancel.cancel' => 'Cancel subscription',
    'account_plan.cancel.confirm_message' => 'Are you sure you want to cancel your subscription?',
    'account_plan.cancel.reason' => 'Cancelled from %s',

    'account_plan.success_message.subscription_canceled' => 'Your recurring subscription was canceled.',

    'account_payments.title' => 'Account payments',
    'account_payments.menu' => 'Payments',
    'account_payments.header' => 'Account payments',
    'account_payments.subheader' => 'All the payments made on your account.',

    'account_payments.payment_processor' => 'Processor',
    'account_payments.total_amount' => 'Total amount',
    'account_payments.plan_id' => 'Plan',
    'account_payments.invoice' => 'Invoice',
    'account_payments.status_pending' => 'Pending approval',
    'account_payments.status_approved' => 'Approved',
    'account_payments.no_data' => 'No payments found',

    'account_payments.processor' => 'Processor',
    'account_payments.type_one_time' => 'One time',
    'account_payments.type_recurring' => 'Recurring',
    'account_payments.frequency' => 'Frequency',
    'account_payments.order_by_total_amount' => 'Total amount',

    'account_logs.title' => 'Account logs',
    'account_logs.menu' => 'Logs',
    'account_logs.header' => 'Account logs',
    'account_logs.subheader' => 'A list of your most important recorded activity.',

    'account_logs.logs.no_data' => 'Your account has no recorded logs',
    'account_logs.logs.no_data_help' => 'Here you will be able to find important log entries regarding your account.',


    'account_api.title' => 'Account API',
    'account_api.menu' => 'API',
    'account_api.header' => 'API',
    'account_api.subheader' => 'Do not share your API key with unauthorized people.',
    'account_api.api_key' => 'API Key',
    'account_api.button' => 'Regenerate API Key',
    'account_api.success_message' => 'Your API key was regenerated successfully.',


    'teams_system.title' => 'Teams system',
    'teams_system.menu' => 'Teams',
    'teams_system.breadcrumb' => 'Teams system',
    'teams_system.header' => 'Teams system',


    'teams.title' => 'My teams',
    'teams.menu' => 'My teams',
    'teams.breadcrumb' => 'My teams',
    'teams.header' => ' My teams',
    'teams.subheader' => 'Create, invite and manage your teams.',
    'teams.create' => 'Create team',
    'teams.table.members' => 'Members',
    'teams.team' => 'Team',
    'teams.no_data' => 'There are no teams available',
    'teams.no_data_help' => 'Start by creating your first team & invite people.',


    'team.breadcrumb' => 'Team',
    'team.title' => 'Team - %s',
    'team.header' => '%s team',


    'team_create.breadcrumb' => 'Create team',
    'team_create.title' => 'Create team',
    'team_create.header' => 'Create team',


    'team_update.breadcrumb' => 'Update team',
    'team_update.title' => 'Update team',
    'team_update.header' => 'Update team',


    'team_members.create' => 'Invite member',
    'team_members.access' => '%s permissions',
    'team_members.access_help' => 'Set what permissions you want to hand out to the user.',
    'team_members.access.read' => 'View',
    'team_members.access.create' => 'Create',
    'team_members.access.update' => 'Update',
    'team_members.access.delete' => 'Delete',
    'team_members.table.member' => 'Member',
    'team_members.table.status_invited' => 'Invited',
    'team_members.table.status_accepted' => 'Accepted',
    'team_members.table.datetime' => 'Invited',
    'team_members.info_message.access' => 'The invited user will not have access to any account related pages, such as the account settings, payments, logs...etc.',
    'team_members.error_message.email_exists' => 'This email is already invited.',
    'team_members.no_data' => 'There are no team members available',
    'team_members.no_data_help' => 'Start by inviting your first member.',


    'team_member_create.breadcrumb' => 'Invite team member',
    'team_member_create.title' => 'Invite team member - %s',
    'team_member_create.header' => 'Invite team member',
    'team_member_create.submit' => 'Invite via Email',
    'team_member_create.success_message' => '%s has been successfully invited.',


    'team_member_update.breadcrumb' => 'Update team member',
    'team_member_update.title' => 'Update team member - %s',
    'team_member_update.header' => 'Update team member',


    'teams_member.title' => 'Teams\' member',
    'teams_member.menu' => 'Teams\' member',
    'teams_member.breadcrumb' => 'Teams\' member',
    'teams_member.header' => ' Teams member',
    'teams_member.subheader' => 'Manage the teams you\'re invited / a member of.',
    'teams_member.table.team' => 'Team',
    'teams_member.table.datetime' => 'Invited',
    'teams_member.no_data' => 'There are no teams available',
    'teams_member.no_data_help' => 'You\'re not invited to any team yet.',


    'teams_member_delete_modal.header' => 'Leave team',
    'teams_member_delete_modal.subheader' => 'This action cannot be undone.',


    'teams_member_join_modal.menu' => 'Join team',
    'teams_member_join_modal.header' => 'Join team',
    'teams_member_join_modal.subheader' => 'Accept & join the invitation of the team.',


    'teams_member_login_modal.menu' => 'Login',
    'teams_member_login_modal.header' => 'Login team',
    'teams_member_login_modal.subheader' => 'Log into the team and start managing it.',


    'referrals.title' => 'Referrals',
    'referrals.menu' => 'Referrals',

    'referrals.invite.header' => 'Invite people',
    'referrals.invite.subheader_once' => 'Invite people to %s with the following link and get %s from their first payment to the platform.',
    'referrals.invite.subheader_forever' => 'Invite people to %s with the following link and get %s from all their payments to the platform.',
    'referrals.invite.referral_key' => 'Referral link',
    'referrals.invite.referral_key_help' => 'You can add the %s parameter to any link of our website.',

    'referrals.statistics.header' => 'Statistics',
    'referrals.statistics.referrals' => 'Referrals',
    'referrals.statistics.referrals_help' => 'People who have signed up using your referral link.',
    'referrals.statistics.converted_referrals' => 'Paying referrals',
    'referrals.statistics.converted_referrals_help' => 'People who have signed up & paid for a plan at least once.',
    'referrals.statistics.pending_affiliate_commissions' => 'Pending commissions',
    'referrals.statistics.pending_affiliate_commissions_help' => 'All payments are held for 30 days for proper confirmation before they are approved.',
    'referrals.statistics.approved_affiliate_commissions' => 'Approved commissions',
    'referrals.statistics.approved_affiliate_commissions_help' => 'All payments that have been approved, which are ready to be withdrawn.',

    'referrals.withdraw.header' => 'Withdraw',
    'referrals.withdraw.subheader' => 'Once you reach at least %s, you can create a withdrawal request.',
    'referrals.withdraw.amount' => 'Amount',
    'referrals.withdraw.is_paid_paid' => 'Paid',
    'referrals.withdraw.is_paid_pending' => 'Pending',
    'referrals.withdraw.success_message' => 'Your withdrawal request has been sent for approval and processing.',


    'sso.menu' => 'Go to %s',


    'invoice.title' => 'Invoice %s',
    'invoice.print' => 'Print',
    'invoice.invoice' => 'Invoice',
    'invoice.invoice_nr' => 'Invoice Nr',
    'invoice.invoice_date' => 'Date',
    'invoice.vendor' => 'Vendor',
    'invoice.customer' => 'Customer',
    'invoice.notes' => 'Additional notes',
    'invoice.name' => 'Name',
    'invoice.address' => 'Address',
    'invoice.county' => 'County',
    'invoice.zip' => 'ZIP',
    'invoice.phone' => 'Phone',
    'invoice.tax_id' => 'Tax ID',

    'invoice.item' => 'Item',
    'invoice.amount' => 'Amount',
    'invoice.plan' => '%s Plan',
    'invoice.frequency' => '%s access.',
    'invoice.frequency.monthly' => '30 days',
    'invoice.frequency.quarterly' => '90 days',
    'invoice.frequency.biannual' => '180 days',
    'invoice.frequency.annual' => '1 year',
    'invoice.frequency.lifetime' => 'Lifetime',
    'invoice.code' => 'Discount',
    'invoice.code_help' => 'Code used: %s',
    'invoice.total' => 'Total',
    'invoice.paid_via' => 'Paid via %s',


    'maintenance.title' => 'Maintenance mode',
    'maintenance.header' => 'Maintenance mode',
    'maintenance.subheader' => 'We are doing some maintenance work, we\'ll be back soon.',


    'login.menu' => 'Sign in',
    'login.title' => 'Sign in',
    'login.header' => 'Sign in',
    'login.twofa_token' => 'Two-factor token',
    'login.remember_me' => 'Remember me',
    'login.remember_me_help' => 'A browser cookie will be used to remember you for %s days on this browser.',
    'login.login' => 'Login',
    'login.verify' => 'Verify',
    'login.register' => 'Don\'t have an account? %s',
    'login.register_help' => 'Register',
    'login.lost_password' => 'Lost password',
    'login.resend_activation' => 'Resend activation',
    'login.facebook' => 'Sign in with Facebook',
    'login.google' => 'Sign in with Google',
    'login.twitter' => 'Sign in with X',
    'login.discord' => 'Sign in with Discord',
    'login.linkedin' => 'Sign in with LinkedIn',
    'login.microsoft' => 'Sign in with Microsoft',
    'login.info_message.twofa_token' => 'Two-factor authentication is required.',
    'login.info_message.logged_in' => 'Welcome back, %s.',
    'login.error_message.twofa_token' => 'Your two-factor authentication token is invalid.',
    'login.error_message.wrong_login_credentials' => 'Your login combination is invalid.',
    'login.error_message.user_not_active' => 'Your account is not confirmed or banned.',
    'login.error_message.email_is_null' => 'Your social account doesn\'t have an email associated with it.',


    'lost_password.title' => 'Lost password',
    'lost_password.header' => 'Lost password',
    'lost_password.subheader' => 'We will send you an email with a magic recovery link to reset your password.',
    'lost_password.return' => 'Return to Login',
    'lost_password.submit' => 'Send me a recovery link',
    'lost_password.success_message' => 'We\'ve emailed you the password reset link.',


    'resend_activation.title' => 'Resend activation',
    'resend_activation.header' => 'Resend activation email',
    'resend_activation.subheader' => 'Mails can get lost, but we can send you another activation email for your account.',
    'resend_activation.return' => 'Return to Login',
    'resend_activation.submit' => 'Send me the activation email',
    'resend_activation.success_message' => 'We\'ve emailed you the activation link.',


    'reset_password.title' => 'Set a new password',
    'reset_password.header' => 'Set a new password',
    'reset_password.subheader' => 'For better security, make sure your new password is strong.',
    'reset_password.return' => 'Return to Login',
    'reset_password.new_password' => 'New password',
    'reset_password.repeat_password' => 'Repeat your new password',
    'reset_password.submit' => 'Set password',
    'reset_password.success_message' => 'Your new password is set.',


    'activate_user.user_activation' => 'Your account has been confirmed and is now active.',
    'activate_user.user_pending_email' => 'Your new email address has been confirmed.',


    'register.title' => 'Sign up',
    'register.menu' => 'Sign up',
    'register.header' => 'Sign up',
    'register.repeat_password' => 'Repeat Password',
    'register.accept' => 'I confirm that I have read and understood the %1$s and %2$s of the site.',
    'register.is_newsletter_subscribed' => 'I agree receive a few emails per month from the newsletter. You can unsubscribe at any time.',
    'register.register' => 'Register',
    'register.login' => 'Already have an account? %s',
    'register.login_help' => 'Sign in',
    'register.error_message.name_length' => 'Name must be between 1 and 64 characters.',
    'register.error_message.email_exists' => 'This email address is already in use.',
    'register.error_message.blacklisted_domain' => 'This email domain has been blacklisted.',
    'register.error_message.blacklisted_country' => 'Your country has been blacklisted.',
    'register.success_message.registration' => 'We\'ve emailed you the activation link.',
    'register.success_message.login' => 'Welcome to our platform, we are grateful to have you here.',


    'dashboard.title' => 'Dashboard',
    'dashboard.breadcrumb' => 'Dashboard',
    'dashboard.menu' => 'Dashboard',
    'dashboard.header' => 'Dashboard',
    'dashboard.total_campaigns' => '%s campaigns',
    'dashboard.total_notifications' => '%s notifications',
    'dashboard.total_notifications_impressions' => '%1$s / %2$s impressions',
    'dashboard.campaigns_header' => 'Latest campaigns',
    'dashboard.notifications_header' => 'Latest notifications',


    'statistics.breadcrumb' => 'Statistics',
    'statistics.title' => 'Statistics',
    'statistics.menu' => 'Statistics',
    'statistics.header' => 'Statistics',
    'statistics.subheader' => 'All your campaigns statistics that you have under your account.',
    'statistics.disabled' => 'The analytics tracking feature is currently disabled.',
    'statistics.link' => 'Statistics',
    'statistics.impressions_chart' => 'Impressions',
    'statistics.hovers_chart' => 'Mouse hovers',
    'statistics.clicks_chart' => 'Clicks',
    'statistics.form_submissions_chart' => 'Form submissions',
    'statistics.no_data' => 'There are no statistics available for this date range',
    'statistics.no_data_help' => 'Wait for new traffic or change your date range.',

    'campaigns.breadcrumb' => 'Campaigns',
    'campaigns.title' => 'Campaigns',
    'campaigns.menu' => 'Campaigns',
    'campaigns.header' => 'Campaigns',
    'campaigns.x_notifications' => '%s notifications',
    'campaigns.subheader' => 'A campaign can be used to create multiple widget notifications for a specific domain.',
    'campaigns.create' => 'Create campaign',
    'campaigns.table.campaign' => 'Campaign',
    'campaigns.table.is_enabled_tooltip' => 'Change the status',
    'campaigns.domain' => 'Domain',
    'campaigns.domain_placeholder' => 'ex: domain.com or subdomain.domain.com',
    'campaigns.domain_help' => 'The website domain name where the notifications will show up.',
    'campaigns.domain_id' => 'Custom domain',
    'campaigns.domain_id_help' => 'Use a custom domain for your tracking code URL. Helpful to bypass ad-blockers.',
    'campaigns.email_reports_is_enabled_help' => 'Receive simple and easy to understand analytics for your campaign via email.',
    'campaigns.no_data' => 'There are no campaigns available',
    'campaigns.no_data_help' => 'Start by creating your first campaign',
    'campaigns.error_message.blacklisted_domain' => 'This domain is blacklisted.',


    'campaign.title' => 'Campaign - %s',
    'campaign.breadcrumb' => 'Campaign',
    'campaign.custom_branding' => 'Custom branding',
    'campaign.pixel_key' => 'Install pixel',
    'campaign.notifications.link' => 'Notifications',
    'campaign.notifications.header' => 'Notifications',


    'campaign_custom_branding_modal.header' => 'Custom branding',
    'campaign_custom_branding_modal.subheader' => 'Create your own custom branding for your notifications.',
    'campaign_custom_branding_modal.name' => 'Branding',
    'campaign_custom_branding_modal.name_help' => 'Leave empty to have the default site branding.',


    'campaign_create_modal.header' => 'Create a new campaign',
    'campaign_create_modal.subheader' => 'Easily create a new campaign by filling the following information.',


    'campaign_update_modal.header' => 'Edit campaign',
    'campaign_update_modal.subheader' => 'Change an already existing campaign.',


    'campaign_pixel_key_modal.install.header' => 'Install pixel',
    'campaign_pixel_key_modal.install.subheader' => 'Copy and paste the following JS code snippet before the end of the <code>head</code> tag of your website.',
    'campaign_pixel_key_modal.install.copy' => 'Copy pixel code',


    'notifications.title' => 'Campaign notifications',
    'notifications.header' => 'Campaign notifications',
    'notifications.create' => 'Create notification',
    'notifications.link' => 'Notifications',
    'notifications.table.name' => 'Notification',
    'notifications.table.display_trigger' => 'Trigger',
    'notifications.table.display_duration' => 'Duration',
    'notifications.table.is_enabled_tooltip' => 'Change the status',
    'notifications.table.display_duration_unlimited' => 'Forever',
    'notifications.no_data' => 'There are no notifications available',
    'notifications.no_data_help' => 'Start by creating your first notification.',


    'notification.breadcrumb' => 'Notification',
    'notification.title' => 'Notification - %s',

    'notification.settings.link' => 'Settings',
    'notification.settings.tab_basic' => 'Main',
    'notification.settings.tab_triggers' => 'Triggers',
    'notification.settings.tab_display' => 'Display',
    'notification.settings.tab_customize' => 'Customize',
    'notification.settings.tab_data' => 'Data',
    'notification.settings.name' => 'Notification name',
    'notification.settings.html_info' => 'This field accepts the usage of <code>span</code> HTML tag along with the <code>style</code> attribute.',
    'notification.settings.html_info_tooltip' => 'Available CSS for the style attribute: color,font-weight,font-style,text-decoration,font-family,background-color,text-transform,margin,padding,text-align',
    'notification.settings.countdown_end_date' => 'Countdown end date',
    'notification.settings.title' => 'Title message',
    'notification.settings.description' => 'Description message',
    'notification.settings.content_title' => 'Content title',
    'notification.settings.content_description' => 'Content description',
    'notification.settings.audio' => 'Audio file',
    'notification.settings.audio_autoplay' => 'Allow audio autoplay',
    'notification.settings.audio_controls' => 'Display audio controls',
    'notification.settings.audio_loop' => 'Audio loop enabled',
    'notification.settings.audio_muted' => 'Audio is muted',
    'notification.settings.video' => 'YouTube video embed URL or direct video URL',
    'notification.settings.video_help' => 'Allowed formats: <code>https://www.youtube.com/embed/VIDEO_ID</code> or <code>https://www.youtube.com/watch?v=VIDEO_ID</code> or <code>https://example.com/video.mp4</code> or <code>https://vimeo.com/1035359933</code>',
    'notification.settings.video_autoplay' => 'Allow video autoplay',
    'notification.settings.video_controls' => 'Display video controls',
    'notification.settings.video_loop' => 'Video loop enabled',
    'notification.settings.video_muted' => 'Video is muted',
    'notification.settings.last_activity' => 'Count data from last',
    'notification.settings.conversion_title' => 'Conversion title',
    'notification.settings.conversion_title_help' => 'You can insert dynamic variables from your Conversion Data. Example: If you have a field named <code>full_name</code>, you can use it as <code>{full_name}</code>.',
    'notification.settings.conversion_description' => 'Conversion description',
    'notification.settings.conversion_active_help' => 'You can insert dynamic variables from your Conversion Data as mentioned in the Conversion Title.',
    'notification.settings.order' => 'Display order',
    'notification.settings.order_descending' => 'Descending',
    'notification.settings.order_random' => 'Random',
    'notification.settings.conversions_count' => 'How many conversions to show?',
    'notification.settings.in_between_delay' => 'In between delay',
    'notification.settings.reviews_count' => 'How many reviews to show?',
    'notification.settings.input_placeholder' => 'Input placeholder',
    'notification.settings.name_placeholder' => 'Name placeholder',
    'notification.settings.email_placeholder' => 'Email placeholder',
    'notification.settings.image' => 'Image',
    'notification.settings.image_alt' => 'Image alt',
    'notification.settings.image_alt_help' => 'Image description for accessibility and SEO purposes.',
    'notification.settings.url' => 'Notification URL',
    'notification.settings.url_help' => 'The URL you want to user to go to after clicking the notification. Leave empty for no link.',
    'notification.settings.display_time' => 'Display timestamp',
    'notification.settings.url_new_tab' => 'On click open on new tab',
    'notification.settings.url_new_tab_help' => '',
    'notification.settings.url_link' => 'Link URL',
    'notification.settings.url_link_text' => 'Link URL text',
    'notification.settings.thank_you_url' => 'Thank you URL',
    'notification.settings.thank_you_url_help' => 'The URL the user will be redirected to after submitting the form. Leave empty to disable the function.',
    'notification.settings.coupon_code' => 'Coupon code',
    'notification.settings.button_url' => 'Button URL',
    'notification.settings.button_text' => 'Button text',
    'notification.settings.button_text_help' => 'Leave empty to remove the button completely.',
    'notification.settings.share_url' => 'Share URL',
    'notification.settings.share_url_help' => 'Leave empty if you want the URL to be dynamic to the current page where the notification is shown.',
    'notification.settings.share_facebook' => 'Facebook share button',
    'notification.settings.share_threads' => 'Threads share button',
    'notification.settings.share_x' => 'X share button',
    'notification.settings.share_linkedin' => 'Linkedin share button',
    'notification.settings.share_pinterest' => 'Pinterest share button',
    'notification.settings.share_reddit' => 'Reddit share button',
    'notification.settings.share_tumblr' => 'Tumblr share button',
    'notification.settings.share_telegram' => 'Telegram share button',
    'notification.settings.share_whatsapp' => 'Whatsapp share button',
    'notification.settings.show_angry' => 'Show Angry',
    'notification.settings.show_sad' => 'Show Sad',
    'notification.settings.show_neutral' => 'Show Neutral',
    'notification.settings.show_happy' => 'Show Happy',
    'notification.settings.show_excited' => 'Show Excited',
    'notification.settings.show_agreement' => 'Show agreement',
    'notification.settings.show_agreement_help' => 'Require the user to confirm his agreement by ticking a checkbox.',
    'notification.settings.agreement_url' => 'Agreement URL',
    'notification.settings.agreement_text' => 'Agreement text',
    'notification.settings.html' => 'Custom HTML',
    'notification.settings.html_help' => 'Use <code>{CLOSE_BUTTON}</code> to add a close button if needed.',
    'notification.settings.contact_email' => 'Contact email',
    'notification.settings.contact_phone_number' => 'Contact phone number',
    'notification.settings.contact_whatsapp' => 'Contact whatsapp',
    'notification.settings.contact_telegram' => 'Contact telegram',
    'notification.settings.contact_facebook_messenger' => 'Contact FB messenger',
    'notification.settings.agent_image' => 'Agent image URL',
    'notification.settings.agent_name' => 'Agent name',
    'notification.settings.agent_description' => 'Agent description',
    'notification.settings.agent_message' => 'Agent message',
    'notification.settings.agent_phone_number' => 'Agent Whatsapp phone number',
    'notification.settings.trigger_all_pages' => 'Trigger on all pages',
    'notification.settings.trigger_all_pages_help' => 'Where should the notification show?',
    'notification.settings.trigger_add' => 'Add new trigger',
    'notification.settings.trigger_type_exact' => 'Exact match',
    'notification.settings.trigger_type_not_exact' => 'Does not match exact',
    'notification.settings.trigger_type_contains' => 'Contains',
    'notification.settings.trigger_type_not_contains' => 'Does not contain',
    'notification.settings.trigger_type_starts_with' => 'Starts with',
    'notification.settings.trigger_type_not_starts_with' => 'Does not start with',
    'notification.settings.trigger_type_ends_with' => 'Ends with',
    'notification.settings.trigger_type_not_ends_with' => 'Does not end with',
    'notification.settings.trigger_type_page_contains' => 'Page contains',
    'notification.settings.trigger_type_exact_placeholder' => 'Full URL - ex: https://domain.com',
    'notification.settings.trigger_type_not_exact_placeholder' => 'Full URL - ex: https://domain.com',
    'notification.settings.trigger_type_contains_placeholder' => 'Part of the URL - ex: /product/12345',
    'notification.settings.trigger_type_not_contains_placeholder' => 'Part of the URL - ex: /product/12345',
    'notification.settings.trigger_type_starts_with_placeholder' => 'Part of the URL - ex: https://domain.com/product',
    'notification.settings.trigger_type_not_starts_with_placeholder' => 'Part of the URL - ex: https://domain.com/product',
    'notification.settings.trigger_type_ends_with_placeholder' => 'Part of the URL - ex: /product/12345',
    'notification.settings.trigger_type_not_ends_with_placeholder' => 'Part of the URL - ex: /product/12345',
    'notification.settings.trigger_type_page_contains_placeholder' => 'Text inside of the website',
    'notification.settings.display_delay_type_after_close' => 'Display delay type after closing the notification',
    'notification.settings.display_delay_type_after_close_help' => 'If the user manually closed the notification, you can set a specific delay to wait before the notification will display again.',
    'notification.settings.display_delay_type_after_close_time_on_site' => 'Time on site',
    'notification.settings.display_delay_type_after_close_pageviews' => 'Pageviews',
    'notification.settings.display_trigger' => 'Display trigger',
    'notification.settings.display_trigger_delay' => 'Delay',
    'notification.settings.display_trigger_time_on_site' => 'Time on site',
    'notification.settings.display_trigger_time_on_site_help' => 'Total time spent on the triggered pages across one browsing session.',
    'notification.settings.display_trigger_pageviews' => 'Pageviews',
    'notification.settings.display_trigger_inactivity' => 'Page inactivity',
    'notification.settings.display_trigger_scroll' => 'Page scroll',
    'notification.settings.display_trigger_click' => 'Mouse click',
    'notification.settings.display_trigger_click_help' => 'CSS selector: #id or .class of the element you want to target.',
    'notification.settings.display_trigger_hover' => 'Mouse hover',
    'notification.settings.display_trigger_hover_help' => 'CSS selector: #id or .class of the element you want to target.',
    'notification.settings.display_trigger_exit_intent' => 'Exit Intent',
    'notification.settings.display_frequency' => 'Display frequency',
    'notification.settings.display_frequency_all_time' => 'All the time',
    'notification.settings.display_frequency_once_per_session' => 'Once per session',
    'notification.settings.display_frequency_once_per_browser' => 'Once per browser',
    'notification.settings.display_mobile' => 'Display on small screens',
    'notification.settings.display_mobile_help' => 'Whether or not to display the notification on when pixels available are smaller than 768px.',
    'notification.settings.display_desktop' => 'Display on large screens',
    'notification.settings.display_desktop_help' => 'Whether or not to display the notification on when pixels available are bigger than 768px.',
    'notification.settings.display_duration' => 'Display duration',
    'notification.settings.display_duration_help' => 'Set -1 to display forever.',
    'notification.settings.direction' => 'Direction',
    'notification.settings.direction_ltr' => 'Left to right',
    'notification.settings.direction_rtl' => 'Right to left',
    'notification.settings.display_position' => 'Display position',
    'notification.settings.display_position_top_left' => 'Top Left',
    'notification.settings.display_position_top_center' => 'Top Center',
    'notification.settings.display_position_top_right' => 'Top Right',
    'notification.settings.display_position_middle_left' => 'Middle Left',
    'notification.settings.display_position_middle_center' => 'Middle Center',
    'notification.settings.display_position_middle_right' => 'Middle Right',
    'notification.settings.display_position_bottom_left' => 'Bottom Left',
    'notification.settings.display_position_bottom_center' => 'Bottom Center',
    'notification.settings.display_position_bottom_right' => 'Bottom Right',
    'notification.settings.display_position_top' => 'Top',
    'notification.settings.display_position_bottom' => 'Bottom',
    'notification.settings.display_position_top_floating' => 'Top Floating',
    'notification.settings.display_position_bottom_floating' => 'Bottom Floating',
    'notification.settings.display_minimum_activity' => 'Minimum activity',
    'notification.settings.display_minimum_activity_help' => 'Minimum data needed to display the notification.',
    'notification.settings.display_close_button' => 'Display close button',
    'notification.settings.display_branding' => 'Display branding',
    'notification.settings.targeting' => 'Targeting',
    'notification.settings.display_targeting_help' => 'Select who should see this notification. Leave empty for all.',
    'notification.settings.display_languages' => 'Browser languages',
    'notification.settings.display_operating_systems' => 'Operating systems',
    'notification.settings.display_browsers' => 'Browsers',
    'notification.settings.display_cities_placeholder' => 'Tokyo, New York, Istanbul',
    'notification.settings.display_cities_help' => 'Comma separated values. Leave empty for all.',
    'notification.settings.borders' => 'Borders',
    'notification.settings.animations' => 'Animations',
    'notification.settings.animation' => 'Animation',
    'notification.settings.animation_interval' => 'Animation interval',
    'notification.settings.animation_heartbeat' => 'Heartbeat',
    'notification.settings.animation_bounce' => 'Bounce',
    'notification.settings.animation_flash' => 'Flash',
    'notification.settings.animation_pulse' => 'Pulse',
    'notification.settings.hover_animation' => 'Hover animation',
    'notification.settings.hover_animation_fast_scale_up' => 'Fast scale up',
    'notification.settings.hover_animation_slow_scale_up' => 'Slow scale up',
    'notification.settings.hover_animation_fast_scale_down' => 'Fast scale down',
    'notification.settings.hover_animation_slow_scale_down' => 'Slow scale down',
    'notification.settings.on_animation' => 'Entrance animation',
    'notification.settings.on_animation_fadeIn' => 'Fade in',
    'notification.settings.on_animation_slideInUp' => 'Slide in up',
    'notification.settings.on_animation_slideInDown' => 'Slide in down',
    'notification.settings.on_animation_zoomIn' => 'Zoom in',
    'notification.settings.on_animation_bounceIn' => 'Bounce in',
    'notification.settings.off_animation' => 'Exit animation',
    'notification.settings.off_animation_fadeOut' => 'Fade out',
    'notification.settings.off_animation_slideOutUp' => 'Slide out up',
    'notification.settings.off_animation_slideOutDown' => 'Slide out down',
    'notification.settings.off_animation_zoomOut' => 'Zoom out',
    'notification.settings.off_animation_bounceOut' => 'Bounce out',
    'notification.settings.font' => 'Font',
    'notification.settings.font_inherit' => 'Inherit from website',
    'notification.settings.title_color' => 'Title color',
    'notification.settings.description_color' => 'Description color',
    'notification.settings.date_color' => 'Date color',
    'notification.settings.content_title_color' => 'Content Title color',
    'notification.settings.content_description_color' => 'Content description color',
    'notification.settings.close_button_color' => 'Close button color',
    'notification.settings.header_agent_name_color' => 'Header agent name color',
    'notification.settings.header_agent_description_color' => 'Header agent description color',
    'notification.settings.header_background_color' => 'Header background color',
    'notification.settings.content_background_color' => 'Content background color',
    'notification.settings.content_agent_name_color' => 'Content agent name color',
    'notification.settings.content_agent_message_color' => 'Content agent message color',
    'notification.settings.content_agent_message_background_color' => 'Content agent message background color',
    'notification.settings.footer_background_color' => 'Footer background color',
    'notification.settings.footer_button_background_color' => 'Footer button background color',
    'notification.settings.footer_button_color' => 'Footer button color',
    'notification.settings.background_color' => 'Background color',
    'notification.settings.background_pattern' => 'Background pattern',
    'notification.settings.background_pattern_jupiter' => 'Jupiter',
    'notification.settings.background_pattern_wavy' => 'Wavy',
    'notification.settings.background_pattern_hexagons' => 'Hexagons',
    'notification.settings.background_pattern_autumn' => 'Autumn',
    'notification.settings.background_pattern_shapes' => 'Shapes',
    'notification.settings.background_pattern_anchors' => 'Anchors',
    'notification.settings.background_pattern_plus' => 'Plus',
    'notification.settings.background_pattern_bubbles' => 'Bubbles',
    'notification.settings.background_pattern_wiggle' => 'Wiggle',
    'notification.settings.button_background_color' => 'Button background color',
    'notification.settings.button_color' => 'Button color',
    'notification.settings.number_color' => 'Number color',
    'notification.settings.coupon_code_color' => 'Coupon code color',
    'notification.settings.coupon_code_background_color' => 'Coupon code background color',
    'notification.settings.coupon_code_border_color' => 'Coupon code border color',
    'notification.settings.number_background_color' => 'Number background color',
    'notification.settings.pulse_background_color' => 'Pulse background color',
    'notification.settings.time_color' => 'Time color',
    'notification.settings.time_background_color' => 'Time background color',
    'notification.settings.internal_padding' => 'Internal padding',
    'notification.settings.background_blur' => 'Background blur',
    'notification.settings.background_blur_help' => 'This feature will only work when you have a transparent color for your background.',
    'notification.settings.border_width' => 'Border width',
    'notification.settings.border_color' => 'Border color',
    'notification.settings.border_radius' => 'Border radius',
    'notification.settings.border_radius_straight' => 'Straight',
    'notification.settings.border_radius_rounded' => 'Rounded',
    'notification.settings.border_radius_highly_rounded' => 'Highly rounded',
    'notification.settings.border_radius_round' => 'Round',
    'notification.settings.shadow' => 'Shadow',
    'notification.settings.shadow.subtle' => 'Subtle',
    'notification.settings.shadow.feather' => 'Feather',
    'notification.settings.shadow.3d' => 'Simple 3D',
    'notification.settings.shadow.layered' => 'Layered',
    'notification.settings.shadow_color' => 'Shadow color tint',
    'notification.settings.engagement_links_categories' => 'Categories',
    'notification.settings.engagement_links_categories_links' => 'Categories links',
    'notification.settings.notifications' => 'Notifications',
    'notification.settings.notifications_help' => 'Get notified when new data is received.',
    'notification.settings.data_info' => 'Data will also be recorded in the Data section of this notification.',
    'notification.settings.data_trigger_webhook' => 'Webhook trigger',
    'notification.settings.data_trigger_webhook_help' => 'Send a POST request with form data parameters to add a new conversion dynamically.',
    'notification.settings.data_trigger_webhook_help_reviews' => 'Available & required fields: %s',
    'notification.settings.data_trigger_type_webhook' => 'Webhook',
    'notification.settings.data_trigger_input_webhook' => 'Webhook URL',
    'notification.settings.data_trigger_auto' => 'Auto capture data',
    'notification.settings.data_trigger_auto_help' => 'Capture data from form submissions of your users and add them to our system as conversions.',
    'notification.settings.data_trigger_auto_add' => 'Add new rule',
    'notification.settings.schedule' => 'Schedule',
    'notification.settings.schedule_help' => 'Trigger the notification only in a specific time window.',
    'notification.settings.start_date' => 'Start date',
    'notification.settings.end_date' => 'End date',

    'notification.statistics.disabled' => 'Statistics for notifications are not enabled.',
    'notification.statistics.header' => 'Statistics',
    'notification.statistics.link' => 'Statistics',
    'notification.statistics.impressions_chart' => 'Impressions',
    'notification.statistics.hovers_chart' => 'Mouse hovers',
    'notification.statistics.clicks_chart' => 'Clicks',
    'notification.statistics.ctr_chart' => 'CTR',
    'notification.statistics.conversions_chart' => 'Conversions',
    'notification.statistics.form_submissions_chart' => 'Form submissions',
    'notification.statistics.feedback_chart' => 'Feedback submissions',
    'notification.statistics.header_feedback' => 'Feedbacks',
    'notification.statistics.feedback' => 'Feedback',
    'notification.statistics.feedback_total' => 'Count',
    'notification.statistics.header_top_pages' => 'Top pages',
    'notification.statistics.subheader_top_pages' => 'Pages with the highest notification activity.',
    'notification.statistics.pageviews' => 'Pageviews',
    'notification.statistics.impression' => 'Impression',
    'notification.statistics.hover' => 'Hover',
    'notification.statistics.form_submission' => 'Form submission',
    'notification.statistics.click' => 'Click',
    'notification.statistics.auto_capture' => 'Auto Capture',
    'notification.statistics.feedback_emoji_angry' => 'Emoji Angry',
    'notification.statistics.feedback_emoji_sad' => 'Emoji Sad',
    'notification.statistics.feedback_emoji_neutral' => 'Emoji Neutral',
    'notification.statistics.feedback_emoji_happy' => 'Emoji Happy',
    'notification.statistics.feedback_emoji_excited' => 'Emoji Excited',
    'notification.statistics.feedback_score_1' => 'Score 1',
    'notification.statistics.feedback_score_2' => 'Score 2',
    'notification.statistics.feedback_score_3' => 'Score 3',
    'notification.statistics.feedback_score_4' => 'Score 4',
    'notification.statistics.feedback_score_5' => 'Score 5',

    'notification.data.header' => 'Data',
    'notification.data.link' => 'Data',
    'notification.data.create' => 'Import data',
    'notification.data.expand_data' => 'Click to expand',
    'notification.data.no_data' => 'No data',
    'notification.data.data' => 'Data',
    'notification.data.page_title' => 'Page title',
    'notification.data.date' => 'Date',
    'notification.data.continent_code' => 'Continent code',
    'notification.data.country_code' => 'Country code',
    'notification.data.variable' => 'Can also be used as a variable {%s}',
    'notification.data.type' => 'Type',
    'notification.data.type_auto_capture' => 'Auto Captured',
    'notification.data.type_webhook' => 'Webhook',
    'notification.data.type_imported' => 'Imported',
    'notification.data.type_collector' => 'Collected',

    'notification.simple_notification' => 'Caught new submitted data for \'%1$s\' notification / \'%2$s\' campaign.%3$sView details: %4$s 🔗.',
    'notification.push_notification.title' => 'Caught new submitted data',
    'notification.push_notification.description' => '%1$s (%2$s)',


    'notification.create_data_modal.header' => 'Import data',
    'notification.create_data_modal.create_key_value' => 'Add field',


    'notification.create_data_modal.csv_header' => 'CSV Import',
    'notification.create_data_modal.data_header' => 'Data Import',
    'notification.create_data_modal.csv' => 'CSV file',
    'notification.create_data_modal.key' => 'Key name',
    'notification.create_data_modal.key_placeholder' => 'name',
    'notification.create_data_modal.value' => 'Value',
    'notification.create_data_modal.value_placeholder' => 'John Doe',


    'notification.create_review_data_modal.header' => 'Create new review',


    'notification.create_review_data_modal.title' => 'Name',
    'notification.create_review_data_modal.description' => 'Text',
    'notification.create_review_data_modal.stars' => 'Stars',
    'notification.create_review_data_modal.stars_help' => 'Leave empty to not show any stars in the review.',


    'notification.informational.name' => 'Informational',
    'notification.informational.description' => 'Fully customizable informational message for your users.',
    'notification.informational.icon' => 'fas fa-fw fa-info-circle',
    'notification.informational.title_default' => 'Free support ✨',
    'notification.informational.description_default' => 'All users benefit of a free support call.',
    'notification.informational.image_default' => ASSETS_FULL_URL . 'images/notifications/support.svg',

    'notification.informational_mini.name' => 'Informational mini',
    'notification.informational_mini.description' => 'Simple & short informational message for your visitors.',
    'notification.informational_mini.icon' => 'fas fa-fw fa-compress',
    'notification.informational_mini.title_default' => 'Version 2.0 is now released ✅',
    'notification.informational_mini.image_default' => ASSETS_FULL_URL . 'images/notifications/code.svg',

    'notification.coupon.name' => 'Coupon',
    'notification.coupon.description' => 'The best way to let your users know that you are running a sale.',
    'notification.coupon.icon' => 'fas fa-fw fa-piggy-bank',
    'notification.coupon.title_default' => 'Summer sale discounts 🍉',
    'notification.coupon.description_default' => 'Use coupon to get the limited discount 🍒',
    'notification.coupon.image_default' => ASSETS_FULL_URL . 'images/notifications/summer.jpg',
    'notification.coupon.coupon_code_default' => 'SUMMER30',
    'notification.coupon.button_text_default' => 'Claim coupon',

    'notification.live_counter.name' => 'Live Counter',
    'notification.live_counter.description' => 'Display online visitors counter are on your site to create more trust.',
    'notification.live_counter.icon' => 'fas fa-fw fa-globe',
    'notification.live_counter.description_default' => 'Active visitors right now 🚀',
    'notification.live_counter.number_default' => '15',

    'notification.email_collector.name' => 'Email Collector',
    'notification.email_collector.description' => 'Easily collect emails and generate leads from your users.',
    'notification.email_collector.icon' => 'fas fa-fw fa-envelope-open',
    'notification.email_collector.title_default' => 'Weekly newsletter',
    'notification.email_collector.description_default' => 'Few useful emails per month, unsubscribe at any point.',
    'notification.email_collector.name_placeholder_default' => 'Your name',
    'notification.email_collector.email_placeholder_default' => 'Your email',
    'notification.email_collector.button_text_default' => 'Sign me up',
    'notification.email_collector.agreement_text_default' => 'I read & agree the Privacy Policy',

    'notification.conversions.name' => 'Conversions',
    'notification.conversions.description' => 'Improve social proof by displaying recent conversions.',
    'notification.conversions.icon' => 'fas fa-fw fa-funnel-dollar',
    'notification.conversions.title_default' => 'Jane from England 🇬🇧',
    'notification.conversions.description_default' => 'Just signed up for our newsletter 💌',
    'notification.conversions.image_default' => ASSETS_FULL_URL . 'images/notifications/check-badge.svg',
    'notification.conversions.time_ago_default' => '10 minutes ago',

    'notification.conversions_counter.name' => 'Conversions Counter',
    'notification.conversions_counter.description' => 'Display the number of recent conversions.',
    'notification.conversions_counter.icon' => 'fas fa-fw fa-comment-dollar',
    'notification.conversions_counter.title_default' => 'People bought the product',
    'notification.conversions_counter.number_default' => '5',
    'notification.conversions_counter.time_default' => 'In the last %s hours',

    'notification.video.name' => 'Video',
    'notification.video.description' => 'Easily display a small widget with an informative YouTube video.',
    'notification.video.icon' => 'fas fa-fw fa-video',
    'notification.video.title_default' => 'Video demo walkthrough',
    'notification.video.thumbnail_default' => ASSETS_FULL_URL . 'images/notifications/video_thumbnail.jpg',
    'notification.video.button_text_default' => 'Sign up',

    'notification.audio.name' => 'Audio',
    'notification.audio.description' => 'Embed a simple and nice looking audio player widget.',
    'notification.audio.icon' => 'fas fa-fw fa-volume-up',
    'notification.audio.title_default' => 'Audio intro walkthrough',
    'notification.audio.audio_default' => ASSETS_FULL_URL . 'audio/notifications/sample.mp3',
    'notification.audio.button_text_default' => 'Sign up',

    'notification.social_share.name' => 'Social Share',
    'notification.social_share.description' => 'Let others share your website and generate social proof.',
    'notification.social_share.icon' => 'fas fa-fw fa-share-alt',
    'notification.social_share.title_default' => 'Tell your friends',
    'notification.social_share.description_default' => 'We appreciate all the shares to support us! Thank you!',

    'notification.reviews.name' => 'Reviews',
    'notification.reviews.description' => 'Display a review/testimonial from your clients to create social proof.',
    'notification.reviews.icon' => 'fas fa-fw fa-random',
    'notification.reviews.title_default' => 'John Doe',
    'notification.reviews.description_default' => 'Thank you very much for providing this awesome service!',
    'notification.reviews.image_default' => ASSETS_FULL_URL . 'images/notifications/stars.svg',

    'notification.emoji_feedback.name' => 'Emoji Feedback',
    'notification.emoji_feedback.description' => 'An interactive way for your users to give you feedback about your site.',
    'notification.emoji_feedback.icon' => 'fas fa-fw fa-smile-beam',
    'notification.emoji_feedback.title_default' => '⭐️ Rate your experience with us',
    'notification.emoji_feedback.feedback_emoji_angry' => 'Angry',
    'notification.emoji_feedback.feedback_emoji_sad' => 'Sad',
    'notification.emoji_feedback.feedback_emoji_neutral' => 'Neutral',
    'notification.emoji_feedback.feedback_emoji_happy' => 'Happy',
    'notification.emoji_feedback.feedback_emoji_excited' => 'Excited',

    'notification.cookie_notification.name' => 'Cookie Notification',
    'notification.cookie_notification.description' => 'Notify your users that you are using cookies on your site.',
    'notification.cookie_notification.icon' => 'fas fa-fw fa-cookie',
    'notification.cookie_notification.description_default' => 'This website uses cookies to ensure you get the best experience on our website.',
    'notification.cookie_notification.button_text_default' => 'Okay',
    'notification.cookie_notification.url_text_default' => 'Learn More',
    'notification.cookie_notification.image_default' => ASSETS_FULL_URL . 'images/notifications/cookie.svg',

    'notification.score_feedback.name' => 'Score Feedback',
    'notification.score_feedback.description' => 'The easiest way for your users to give you a score feedback.',
    'notification.score_feedback.icon' => 'fas fa-fw fa-sort-numeric-up',
    'notification.score_feedback.title_default' => 'Rate our services',
    'notification.score_feedback.description_default' => 'Rate from 1 to 5. 5 being excellent.',
    'notification.score_feedback.feedback_score_1' => '1',
    'notification.score_feedback.feedback_score_2' => '2',
    'notification.score_feedback.feedback_score_3' => '3',
    'notification.score_feedback.feedback_score_4' => '4',
    'notification.score_feedback.feedback_score_5' => '5',

    'notification.request_collector.name' => 'Request Collector',
    'notification.request_collector.description' => 'Collecting leads has never been easier with the request collector.',
    'notification.request_collector.icon' => 'fas fa-fw fa-user-plus',
    'notification.request_collector.title_default' => 'John',
    'notification.request_collector.description_default' => 'Support Team',
    'notification.request_collector.image_default' => ASSETS_FULL_URL . 'images/notifications/headset.svg',
    'notification.request_collector.content_title_default' => 'Any questions?',
    'notification.request_collector.content_description_default' => 'Let us know and we will get back to you!',
    'notification.request_collector.input_placeholder_default' => 'Valid Phone Number',
    'notification.request_collector.button_text_default' => 'Call me back ⚡️',
    'notification.request_collector.agreement_text_default' => 'I read & agree the Privacy Policy',

    'notification.countdown_collector.name' => 'Countdown Collector',
    'notification.countdown_collector.description' => 'Create urgency with a countdown timer for lead generation.',
    'notification.countdown_collector.icon' => 'fas fa-fw fa-clock',
    'notification.countdown_collector.title_default' => 'Building a website 💻',
    'notification.countdown_collector.description_default' => 'Free Webinar by us.',
    'notification.countdown_collector.content_title_default' => 'Hurry up! Registrations are closing soon.',
    'notification.countdown_collector.input_placeholder_default' => 'Your valid email',
    'notification.countdown_collector.button_text_default' => 'Sign up️',
    'notification.countdown_collector.agreement_text_default' => 'I read & agree the Privacy Policy',
    'notification.countdown_collector.days' => 'days',
    'notification.countdown_collector.hours' => 'hours',
    'notification.countdown_collector.minutes' => 'minutes',
    'notification.countdown_collector.seconds' => 'seconds',

    'notification.custom_html.name' => 'Custom HTML',
    'notification.custom_html.description' => 'Write your own fully-personalized & customizable notification widget.',
    'notification.custom_html.icon' => 'fas fa-fw fa-code',
    'notification.custom_html.html_default' => 'Your custom HTML content right here.<br />',

    'notification.informational_bar.name' => 'Informational bar',
    'notification.informational_bar.description' => 'Fully customizable informational bar for the top or bottom of the page.',
    'notification.informational_bar.icon' => 'fas fa-fw fa-info',
    'notification.informational_bar.title_default' => 'Your title here',
    'notification.informational_bar.description_default' => 'Your description will go here!',
    'notification.informational_bar.image_default' => ASSETS_FULL_URL . 'images/notifications/info.svg',

    'notification.informational_bar_mini.name' => 'Informational bar mini',
    'notification.informational_bar_mini.description' => 'Simple and small bar for the top or bottom of the page.',
    'notification.informational_bar_mini.icon' => 'fas fa-fw fa-bolt',
    'notification.informational_bar_mini.title_default' => 'Pay for a plan and receive 2 months off 🚀',
    'notification.informational_bar_mini.image_default' => ASSETS_FULL_URL . 'images/notifications/bolt.svg',

    'notification.image.name' => 'Image',
    'notification.image.description' => 'Display a small widget with an informative Image of your choice.',
    'notification.image.icon' => 'fas fa-fw fa-image',
    'notification.image.title_default' => 'Your custom title here',
    'notification.image.image_default' => ASSETS_FULL_URL . 'images/notifications/image.jpg',
    'notification.image.button_text_default' => 'Register',

    'notification.collector_bar.name' => 'Collector Bar',
    'notification.collector_bar.description' => 'Collect emails or leads without distracting the users.',
    'notification.collector_bar.icon' => 'fas fa-fw fa-inbox',
    'notification.collector_bar.title_default' => 'Sign up to receive updates & discounts via email',
    'notification.collector_bar.input_placeholder_default' => 'Your valid email',
    'notification.collector_bar.button_text_default' => 'Subscribe',
    'notification.collector_bar.agreement_text_default' => 'I read & agree the Privacy Policy',

    'notification.coupon_bar.name' => 'Coupon Bar',
    'notification.coupon_bar.description' => 'Top or bottom bar to share coupons with your visitors.',
    'notification.coupon_bar.icon' => 'fas fa-fw fa-money-check-alt',
    'notification.coupon_bar.title_default' => 'We\'re running a limited sale until the end of the day 🙌',
    'notification.coupon_bar.coupon_code_default' => 'SALE15',

    'notification.button_bar.name' => 'Button Bar',
    'notification.button_bar.description' => 'Top or bottom cool bar to promote anything to your visitors.',
    'notification.button_bar.icon' => 'fas fa-fw fa-newspaper',
    'notification.button_bar.title_default' => 'We just launched our new product feature',
    'notification.button_bar.button_text_default' => 'Check product',

    'notification.collector_modal.name' => 'Modal Collector',
    'notification.collector_modal.description' => 'Collect leads with a nice looking and big modal.',
    'notification.collector_modal.icon' => 'fas fa-fw fa-fire',
    'notification.collector_modal.title_default' => 'Monthly discount coupons ✨',
    'notification.collector_modal.description_default' => 'Few useful emails per month, unsubscribe at any point.',
    'notification.collector_modal.image_default' => '',
    'notification.collector_modal.input_placeholder_default' => 'Your valid email',
    'notification.collector_modal.button_text_default' => 'Sign me up',
    'notification.collector_modal.agreement_text_default' => 'I read & agree the Privacy Policy',

    'notification.collector_two_modal.name' => 'Modal Two Collector',
    'notification.collector_two_modal.description' => 'Collect leads with a nice looking and big modal.',
    'notification.collector_two_modal.icon' => 'fas fa-fw fa-dice',
    'notification.collector_two_modal.title_default' => 'Get discounts & latest offers via email',
    'notification.collector_two_modal.description_default' => 'Few useful emails per month, unsubscribe at any point.',
    'notification.collector_two_modal.image_default' => '',
    'notification.collector_two_modal.input_placeholder_default' => 'Your valid email',
    'notification.collector_two_modal.button_text_default' => 'Sign up',
    'notification.collector_two_modal.agreement_text_default' => 'I read & agree the Privacy Policy',

    'notification.button_modal.name' => 'Call to action',
    'notification.button_modal.description' => 'Raise awareness and cta with a nice looking modal.',
    'notification.button_modal.icon' => 'fas fa-fw fa-cloud',
    'notification.button_modal.title_default' => 'New product',
    'notification.button_modal.description_default' => 'We just launched our new product. You can download it for free for the next 3 days.',
    'notification.button_modal.image_default' => ASSETS_FULL_URL . 'images/notifications/button_modal.jpg',
    'notification.button_modal.button_text_default' => 'Download for free',

    'notification.text_feedback.name' => 'Text Feedback',
    'notification.text_feedback.description' => 'Collect better and straight forward insight from your users.',
    'notification.text_feedback.icon' => 'fas fa-fw fa-heading',
    'notification.text_feedback.title_default' => 'Any suggestions for us?',
    'notification.text_feedback.description_default' => 'Let us know how we can do better 🙏.',
    'notification.text_feedback.input_placeholder_default' => 'Your honest input',
    'notification.text_feedback.button_text_default' => 'Submit',

    'notification.engagement_links.name' => 'Engagement Links',
    'notification.engagement_links.description' => 'Display a subtle widget which contains all of your relevant links.',
    'notification.engagement_links.icon' => 'fas fa-fw fa-link',
    'notification.engagement_links.title' => 'Connect with us 👋',

    'notification.whatsapp_chat.name' => 'Whatsapp Chat',
    'notification.whatsapp_chat.description' => 'Display a chat widget that points to your whatsapp number.',
    'notification.whatsapp_chat.icon' => 'fab fa-fw fa-whatsapp',
    'notification.whatsapp_chat.image_default' => ASSETS_FULL_URL . 'images/notifications/support-male-circle.svg',
    'notification.whatsapp_chat.agent_name_default' => 'John Doe',
    'notification.whatsapp_chat.agent_description_default' => 'Support at Example',
    'notification.whatsapp_chat.agent_message_default' => 'Hello, how can I help?',
    'notification.whatsapp_chat.button_text_default' => 'Message me 💬',

    'notification.contact_us.name' => 'Contact us',
    'notification.contact_us.description' => 'Display a widget notification with your contact details.',
    'notification.contact_us.icon' => 'fas fa-fw fa-id-card',
    'notification.contact_us.title_default' => 'Get in touch 👋',
    'notification.contact_us.description_default' => 'We typically respond in under 1 hour.',
    'notification.contact_us.contact_email_default' => 'john@example.com',
    'notification.contact_us.contact_phone_number_default' => '+1010101010',
    'notification.contact_us.contact_whatsapp_default' => '+1010101010',
    'notification.contact_us.contact_telegram_default' => 'example',
    'notification.contact_us.contact_facebook_messenger_default' => 'example',


    'notification_create.breadcrumb' => 'Create a new notification',
    'notification_create.title' => 'Create a new notification',
    'notification_create.header' => 'Create a new notification',
    'notification_create.default_name' => 'My new notification',


    'domains.breadcrumb' => 'Custom domains',
    'domains.title' => 'Custom domains',
    'domains.menu' => 'Custom domains',
    'domains.header' => 'Custom domains',
    'domains.subheader' => 'Here you can add your own custom domain to use with your pixel tracking codes.',
    'domains.create' => 'Connect domain',
    'domains.domain_id' => 'Domain',

    'domains.table.host' => 'Domain',
    'domains.table.is_enabled_pending' => 'Pending',
    'domains.table.is_enabled_active' => 'Active',

    'domains.help' => 'Your domain or subdomain must have an A record pointing to %1$s or CNAME record pointing to %2$s.',
    'domains.host' => 'Domain or subdomain',
    'domains.custom_index_url' => 'Custom index URL',
    'domains.custom_index_url_help' => 'Redirect to a specific URL when visitors land on the index of the domain.',
    'domains.custom_not_found_url' => 'Custom 404 not found URL',
    'domains.custom_not_found_url_help' => 'Redirect to a specific URL when visitors land on a not found page of the domain.',
    'domains.no_data' => 'There are no custom domains added',
    'domains.no_data_help' => 'Start by linking your first custom domain.',
    'domains.error_message.host_exists' => 'This custom domain already exists.',


    'domain_create.breadcrumb' => 'Connect custom domain',
    'domain_create.title' => 'Connect custom domain',
    'domain_create.menu' => 'Connect custom domain',
    'domain_create.header' => 'Connect custom domain',
    'domain_create.success_message' => 'Your custom domain has been submitted for approval and processing.',


    'domain_update.breadcrumb' => 'Edit custom domain',
    'domain_update.title' => 'Edit custom domain',
    'domain_update.menu' => 'Edit custom domain',
    'domain_update.header' => 'Edit custom domain',
    'domain_update.success_message' => 'Your custom domain update has been submitted for approval and processing.',


    'domain_delete_modal.header' => 'Delete domain',
    'domain_delete_modal.subheader' => 'By deleting the domain, all the websites pixels codes associated with the domain will stop working. This action cannot be undone.',


    'notification_handlers.title' => 'Notification handlers',
    'notification_handlers.menu' => 'Notification handlers',
    'notification_handlers.breadcrumb' => 'Notification handlers',
    'notification_handlers.header' => 'Notification handlers',
    'notification_handlers.subheader' => 'How do you want to get notified when certain events happen?',
    'notification_handlers.create' => 'Create notification handler',
    'notification_handlers.test' => 'Test integration',
    'notification_handlers.test_title' => 'This is a test message.',
    'notification_handlers.test_description' => 'This is the test description for the notification handler.',
    'notification_handlers.test.subject' => 'Notification handler test - {{WEBSITE_TITLE}}',
    'notification_handlers.test.body' => 'This is the test description for the notification handler.',
    'notification_handlers.success_message_test' => 'The test has been successful.',
    'notification_handlers.error_message_test' => 'The test has failed.',

    'notification_handlers.type' => 'Notification type',
    'notification_handlers.type_x' => 'X tweet',
    'notification_handlers.type_email' => 'Email',
    'notification_handlers.type_webhook' => 'Webhook',
    'notification_handlers.type_slack' => 'Slack',
    'notification_handlers.type_microsoft_teams' => 'Microsoft Teams',
    'notification_handlers.type_discord' => 'Discord',
    'notification_handlers.type_telegram' => 'Telegram',
    'notification_handlers.type_twilio' => 'SMS',
    'notification_handlers.type_twilio_call' => 'Phone call',
    'notification_handlers.type_whatsapp' => 'Whatsapp',
    'notification_handlers.type_google_chat' => 'Google chat',
    'notification_handlers.type_internal_notification' => 'Internal notification',
    'notification_handlers.type_push_subscriber_id' => 'Push notification',
    'notification_handlers.push_subscriber_id' => 'Push subscriber',
    'notification_handlers.push_subscriber_id_help' => 'Select one device that you have subscribed with.',
    'notification_handlers.email' => 'Email',
    'notification_handlers.email_help' => 'Receive email notifications.',
    'notification_handlers.webhook' => 'Webhook URL',
    'notification_handlers.webhook_help' => 'Receive POST calls notifications to your specified webhook URL.',
    'notification_handlers.slack' => 'Slack webhook URL',
    'notification_handlers.slack_help' => 'Receive Slack notifications for your specified Slack channel via webhooks. <a href="https://slack.com/apps/A0F7XDUAZ-incoming-webhooks" target="_blank">Get Slack webhook URL</a>.',
    'notification_handlers.discord' => 'Discord webhook URL',
    'notification_handlers.discord_help' => 'Receive Discord notifications for your specified Discord channel via webhooks.',
    'notification_handlers.microsoft_teams' => 'Microsoft Teams webhook URL',
    'notification_handlers.microsoft_teams_help' => 'Receive Microsoft Teams notifications for your specified channel via webhooks. <a href="https://learn.microsoft.com/en-us/microsoftteams/platform/webhooks-and-connectors/how-to/add-incoming-webhook?tabs=dotnet" target="_blank">Get Microsoft Teams webhook URL</a>.',
    'notification_handlers.telegram' => 'Telegram API Token',
    'notification_handlers.telegram_help' => 'The token for the HTTP API that you received after creating the bot on Telegram.',
    'notification_handlers.telegram_chat_id' => 'Telegram Chat ID',
    'notification_handlers.telegram_chat_id_help' => 'Where the bot should send the messages to.',
    'notification_handlers.twilio' => 'Phone number',
    'notification_handlers.twilio_help' => 'Example of valid phone number: +15558675310.',
    'notification_handlers.twilio_call' => 'Phone number',
    'notification_handlers.twilio_call_help' => 'Example of valid phone number: +15558675310.',
    'notification_handlers.whatsapp' => 'Whatsapp number',
    'notification_handlers.whatsapp_help' => 'Example of valid phone number: 15558675310. Only numbers.',
    'notification_handlers.google_chat' => 'Google chat webhook URL',
    'notification_handlers.google_chat_help' => 'Receive Google chat notifications for your specified space via webhooks.',
    'notification_handlers.x_consumer_key' => 'X consumer key',
    'notification_handlers.x_consumer_secret' => 'X consumer secret',
    'notification_handlers.x_access_token' => 'X access token',
    'notification_handlers.x_access_token_secret' => 'X access token secret',
    'notification_handlers.internal_notification_help' => 'Get notified internally via the notifications system near in the menu bar.',
    'notification_handlers.is_enabled' => 'Notification handler is active',
    'notification_handlers.no_data' => 'There are no notification handlers for now',
    'notification_handlers.no_data_help' => 'Start by creating your first notification handler.',


    'notification_handler_create.breadcrumb' => 'Create a new notification handler',
    'notification_handler_create.title' => 'Create a new notification handler',
    'notification_handler_create.header' => 'Create a new notification handler',


    'notification_handler_update.breadcrumb' => 'Edit notification handler',
    'notification_handler_update.title' => 'Edit notification handler',
    'notification_handler_update.header' => 'Edit notification handler',


    'index.title' => 'Increase Conversions & Site Growth',
    'index.meta_description' => '',
    'index.meta_keywords' => '',
    'index.header' => '<span class="text-primary-600">Increase Trust</span> with <br />Social Proof Popups.',
    'index.subheader' => '<strong>%s notifications created</strong> by our users.',
    'index.subheader2' => '<strong>%s displayed notifications</strong> across the web.',
    'index.subheader3' => 'Trusted by <strong>%s happy customers</strong>.',
    'index.subheader4' => 'GDPR, CCPA, and PECR compliant',
    'index.sign_up' => 'Get started',
    'index.breadcrumb' => 'Home',
    'index.menu' => 'Home',

    'index.api.name' => 'API system',
    'index.api.header' => 'Developer ready',
    'index.api.subheader' => 'Fully featured & easy to use API system for developers.',

    'index.notifications_handlers.header' => 'Notifications for your conversions',
    'index.notifications_handlers.subheader' => 'Countless notification integrations for when your visitors submit data through your widgets.',

    'index.steps.one' => 'Install pixel',
    'index.steps.one_text' => 'With just one line of code',
    'index.steps.two' => 'Create widgets',
    'index.steps.two_text' => 'Setup & customize them',
    'index.steps.three' => 'Display popups',
    'index.steps.three_text' => 'Easily increase social proof',

    'index.setup.header' => 'Easy setup & integration on <span class="text-primary">any website</span>.',
    'index.setup.subheader' => 'Copy and paste <span class="font-weight-bold">one line of code</span> into your website.',

    'index.preview' => 'Notification preview',

    'index.pricing.header' => 'Simple, transparent pricing.',
    'index.pricing.subheader' => 'Choose the plan that is right for you and your budget.',

    'index.cta.header' => 'Get started',
    'index.cta.subheader' => 'Start upgrading your website with our widgets.',
    'index.cta.register' => 'Sign up',

    'index.blog.header' => 'Latest %1$sblog%2$s posts',

    'index.testimonials.header' => 'Here\'s what people are saying',
    'index.testimonials.one.text' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ornare ex. Vivamus eu ex non orci condimentum placerat ac ac nisi. Nam velit libero, hendrerit vitae auctor eget, congue ut ante.',
    'index.testimonials.one.name' => 'Andrea',
    'index.testimonials.one.attribute' => 'Writer Magazine',
    'index.testimonials.two.text' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent finibus vestibulum porta. Sed id eros quam. Nunc at nisi vel arcu placerat gravida.',
    'index.testimonials.two.name' => 'George',
    'index.testimonials.two.attribute' => 'Lorem Ipsum Founder',
    'index.testimonials.three.text' => 'Praesent finibus vestibulum porta. Sed id eros quam. Proin lacinia ipsum porttitor, sollicitudin est in, ornare ex. Vivamus eu ex non orci condimentum placerat ac ac nisi. Nam velit libero, hendrerit vitae auctor eget, congue ut ante.',
    'index.testimonials.three.name' => 'Calvin',
    'index.testimonials.three.attribute' => 'SAAS Lorem Owner',

    'index.faq.header' => '%1$sAnswers%2$s for your common %1$squestions%2$s',
    'index.faq.one.question' => 'How do you edit this?',
    'index.faq.one.answer' => 'All the FAQ section can be edited from the admin panel - languages section.',
    'index.faq.two.question' => 'Lorem ipsum dolor sit amet',
    'index.faq.two.answer' => 'Lorem ipsum dolor sit amet, vim eu quem nonumes omittam. Mutat facete patrioque et est, nusquam abhorreant definiebas te sit, albucius urbanitas pro ad. Ne nemore officiis sed. Cu mundi docendi qui, nam nonumes maluisset constituto an, vix ea solum accusamus consequuntur.',
    'index.faq.three.question' => 'Virtute feugiat ocurreret ad cum',
    'index.faq.three.answer' => 'Virtute feugiat ocurreret ad cum, pro in posse ullum adversarium, te qui stet graece antiopam. Amet omnesque indoctum ut mel, ea eam sonet saperet nostrum. Te modus delectus mel, pri populo definitionem ne, an eam hinc labitur inciderint. Novum vivendum gloriatur ex nec, ad vocibus eleifend deterruisset pro, mutat voluptaria repudiandae eum ea. Ipsum soluta cotidieque sea ut, aliquando scripserit no has, iisque impetus erroribus pro ad. Case labitur scaevola vis ut, clita meliore te eos.',
    'index.faq.four.question' => 'Mel iusto putant feugiat et',
    'index.faq.four.answer' => 'Mel iusto putant feugiat et, qui alii virtute eu. Diceret corrumpit mei an. Ius ei congue iudico, ex quo delectus indoctum. Mnesarchum reprehendunt pro ex, ea vix amet maluisset, in autem omnes consectetuer eum.',


    'api.error_message.no_bearer' => 'The request is missing the Bearer Authentication header.',
    'api.error_message.no_access' => 'You do not have access to the API.',
    'api.error_message.rate_limit' => 'You reached the limit of requests in one minute, please wait.',
    'api.error_message.not_found' => 'The resource you are looking for does not exist.',


    'api_documentation.menu' => 'API Documentation',
    'api_documentation.breadcrumb' => 'API Documentation',
    'api_documentation.title' => 'API Documentation',
    'api_documentation.title_dynamic' => '%s - API Documentation',
    'api_documentation.header' => 'API Documentation',
    'api_documentation.subheader' => 'This is the documentation for the available API endpoints, which are built around the <strong>REST architecture</strong>. All the API endpoints will return a <strong>JSON response</strong> with the standard <strong>HTTP response codes</strong> and need a <strong>Bearer Authentication via an API Key</strong>.',
    'api_documentation.endpoint' => 'Endpoint',
    'api_documentation.example' => 'Example',
    'api_documentation.response' => 'Response example',
    'api_documentation.api_key' => 'API Key',
    'api_documentation.base_url' => 'Base URL',
    'api_documentation.parameters' => 'Parameters',
    'api_documentation.required' => 'Required',
    'api_documentation.optional' => 'Optional',
    'api_documentation.string' => 'String',
    'api_documentation.int' => 'Integer',
    'api_documentation.float' => 'Float',
    'api_documentation.boolean' => 'Boolean',
    'api_documentation.file' => 'File',
    'api_documentation.array' => 'Array',
    'api_documentation.read_all' => 'Retrieve all',
    'api_documentation.read' => 'Retrieve one',
    'api_documentation.create' => 'Create',
    'api_documentation.update' => 'Update',
    'api_documentation.delete' => 'Delete',
    'api_documentation.allowed_values' => 'Allowed values: %s',
    'api_documentation.available_when' => 'Available when: %s',
    'api_documentation.timezone_info' => 'All API endpoint results work with the <strong>%s timezone</strong> unless specified otherwise.',

    'api_documentation.authentication.header' => 'Authentication',
    'api_documentation.authentication.subheader' => 'All the API endpoints require an API key sent by the <strong>Bearer Authentication method.</strong>',

    'api_documentation.filters.page' => 'The page number that you want results from. Defaults to <code>1</code>.',
    'api_documentation.filters.results_per_page' => 'How many results you want per page. Allowed values are: %1$s. Defaults to <code>%2$s</code>.',
    'api_documentation.filters.search' => 'The search string.',
    'api_documentation.filters.search_by' => 'What field are you searching by. Allowed values are: %s.',
    'api_documentation.filters.order_by' => 'What field to order the results by. Allowed values are: %s.',
    'api_documentation.filters.order_by_type' => 'The ordering of the results. Allowed values are: <code>ASC</code> for ascending ordering, and <code>DESC</code> for descending ordering.',

    'api_documentation.team_members' => 'Team members',
    'api_documentation.teams_member' => 'Teams\' member',
    'api_documentation.user' => 'User',

    'api_documentation.notification_handlers' => 'Notification handlers',
    'api_documentation.notifications_handlers_ids' => 'Notification handler ids',


    'contact.breadcrumb' => 'Contact',
    'contact.title' => 'Contact',
    'contact.menu' => 'Contact',
    'contact.header' => 'Contact us',
    'contact.subheader' => 'Get in touch with us via email.',
    'contact.email' => 'Email address',
    'contact.name' => 'Full name',
    'contact.subject' => 'Subject',
    'contact.message' => 'Message',
    'contact.success_message' => 'Your message was sent! We\'ll get back to you shortly.',


    'internal_notifications.breadcrumb' => 'Notifications',
    'internal_notifications.title' => 'Notifications',
    'internal_notifications.menu' => 'Notifications',
    'internal_notifications.header' => 'Notifications',
    'internal_notifications.subheader' => 'All your recent account related notifications.',
    'internal_notifications.no_data' => 'No notifications available',


    'affiliate.breadcrumb' => 'Affiliate',
    'affiliate.title' => 'Affiliate',
    'affiliate.menu' => 'Affiliate',
    'affiliate.header' => 'The affiliates program',
    'affiliate.subheader' => 'Easiest way to earn commission from people that you bring to the platform.',

    'affiliate.commission_percentage.header' => '%s commission',
    'affiliate.commission_percentage.subheader_once' => 'Earn commission from the first payment of any user that you bring to the platform.',
    'affiliate.commission_percentage.subheader_forever' => 'Earn commission from all of the payments of any user that you bring to the platform.',

    'affiliate.minimum_withdrawal_amount.header' => '%s minimum withdrawal',
    'affiliate.minimum_withdrawal_amount.subheader' => 'Once your approved balance reaches the minimum withdrawal amount, you can request a withdrawal.',

    'affiliate.how.header' => 'How does it work?',
    'affiliate.how.one' => 'Sign up',
    'affiliate.how.one_help' => 'Simply register for an account on our platform.',
    'affiliate.how.two' => 'Share your link',
    'affiliate.how.two_help' => 'Start promoting your referral link and bring new users.',
    'affiliate.how.three' => 'Start earning',
    'affiliate.how.three_help' => 'Once your referred users start paying, you\'ll get paid as well.',
    'affiliate.how.four' => 'Withdraw your money',
    'affiliate.how.four_help' => 'Request a withdrawal and you\'ll get paid.',

    'affiliate.cta.header' => 'Start earning money 💰',
    'affiliate.cta.subheader' => 'Create an account and start in just a few minutes.',
    'affiliate.cta.register' => 'Sign up',


    'not_found.title' => 'Not found',
    'not_found.header' => 'Page not found',
    'not_found.subheader' => 'Sorry, we couldn\'t find the page you\'re looking for.',
    'not_found.button' => 'Go back home',

    'cron.email_reports.title' => 'Summary analytics for \'{{CAMPAIGN:NAME}}\' between {{START_DATE}} and {{END_DATE}} - {{WEBSITE_TITLE}}',
    'cron.email_reports.p1' => 'Short analytics overview for the <strong>%s</strong> campaign.',
    'cron.email_reports.button' => 'View statistics',
    'cron.email_reports.notice' => 'You\'re receiving these emails because you activated email reports. You can unsubscribe from the %scampaign settings%s page at any point in time.',
];
