<?php defined('ALTUMCODE') || die() ?>

<div class="index-cover-container d-none d-lg-block">
    <div class="container container-disabled-simple">
        <div class="index-cover">
            <div class="row mb-3">
                <div class="col-4">
                    <?php $notification = \Altum\Notification::get('INFORMATIONAL', null, null, false) ?>
                    <?= preg_replace(['/<form/', '/<\/form>/', '/required=\"required\"/'], ['<div', '</div>', ''], $notification->html) ?>
                </div>

                <div class="col-4">
                    <?php $notification = \Altum\Notification::get('CONVERSIONS', null, null, false) ?>
                    <?= preg_replace(['/<form/', '/<\/form>/', '/required=\"required\"/'], ['<div', '</div>', ''], $notification->html) ?>
                </div>

                <div class="col-4">
                    <?php $notification = \Altum\Notification::get('REVIEWS', null, null, false) ?>
                    <?= preg_replace(['/<form/', '/<\/form>/', '/required=\"required\"/'], ['<div', '</div>', ''], $notification->html) ?>
                </div>
            </div>

            <div class="row mb-3">
                <div class="col-4">
                    <?php $notification = \Altum\Notification::get('EMAIL_COLLECTOR', null, null, false) ?>
                    <?= preg_replace(['/<form/', '/<\/form>/', '/required=\"required\"/'], ['<div', '</div>', ''], $notification->html) ?>
                </div>

                <div class="col-4">
                    <div>
                        <?php $notification = \Altum\Notification::get('SCORE_FEEDBACK', null, null, false) ?>
                        <?= preg_replace(['/<form/', '/<\/form>/', '/required=\"required\"/'], ['<div', '</div>', ''], $notification->html) ?>
                    </div>

                    <div class="mt-3">
                        <?php $notification = \Altum\Notification::get('CONVERSIONS_COUNTER', null, null, false) ?>
                        <?= preg_replace(['/<form/', '/<\/form>/', '/required=\"required\"/'], ['<div', '</div>', ''], $notification->html) ?>
                    </div>
                </div>

                <div class="col-4">
                    <div>
                        <?php $notification = \Altum\Notification::get('EMOJI_FEEDBACK', null, null, false) ?>
                        <?= preg_replace(['/<form/', '/<\/form>/', '/required=\"required\"/'], ['<div', '</div>', ''], $notification->html) ?>
                    </div>

                    <div class="mt-3">
                        <?php $notification = \Altum\Notification::get('COOKIE_NOTIFICATION', null, null, false) ?>
                        <?= preg_replace(['/<form/', '/<\/form>/', '/required=\"required\"/'], ['<div', '</div>', ''], $notification->html) ?>
                    </div>
                </div>
            </div>

            <div class="row mb-3">
                <div class="col-4">
                    <?php $notification = \Altum\Notification::get('SOCIAL_SHARE', null, null, false) ?>
                    <?= preg_replace(['/<form/', '/<\/form>/', '/required=\"required\"/'], ['<div', '</div>', ''], $notification->html) ?>
                </div>

                <div class="col-4">
                    <?php $notification = \Altum\Notification::get('REQUEST_COLLECTOR', null, null, false) ?>
                    <?= preg_replace(['/<form/', '/<\/form>/', '/required=\"required\"/'], ['<div', '</div>', ''], $notification->html) ?>
                </div>

                <div class="col-4">
                    <?php $notification = \Altum\Notification::get('LIVE_COUNTER', null, null, false) ?>
                    <?= preg_replace(['/<form/', '/<\/form>/', '/required=\"required\"/'], ['<div', '</div>', ''], $notification->html) ?>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="index-container">
    <div class="container">
        <?= \Altum\Alerts::output_alerts() ?>

        <div class="row mt-4">
            <div class="col">
                <div class="text-left">
                    <div class="mb-2">
                        <span class="badge badge-primary badge-pill"><i class="fas fa-fw fa-sm fa-check-circle mr-1"></i> <?= l('index.subheader4') ?></span>
                    </div>

                    <h1 class="index-header mb-4"><?= l('index.header') ?></h1>

                    <p class="index-subheader text-gray-700 mb-2">
                        <i class="fas fa-fw fa-xs fa-check-circle text-success mr-1"></i> <?= sprintf(l('index.subheader'), nr($data->total_notifications)) ?>
                    </p>

                    <p class="index-subheader text-gray-700 mb-2">
                        <i class="fas fa-fw fa-xs fa-check-circle text-success mr-1"></i> <?= sprintf(l('index.subheader2'), nr($data->total_track_notifications, 0, true, true) ) ?>
                    </p>

                    <p class="index-subheader text-gray-700 mb-2">
                        <i class="fas fa-fw fa-xs fa-check-circle text-success mr-1"></i> <?= sprintf(l('index.subheader3'), nr($data->total_users, 0, true, true) ) ?>
                    </p>

                    <div class="mt-5">
                        <a href="<?= url('register') ?>" class="btn btn-primary index-button">
                            <?= l('index.sign_up') ?> <i class="fas fa-fw fa-sm fa-arrow-right"></i>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="container mt-10">
    <div class="row">
        <div class="col-12 col-lg-4 p-3">
            <div class="card border border-gray-100 mb-md-0" data-aos="fade-up" data-aos-delay="100">
                <div class="card-body">
                    <div class="d-flex align-items-start icon-zoom-animation">
                        <div class="index-icon-container mr-4">
                            <i class="fas fa-fw fa-plug"></i>
                        </div>

                        <div>
                            <h2 class="h5"><?= l('index.steps.one') ?></h2>
                            <p class="text-muted m-0"><?= l('index.steps.one_text') ?></p>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-12 col-lg-4 p-3">
            <div class="card border border-gray-100 mb-md-0" data-aos="fade-up" data-aos-delay="200">
                <div class="card-body">
                    <div class="d-flex align-items-start icon-zoom-animation">
                        <div class="index-icon-container mr-4">
                            <i class="fas fa-fw fa-plus"></i>
                        </div>

                        <div>
                            <h2 class="h5"><?= l('index.steps.two') ?></h2>
                            <p class="text-muted m-0"><?= l('index.steps.two_text') ?></p>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-12 col-lg-4 p-3">
            <div class="card border border-gray-100 mb-md-0" data-aos="fade-up" data-aos-delay="300">
                <div class="card-body">
                    <div class="d-flex align-items-start icon-zoom-animation">
                        <div class="index-icon-container mr-4">
                            <i class="fas fa-fw fa-mobile-alt"></i>
                        </div>

                        <div>
                            <h2 class="h5"><?= l('index.steps.three') ?></h2>
                            <p class="text-muted m-0"><?= l('index.steps.three_text') ?></p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


<?php
$brands = [
    'blogger' => [
        'name' => 'Blogger',
        'color' => '#f57d00',
        'svg_logo' => '<svg xmlns="http://www.w3.org/2000/svg" width="191.488" height="191.151" viewBox="0 0 179.52 179.204"><path fill="#f06a35" d="M20.512 178.499c-3.359-.884-6.258-2.184-8.931-4.006-2.257-1.538-5.556-4.717-6.81-6.563-1.533-2.255-3.294-6.117-4.012-8.795-.732-2.732-.743-3.82-.757-69.395-.013-65.245.002-66.68.72-69.483C3.259 10.34 11.117 2.797 21.252.547c2.913-.648 133.08-.76 136.222-.119 8.51 1.738 15.198 6.846 19.068 14.564 3.078 6.135 2.803-.617 2.943 72.23.09 46.35.007 65.81-.288 68.233-1.386 11.345-9.211 20.143-20.47 23.019-2.88.735-3.883.746-69.276.726-63.227-.02-66.474-.052-68.939-.701"/><path fill="none" d="M-82.995 87.838v-171.9h1020v343.8h-1020z"/><path fill="#fff" d="M115.162 144.835c8.064-1.1 14.384-4.333 20.313-10.39 4.289-4.382 6.974-9.125 8.728-15.42.73-2.614.79-3.887.924-19.24.1-11.589.017-17.016-.285-18.386-.437-1.986-1.677-3.83-3.092-4.599-.435-.237-3.224-.538-6.198-.67-4.982-.221-5.54-.318-7.113-1.24-2.494-1.462-3.181-3.04-3.188-7.327-.013-8.19-3.421-15.792-10.155-22.654-4.797-4.889-10.149-8.198-16.257-10.052-1.462-.444-4.736-.595-15.702-.725-17.207-.203-21.026.15-26.884 2.483-10.8 4.302-18.56 13.368-21.39 24.99-.532 2.183-.635 5.682-.76 25.779-.158 25.177.015 28.874 1.589 33.864 1.3 4.122 2.61 6.648 5.313 10.234 5.146 6.83 12.86 11.763 20.572 13.156 3.67.663 48.948.83 53.585.197"/><path fill="#f06a35" d="M67.575 75.717c-4.123-1.136-5.663-7.051-2.633-10.11 1.937-1.956 2.472-2.03 14.595-2.03 10.883 0 11.25.023 12.848.83 2.31 1.168 3.314 2.813 3.314 5.433 0 2.367-.943 4.025-3.046 5.357-1.129.716-1.804.76-12.467.823-6.584.039-11.83-.087-12.611-.303m-.517 39.81c-1.77-.772-3.417-2.914-3.702-4.814-.272-1.809.638-4.296 2.032-5.558 1.757-1.59 2.528-1.643 24.134-1.66 22.227-.017 22.111-.027 24.219 1.941 2.976 2.78 2.349 7.728-1.239 9.76l-3.686.6-19.213.224c-16.883.198-21.666-.111-22.545-.494"/></svg>',
        'faded_color' => '#fcd8b2',
    ],
    'shopify' => [
        'name' => 'Shopify',
        'color' => '#96bf48',
        'svg_logo' => '<svg width="800px" height="800px" viewBox="-18 0 292 292" xmlns="http://www.w3.org/2000/svg" preserveAspectRatio="xMidYMid"><path d="M223.774 57.34c-.201-1.46-1.48-2.268-2.537-2.357-1.055-.088-23.383-1.743-23.383-1.743s-15.507-15.395-17.209-17.099c-1.703-1.703-5.029-1.185-6.32-.805-.19.056-3.388 1.043-8.678 2.68-5.18-14.906-14.322-28.604-30.405-28.604-.444 0-.901.018-1.358.044C129.31 3.407 123.644.779 118.75.779c-37.465 0-55.364 46.835-60.976 70.635-14.558 4.511-24.9 7.718-26.221 8.133-8.126 2.549-8.383 2.805-9.45 10.462C21.3 95.806.038 260.235.038 260.235l165.678 31.042 89.77-19.42S223.973 58.8 223.775 57.34zM156.49 40.848l-14.019 4.339c.005-.988.01-1.96.01-3.023 0-9.264-1.286-16.723-3.349-22.636 8.287 1.04 13.806 10.469 17.358 21.32zm-27.638-19.483c2.304 5.773 3.802 14.058 3.802 25.238 0 .572-.005 1.095-.01 1.624-9.117 2.824-19.024 5.89-28.953 8.966 5.575-21.516 16.025-31.908 25.161-35.828zm-11.131-10.537c1.617 0 3.246.549 4.805 1.622-12.007 5.65-24.877 19.88-30.312 48.297l-22.886 7.088C75.694 46.16 90.81 10.828 117.72 10.828z" fill="#95BF46"/><path d="M221.237 54.983c-1.055-.088-23.383-1.743-23.383-1.743s-15.507-15.395-17.209-17.099c-.637-.634-1.496-.959-2.394-1.099l-12.527 256.233 89.762-19.418S223.972 58.8 223.774 57.34c-.201-1.46-1.48-2.268-2.537-2.357" fill="#5E8E3E"/><path d="M135.242 104.585l-11.069 32.926s-9.698-5.176-21.586-5.176c-17.428 0-18.305 10.937-18.305 13.693 0 15.038 39.2 20.8 39.2 56.024 0 27.713-17.577 45.558-41.277 45.558-28.44 0-42.984-17.7-42.984-17.7l7.615-25.16s14.95 12.835 27.565 12.835c8.243 0 11.596-6.49 11.596-11.232 0-19.616-32.16-20.491-32.16-52.724 0-27.129 19.472-53.382 58.778-53.382 15.145 0 22.627 4.338 22.627 4.338" fill="#FFF"/></svg>',
        'faded_color' => '#dfebc8',
    ],
    'wordpress' => [
        'name' => 'WordPress',
        'color' => '#21759b',
        'svg_logo' => '<svg height="800" width="800" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 25.925 25.925" xml:space="preserve"><path style="fill:#030104" d="M1.843 12.962c0 4.401 2.557 8.205 6.267 10.008L2.805 8.437a11.1 11.1 0 0 0-.962 4.525m18.626-.562c0-1.374-.493-2.326-.917-3.066-.563-.917-1.092-1.691-1.092-2.608 0-1.021.775-1.973 1.867-1.973.049 0 .096.006.145.008a11.08 11.08 0 0 0-7.509-2.919 11.1 11.1 0 0 0-9.291 5.013c.261.008.507.013.716.013 1.163 0 2.963-.142 2.963-.142.599-.035.67.846.071.917 0 0-.603.07-1.272.105l4.049 12.045 2.434-7.298-1.732-4.747a21 21 0 0 1-1.167-.105c-.6-.036-.529-.953.07-.917 0 0 1.836.142 2.928.142 1.163 0 2.964-.142 2.964-.142.6-.035.67.846.071.917 0 0-.604.07-1.272.105l4.018 11.953 1.11-3.706q.846-2.166.846-3.595m-7.311 1.535-3.337 9.694a11.12 11.12 0 0 0 6.835-.177 1 1 0 0 1-.08-.153zm9.562-6.308q.074.53.075 1.144c0 1.128-.212 2.396-.846 3.982l-3.396 9.82a11.11 11.11 0 0 0 5.529-9.611c0-1.934-.494-3.752-1.362-5.335"/><path style="fill:#030104" d="M0 12.962c0 7.147 5.815 12.963 12.962 12.963 7.149 0 12.963-5.816 12.963-12.963S20.111 0 12.963 0 0 5.814 0 12.962m.594 0C.594 6.143 6.142.594 12.962.594s12.369 5.549 12.369 12.368S19.782 25.33 12.963 25.33.594 19.781.594 12.962"/></svg>',
        'faded_color' => '#bcd5e1',
    ],
    'woocommerce' => [
        'name' => 'WooCommerce',
        'color' => '#96588a',
        'svg_logo' => '<svg width="800" height="800" viewBox="0 -51.5 256 256" xmlns="http://www.w3.org/2000/svg" preserveAspectRatio="xMidYMid"><path d="M23.759 0h208.378C245.325 0 256 10.675 256 23.863v79.541c0 13.188-10.675 23.863-23.863 23.863H157.41l10.257 25.118-45.109-25.118H23.863c-13.187 0-23.862-10.675-23.862-23.863V23.863C-.104 10.78 10.57 0 23.759 0" fill="#9B5C8F"/><path d="M14.578 21.75c1.457-1.978 3.642-3.018 6.556-3.226q7.962-.626 9.054 7.492c3.226 21.75 6.764 40.17 10.51 55.259l22.79-43.395q3.123-5.932 7.806-6.244c4.579-.312 7.388 2.601 8.533 8.741 2.602 13.84 5.932 25.6 9.886 35.59 2.706-26.432 7.285-45.476 13.737-57.235 1.56-2.914 3.85-4.371 6.868-4.58 2.394-.207 4.579.521 6.556 2.082s3.018 3.538 3.226 5.932c.104 1.873-.208 3.434-1.04 4.995-4.059 7.493-7.39 20.085-10.095 37.567-2.601 16.963-3.538 30.18-2.914 39.65q.313 3.9-1.248 6.868c-1.25 2.289-3.122 3.538-5.516 3.746-2.706.208-5.515-1.04-8.221-3.85-9.678-9.887-17.379-24.664-22.998-44.332Q57.921 86.79 53.082 96.78c-6.14 11.76-11.343 17.796-15.714 18.108-2.81.208-5.203-2.186-7.284-7.18q-7.961-20.45-17.17-78.986c-.417-2.706.207-5.1 1.664-6.972m223.636 16.338c-3.746-6.556-9.262-10.51-16.65-12.072q-2.966-.624-5.62-.624c-9.99 0-18.107 5.203-24.455 15.61q-8.118 13.267-8.117 29.346 0 12.02 4.995 20.605c3.746 6.556 9.262 10.51 16.65 12.071q2.965.625 5.62.625c10.094 0 18.211-5.203 24.455-15.61 5.411-8.95 8.117-18.732 8.117-29.45.104-8.117-1.665-14.882-4.995-20.501m-13.112 28.826c-1.457 6.868-4.059 11.967-7.91 15.401-3.017 2.706-5.827 3.85-8.428 3.33-2.498-.52-4.58-2.705-6.14-6.764-1.25-3.226-1.873-6.452-1.873-9.47 0-2.601.208-5.203.728-7.596.937-4.267 2.706-8.43 5.515-12.384 3.435-5.1 7.077-7.18 10.823-6.452 2.498.52 4.58 2.706 6.14 6.764 1.249 3.226 1.873 6.452 1.873 9.47 0 2.706-.208 5.307-.728 7.7zm-52.033-28.826c-3.746-6.556-9.366-10.51-16.65-12.072q-2.965-.624-5.62-.624c-9.99 0-18.107 5.203-24.455 15.61q-8.117 13.267-8.117 29.346 0 12.02 4.995 20.605c3.746 6.556 9.262 10.51 16.65 12.071q2.966.625 5.62.625c10.094 0 18.211-5.203 24.455-15.61 5.412-8.95 8.117-18.732 8.117-29.45 0-8.117-1.665-14.882-4.995-20.501m-13.216 28.826c-1.457 6.868-4.059 11.967-7.909 15.401-3.018 2.706-5.828 3.85-8.43 3.33-2.497-.52-4.578-2.705-6.14-6.764-1.248-3.226-1.872-6.452-1.872-9.47 0-2.601.208-5.203.728-7.596.937-4.267 2.706-8.43 5.516-12.384 3.434-5.1 7.076-7.18 10.822-6.452 2.498.52 4.58 2.706 6.14 6.764 1.25 3.226 1.873 6.452 1.873 9.47.105 2.706-.208 5.307-.728 7.7z" fill="#FFF"/></svg>',
        'faded_color' => '#dfccdb',
    ],
    'wix' => [
        'name' => 'Wix',
        'color' => '#ff7100',
        'svg_logo' => '<svg xmlns="http://www.w3.org/2000/svg" width="311" height="121" viewBox="0 0 311 121" xml:space="preserve"><path fill="#FBBD71" d="M178 2.3c-6 3-8.6 8.6-8.6 23.8 0 0 3-3 7.8-4.8 3.5-1.3 6-3 7.8-4.3 5.2-3.9 6-8.6 6-16.8-.1 0-8.3-.5-13 2.1"/><path d="M141.3 5.8c-5.2 4.3-6.5 11.7-6.5 11.7L118 81.9l-13.8-52.7c-1.3-5.6-3.9-12.5-7.8-17.3-4.8-6.1-14.8-6.5-16-6.5-.9 0-10.8.4-16 6.5-3.9 4.8-6.5 11.7-7.8 17.3l-13 52.7-16.8-64.4s-1.3-6.9-6.5-11.7C12.1-1.6 0 .2 0 .2l32 120.5s10.4.9 15.6-1.7c6.9-3.5 10.4-6 14.3-22.5C65.8 81.8 76.2 39 77 36c.4-1.3 1.3-5.2 3.9-5.2s3.5 3.5 3.9 5.2c.9 3 11.2 45.8 15.1 60.5 4.3 16.4 7.3 19 14.3 22.5 5.2 2.6 15.6 1.7 15.6 1.7L161.6.2s-12.1-1.7-20.3 5.6m49.6 13.8s-2.2 3-6.5 5.6c-3 1.7-5.6 2.6-8.6 4.3-5.2 2.6-6.5 5.2-6.5 9.1v81.7s8.2.9 13.4-1.7c6.9-3.5 8.2-6.9 8.2-21.6zm79.5 41.1L311 .6s-16.8-3-25.5 4.8c-5.6 4.8-11.2 13.8-11.2 13.8l-14.7 21.6c-.9 1.3-1.7 2.2-3 2.2s-2.6-1.3-3-2.2l-14.7-21.6s-6-8.6-11.2-13.8C219.1-2.4 202.2.6 202.2.6l39.3 60-40.2 60s17.7 2.2 26.4-5.6c5.6-4.8 10.8-13 10.8-13l14.7-21.6c.9-1.3 1.7-2.2 3-2.2s2.6 1.3 3 2.2l14.7 21.6s5.6 8.2 10.8 13c8.6 7.8 25.9 5.6 25.9 5.6z"/></svg>',
        'faded_color' => '#ffd4b2',
    ],
    'jekyll' => [
        'name' => 'Jekyll',
        'color' => '#cc0000',
        'svg_logo' => '<svg xmlns="http://www.w3.org/2000/svg" width="64" height="64" viewBox="0 0 32 32"><defs><linearGradient id="a" y2="277.465" x2="296.661" y1="238.547" x1="195.456" gradientUnits="userSpaceOnUse"><stop offset="0" stop-color="#919191"/><stop offset="1" stop-color="#fff"/></linearGradient><linearGradient id="b" y2="327.266" x2="254.14" y1="303.705" x1="192.87" gradientUnits="userSpaceOnUse"><stop offset="0" stop-color="#900"/><stop offset="1" stop-color="#e80000"/></linearGradient></defs><g transform="translate(-3.451 -3.955)scale(.07776)"><path d="M269.02 59.15c-.184.737-.188 1.53-.033 2.365 0 0 2.507 16.642-.34 24.048L147.652 400.2c-8.636 23.1 2.937 48.91 26.014 57.787s48.955-2.524 58.03-25.464l.01.005 121.005-314.634c2.366-6.155 15.86-18.08 15.86-18.08.677-.516 1.202-1.108 1.56-1.778l.06-.122c.065-.132.14-.258.193-.395 3.12-8.113-17.005-23.405-44.952-34.152s-53.133-12.884-56.253-4.77c-.053.137-.083.28-.122.422l-.037.13z" opacity=".3"/><path d="M265.523 56.477c-.185.737-.2 1.53-.033 2.365 0 0 2.508 16.642-.34 24.048L144.155 397.526c-8.635 23.1 2.937 48.91 26.014 57.787s48.955-2.524 58.03-25.464v.005L349.215 115.22c2.365-6.155 15.86-18.08 15.86-18.08.677-.516 1.202-1.107 1.56-1.778l.058-.122c.065-.13.14-.258.193-.395 3.12-8.113-17.005-23.404-44.95-34.152s-53.133-12.884-56.253-4.77c-.053.137-.083.28-.122.422z" fill="url(#a)"/><path d="M303.48 198.814 216.275 425.73c-6.436 16.262-25.166 24.723-41.78 18.333s-25.608-25.512-19.488-41.897l55.758-144.982s6.964-11.233 20.637-19.225 24.95-6.305 40.132-13.053 31.947-26.093 31.947-26.093z" fill="url(#b)"/><ellipse ry="8.85" rx="33.648" cy="76.201" cx="315.97" transform="rotate(21.038 315.94 76.192)" fill="#333"/><g fill="#fff"><path d="M265.49 58.84s2.47 16.737-.34 24.048L144.155 397.526c-8.635 23.1 2.937 48.91 26.014 57.787a45 45 0 0 0 12.164 2.822c-15.556-11.702-22.23-32.632-15.093-51.73l-.01-.004L285.833 98.01S269.69 82.85 265.49 58.84" opacity=".3"/><circle r="3.506" cy="261.806" cx="226.531" opacity=".5"/><circle r="5.285" cy="287.227" cx="249.514" opacity=".5"/><circle r="9.915" cy="317.459" cx="214.429" opacity=".5"/><circle r="5.286" cy="335.795" cx="198.375" opacity=".5"/><circle r="3.506" cy="375.008" cx="219.43" opacity=".5"/></g></g></svg>',
        'faded_color' => '#efb2b2',
    ],
    'prestashop' => [
        'name' => 'PrestaShop',
        'color' => '#df0067',
        'svg_logo' => '<svg width="800" height="800" viewBox="0 0 256 256" xmlns="http://www.w3.org/2000/svg" preserveAspectRatio="xMidYMid"><path d="M82.979 196.416c2.044-.91 4.115-1.747 6.205-2.532 2.36-.887 4.739-1.721 7.15-2.447 3.001-.904 6.027-1.722 9.094-2.373a113 113 0 0 1 12.534-1.937 392 392 0 0 1-7.808 22.168 74 74 0 0 1 .224 4.288A91 91 0 0 1 128 211.856c6.031 0 11.92.602 17.622 1.727a74 74 0 0 1 .224-4.288 391 391 0 0 1-7.808-22.168c4.215.409 8.399 1.059 12.534 1.937 3.066.651 6.092 1.469 9.093 2.373 2.412.726 4.791 1.56 7.151 2.447 2.091.786 4.163 1.623 6.207 2.533a111.1 111.1 0 0 1 38.57 28.471C238.773 201.417 256 166.731 256 128 256 57.308 198.692 0 128 0S0 57.308 0 128c0 38.731 17.227 73.416 44.407 96.888a111.1 111.1 0 0 1 38.572-28.472" fill="#A5DBE8"/><path d="m173.023 196.417 7.946 27.323 2.254.106c1.463 0 2.492.385 2.492 1.848 0 2.432.126 5.165.359 7.551 1.98 1.681 4.391 3.577 6.219 5.419a128.3 128.3 0 0 0 19.3-13.776 111.1 111.1 0 0 0-38.57-28.471m-15.537-.273 9.33-2.26c-2.36-.887-4.739-1.721-7.151-2.447-3.001-.904-6.027-1.722-9.093-2.373a113 113 0 0 0-12.534-1.937 391 391 0 0 0 7.808 22.168 74 74 0 0 0-.224 4.288c6.611 1.304 13.111 3.57 19.121 6.228z" fill="#525353"/><path d="M63.707 238.664c1.486.866 2.987 1.711 4.513 2.518.534-2.565 1.388-6.119 1.646-8.758-1.98 1.681-4.331 4.398-6.159 6.24m100.88-19.089a89.8 89.8 0 0 0-18.965-5.992A91 91 0 0 0 128 211.856c-6.032 0-11.92.602-17.622 1.727-6.61 1.303-13.507 3.28-19.515 5.937l-.639 3.981h75.554z"/><path d="M69.632 233.182c.234-2.386.403-4.513.403-6.946 0-1.462 1.003-2.399 2.466-2.399l2.399-.084 8.079-27.337a111.1 111.1 0 0 0-38.572 28.472 128.3 128.3 0 0 0 19.3 13.776 91 91 0 0 1 5.712-5.29" fill="#525353"/><path d="M187.051 238.045c.518 2.6.635 3.118.729 3.137a126 126 0 0 0 4.513-2.518 93 93 0 0 0-5.772-5.349z"/><path d="m164.587 219.575 1.191 3.926h15.454l-8.209-27.084a113 113 0 0 0-6.207-2.533l-9.33 2.26z" fill="#AA9678"/><path d="M75.039 228.971q.122-.085.243-.172h-.232z" fill="#C4B6A1"/><path d="M180.95 228.799h-.233l.243.172c-.002-.057-.008-.115-.01-.172" fill="#AA9678"/><path d="m180.684 228.404-52.794.06L128 256c19.648 0 38.256-4.439 54.893-12.351-1.086-4.772-1.195-9.912-1.372-14.914-.08-.058-.837-.331-.837-.331" fill="#AA9678"/><path d="M127.915 228.578s-53.085-.067-53.166-.01c-.176 5.003-1.208 10.939-1.642 15.081C89.744 251.561 108.352 256 128 256l.03-27.333z" fill="#C4B6A1"/><path d="M128 226.15h.001v2.649H128z" fill="#786453"/><path d="m167.594 208.16.027.083zs-1.298-1.029-2.945-2.924c1.647 1.895 2.945 2.924 2.945 2.924" fill="#AA9678"/><path d="M206.706 92.348v.006zm5.151 36.853.001-.038z" fill="#FFF"/><path d="m211.858 129.163-.001-.035z" fill="#BBBCBD"/><path d="M211.714 127.169c.004.034.014.064.018.098l.012.06v.008c.061.489.084 1 .095 1.515.002.095.018.184.018.278l.001.035-.001.038c-.001.102-.018.197-.019.298a15 15 0 0 1-.093 1.486v.007l-.014.073c-.004.039-.016.074-.021.112a14 14 0 0 1-.287 1.515l-.002.007v.001l.018-.02.007-.023v.001l3.35-3.507-3.377-3.535.001.007q.187.741.294 1.546" fill="#676A6A"/><path d="M211.71 131.177c.009-.066.026-.125.035-.192.059-.48.081-.981.093-1.486.001-.114.019-.221.019-.336 0-.107-.016-.207-.018-.313a15 15 0 0 0-.095-1.515c-.008-.058-.023-.109-.03-.166a14 14 0 0 0-.294-1.546c-.044-.172-.105-.325-.156-.491-.303-1.002-.716-1.887-1.206-2.622a8 8 0 0 0-.614-.8 5 5 0 0 0-.662-.615c-.088-.067-.181-.114-.271-.172a3.8 3.8 0 0 0-.888-.429 3.1 3.1 0 0 0-.917-.158c-.314 0-.618.066-.917.158a3.7 3.7 0 0 0-.889.429c-.088.058-.182.104-.269.171a5.3 5.3 0 0 0-1.074 1.129 7 7 0 0 0-.203.288c-.49.735-.904 1.62-1.206 2.622l-.038.12c-.134.46-.238.944-.325 1.441-.026.152-.061.298-.082.454-.08.556-.121 1.136-.131 1.73-.001.082-.014.16-.014.242h.02c0 4.876 2.307 8.828 5.152 8.828.49 0 .961-.128 1.41-.347a4.2 4.2 0 0 0 .758-.479c.097-.078.188-.172.281-.26q.34-.318.648-.719c.142-.187.282-.374.412-.583.083-.133.159-.277.236-.419q.217-.397.403-.837c.046-.106.093-.209.135-.318q.236-.614.41-1.294c.123-.483.215-.991.287-1.515m-4.819-3.189c-1.067 0-1.932-1.483-1.932-3.311s.865-3.31 1.932-3.31 1.931 1.483 1.931 3.31c0 1.828-.864 3.311-1.931 3.311"/><path d="M206.891 121.367c-1.067 0-1.932 1.483-1.932 3.31 0 1.828.865 3.311 1.932 3.311s1.931-1.483 1.931-3.311-.864-3.31-1.931-3.31" fill="#FFF"/><path d="M202.148 125.133c.302-1.002.716-1.887 1.206-2.622.066-.1.133-.193.203-.288a5.2 5.2 0 0 1 1.074-1.129c.087-.067.181-.113.269-.171a3.7 3.7 0 0 1 .889-.429c.298-.094.603-.158.917-.158s.619.064.917.158a3.8 3.8 0 0 1 .888.429c.09.058.183.105.271.172.23.176.45.384.662.615a8 8 0 0 1 .614.8c.49.735.903 1.62 1.206 2.622v.002l-4.558-20.877z" fill="#909393"/><path d="M146.299 128.968q-.01-.63-.08-1.243l-.003-.017a12 12 0 0 0-.201-1.188l-.008-.03a12 12 0 0 0-.313-1.134l-.01-.025a11 11 0 0 0-.422-1.088l-.01-.022a12.12 12.12 0 0 0-6.441-6.24l-.035-.013a12 12 0 0 0-2.158-.651l-.056-.008a12 12 0 0 0-2.313-.227c-.779 0-1.536.08-2.273.221l-.078.012c-.733.146-1.44.36-2.119.632l-.054.021a12 12 0 0 0-1.969 1.021c-.623.402-1.208.859-1.746 1.364l-.013.041-.045.01a12.2 12.2 0 0 0-2.189 2.794l-.022.037q-.269.477-.493.983c-.016.036-.036.07-.051.106-.137.311-.255.633-.365.957-.021.064-.049.124-.069.187-.096.303-.174.614-.248.925-.019.09-.048.176-.067.265-.064.308-.108.623-.149.939-.012.097-.033.19-.043.287a12 12 0 0 0 .164 3.588q.002.023.007.048c.151.753.373 1.479.658 2.174l.011.029a12.1 12.1 0 0 0 2.456 3.76c.82.855 1.764 1.588 2.802 2.174l.015.009q.487.272 1 .498l.084.04c.316.138.643.257.972.368.056.019.11.043.166.061.304.097.618.175.932.247.085.02.167.048.253.066.305.063.619.106.935.147.095.011.189.033.286.043a12.03 12.03 0 0 0 7.994-1.994 12.1 12.1 0 0 0 3.258-3.257 12.03 12.03 0 0 0 2.06-6.743l-.004-.083zm-12.05-1.413a4.53 4.53 0 1 1 .001-9.061 4.53 4.53 0 0 1-.001 9.061"/><path d="M134.249 118.494a4.53 4.53 0 1 0 0 9.06 4.53 4.53 0 0 0 0-9.06" fill="#FFF"/><path d="m125.952 120.404.045-.01.013-.041 8.306-25.402v-5.945l-.001-.067a70.8 70.8 0 0 0-14.25-1.47c-1.625 0-3.237.069-4.839.178l-.701.048c-8.337.633-16.547 2.806-24.149 6.276-6.519 2.977-12.576 6.898-18.021 11.547v.001l-.009.008a80 80 0 0 0-4.231 3.897c-.256.25-.516.498-.769.752a86 86 0 0 0-3.737 4.019c-.261.301-.518.608-.776.912a88 88 0 0 0-3.502 4.383c-.093.126-.18.258-.272.384a90 90 0 0 0-3.056 4.448c-.191.295-.387.586-.574.884-.79 1.253-1.525 2.54-2.255 3.83h37.837z" fill="#BBBCBD"/><path d="M157.895 117.546q.115-1.486.191-2.973.103-2.014.142-4.029c.02-1.043.017-2.087.012-3.13 0-.301.007-.602.004-.904a160 160 0 0 0-.297-8.073l-.023-.015-.01-.019a721 721 0 0 0-3.003-1.716l-.07-.04-.783-.443-.014-.008-.543-.304-.107-.06-.395-.215a74 74 0 0 0-5.319-2.499c-4.303-1.817-10.099-3.41-13.364-4.179v6.012l8.233 25.443.009.021c.85.81 1.581 1.741 2.167 2.767v.001q.288.505.527 1.038.007.012.01.022.238.531.422 1.088l.01.025q.184.556.313 1.134l.008.03q.129.584.201 1.188 0 .01.003.017.07.612.08 1.243l.031.068h10.081a110 110 0 0 0 1.457-11.181c.007-.103.019-.206.027-.309" fill="#E3DDDB"/><path d="M171.079 108.55q-.01.017-.018.035z" fill="#FCB03F"/><path d="M126.01 120.353a12.3 12.3 0 0 1 1.753-1.367 12 12 0 0 1 1.962-1.018l.054-.021a12 12 0 0 1 2.119-.632l.078-.012a12 12 0 0 1 2.273-.221c.792 0 1.564.08 2.313.227l.056.008a12 12 0 0 1 2.193.664 12.2 12.2 0 0 1 3.747 2.434l-.009-.021-8.233-25.443z" fill="#909393"/><path d="M123.085 133.694a12 12 0 0 1-.658-2.174q-.005-.025-.007-.048a12 12 0 0 1-.164-3.588c.01-.097.031-.19.043-.287.041-.316.085-.631.149-.939.019-.089.048-.175.067-.265.074-.311.152-.622.248-.925.021-.063.047-.123.069-.187.11-.324.228-.646.365-.957.015-.036.035-.07.051-.106q.224-.506.493-.983l.022-.037a12.2 12.2 0 0 1 2.189-2.794l-34.941 8.632h-.067l34.608 8.447a12.1 12.1 0 0 1-2.456-3.76z" fill="#676A6A"/><path d="M201.703 127.148c.022-.156.055-.302.082-.454.087-.497.191-.981.325-1.441.015-.052.021-.111.037-.162l4.559-20.876-.001-11.903c-3.725-3.077-7.714-4.759-11.867-4.759-5.248 0-10.141 2.898-13.8 6.477-4.004 3.917-7.098 8.845-9.6 13.818-.115.229-.233.449-.347.679q1.157 1.001 2.287 2.034a186 186 0 0 1 5.016 4.781c.766.756 1.518 1.528 2.272 2.297.8.815 1.601 1.628 2.389 2.456a236 236 0 0 1 4.262 4.598 271 271 0 0 1 3.565 4.011l.002.002c.197.206.335.354.388.414h10.282c0-.083.017-.159.018-.242.01-.594.051-1.174.131-1.73m-30.613-18.566-.011-.031-.018.034.045.044z" fill="#E3DDDB"/><path d="m46.975 142.173.092-.23a97 97 0 0 1 4.768-10.473c.278-.528.55-1.058.838-1.581.159-.289.339-.565.501-.853.73-1.29 1.465-2.577 2.255-3.83.187-.299.383-.589.574-.884a90 90 0 0 1 3.056-4.448c.092-.126.179-.258.272-.384a88 88 0 0 1 3.502-4.383c.258-.304.514-.61.776-.912a86 86 0 0 1 3.737-4.019c.254-.254.513-.502.769-.752a80 80 0 0 1 4.231-3.897l.009-.009c5.751-19.264 24.321-31.102 45.142-31.102 8.38 0 16.714 2.415 23.856 6.784 7.326 4.481 12.321 8.859 16.199 16.512l.058.115c.098.194.208.38.304.576l.01.019.023.015a77 77 0 0 1 9.281 6.745 86 86 0 0 1 2.892 2.554c.312.286.633.558.941.849q.008-.018.018-.035l.011-.024c.106-.217.21-.438.317-.652 2.934-18.517 12.256-28.614 21.89-28.614 7.262 0 12.541 4.33 16.528 15.986l.041.125.01.014a44 44 0 0 1 3.287 4.048l-.002-.001.064.083-.001-.001.001.001c.057.169.106.343.161.512v-.001l-.15-.607c-11.985-35.482-45.545-61.028-85.073-61.028-49.58 0-89.772 40.192-89.772 89.772 0 9.774 1.562 19.184 4.462 27.94l.012-.051a96 96 0 0 1 4.11-13.879" fill="#525353"/><path d="m214.577 129.155-3.131 3.503v-.001l-.007.023c-.119.461-.265.891-.426 1.306-.042.109-.089.212-.135.318a9 9 0 0 1-.403.837c-.077.142-.153.286-.236.419-.13.208-.27.397-.412.583a6 6 0 0 1-.648.719c-.093.087-.183.182-.281.26a4.2 4.2 0 0 1-.758.479c-.449.219-.92.347-1.41.347-2.845 0-5.152-3.952-5.152-8.828h-10.337l.006.008a328 328 0 0 1 5.734 6.812 423 423 0 0 1 5.354 6.679l.26.329a574 574 0 0 1 4.964 6.43l.478.624a883 883 0 0 1 5.191 6.903 89.6 89.6 0 0 0 4.708-27.785l-2.906-.11z" fill="#FFF"/><path d="M114.525 87.695q.351-.026.701-.048a71 71 0 0 1 4.839-.178c4.868 0 9.624.521 14.25 1.47h.001c3.265.769 9.061 2.362 13.364 4.179a74 74 0 0 1 5.319 2.499l.395.215.107.06c.161.09.337.187.543.304l.014.008.783.443.07.04c1.106.627 2.33 1.33 2.798 1.598l.12.069.085.049c-.096-.196-.206-.382-.304-.576l-.058-.115c-3.878-7.653-9.848-14.217-17.174-18.698-7.142-4.369-15.476-6.784-23.857-6.784-20.82 0-38.415 14.024-44.166 33.288 5.445-4.649 11.502-8.57 18.021-11.547 7.602-3.47 15.812-5.643 24.149-6.276"/><path d="m213.225 99.515-.001-.001zl-.064-.083.002.001a44 44 0 0 0-3.287-4.048l-.029-.035a37 37 0 0 0-1.551-1.585c-.197-.189-.401-.354-.6-.535-.329-.299-.656-.608-.99-.882v11.909l4.559 20.878v-.001c.05.162.11.314.154.482l3.158 3.539.031-.035h3.305c.004-.306.023-.608.023-.915v-.005a89.6 89.6 0 0 0-4.55-28.174v.001c-.055-.169-.104-.343-.161-.512" fill="#BBBCBD"/><path d="M181.038 94.03c3.659-3.579 8.552-6.477 13.8-6.477 4.153 0 8.142 1.682 11.867 4.759l.001.036v.006-.006c.334.274.661.583.99.882.199.181.403.346.6.535a37 37 0 0 1 1.551 1.585l.029.035-.009-.012-.001-.001-.041-.126c-3.987-11.656-10.42-19.229-17.68-19.229-9.635 0-17.804 13.34-20.738 31.857l.031-.026c2.502-4.973 5.596-9.901 9.6-13.818m-13.019 113.806s-1.297-1.028-2.944-2.923a30 30 0 0 1-2.139-2.757q-.315-.46-.625-.952c-.623-.985-1.12-2.184-1.668-3.369-.634-1.372-.636-2.285-1-3.563a25 25 0 0 1-.637-2.863 24.6 24.6 0 0 1-.303-4.728c.028-.913.122-1.858.259-2.82a28 28 0 0 1 .557-2.839c.726-2.903 1.981-5.995 3.939-9.259l.498-1.118c.64-1.066.782-1.019 1.39-2.046 8.564-14.453 13.184-25.382 10.924-42.21a134 134 0 0 0-.844-5.156 205 205 0 0 1-.625 3.719c-.085.384-.318.801-.406 1.062-3.72 11.01-9.576 19.109-18.002 28.254a230 230 0 0 1-3.562 3.765 457 457 0 0 1-6.505 6.59q-1.369 1.36-2.788 2.765c-.869.86-1.95 2.699-3.24 4.054-.796 2.229-1.701 4.743-2.466 7.387-.345-.131-.674-.248-1.025-.384-16.368-6.331-27.327-14.79-27.327-14.79s8.432 10.979 22.638 21.285a46 46 0 0 0 4.059 2.628c-.586 9.276 3.506 18.181 21.977 20.837 3.123.449 6.321.428 9.542.065-.032-.096.18-.094.163-.147-.018-.054.172-.196.172-.196"/><path d="M158.139 183.959c16.398 2.646 40.667 2.212 65.861-9.584.607-.284 1.276.464 1.883.166 0 0-17.219 17.587-37.783 27.53-.601.29-1.194.599-1.801.875-1.987.908-4.008 1.699-6.037 2.429-3.979 1.43-8.011 2.515-12.014 3.016-.184.024-.368.059-.552.079l-.075-.227-.027-.083s-1.298-1.029-2.945-2.924a29 29 0 0 1-2.138-2.757 28.7 28.7 0 0 1-2.401-4.21 26 26 0 0 1-1.427-3.837 24.7 24.7 0 0 1-.941-7.591 26 26 0 0 1 .259-2.82z" fill="#9F2254"/><path d="M146.386 165.29a452 452 0 0 0 6.506-6.59 234 234 0 0 0 3.562-3.765c8.425-9.145 14.61-17.703 18.331-28.713.087-.261.175-.605.26-.992l.04-.179c.087-.411.172-.868.257-1.383.034-.355 1.147-1.071 1.178-1.404-.933-4.794-3.083-9.834-5.43-13.682l.016.047-.045-.044c-.308-.291-.629-.563-.941-.849a86 86 0 0 0-2.892-2.554 77 77 0 0 0-9.281-6.745c.164 2.694.269 5.385.297 8.073.004.302-.004.603-.004.904.005 1.043.008 2.087-.012 3.13a126 126 0 0 1-.142 4.029q-.076 1.487-.191 2.973c-.008.103-.02.206-.027.309a110 110 0 0 1-1.457 11.181l-1.184 5.599c-2.473 10.026-7.496 19.12-11.626 28.51-1.095 2.49-2.134 5.008-3.045 7.573l-.258.724a171 171 0 0 1 3.3-3.387q1.421-1.405 2.788-2.765" fill="#FCB03F"/><path d="M92.198 219.213c6.009-2.658 11.57-4.327 18.18-5.63a74 74 0 0 0-.224-4.288 392 392 0 0 0 7.808-22.168 113 113 0 0 0-12.534 1.937c-3.067.651-6.093 1.469-9.094 2.373-2.411.726-4.79 1.56-7.15 2.447l9.331 2.26-7.508 23.566z" fill="#525353"/><path d="M207.559 149.378a574 574 0 0 0-4.964-6.43l-.26-.329a423 423 0 0 0-5.421-6.761 328 328 0 0 0-5.667-6.73q-.181-.213-.365-.424a271 271 0 0 0-4.816-5.385 236 236 0 0 0-3.011-3.224 222 222 0 0 0-2.389-2.456c-.754-.769-1.506-1.541-2.272-2.297a189 189 0 0 0-5.016-4.781 116 116 0 0 0-2.288-2.035l-.011.024c1.622 4.662 3.473 9.382 4.4 14.244q.36 1.896.602 3.697c2.26 16.827-3.132 27.814-11.695 42.267a721 721 0 0 1-1.889 3.164c-1.958 3.266-3.212 6.357-3.939 9.26a28 28 0 0 0-.557 2.839c16.793 2.71 42.045 3.215 67.882-9.48 0 0-5.067-7.447-12.691-17.684a883 883 0 0 0-5.155-6.855q-.238-.314-.478-.624" fill="#DF0067"/><path d="m90.115 223.922 8.4-27.778-9.331-2.26c-2.09.785-4.161 1.622-6.205 2.532l-8.319 27.506 9.287.145z" fill="#AA9678"/><path d="M96.02 211.904c.82.315 1.654.599 2.486.89a89.5 89.5 0 0 0 29.658 5.047 89.5 89.5 0 0 0 33.528-6.498c.548-.22 1.085-.462 1.627-.693a92 92 0 0 0 2.619-1.161c.774-.36 1.548-.717 2.31-1.098-.184.024-.368.059-.552.079-3.221.363-6.419.384-9.542-.065-18.471-2.656-22.563-11.561-21.977-20.837a46 46 0 0 1-4.059-2.628c-14.206-10.306-22.638-21.285-22.638-21.285s10.959 8.459 27.327 14.79c.351.136.68.253 1.025.384.765-2.644 1.67-5.158 2.466-7.387l.258-.724c.911-2.565 1.95-5.083 3.045-7.573 4.13-9.39 9.153-18.484 11.626-28.51l1.184-5.599h-10.102l-.001.001.001.02-.004.002c0 .027.004.054.004.083a12.03 12.03 0 0 1-2.06 6.743 12.14 12.14 0 0 1-5.306 4.368 12 12 0 0 1-5.946.883c-.097-.01-.19-.031-.286-.043-.316-.041-.63-.084-.935-.147-.086-.019-.168-.046-.253-.066-.314-.072-.628-.15-.932-.247l-.166-.061c-.329-.111-.656-.23-.972-.368l-.084-.04a12 12 0 0 1-1-.498l-.015-.009a12.2 12.2 0 0 1-2.802-2.174l-34.608-8.447h-37.77c-.162.288-.342.564-.501.853-.288.523-.56 1.054-.838 1.581a96 96 0 0 0-2.62 5.342 97 97 0 0 0-2.148 5.131l-.092.23a96 96 0 0 0-4.11 13.879c5.946 18.136 17.515 33.72 32.638 44.704.44.319.904.603 1.35.915a90 90 0 0 0 7.943 4.979 89 89 0 0 0 11.224 5.254" fill="#FFF"/><path d="M186.58 233.374a75 75 0 0 1-.376-7.224 2.65 2.65 0 0 0-2.648-2.649H72.444a2.65 2.65 0 0 0-2.649 2.649c0 2.432-.143 4.838-.376 7.224a73 73 0 0 1-1.199 7.808c1.611.852 3.235 1.681 4.887 2.467a78.5 78.5 0 0 0 1.932-14.678l.011-.172h105.9c.002.057.008.115.01.172a78.6 78.6 0 0 0 1.933 14.678 129 129 0 0 0 4.887-2.467 74 74 0 0 1-1.2-7.808" fill="#8B7460"/></svg>',
        'faded_color' => '#f5b2d1',
    ],
    'bigcommerce' => [
        'name' => 'BigCommerce',
        'color' => '#0d5092',
        'svg_logo' => '<svg version="1.1" id="Laag_1" xmlns="http://www.w3.org/2000/svg" x="0" y="0" viewBox="0 0 2489.2 2487.6" xml:space="preserve"><style>.st0{fill:#34313f}</style><path class="st0" d="M1311.5 1416.2h314c89.3 0 145.8-49.1 145.8-128 0-74.4-56.5-128-145.8-128h-314c-10.4 0-19.3 8.9-19.3 17.9v220.2c1.4 10.4 8.8 17.9 19.3 17.9m0 507.4h324.4c99.7 0 159.2-50.6 159.2-139.9 0-77.4-56.5-139.9-159.2-139.9h-324.4c-10.4 0-19.3 8.9-19.3 17.9v242.6c1.4 11.9 8.8 19.3 19.3 19.3"/><path class="st0" d="m2460.3 5.5-928.6 925.6h151.8c236.6 0 376.5 148.8 376.5 311 0 128-86.3 221.7-178.6 263.4-14.9 6-14.9 26.8 1.5 32.7 107.1 41.7 183 153.3 183 284.2 0 184.5-123.5 331.8-363.1 331.8h-657.7c-10.4 0-19.3-8.9-19.3-17.9v-700.9L6.4 2450.4c-13.4 13.4-4.5 37.2 14.9 37.2h2450.9c8.9 0 16.4-7.4 16.4-16.4V18.9c4.4-16.4-16.4-25.3-28.3-13.4"/></svg>',
        'faded_color' => '#b6cade',
    ],
    'drupal' => [
        'name' => 'Drupal',
        'color' => '#0678be',
        'svg_logo' => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1011.55 1333.33" shape-rendering="geometricPrecision" text-rendering="geometricPrecision" image-rendering="optimizeQuality" fill-rule="evenodd" clip-rule="evenodd"><path d="M716.04 281.05C622.35 189.77 533.47 100.89 507.04 0c-26.43 100.89-115.31 189.79-209 281.07C158.71 420.4.17 578.94.17 816.76c-7.21 278.66 216.2 511.68 494.86 516.49s511.68-216.2 516.49-494.86v-21.62c2.39-237.83-156.15-396.37-295.48-535.71zM259.61 862.39c-14.41 19.22-28.82 40.84-38.44 62.46-2.41 2.41-4.81 7.21-9.6 7.21l-2.4-.02c-12.01 0-24.03-21.62-24.03-21.62-2.41-4.81-7.21-12-9.6-16.81l-2.41-4.79c-31.24-67.28-4.81-160.95-4.81-160.95 12-45.63 33.63-91.29 60.06-129.72 16.81-24.03 36.04-48.04 55.25-72.07l24.03 24.03 112.91 115.31c4.81 4.81 4.81 12 0 16.81L302.85 814.36l-43.25 48.02zm252.24 331.51c-96.09 0-175.36-79.28-172.97-175.36 0-43.25 16.81-84.07 43.25-115.31 36.04-43.25 81.68-86.48 132.13-144.13 57.65 62.46 96.09 103.29 132.13 151.35 2.41 2.41 4.81 7.21 7.21 12.01 19.22 28.82 31.22 62.46 31.22 98.5 2.39 96.08-76.87 172.96-172.97 172.96zm329.11-278.67c-2.41 7.22-9.6 12.01-16.81 14.41l-2.41.02c-7.21-2.41-12-7.21-16.81-12.01-31.22-45.63-64.85-88.88-103.29-127.32l-45.63-48.04-153.75-158.54c-31.22-28.82-62.46-62.46-91.29-93.69 0-2.4-2.4-2.4-2.4-2.4-4.81-7.21-9.6-14.41-12.01-24.03v-4.81c-4.81-26.43 4.81-52.85 24.03-72.07 28.82-28.82 60.06-60.06 88.88-91.28 31.22 33.63 64.85 67.26 98.5 100.89 67.26 62.46 127.32 132.13 182.57 206.6 45.63 64.85 69.66 139.33 69.66 218.61-4.82 28.82-9.63 62.45-19.23 93.67z" fill="#009cde" fill-rule="nonzero"/></svg>',
        'faded_color' => '#b4d6eb',
    ],
    'squarespace' => [
        'name' => 'Squarespace',
        'color' => '#222222',
        'svg_logo' => '<svg width="800" height="800" viewBox="0 -26 256 256" xmlns="http://www.w3.org/2000/svg" preserveAspectRatio="xMidYMid"><path d="M162.931 40.67c-4.823-4.824-12.644-4.824-17.464 0L66.87 119.268c-9.651 9.643-25.287 9.643-34.931 0-9.654-9.647-9.654-25.285 0-34.937L109.023 7.25c-9.646-9.649-25.288-9.649-34.934 0L14.467 66.87c-19.29 19.294-19.29 50.57 0 69.866 19.295 19.295 50.57 19.295 69.865 0l78.599-78.599c4.82-4.823 4.82-12.644 0-17.467m26.199-26.197c-19.295-19.297-50.57-19.297-69.865 0L40.67 93.067c-4.82 4.82-4.82 12.646 0 17.467 4.823 4.823 12.64 4.823 17.464 0l78.602-78.594c9.646-9.649 25.282-9.649 34.926 0 4.828 4.82 12.646 4.82 17.469 0 4.823-4.828 4.823-12.644 0-17.467m26.201 78.594c-4.823-4.818-12.646-4.818-17.469 0l-78.597 78.597c-9.646 9.646-25.287 9.646-34.933 0-4.82-4.82-12.639-4.82-17.462 0-4.83 4.825-4.83 12.646 0 17.464 19.287 19.295 50.57 19.295 69.865 0l78.596-78.594c4.82-4.82 4.82-12.646 0-17.467m26.202-26.196c-19.295-19.292-50.575-19.292-69.865 0L93.066 145.47c-4.823 4.818-4.823 12.644 0 17.464 4.826 4.826 12.647 4.826 17.467 0l78.597-78.597c9.643-9.648 25.287-9.648 34.931 0 9.646 9.647 9.646 25.285 0 34.932l-77.084 77.086c9.646 9.643 25.28 9.643 34.934 0l59.622-59.62c19.29-19.297 19.29-50.572 0-69.864" fill="#1A1918"/></svg>',
        'faded_color' => '#bcbcbc',
    ],
    'joomla' => [
        'name' => 'Joomla',
        'color' => '#5091cd',
        'svg_logo' => '<svg width="256" height="258" viewBox="0 0 256 258" xmlns="http://www.w3.org/2000/svg" preserveAspectRatio="xMidYMid"><path d="M255.667 35.561c0-18.607-15.084-33.691-33.691-33.691-16.99 0-31.035 12.578-33.349 28.929l-.341-.18c-27.553-12.427-50.762 9.584-50.762 9.584l-61.391 61.692 24.257 23.36 49.413-48.546c23.074-23.075 35.638-7.457 35.638-7.457 17.37 14.674.598 32.044.598 32.044l24.857 23.959c20.298-21.923 21.475-41.056 15.305-56.276 16.612-2.08 29.466-16.243 29.466-33.418" fill="#F9AE41"/><path d="M226.514 190.507c.115-.215.18-.34.18-.34 12.428-27.554-9.584-50.763-9.584-50.763l-61.693-61.393-23.359 24.259 48.546 49.412c23.074 23.075 7.456 35.64 7.456 35.64-14.673 17.37-32.043.598-32.043.598l-23.959 24.856c21.922 20.298 41.056 21.475 56.275 15.305 2.08 16.612 16.244 29.467 33.419 29.467 18.607 0 33.69-15.084 33.69-33.691 0-16.99-12.577-31.035-28.928-33.35" fill="#EE4035"/><path d="m155.942 133.04-49.413 48.545c-23.075 23.076-35.639 7.459-35.639 7.459C53.52 174.369 70.291 157 70.291 157l-24.855-23.96c-20.298 21.922-21.476 41.055-15.307 56.275C13.517 191.396.663 205.558.663 222.734c0 18.607 15.084 33.69 33.692 33.69 16.99.001 31.035-12.576 33.349-28.927.216.115.341.179.341.179 27.554 12.43 50.762-9.584 50.762-9.584l61.392-61.693z" fill="#4F91CD"/><path d="M75.727 106.613c-23.075-23.075-7.459-35.64-7.459-35.64 14.676-17.37 32.045-.598 32.045-.598l23.959-24.855C102.35 25.222 83.217 24.045 67.997 30.214 65.917 13.601 51.755.747 34.577.747 15.973.747.89 15.831.888 34.438c0 16.991 12.577 31.036 28.929 33.35-.115.216-.179.342-.179.342-12.43 27.552 9.583 50.76 9.583 50.76l61.694 61.393 23.359-24.257z" fill="#7AC043"/></svg>',
        'faded_color' => '#cadef0',
    ],
    'tumblr' => [
        'name' => 'Tumblr',
        'color' => '#011835',
        'svg_logo' => '<svg xmlns="http://www.w3.org/2000/svg" width="256" height="256" viewBox="0 0 256 256" xml:space="preserve"><g style="stroke:none;stroke-width:0;stroke-dasharray:none;stroke-linecap:butt;stroke-linejoin:miter;stroke-miterlimit:10;fill:none;fill-rule:nonzero;opacity:1"><path d="M72.028 0H17.972C8.09 0 0 8.09 0 17.972v54.056C0 81.91 8.09 90 17.972 90h54.056C81.91 90 90 81.91 90 72.028V17.972C90 8.09 81.91 0 72.028 0" style="stroke:none;stroke-width:1;stroke-dasharray:none;stroke-linecap:butt;stroke-linejoin:miter;stroke-miterlimit:10;fill:#001935;fill-rule:nonzero;opacity:1" transform="translate(1.407 1.407)scale(2.81)"/><path d="M60.502 73.03h-9.484c-8.54 0-14.905-4.394-14.905-14.905V41.292h-7.76v-9.115c8.54-2.218 12.112-9.567 12.523-15.931h8.868v14.453H60.09v10.593H49.744V55.95c0 4.393 2.218 5.912 5.748 5.912h5.01z" style="stroke:none;stroke-width:1;stroke-dasharray:none;stroke-linecap:butt;stroke-linejoin:miter;stroke-miterlimit:10;fill:#fff;fill-rule:nonzero;opacity:1" transform="translate(1.407 1.407)scale(2.81)"/></g></svg>',
        'faded_color' => '#b2b9c2',
    ],
    'magento' => [
        'name' => 'Magento',
        'color' => '#f46f25',
        'svg_logo' => '<svg width="800" height="800" viewBox="-23.5 0 303 303" xmlns="http://www.w3.org/2000/svg" preserveAspectRatio="xMidYMid"><path d="M144.852 90.67v172.192l-16.933 10.349-16.946-10.404V90.803l-43.878 27.016v147.255l60.824 37.217 61.339-37.482V117.725zM127.919 0 0 77.502v147.274l33.223 19.572V97.06l94.722-57.596 94.81 57.512.391.223-.042 146.929L256 224.776V77.502z" fill="#EC6737"/></svg>',
        'faded_color' => '#fbd3bd',
    ],
    'ghost' => [
        'name' => 'Ghost',
        'color' => '#718087',
        'svg_logo' => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512" xml:space="preserve"><path d="M417.6 454.9c-1.2.6-2.5 1.1-3.8 1.1-1.9 0-3.7-.8-5.3-2.1-.1-.1-.2-.1-.2-.2-.2-.2-.5-.3-.7-.5l-46.5-51.5-46.5 51.5-.3.3c-.1.1-.1.2-.2.3-.4.3-.8.5-1.2.8-.4.2-.7.5-1.1.7-.6.3-1.2.4-1.8.5-.4.1-.8.2-1.2.2h-.2c-.4 0-.7-.2-1.1-.2-.7-.1-1.3-.2-2-.4-.4-.2-.8-.5-1.2-.7-.4-.3-.9-.4-1.3-.8l-.3-.3c-.1-.1-.2-.1-.3-.2L256 401.9l-46.5 51.5-.3.3c-.1.1-.1.2-.2.3-.3.3-.7.4-1.1.6-.5.3-.9.6-1.4.8s-1 .3-1.6.4c-.5.1-1 .2-1.5.2s-1-.1-1.5-.2-1.1-.2-1.6-.4-.9-.5-1.4-.8c-.4-.2-.8-.4-1.1-.6-.1-.1-.1-.2-.2-.3s-.3-.1-.3-.3l-46.5-51.5-46.5 51.5c-.2.2-.4.2-.5.4-.2.2-.4.3-.6.4-1.5 1.2-3.2 1.9-5.1 1.9-1.4 0-2.7-.5-3.9-1.1-2.9-1-5.2-3-5.2-6.3v-234C89 125.9 164.3 56 255.9 56S423 125.9 423 214.7v233.9c0 3.3-2.4 5.4-5.4 6.3m-11.3-240.2c0-79.7-68-142.1-150.4-142.1-82.5 0-150.3 62.4-150.3 142.1v212.1l38.9-43.1c1.6-1.8 3.8-2.7 6.2-2.7s4.6 1 6.2 2.7l46.4 51.5 46.5-51.5c3.2-3.5 9.2-3.5 12.3 0l46.4 51.5 46.5-51.5c3.2-3.5 9.2-3.5 12.3 0l39 43.2zM322.4 256c-13.7 0-24.9-11.2-24.9-25s11.2-25 24.9-25 24.9 11.2 24.9 25-11.2 25-24.9 25m-132.9 0c-13.7 0-24.9-11.2-24.9-25s11.2-25 24.9-25 24.9 11.2 24.9 25-11.2 25-24.9 25" style="fill-rule:evenodd;clip-rule:evenodd;fill:#1b1b1b"/></svg>',
        'faded_color' => '#d4d8db',
    ],
    'webflow' => [
        'name' => 'Webflow',
        'color' => '#4353ff',
        'svg_logo' => '<svg version="1.0" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 841.89 595.28" xml:space="preserve"><path d="M694.27 126.98 521.26 464.59h-163.8l71.59-138.02h-3.3c-60.19 78.14-150.05 129.6-278.06 141.26V328.49s81.87-4.85 130.03-55.45H147.75V126.98h148.67l-2.56 120.17h3.3l59.71-120.17h118.2l-7.67 119.43h3.3l61.9-119.43z" style="fill-rule:evenodd;clip-rule:evenodd;fill:#146ef5"/></svg>',
        'faded_color' => '#c6cbff',
    ],
];
?>

<div class="p-4 mt-10 ">
    <div class="py-6 bg-gray-100 rounded-2x">
        <div class="container">
            <div class="text-center">
                <h2 class="h4 mb-3"><?= l('index.setup.header') ?></h2>
                <p class="text-muted"><i class="fas fa-fw fa-xs fa-code mr-1"></i> <?= l('index.setup.subheader') ?></p>
            </div>

            <div class="mt-5 d-flex justify-content-around flex-wrap">
                <?php foreach($brands as $brand): ?>
                    <div class="index-brand-icon-container mx-4 my-3" style="background: <?= $brand['faded_color'] ?> !important;" data-toggle="tooltip" title="<?= $brand['name'] ?>">
                        <?= $brand['svg_logo'] ?>
                    </div>
                <?php endforeach ?>
            </div>
        </div>
    </div>
</div>

<div class="container mt-10">
    <div class="mb-3 d-flex justify-content-between align-items-center flex-column flex-md-row">
        <div class="mr-3">
            <h2><?= l('index.preview') ?></h2>
        </div>

        <div id="notification_preview" class="container-disabled-simple"></div>
    </div>

    <div id="notifications" class="mt-8 row">
        <?php foreach($data->notifications as $notification_type => $notification_config): ?>
            <?php $notification = \Altum\Notification::get($notification_type, null, null, false) ?>

            <label class="col-12 col-md-6 col-lg-4 p-3 custom-radio-box m-0">
                <input type="radio" name="type" value="<?= $notification_type ?>" class="custom-control-input" required="required">

                <div class="card zoomer h-100" data-aos="fade-up">
                    <div class="card-body">
                        <div class="mb-3 d-flex justify-content-center">
                            <div class="notification-avatar rounded-circle" style="background-color: <?= $data->notifications_config[$notification_type]['notification_background_color'] ?>; color: <?= $data->notifications_config[$notification_type]['notification_color'] ?>">
                                <i class="<?= l('notification.' . mb_strtolower($notification_type) . '.icon') ?>"></i>
                            </div>
                        </div>

                        <div class="card-title font-weight-bold text-center"><?= l('notification.' . mb_strtolower($notification_type) . '.name') ?></div>

                        <p class="small text-muted text-center mb-0"><?= l('notification.' . mb_strtolower($notification_type) . '.description') ?></p>
                    </div>
                </div>

                <div class="preview" style="display: none">
                    <?= preg_replace(['/<form/', '/<\/form>/', '/required=\"required\"/'], ['<div', '</div>', ''], $notification->html) ?>
                </div>
            </label>
        <?php endforeach ?>
    </div>
</div>

<?php ob_start() ?>
<script>
    $('#notifications .altumcode-hidden').removeClass('altumcode-hidden').addClass('altumcode-shown');
</script>
<?php \Altum\Event::add_content(ob_get_clean(), 'javascript') ?>


<div class="container mt-10">
    <div class="card py-4 border-0 rounded-2x">
        <div class="card-body">
            <div class="text-center mb-4">
                <h2><?= l('index.notifications_handlers.header') ?> <i class="fas fa-fw fa-xs fa-bell ml-1"></i> </h2>
                <p class="text-muted"><?= l('index.notifications_handlers.subheader') ?></p>
            </div>

            <div class="row mx-n4">
                <?php $notification_handlers = require APP_PATH . 'includes/notification_handlers.php' ?>
                <?php $i = 0; ?>
                <?php foreach($notification_handlers as $key => $notification_handler): ?>
                    <div class="col-6 col-lg-4 p-4" data-aos="fade-up" data-aos-delay="<?= $i * 100 ?>">
                        <div class="bg-gray-100 rounded-2x w-100 p-4 icon-zoom-animation text-truncate text-center">
                            <div><i class="<?= $notification_handler['icon'] ?> fa-fw fa-xl mx-1" style="color: <?= $notification_handler['color'] ?>"></i></div>

                            <div class="mt-3 mb-0 h6 text-truncate"><?= l('notification_handlers.type_' . $key) ?></div>
                        </div>
                    </div>
                    <?php $i++ ?>
                <?php endforeach ?>
            </div>
        </div>
    </div>
</div>

<?php if(settings()->main->api_is_enabled): ?>
    <div class="py-6"></div>

    <div class="container">
        <div class="row align-items-center justify-content-between" data-aos="fade-up">
            <div class="col-12 col-lg-6 mb-5 mb-lg-0 d-flex flex-column justify-content-center">
                <div class="text-uppercase font-weight-bold text-primary mb-3"><?= l('index.api.name') ?></div>

                <div>
                    <h2 class="mb-2"><?= l('index.api.header') ?></h2>
                    <p class="text-muted mb-4"><?= l('index.api.subheader') ?></p>

                    <div class="position-relative">
                        <div class="index-fade"></div>
                        <div class="row">
                            <div class="col">
                                <div class="small mb-2"><i class="fas fa-fw fa-check-circle text-success mr-1"></i> <?= l('campaigns.title') ?></div>
                                <div class="small mb-2"><i class="fas fa-fw fa-check-circle text-success mr-1"></i> <?= l('notifications.title') ?></div>
                            </div>

                            <div class="col">
                                <div class="small mb-2"><i class="fas fa-fw fa-check-circle text-success mr-1"></i> <?= l('notification_handlers.title') ?></div>
                                <?php if(settings()->notifications->domains_is_enabled): ?>
                                    <div class="small mb-2"><i class="fas fa-fw fa-check-circle text-success mr-1"></i> <?= l('domains.title') ?></div>
                                <?php endif ?>
                            </div>
                        </div>
                    </div>

                    <a href="<?= url('api-documentation') ?>" class="btn btn-block btn-outline-primary mt-5">
                        <?= l('api_documentation.menu') ?> <i class="fas fa-fw fa-xs fa-code ml-1"></i>
                    </a>
                </div>
            </div>

            <div class="col-12 col-lg-6">
                <div class="card bg-dark text-white">
                    <div class="card-body p-4 text-monospace font-size-small" style="line-height: 1.75">
                        curl --request POST \<br />
                        --url '<?= SITE_URL ?>api/campaigns' \<br />
                        --header 'Authorization: Bearer <span class="text-primary" <?= is_logged_in() ? 'data-toggle="tooltip" title="' . l('api_documentation.api_key') . '"' : null ?>><?= is_logged_in() ? $this->user->api_key : '{api_key}' ?></span>' \<br />
                        --header 'Content-Type: multipart/form-data' \<br />
                        --form 'name=<span class="text-primary">Example</span>' \<br />
                        --form 'domain=<span class="text-primary">example.com</span>' \<br />
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php endif ?>

<?php if(settings()->main->display_index_testimonials): ?>
    <div class="p-4 mt-9">
        <div class="py-7 bg-primary-100 rounded-2x">
            <div class="container">
                <div class="text-center">
                    <h2><?= l('index.testimonials.header') ?> <i class="fas fa-fw fa-xs fa-check-circle text-primary"></i></h2>
                </div>

                <?php
                $language_array = \Altum\Language::get(\Altum\Language::$name);
                if(\Altum\Language::$main_name != \Altum\Language::$name) {
                    $language_array = array_merge(\Altum\Language::get(\Altum\Language::$main_name), $language_array);
                }

                $testimonials_language_keys = [];
                foreach ($language_array as $key => $value) {
                    if(preg_match('/index\.testimonials\.(\w+)\./', $key, $matches)) {
                        $testimonials_language_keys[] = $matches[1];
                    }
                }

                $testimonials_language_keys = array_unique($testimonials_language_keys);
                ?>

                <div class="row mt-8">
                    <?php foreach($testimonials_language_keys as $key => $value): ?>
                        <div class="col-12 col-lg-4 mb-6 mb-lg-0" data-aos="fade-up" data-aos-delay="<?= $key * 100 ?>">
                            <div class="card border-0 zoom-animation-subtle">
                                <div class="card-body">
                                    <img src="<?= get_custom_image_if_any('index/testimonial-' . $value . '.webp') ?>" class="img-fluid index-testimonial-avatar" alt="<?= l('index.testimonials.' . $value . '.name') . ', ' . l('index.testimonials.' . $value . '.attribute') ?>" loading="lazy" />

                                    <p class="mt-5">
                                        <span class="text-gray-800 font-weight-bold text-muted h5">“</span>
                                        <span><?= l('index.testimonials.' . $value . '.text') ?></span>
                                        <span class="text-gray-800 font-weight-bold text-muted h5">”</span>
                                    </p>

                                    <div class="blockquote-footer mt-4">
                                        <span class="font-weight-bold"><?= l('index.testimonials.' . $value . '.name') ?></span>, <span class="text-muted"><?= l('index.testimonials.' . $value . '.attribute') ?></span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endforeach ?>
                </div>
            </div>
        </div>
    </div>
<?php endif ?>

<?php if(settings()->main->display_index_plans): ?>
    <div id="plans" class="container mt-10">
        <div class="text-center mb-5">
            <h2><?= l('index.pricing.header') ?></h2>
            <p class="text-muted"><?= l('index.pricing.subheader') ?></p>
        </div>

        <?= $this->views['plans'] ?>
    </div>
<?php endif ?>

<?php if(settings()->main->display_index_faq): ?>
    <div class="container mt-9">
        <div class="text-center mb-5">
            <h2><?= sprintf(l('index.faq.header'), '<span class="text-primary">', '</span>') ?></h2>
        </div>

        <?php
        $language_array = \Altum\Language::get(\Altum\Language::$name);
        if(\Altum\Language::$main_name != \Altum\Language::$name) {
            $language_array = array_merge(\Altum\Language::get(\Altum\Language::$main_name), $language_array);
        }

        $faq_language_keys = [];
        foreach ($language_array as $key => $value) {
            if(preg_match('/index\.faq\.(\w+)\./', $key, $matches)) {
                $faq_language_keys[] = $matches[1];
            }
        }

        $faq_language_keys = array_unique($faq_language_keys);
        ?>

        <div class="accordion index-faq" id="faq_accordion">
            <?php foreach($faq_language_keys as $key): ?>
                <div class="card">
                    <div class="card-body">
                        <div class="" id="<?= 'faq_accordion_' . $key ?>">
                            <h3 class="mb-0">
                                <button class="btn btn-lg font-weight-bold btn-block d-flex justify-content-between text-gray-800 px-0 icon-zoom-animation" type="button" data-toggle="collapse" data-target="<?= '#faq_accordion_answer_' . $key ?>" aria-expanded="true" aria-controls="<?= 'faq_accordion_answer_' . $key ?>">
                                    <span><?= l('index.faq.' . $key . '.question') ?></span>

                                    <span data-icon>
                                        <i class="fas fa-fw fa-circle-chevron-down"></i>
                                    </span>
                                </button>
                            </h3>
                        </div>

                        <div id="<?= 'faq_accordion_answer_' . $key ?>" class="collapse text-muted mt-2" aria-labelledby="<?= 'faq_accordion_' . $key ?>" data-parent="#faq_accordion">
                            <?= l('index.faq.' . $key . '.answer') ?>
                        </div>
                    </div>
                </div>
            <?php endforeach ?>
        </div>
    </div>

    <?php ob_start() ?>
    <script>
        'use strict';

        $('#faq_accordion').on('show.bs.collapse', event => {
            let svg = event.target.parentElement.querySelector('[data-icon] svg')
            svg.style.transform = 'rotate(180deg)';
            svg.style.color = 'var(--primary)';
        })

        $('#faq_accordion').on('hide.bs.collapse', event => {
            let svg = event.target.parentElement.querySelector('[data-icon] svg')
            svg.style.color = 'var(--primary-800)';
            svg.style.removeProperty('transform');
        })
    </script>
    <?php \Altum\Event::add_content(ob_get_clean(), 'javascript') ?>
<?php endif ?>

<?php if(settings()->users->register_is_enabled): ?>
    <div class="p-4 mt-9">
        <div class="index-register-container rounded-2x">
            <div class="container">
                <div class="py-4">
                    <div class="row align-items-center justify-content-center" data-aos="fade-up">
                        <div class="col-12 col-lg-5">
                            <div class="text-center text-lg-left mb-4 mb-lg-0">
                                <h2><?= l('index.cta.header') ?></h2>
                                <p class="h6"><?= l('index.cta.subheader') ?></p>
                            </div>
                        </div>

                        <div class="col-12 col-lg-5 mt-4 mt-lg-0">
                            <div class="text-center text-lg-right">
                                <?php if(is_logged_in()): ?>
                                    <a href="<?= url('dashboard') ?>" class="btn btn-outline-light index-button">
                                        <?= l('dashboard.menu') ?> <i class="fas fa-fw fa-arrow-right"></i>
                                    </a>
                                <?php else: ?>
                                    <a href="<?= url('register') ?>" class="btn btn-outline-light index-button">
                                        <?= l('index.cta.register') ?> <i class="fas fa-fw fa-arrow-right"></i>
                                    </a>
                                <?php endif ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php endif ?>

<?php if(count($data->blog_posts)): ?>
    <div class="my-5">&nbsp;</div>

    <div class="container">
        <div class="text-center mb-5">
            <h2><?= sprintf(l('index.blog.header'), '<span class="text-primary">', '</span>') ?></h2>
        </div>

        <div class="row">
            <?php foreach($data->blog_posts as $blog_post): ?>
                <div class="col-12 col-lg-4 p-4">
                    <div class="card h-100 zoom-animation-subtle">
                        <div class="card-body">
                            <?php if($blog_post->image): ?>
                                <a href="<?= SITE_URL . ($blog_post->language ? \Altum\Language::$active_languages[$blog_post->language] . '/' : null) . 'blog/' . $blog_post->url ?>" aria-label="<?= $blog_post->title ?>">
                                    <img src="<?= \Altum\Uploads::get_full_url('blog') . $blog_post->image ?>" class="blog-post-image-small img-fluid w-100 rounded mb-4" alt="<?= $blog_post->image_description ?>" loading="lazy" />
                                </a>
                            <?php endif ?>

                            <a href="<?= SITE_URL . ($blog_post->language ? \Altum\Language::$active_languages[$blog_post->language] . '/' : null) . 'blog/' . $blog_post->url ?>">
                                <h3 class="h5 card-title mb-2"><?= $blog_post->title ?></h3>
                            </a>

                            <p class="text-muted mb-0"><?= $blog_post->description ?></p>
                        </div>
                    </div>
                </div>
            <?php endforeach ?>
        </div>
    </div>
<?php endif ?>


<?php ob_start() ?>
<link rel="stylesheet" href="<?= ASSETS_FULL_URL . 'css/libraries/aos.min.css?v=' . PRODUCT_CODE ?>">
<?php \Altum\Event::add_content(ob_get_clean(), 'head') ?>

<?php ob_start() ?>
<link href="<?= ASSETS_FULL_URL . 'css/pixel.min.css?v=' . PRODUCT_CODE ?>" rel="stylesheet" media="screen,print">
<?php \Altum\Event::add_content(ob_get_clean(), 'head') ?>


<?php ob_start() ?>
<script src="<?= ASSETS_FULL_URL . 'js/libraries/aos.min.js?v=' . PRODUCT_CODE ?>"></script>

<script>
    AOS.init({
        delay: 100,
        duration: 600
    });

    /* Preview handler */
    $('input[name="type"]').on('change', (event, first_trigger = false) => {

        let preview_html = $(event.currentTarget).closest('label').find('.preview').html();

        $('#notification_preview').hide().html(preview_html).fadeIn();

        /* Make sure its not the first check */
        if(!first_trigger) {
            document.querySelector('#notification_preview').scrollIntoView();
        }

    });

    /* Select a default option */
    $('input[name="type"]:first').attr('checked', true).trigger('change', true);
</script>
<?php \Altum\Event::add_content(ob_get_clean(), 'javascript') ?>

<?php ob_start() ?>
<script type="application/ld+json">
    {
        "@context": "https://schema.org",
        "@type": "Organization",
        "name": "<?= settings()->main->title ?>",
        "url": "<?= url() ?>",
    <?php if(settings()->main->{'logo_' . \Altum\ThemeStyle::get()}): ?>
        "logo": "<?= settings()->main->{'logo_' . \Altum\ThemeStyle::get() . '_full_url'} ?>",
        <?php endif ?>
    "slogan": "<?= l('index.header') ?>",
        "contactPoint": {
            "@type": "ContactPoint",
            "url": "<?= url('contact') ?>",
            "contactType": "Contact us"
        }
    }
</script>

<script type="application/ld+json">
    {
        "@context": "https://schema.org",
        "@type": "BreadcrumbList",
        "itemListElement": [
            {
                "@type": "ListItem",
                "position": 1,
                "name": "<?= l('index.title') ?>",
                    "item": "<?= url() ?>"
                }
            ]
        }
</script>

<?php if(settings()->main->display_index_faq): ?>
    <?php
    $faqs = [];
    foreach($faq_language_keys as $key) {
        $faqs[] = [
            '@type' => 'Question',
            'name' => l('index.faq.' . $key . '.question'),
            'acceptedAnswer' => [
                '@type' => 'Answer',
                'text' => l('index.faq.' . $key . '.answer'),
            ]
        ];
    }
    ?>
    <script type="application/ld+json">
        {
            "@context": "https://schema.org",
            "@type": "FAQPage",
            "mainEntity": <?= json_encode($faqs) ?>
        }
    </script>
<?php endif ?>
<?php \Altum\Event::add_content(ob_get_clean(), 'javascript') ?>
