<?php defined('ALTUMCODE') || die() ?>

<?php if(settings()->payment->is_enabled): ?>

    <?php
    $plans = [];
    $available_payment_frequencies = [];

    $plans = (new \Altum\Models\Plan())->get_plans();

    foreach($plans as $plan) {
        if($plan->status != 1) continue;

        foreach(['monthly', 'quarterly', 'biannual', 'annual', 'lifetime'] as $value) {
            if($plan->prices->{$value}->{currency()}) {
                $available_payment_frequencies[$value] = true;
            }
        }
    }
    ?>

    <?php if(count($plans)): ?>
        <?php if(\Altum\Router::$controller_settings['currency_switcher'] && count((array) settings()->payment->currencies ?? []) > 1): ?>
            <div class="mb-3 text-center">
                <div class="dropdown mb-2 ml-lg-3">
                    <span class="font-weight-bold small mr-3"><?= l('global.choose_currency') ?></span>

                    <button type="button" class="btn btn-sm rounded-2x btn-light py-2 px-3" id="currency_switch" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                        <i class="fas fa-fw fa-sm fa-coins mr-1"></i> <?= currency() ?>
                    </button>

                    <div class="dropdown-menu dropdown-menu-right" aria-labelledby="currency_switch">
                        <?php foreach((array) settings()->payment->currencies as $currency => $currency_data): ?>
                            <a href="#" class="dropdown-item" data-set-currency="<?= $currency ?>">
                                <?php if($currency == currency()): ?>
                                    <i class="fas fa-fw fa-sm fa-check mr-2 text-success"></i>
                                <?php else: ?>
                                    <span class="fas fa-fw text-muted mr-2"><?= $currency_data->symbol ?: '&nbsp;' ?></span>
                                <?php endif ?>

                                <?= $currency ?>
                            </a>
                        <?php endforeach ?>
                    </div>
                </div>
            </div>
        <?php endif ?>

        <div class="mb-4 d-flex justify-content-center">
            <div class="btn-group btn-group-toggle btn-group-custom" data-toggle="buttons">

                <?php foreach(['monthly', 'quarterly', 'biannual', 'annual', 'lifetime'] as $frequency): ?>
                    <?php if(isset($available_payment_frequencies[$frequency])): ?>
                        <label class="btn <?= settings()->payment->default_payment_frequency == $frequency ? 'active' : null ?>" data-payment-frequency="<?= $frequency ?>">
                            <input type="radio" name="payment_frequency" <?= settings()->payment->default_payment_frequency == $frequency ? 'checked="checked"' : null ?>> <?= l('plan.custom_plan.' . $frequency) ?>
                        </label>
                    <?php endif ?>
                <?php endforeach ?>

            </div>
        </div>
    <?php endif ?>
<?php endif ?>


<div class="pricing pricing-palden">

    <?php if(settings()->plan_free->status == 1): ?>

        <div class="pricing-item zoomer">
            <div class="pricing-deco" style="<?= settings()->plan_free->color ? 'background-color: ' . settings()->plan_free->color : null ?>">
                <div class="d-flex align-items-center justify-content-center mb-5">
                    <h3 class="pricing-title"><?= settings()->plan_free->translations->{\Altum\Language::$name}->name ?: settings()->plan_free->name ?></h3>
                </div>

                <svg class="pricing-deco-img" enable-background="new 0 0 300 100" height="100px" id="Layer_1" preserveAspectRatio="none" version="1.1" viewBox="0 0 300 100" width="300px" x="0px" xml:space="preserve" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns="http://www.w3.org/2000/svg" y="0px">
                    <path class="deco-layer deco-layer--1" d="M30.913,43.944c0,0,42.911-34.464,87.51-14.191c77.31,35.14,113.304-1.952,146.638-4.729&#x000A;	c48.654-4.056,69.94,16.218,69.94,16.218v54.396H30.913V43.944z" opacity="0.6"></path>
                    <path class="deco-layer deco-layer--2" d="M-35.667,44.628c0,0,42.91-34.463,87.51-14.191c77.31,35.141,113.304-1.952,146.639-4.729&#x000A;	c48.653-4.055,69.939,16.218,69.939,16.218v54.396H-35.667V44.628z" opacity="0.6"></path>
                    <path class="deco-layer deco-layer--3" d="M43.415,98.342c0,0,48.283-68.927,109.133-68.927c65.886,0,97.983,67.914,97.983,67.914v3.716&#x000A;	H42.401L43.415,98.342z" opacity="0.7"></path>
                    <path class="deco-layer deco-layer--4" d="M-34.667,62.998c0,0,56-45.667,120.316-27.839C167.484,57.842,197,41.332,232.286,30.428&#x000A;	c53.07-16.399,104.047,36.903,104.047,36.903l1.333,36.667l-372-2.954L-34.667,62.998z"></path>
                </svg>

                <div class="pricing-price">
                    <?= settings()->plan_free->translations->{\Altum\Language::$name}->price ?: settings()->plan_free->price ?>
                </div>

                <div class="pricing-sub"><?= settings()->plan_free->translations->{\Altum\Language::$name}->description ?: settings()->plan_free->description ?></div>
            </div>

            <?= include_view(THEME_PATH . 'views/partials/plans_plan_content.php', ['plan_settings' => settings()->plan_free->settings]) ?>

            <?php if(settings()->users->register_is_enabled || is_logged_in()): ?>
            <div class="mt-5 mb-4 px-4">
                <a href="<?= url('register') ?>" class="btn btn-block btn-lg btn-primary <?= is_logged_in() && $this->user->plan_id != 'free' ? 'disabled' : null ?>" style="<?= settings()->plan_free->color ? 'background-color: ' . settings()->plan_free->color : null ?>"><?= l('plans.choose') ?></a>
            </div>
            <?php endif ?>
        </div>

    <?php endif ?>

    <?php if(settings()->payment->is_enabled): ?>
        <?php foreach($plans as $plan): ?>
        <?php if($plan->status != 1) continue; ?>

        <?php $annual_price_savings = ceil(($plan->prices->monthly->{currency()} * 12) - $plan->prices->annual->{currency()}); ?>

        <div
                class="pricing-item zoomer"
                data-plan-monthly="<?= json_encode((bool) $plan->prices->monthly->{currency()}) ?>"
                data-plan-quarterly="<?= json_encode((bool) $plan->prices->quarterly->{currency()}) ?>"
                data-plan-biannual="<?= json_encode((bool) $plan->prices->biannual->{currency()}) ?>"
                data-plan-annual="<?= json_encode((bool) $plan->prices->annual->{currency()}) ?>"
                data-plan-lifetime="<?= json_encode((bool) $plan->prices->lifetime->{currency()}) ?>"
        >
            <div class="pricing-deco" style="<?= $plan->color ? 'background-color: ' . $plan->color : null ?>">
                <div class="d-flex align-items-center justify-content-center mb-5">
                    <h3 class="pricing-title"><?= $plan->translations->{\Altum\Language::$name}->name ?: $plan->name ?></h3>

                    <?php if($plan->prices->monthly->{currency()} && $annual_price_savings > 0): ?>
                        <span class="badge badge-success mx-1 d-none" data-plan-payment-frequency="annual" data-toggle="tooltip" title="<?= sprintf(l('global.plan_settings.annual_price_savings'), $annual_price_savings . ' ' . currency()) ?>">
                            <i class="fas fa-fw fa-sm fa-percentage"></i>
                        </span>
                    <?php endif ?>
                </div>

                <svg class="pricing-deco-img" enable-background="new 0 0 300 100" height="100px" id="Layer_1" preserveAspectRatio="none" version="1.1" viewBox="0 0 300 100" width="300px" x="0px" xml:space="preserve" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns="http://www.w3.org/2000/svg" y="0px">
                    <path class="deco-layer deco-layer--1" d="M30.913,43.944c0,0,42.911-34.464,87.51-14.191c77.31,35.14,113.304-1.952,146.638-4.729&#x000A;	c48.654-4.056,69.94,16.218,69.94,16.218v54.396H30.913V43.944z" opacity="0.6"></path>
                    <path class="deco-layer deco-layer--2" d="M-35.667,44.628c0,0,42.91-34.463,87.51-14.191c77.31,35.141,113.304-1.952,146.639-4.729&#x000A;	c48.653-4.055,69.939,16.218,69.939,16.218v54.396H-35.667V44.628z" opacity="0.6"></path>
                    <path class="deco-layer deco-layer--3" d="M43.415,98.342c0,0,48.283-68.927,109.133-68.927c65.886,0,97.983,67.914,97.983,67.914v3.716&#x000A;	H42.401L43.415,98.342z" opacity="0.7"></path>
                    <path class="deco-layer deco-layer--4" d="M-34.667,62.998c0,0,56-45.667,120.316-27.839C167.484,57.842,197,41.332,232.286,30.428&#x000A;	c53.07-16.399,104.047,36.903,104.047,36.903l1.333,36.667l-372-2.954L-34.667,62.998z"></path>
                </svg>

                <div class="pricing-price">
                    <span class="d-none" data-plan-payment-frequency="monthly"><?= nr($plan->prices->monthly->{currency()}, 2, false) ?></span>
                    <span class="d-none" data-plan-payment-frequency="quarterly"><?= nr($plan->prices->quarterly->{currency()}, 2, false) ?></span>
                    <span class="d-none" data-plan-payment-frequency="biannual"><?= nr($plan->prices->biannual->{currency()}, 2, false) ?></span>
                    <span class="d-none" data-plan-payment-frequency="annual"><?= nr($plan->prices->annual->{currency()}, 2, false) ?></span>
                    <span class="d-none" data-plan-payment-frequency="lifetime"><?= nr($plan->prices->lifetime->{currency()}, 2, false) ?></span>
                    <span class="pricing-currency"><?= currency() ?></span>
                </div>

                <div class="pricing-sub">
                    <?= $plan->translations->{\Altum\Language::$name}->description ?: $plan->description ?>
                </div>
            </div>

            <?= include_view(THEME_PATH . 'views/partials/plans_plan_content.php', ['plan_settings' => $plan->settings]) ?>

            <?php if(settings()->users->register_is_enabled || is_logged_in()): ?>
            <div class="mt-5 mb-4 px-4">
                <a href="<?= url('register?redirect=pay/' . $plan->plan_id) ?>" class="btn btn-block btn-lg btn-primary <?= is_logged_in() && $this->user->plan_id == $plan->plan_id && (new \DateTime($this->user->plan_expiration_date)) > (new \DateTime())->modify('+10 years') ? 'disabled' : null ?>" style="<?= $plan->color ? 'background-color: ' . $plan->color : null ?>">
                    <?php if(is_logged_in()): ?>
                        <?php if($this->user->plan_id == $plan->plan_id && (new \DateTime($this->user->plan_expiration_date)) > (new \DateTime())->modify('+10 years')): ?>
                            <?= l('plans.lifetime') ?>
                        <?php elseif(!$this->user->plan_trial_done && $plan->trial_days): ?>
                            <?= sprintf(l('plans.trial'), $plan->trial_days) ?>
                        <?php elseif($this->user->plan_id == $plan->plan_id): ?>
                            <?= l('plans.renew') ?>
                        <?php else: ?>
                            <?= l('plans.choose') ?>
                        <?php endif ?>
                    <?php else: ?>
                        <?php if($plan->trial_days): ?>
                            <?= sprintf(l('plans.trial'), $plan->trial_days) ?>
                        <?php else: ?>
                            <?= l('plans.choose') ?>
                        <?php endif ?>
                    <?php endif ?>
                </a>
            </div>
            <?php endif ?>
        </div>
    <?php endforeach ?>

    <?php ob_start() ?>
        <script>
            'use strict';

            let payment_frequency_handler = (event = null) => {

                let payment_frequency = null;

                if(event) {
                    payment_frequency = $(event.currentTarget).data('payment-frequency');
                } else {
                    payment_frequency = $('[name="payment_frequency"]:checked').closest('label').data('payment-frequency');
                }

                const frequencies = ['monthly', 'quarterly', 'biannual', 'annual', 'lifetime'];

                frequencies.forEach(freq => {
                    const $el = $(`[data-plan-payment-frequency="${freq}"]`);
                    if(freq === payment_frequency) {
                        $el.removeClass('d-none').addClass('d-inline-block');
                    } else {
                        $el.removeClass('d-inline-block').addClass('d-none');
                    }
                });

                $(`[data-plan-payment-frequency="${payment_frequency}"]`).addClass('d-inline-block');

                $(`[data-plan-${payment_frequency}="true"]`).removeClass('d-none').addClass('');
                $(`[data-plan-${payment_frequency}="false"]`).addClass('d-none').removeClass('');

            };

            $('[data-payment-frequency]').on('click', payment_frequency_handler);

            payment_frequency_handler();
        </script>
    <?php \Altum\Event::add_content(ob_get_clean(), 'javascript') ?>

    <?php if(settings()->plan_custom->status == 1): ?>

        <div class="pricing-item zoomer">
            <div class="pricing-deco" style="<?= settings()->plan_custom->color ? 'background-color: ' . settings()->plan_custom->color : null ?>">
                <div class="d-flex align-items-center justify-content-center mb-5">
                    <h3 class="pricing-title"><?= settings()->plan_custom->translations->{\Altum\Language::$name}->name ?: settings()->plan_custom->name ?></h3>
                </div>

                <svg class="pricing-deco-img" enable-background="new 0 0 300 100" height="100px" id="Layer_1" preserveAspectRatio="none" version="1.1" viewBox="0 0 300 100" width="300px" x="0px" xml:space="preserve" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns="http://www.w3.org/2000/svg" y="0px">
                    <path class="deco-layer deco-layer--1" d="M30.913,43.944c0,0,42.911-34.464,87.51-14.191c77.31,35.14,113.304-1.952,146.638-4.729&#x000A;	c48.654-4.056,69.94,16.218,69.94,16.218v54.396H30.913V43.944z" opacity="0.6"></path>
                    <path class="deco-layer deco-layer--2" d="M-35.667,44.628c0,0,42.91-34.463,87.51-14.191c77.31,35.141,113.304-1.952,146.639-4.729&#x000A;	c48.653-4.055,69.939,16.218,69.939,16.218v54.396H-35.667V44.628z" opacity="0.6"></path>
                    <path class="deco-layer deco-layer--3" d="M43.415,98.342c0,0,48.283-68.927,109.133-68.927c65.886,0,97.983,67.914,97.983,67.914v3.716&#x000A;	H42.401L43.415,98.342z" opacity="0.7"></path>
                    <path class="deco-layer deco-layer--4" d="M-34.667,62.998c0,0,56-45.667,120.316-27.839C167.484,57.842,197,41.332,232.286,30.428&#x000A;	c53.07-16.399,104.047,36.903,104.047,36.903l1.333,36.667l-372-2.954L-34.667,62.998z"></path>
                </svg>

                <div class="pricing-price">
                    <?= settings()->plan_custom->translations->{\Altum\Language::$name}->price ?: settings()->plan_custom->price ?>
                </div>

                <div class="pricing-sub"><?= settings()->plan_custom->translations->{\Altum\Language::$name}->description ?: settings()->plan_custom->description ?></div>
            </div>

            <?= include_view(THEME_PATH . 'views/partials/plans_plan_content.php', ['plan_settings' => settings()->plan_custom->settings]) ?>

            <?php if(settings()->users->register_is_enabled || is_logged_in()): ?>
            <div class="mt-5 mb-4 px-4">
                <a href="<?= settings()->plan_custom->custom_button_url ?>" class="btn btn-block btn-lg btn-primary" style="<?= settings()->plan_custom->color ? 'background-color: ' . settings()->plan_custom->color : null ?>"><?= l('plans.contact') ?></a>
            </div>
            <?php endif ?>
        </div>

    <?php endif ?>

    <?php endif ?>
</div>

<?php ob_start() ?>
<?php
/* Generate schema offers dynamically */
$offers = [];

if(settings()->plan_guest->status ?? null) {
    $offers[] = [
        '@type' => 'Offer',
        'name' => settings()->plan_guest->translations->{\Altum\Language::$name}->name ?: settings()->plan_guest->name,
        'availability' => 'https://schema.org/InStock',
        'url' => url('plan')
    ];
}

if(settings()->plan_free->status) {
    $offers[] = [
        '@type' => 'Offer',
        'name' => settings()->plan_free->translations->{\Altum\Language::$name}->name ?: settings()->plan_free->name,
        'availability' => 'https://schema.org/InStock',
        'url' => url('plan')
    ];
}

if(settings()->plan_custom->status) {
    $offers[] = [
        '@type' => 'Offer',
        'name' => settings()->plan_custom->translations->{\Altum\Language::$name}->name ?: settings()->plan_custom->name,
        'availability' => 'https://schema.org/InStock',
        'url' => url('plan')
    ];
}

if(settings()->payment->is_enabled) {
    foreach($plans as $plan) {
        if($plan->status != 1) continue;

        foreach(['monthly', 'quarterly', 'biannual', 'annual', 'lifetime'] as $value) {
            if($plan->prices->{$value}->{currency()}) {
                $offers[] = [
                    '@type' => 'Offer',
                    'name' => $plan->translations->{\Altum\Language::$name}->name ?: $plan->name . ' - ' . l('plan.custom_plan.' . $value),
                    'price' => nr($plan->prices->{$value}->{currency()}, 2, false),
                    'priceCurrency' => currency(),
                    'availability' => 'https://schema.org/InStock',
                    'url' => url('pay/' . $plan->plan_id)
                ];
            }
        }
    }
}

?>
    <script type="application/ld+json">
        {
            "@context": "https://schema.org",
            "@type": "SoftwareApplication",
            "name": "<?= settings()->main->title ?>",
        "description": "<?= l('index.header') ?>",
        "applicationCategory": "WebApplication",
        "operatingSystem": "All",
        "url": "<?= url() ?>",
        <?php if(settings()->main->{'logo_' . \Altum\ThemeStyle::get()}): ?>
        "image": "<?= settings()->main->{'logo_' . \Altum\ThemeStyle::get() . '_full_url'} ?>",
        <?php endif ?>
        "offers": <?= json_encode($offers) ?>
        }
    </script>

<?php \Altum\Event::add_content(ob_get_clean(), 'javascript') ?>
