CREATE TABLE `users` (
`user_id` bigint unsigned NOT NULL AUTO_INCREMENT,
`email` varchar(320) NOT NULL,
`password` varchar(128) DEFAULT NULL,
`name` varchar(64) NOT NULL,
`billing` text,
`api_key` varchar(32) DEFAULT NULL,
`token_code` varchar(32) DEFAULT NULL,
`twofa_secret` varchar(16) DEFAULT NULL,
`anti_phishing_code` varchar(8) DEFAULT NULL,
`one_time_login_code` varchar(32) DEFAULT NULL,
`pending_email` varchar(128) DEFAULT NULL,
`email_activation_code` varchar(32) DEFAULT NULL,
`lost_password_code` varchar(32) DEFAULT NULL,
`type` tinyint NOT NULL DEFAULT '0',
`status` tinyint NOT NULL DEFAULT '0',
`is_newsletter_subscribed` tinyint NOT NULL DEFAULT '0',
`has_pending_internal_notifications` tinyint NOT NULL DEFAULT '0',
`plan_id` varchar(16) NOT NULL DEFAULT '',
`plan_expiration_date` datetime DEFAULT NULL,
`plan_settings` longtext,
`plan_trial_done` tinyint DEFAULT '0',
`plan_expiry_reminder` tinyint DEFAULT '0',
`payment_subscription_id` varchar(64) DEFAULT NULL,
`payment_processor` varchar(16) DEFAULT NULL,
`payment_total_amount` float DEFAULT NULL,
`payment_currency` varchar(4) DEFAULT NULL,
`referral_key` varchar(32) DEFAULT NULL,
`referred_by` varchar(32) DEFAULT NULL,
`referred_by_has_converted` tinyint DEFAULT '0',
`language` varchar(32) DEFAULT 'english',
`currency` varchar(4) DEFAULT NULL,
`timezone` varchar(32) DEFAULT 'UTC',
`preferences` text,
`extra` text,
`datetime` datetime DEFAULT NULL,
`next_cleanup_datetime` datetime DEFAULT CURRENT_TIMESTAMP,
`ip` varchar(64) DEFAULT NULL,
`continent_code` varchar(8) DEFAULT NULL,
`country` varchar(8) DEFAULT NULL,
`city_name` varchar(32) DEFAULT NULL,
`device_type` varchar(16) DEFAULT NULL,
`browser_language` varchar(32) DEFAULT NULL,
`browser_name` varchar(32) DEFAULT NULL,
`os_name` varchar(16) DEFAULT NULL,
`last_activity` datetime DEFAULT NULL,
`total_logins` int DEFAULT '0',
`user_deletion_reminder` tinyint(4) DEFAULT '0',
`source` varchar(32) DEFAULT 'direct',
PRIMARY KEY (`user_id`),
KEY `plan_id` (`plan_id`),
KEY `api_key` (`api_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- SEPARATOR --

INSERT INTO `users` (`user_id`, `email`, `password`, `api_key`, `referral_key`, `name`, `type`, `status`, `plan_id`, `plan_expiration_date`, `plan_settings`, `datetime`, `ip`, `last_activity`, `preferences`)
VALUES (1,'admin','$2y$10$uFNO0pQKEHSFcus1zSFlveiPCB3EvG9ZlES7XKgJFTAl5JbRGFCWy', md5(rand()), md5(rand()), 'AltumCode',1,1,'custom','2030-01-01 12:00:00', '{"signatures_limit":0,"projects_limit":-1,"teams_limit":0,"team_members_limit":0,"api_is_enabled":true,"affiliate_commission_percentage":10,"no_ads":true,"white_labeling_is_enabled":true,"export":{"pdf":true,"csv":true,"json":true},"enabled_tools":{"dns_lookup":true,"ip_lookup":true,"reverse_ip_lookup":true,"ssl_lookup":true,"whois_lookup":true,"ping":true,"http_headers_lookup":true,"http2_checker":true,"brotli_checker":true,"safe_url_checker":true,"google_cache_checker":true,"url_redirect_checker":true,"password_strength_checker":true,"meta_tags_checker":true,"website_hosting_checker":true,"file_mime_type_checker":true,"gravatar_checker":true,"text_separator":true,"email_extractor":true,"url_extractor":true,"text_size_calculator":true,"duplicate_lines_remover":true,"text_to_speech":true,"idn_punnycode_converter":true,"case_converter":true,"character_counter":true,"list_randomizer":true,"reverse_words":true,"reverse_letters":true,"emojis_remover":true,"reverse_list":true,"list_alphabetizer":true,"upside_down_text_generator":true,"old_english_text_generator":true,"cursive_text_generator":true,"palindrome_checker":true,"base64_encoder":true,"base64_decoder":true,"base64_to_image":true,"image_to_base64":true,"url_encoder":true,"url_decoder":true,"color_converter":true,"binary_converter":true,"hex_converter":true,"ascii_converter":true,"decimal_converter":true,"octal_converter":true,"morse_converter":true,"number_to_words_converter":true,"paypal_link_generator":true,"signature_generator":true,"mailto_link_generator":true,"utm_link_generator":true,"whatsapp_link_generator":true,"youtube_timestamp_link_generator":true,"slug_generator":true,"lorem_ipsum_generator":true,"password_generator":true,"random_number_generator":true,"uuid_v4_generator":true,"bcrypt_generator":true,"md2_generator":true,"md4_generator":true,"md5_generator":true,"whirlpool_generator":true,"sha1_generator":true,"sha224_generator":true,"sha256_generator":true,"sha384_generator":true,"sha512_generator":true,"sha512_224_generator":true,"sha512_256_generator":true,"sha3_224_generator":true,"sha3_256_generator":true,"sha3_384_generator":true,"sha3_512_generator":true,"ripemd128_generator":true,"ripemd160_generator":true,"ripemd256_generator":true,"ripemd320_generator":true,"html_minifier":true,"css_minifier":true,"js_minifier":true,"json_validator_beautifier":true,"sql_beautifier":true,"html_entity_converter":true,"bbcode_to_html":true,"markdown_to_html":true,"html_tags_remover":true,"user_agent_parser":true,"url_parser":true,"png_to_jpg":true,"png_to_bmp":true,"png_to_ico":true,"png_to_gif":true,"png_to_webp":true,"png_to_avif":true,"png_to_tiff":true,"png_to_tga":true,"jpg_to_png":true,"jpg_to_bmp":true,"jpg_to_ico":true,"jpg_to_gif":true,"jpg_to_webp":true,"jpg_to_avif":true,"jpg_to_tiff":true,"jpg_to_tga":true,"bmp_to_png":true,"bmp_to_jpg":true,"bmp_to_ico":true,"bmp_to_gif":true,"bmp_to_webp":true,"bmp_to_avif":true,"bmp_to_tiff":true,"bmp_to_tga":true,"ico_to_png":true,"ico_to_jpg":true,"ico_to_bmp":true,"ico_to_gif":true,"ico_to_webp":true,"ico_to_avif":true,"ico_to_tiff":true,"ico_to_tga":true,"gif_to_png":true,"gif_to_jpg":true,"gif_to_bmp":true,"gif_to_ico":true,"gif_to_webp":true,"gif_to_avif":true,"gif_to_tiff":true,"gif_to_tga":true,"webp_to_png":true,"webp_to_jpg":true,"webp_to_bmp":true,"webp_to_ico":true,"webp_to_gif":true,"webp_to_avif":true,"webp_to_tiff":true,"webp_to_tga":true,"heic_to_png":true,"heic_to_jpg":true,"heic_to_bmp":true,"heic_to_ico":true,"heic_to_gif":true,"heic_to_webp":true,"heic_to_avif":true,"heic_to_tiff":true,"heic_to_tga":true,"avif_to_png":true,"avif_to_jpg":true,"avif_to_bmp":true,"avif_to_ico":true,"avif_to_gif":true,"avif_to_webp":true,"avif_to_tiff":true,"avif_to_tga":true,"tiff_to_png":true,"tiff_to_jpg":true,"tiff_to_bmp":true,"tiff_to_ico":true,"tiff_to_gif":true,"tiff_to_webp":true,"tiff_to_avif":true,"tiff_to_tga":true,"image_optimizer":true,"youtube_thumbnail_downloader":true,"qr_code_reader":true,"barcode_reader":true,"exif_reader":true,"color_picker":true,"celsius_to_fahrenheit":true,"celsius_to_kelvin":true,"fahrenheit_to_celsius":true,"fahrenheit_to_kelvin":true,"kelvin_to_celsius":true,"kelvin_to_fahrenheit":true,"miles_per_hour_to_kilometers_per_hour":true,"kilometers_per_hour_to_miles_per_hour":true,"number_to_roman_numerals":true,"roman_numerals_to_number":true,"unix_timestamp_to_date":true,"date_to_unix_timestamp":true,"seconds_to_milliseconds":true,"seconds_to_microseconds":true,"seconds_to_nanoseconds":true,"seconds_to_picoseconds":true,"seconds_to_minutes":true,"seconds_to_hours":true,"seconds_to_days":true,"seconds_to_weeks":true,"seconds_to_months":true,"seconds_to_years":true,"seconds_to_decades":true,"seconds_to_centuries":true,"seconds_to_millennia":true,"seconds_to_femtoseconds":true,"seconds_to_attoseconds":true,"seconds_to_zeptoseconds":true,"seconds_to_yoctoseconds":true,"seconds_to_planck_time":true,"seconds_to_kiloseconds":true,"seconds_to_megaseconds":true,"seconds_to_gigaseconds":true,"seconds_to_teraseconds":true,"seconds_to_petaseconds":true,"seconds_to_exaseconds":true,"seconds_to_zettaseconds":true,"seconds_to_yottaseconds":true,"seconds_to_fortnights":true,"seconds_to_sidereal_day":true,"seconds_to_sidereal_year":true,"seconds_to_julian_year":true,"seconds_to_galactic_year":true,"seconds_to_megayear":true,"seconds_to_gigayear":true,"seconds_to_shakes":true,"milliseconds_to_seconds":true,"milliseconds_to_microseconds":true,"milliseconds_to_nanoseconds":true,"milliseconds_to_picoseconds":true,"milliseconds_to_minutes":true,"milliseconds_to_hours":true,"milliseconds_to_days":true,"milliseconds_to_weeks":true,"milliseconds_to_months":true,"milliseconds_to_years":true,"milliseconds_to_decades":true,"milliseconds_to_centuries":true,"milliseconds_to_millennia":true,"milliseconds_to_femtoseconds":true,"milliseconds_to_attoseconds":true,"milliseconds_to_zeptoseconds":true,"milliseconds_to_yoctoseconds":true,"milliseconds_to_planck_time":true,"milliseconds_to_kiloseconds":true,"milliseconds_to_megaseconds":true,"milliseconds_to_gigaseconds":true,"milliseconds_to_teraseconds":true,"milliseconds_to_petaseconds":true,"milliseconds_to_exaseconds":true,"milliseconds_to_zettaseconds":true,"milliseconds_to_yottaseconds":true,"milliseconds_to_fortnights":true,"milliseconds_to_sidereal_day":true,"milliseconds_to_sidereal_year":true,"milliseconds_to_julian_year":true,"milliseconds_to_galactic_year":true,"milliseconds_to_megayear":true,"milliseconds_to_gigayear":true,"milliseconds_to_shakes":true,"microseconds_to_seconds":true,"microseconds_to_milliseconds":true,"microseconds_to_nanoseconds":true,"microseconds_to_picoseconds":true,"microseconds_to_minutes":true,"microseconds_to_hours":true,"microseconds_to_days":true,"microseconds_to_weeks":true,"microseconds_to_months":true,"microseconds_to_years":true,"microseconds_to_decades":true,"microseconds_to_centuries":true,"microseconds_to_millennia":true,"microseconds_to_femtoseconds":true,"microseconds_to_attoseconds":true,"microseconds_to_zeptoseconds":true,"microseconds_to_yoctoseconds":true,"microseconds_to_planck_time":true,"microseconds_to_kiloseconds":true,"microseconds_to_megaseconds":true,"microseconds_to_gigaseconds":true,"microseconds_to_teraseconds":true,"microseconds_to_petaseconds":true,"microseconds_to_exaseconds":true,"microseconds_to_zettaseconds":true,"microseconds_to_yottaseconds":true,"microseconds_to_fortnights":true,"microseconds_to_sidereal_day":true,"microseconds_to_sidereal_year":true,"microseconds_to_julian_year":true,"microseconds_to_galactic_year":true,"microseconds_to_megayear":true,"microseconds_to_gigayear":true,"microseconds_to_shakes":true,"nanoseconds_to_seconds":true,"nanoseconds_to_milliseconds":true,"nanoseconds_to_microseconds":true,"nanoseconds_to_picoseconds":true,"nanoseconds_to_minutes":true,"nanoseconds_to_hours":true,"nanoseconds_to_days":true,"nanoseconds_to_weeks":true,"nanoseconds_to_months":true,"nanoseconds_to_years":true,"nanoseconds_to_decades":true,"nanoseconds_to_centuries":true,"nanoseconds_to_millennia":true,"nanoseconds_to_femtoseconds":true,"nanoseconds_to_attoseconds":true,"nanoseconds_to_zeptoseconds":true,"nanoseconds_to_yoctoseconds":true,"nanoseconds_to_planck_time":true,"nanoseconds_to_kiloseconds":true,"nanoseconds_to_megaseconds":true,"nanoseconds_to_gigaseconds":true,"nanoseconds_to_teraseconds":true,"nanoseconds_to_petaseconds":true,"nanoseconds_to_exaseconds":true,"nanoseconds_to_zettaseconds":true,"nanoseconds_to_yottaseconds":true,"nanoseconds_to_fortnights":true,"nanoseconds_to_sidereal_day":true,"nanoseconds_to_sidereal_year":true,"nanoseconds_to_julian_year":true,"nanoseconds_to_galactic_year":true,"nanoseconds_to_megayear":true,"nanoseconds_to_gigayear":true,"nanoseconds_to_shakes":true,"picoseconds_to_seconds":true,"picoseconds_to_milliseconds":true,"picoseconds_to_microseconds":true,"picoseconds_to_nanoseconds":true,"picoseconds_to_minutes":true,"picoseconds_to_hours":true,"picoseconds_to_days":true,"picoseconds_to_weeks":true,"picoseconds_to_months":true,"picoseconds_to_years":true,"picoseconds_to_decades":true,"picoseconds_to_centuries":true,"picoseconds_to_millennia":true,"picoseconds_to_femtoseconds":true,"picoseconds_to_attoseconds":true,"picoseconds_to_zeptoseconds":true,"picoseconds_to_yoctoseconds":true,"picoseconds_to_planck_time":true,"picoseconds_to_kiloseconds":true,"picoseconds_to_megaseconds":true,"picoseconds_to_gigaseconds":true,"picoseconds_to_teraseconds":true,"picoseconds_to_petaseconds":true,"picoseconds_to_exaseconds":true,"picoseconds_to_zettaseconds":true,"picoseconds_to_yottaseconds":true,"picoseconds_to_fortnights":true,"picoseconds_to_sidereal_day":true,"picoseconds_to_sidereal_year":true,"picoseconds_to_julian_year":true,"picoseconds_to_galactic_year":true,"picoseconds_to_megayear":true,"picoseconds_to_gigayear":true,"picoseconds_to_shakes":true,"minutes_to_seconds":true,"minutes_to_milliseconds":true,"minutes_to_microseconds":true,"minutes_to_nanoseconds":true,"minutes_to_picoseconds":true,"minutes_to_hours":true,"minutes_to_days":true,"minutes_to_weeks":true,"minutes_to_months":true,"minutes_to_years":true,"minutes_to_decades":true,"minutes_to_centuries":true,"minutes_to_millennia":true,"minutes_to_femtoseconds":true,"minutes_to_attoseconds":true,"minutes_to_zeptoseconds":true,"minutes_to_yoctoseconds":true,"minutes_to_planck_time":true,"minutes_to_kiloseconds":true,"minutes_to_megaseconds":true,"minutes_to_gigaseconds":true,"minutes_to_teraseconds":true,"minutes_to_petaseconds":true,"minutes_to_exaseconds":true,"minutes_to_zettaseconds":true,"minutes_to_yottaseconds":true,"minutes_to_fortnights":true,"minutes_to_sidereal_day":true,"minutes_to_sidereal_year":true,"minutes_to_julian_year":true,"minutes_to_galactic_year":true,"minutes_to_megayear":true,"minutes_to_gigayear":true,"minutes_to_shakes":true,"hours_to_seconds":true,"hours_to_milliseconds":true,"hours_to_microseconds":true,"hours_to_nanoseconds":true,"hours_to_picoseconds":true,"hours_to_minutes":true,"hours_to_days":true,"hours_to_weeks":true,"hours_to_months":true,"hours_to_years":true,"hours_to_decades":true,"hours_to_centuries":true,"hours_to_millennia":true,"hours_to_femtoseconds":true,"hours_to_attoseconds":true,"hours_to_zeptoseconds":true,"hours_to_yoctoseconds":true,"hours_to_planck_time":true,"hours_to_kiloseconds":true,"hours_to_megaseconds":true,"hours_to_gigaseconds":true,"hours_to_teraseconds":true,"hours_to_petaseconds":true,"hours_to_exaseconds":true,"hours_to_zettaseconds":true,"hours_to_yottaseconds":true,"hours_to_fortnights":true,"hours_to_sidereal_day":true,"hours_to_sidereal_year":true,"hours_to_julian_year":true,"hours_to_galactic_year":true,"hours_to_megayear":true,"hours_to_gigayear":true,"hours_to_shakes":true,"days_to_seconds":true,"days_to_milliseconds":true,"days_to_microseconds":true,"days_to_nanoseconds":true,"days_to_picoseconds":true,"days_to_minutes":true,"days_to_hours":true,"days_to_weeks":true,"days_to_months":true,"days_to_years":true,"days_to_decades":true,"days_to_centuries":true,"days_to_millennia":true,"days_to_femtoseconds":true,"days_to_attoseconds":true,"days_to_zeptoseconds":true,"days_to_yoctoseconds":true,"days_to_planck_time":true,"days_to_kiloseconds":true,"days_to_megaseconds":true,"days_to_gigaseconds":true,"days_to_teraseconds":true,"days_to_petaseconds":true,"days_to_exaseconds":true,"days_to_zettaseconds":true,"days_to_yottaseconds":true,"days_to_fortnights":true,"days_to_sidereal_day":true,"days_to_sidereal_year":true,"days_to_julian_year":true,"days_to_galactic_year":true,"days_to_megayear":true,"days_to_gigayear":true,"days_to_shakes":true,"weeks_to_seconds":true,"weeks_to_milliseconds":true,"weeks_to_microseconds":true,"weeks_to_nanoseconds":true,"weeks_to_picoseconds":true,"weeks_to_minutes":true,"weeks_to_hours":true,"weeks_to_days":true,"weeks_to_months":true,"weeks_to_years":true,"weeks_to_decades":true,"weeks_to_centuries":true,"weeks_to_millennia":true,"weeks_to_femtoseconds":true,"weeks_to_attoseconds":true,"weeks_to_zeptoseconds":true,"weeks_to_yoctoseconds":true,"weeks_to_planck_time":true,"weeks_to_kiloseconds":true,"weeks_to_megaseconds":true,"weeks_to_gigaseconds":true,"weeks_to_teraseconds":true,"weeks_to_petaseconds":true,"weeks_to_exaseconds":true,"weeks_to_zettaseconds":true,"weeks_to_yottaseconds":true,"weeks_to_fortnights":true,"weeks_to_sidereal_day":true,"weeks_to_sidereal_year":true,"weeks_to_julian_year":true,"weeks_to_galactic_year":true,"weeks_to_megayear":true,"weeks_to_gigayear":true,"weeks_to_shakes":true,"months_to_seconds":true,"months_to_milliseconds":true,"months_to_microseconds":true,"months_to_nanoseconds":true,"months_to_picoseconds":true,"months_to_minutes":true,"months_to_hours":true,"months_to_days":true,"months_to_weeks":true,"months_to_years":true,"months_to_decades":true,"months_to_centuries":true,"months_to_millennia":true,"months_to_femtoseconds":true,"months_to_attoseconds":true,"months_to_zeptoseconds":true,"months_to_yoctoseconds":true,"months_to_planck_time":true,"months_to_kiloseconds":true,"months_to_megaseconds":true,"months_to_gigaseconds":true,"months_to_teraseconds":true,"months_to_petaseconds":true,"months_to_exaseconds":true,"months_to_zettaseconds":true,"months_to_yottaseconds":true,"months_to_fortnights":true,"months_to_sidereal_day":true,"months_to_sidereal_year":true,"months_to_julian_year":true,"months_to_galactic_year":true,"months_to_megayear":true,"months_to_gigayear":true,"months_to_shakes":true,"years_to_seconds":true,"years_to_milliseconds":true,"years_to_microseconds":true,"years_to_nanoseconds":true,"years_to_picoseconds":true,"years_to_minutes":true,"years_to_hours":true,"years_to_days":true,"years_to_weeks":true,"years_to_months":true,"years_to_decades":true,"years_to_centuries":true,"years_to_millennia":true,"years_to_femtoseconds":true,"years_to_attoseconds":true,"years_to_zeptoseconds":true,"years_to_yoctoseconds":true,"years_to_planck_time":true,"years_to_kiloseconds":true,"years_to_megaseconds":true,"years_to_gigaseconds":true,"years_to_teraseconds":true,"years_to_petaseconds":true,"years_to_exaseconds":true,"years_to_zettaseconds":true,"years_to_yottaseconds":true,"years_to_fortnights":true,"years_to_sidereal_day":true,"years_to_sidereal_year":true,"years_to_julian_year":true,"years_to_galactic_year":true,"years_to_megayear":true,"years_to_gigayear":true,"years_to_shakes":true,"decades_to_seconds":true,"decades_to_milliseconds":true,"decades_to_microseconds":true,"decades_to_nanoseconds":true,"decades_to_picoseconds":true,"decades_to_minutes":true,"decades_to_hours":true,"decades_to_days":true,"decades_to_weeks":true,"decades_to_months":true,"decades_to_years":true,"decades_to_centuries":true,"decades_to_millennia":true,"decades_to_femtoseconds":true,"decades_to_attoseconds":true,"decades_to_zeptoseconds":true,"decades_to_yoctoseconds":true,"decades_to_planck_time":true,"decades_to_kiloseconds":true,"decades_to_megaseconds":true,"decades_to_gigaseconds":true,"decades_to_teraseconds":true,"decades_to_petaseconds":true,"decades_to_exaseconds":true,"decades_to_zettaseconds":true,"decades_to_yottaseconds":true,"decades_to_fortnights":true,"decades_to_sidereal_day":true,"decades_to_sidereal_year":true,"decades_to_julian_year":true,"decades_to_galactic_year":true,"decades_to_megayear":true,"decades_to_gigayear":true,"decades_to_shakes":true,"centuries_to_seconds":true,"centuries_to_milliseconds":true,"centuries_to_microseconds":true,"centuries_to_nanoseconds":true,"centuries_to_picoseconds":true,"centuries_to_minutes":true,"centuries_to_hours":true,"centuries_to_days":true,"centuries_to_weeks":true,"centuries_to_months":true,"centuries_to_years":true,"centuries_to_decades":true,"centuries_to_millennia":true,"centuries_to_femtoseconds":true,"centuries_to_attoseconds":true,"centuries_to_zeptoseconds":true,"centuries_to_yoctoseconds":true,"centuries_to_planck_time":true,"centuries_to_kiloseconds":true,"centuries_to_megaseconds":true,"centuries_to_gigaseconds":true,"centuries_to_teraseconds":true,"centuries_to_petaseconds":true,"centuries_to_exaseconds":true,"centuries_to_zettaseconds":true,"centuries_to_yottaseconds":true,"centuries_to_fortnights":true,"centuries_to_sidereal_day":true,"centuries_to_sidereal_year":true,"centuries_to_julian_year":true,"centuries_to_galactic_year":true,"centuries_to_megayear":true,"centuries_to_gigayear":true,"centuries_to_shakes":true,"millennia_to_seconds":true,"millennia_to_milliseconds":true,"millennia_to_microseconds":true,"millennia_to_nanoseconds":true,"millennia_to_picoseconds":true,"millennia_to_minutes":true,"millennia_to_hours":true,"millennia_to_days":true,"millennia_to_weeks":true,"millennia_to_months":true,"millennia_to_years":true,"millennia_to_decades":true,"millennia_to_centuries":true,"millennia_to_femtoseconds":true,"millennia_to_attoseconds":true,"millennia_to_zeptoseconds":true,"millennia_to_yoctoseconds":true,"millennia_to_planck_time":true,"millennia_to_kiloseconds":true,"millennia_to_megaseconds":true,"millennia_to_gigaseconds":true,"millennia_to_teraseconds":true,"millennia_to_petaseconds":true,"millennia_to_exaseconds":true,"millennia_to_zettaseconds":true,"millennia_to_yottaseconds":true,"millennia_to_fortnights":true,"millennia_to_sidereal_day":true,"millennia_to_sidereal_year":true,"millennia_to_julian_year":true,"millennia_to_galactic_year":true,"millennia_to_megayear":true,"millennia_to_gigayear":true,"millennia_to_shakes":true,"femtoseconds_to_seconds":true,"femtoseconds_to_milliseconds":true,"femtoseconds_to_microseconds":true,"femtoseconds_to_nanoseconds":true,"femtoseconds_to_picoseconds":true,"femtoseconds_to_minutes":true,"femtoseconds_to_hours":true,"femtoseconds_to_days":true,"femtoseconds_to_weeks":true,"femtoseconds_to_months":true,"femtoseconds_to_years":true,"femtoseconds_to_decades":true,"femtoseconds_to_centuries":true,"femtoseconds_to_millennia":true,"femtoseconds_to_attoseconds":true,"femtoseconds_to_zeptoseconds":true,"femtoseconds_to_yoctoseconds":true,"femtoseconds_to_planck_time":true,"femtoseconds_to_kiloseconds":true,"femtoseconds_to_megaseconds":true,"femtoseconds_to_gigaseconds":true,"femtoseconds_to_teraseconds":true,"femtoseconds_to_petaseconds":true,"femtoseconds_to_exaseconds":true,"femtoseconds_to_zettaseconds":true,"femtoseconds_to_yottaseconds":true,"femtoseconds_to_fortnights":true,"femtoseconds_to_sidereal_day":true,"femtoseconds_to_sidereal_year":true,"femtoseconds_to_julian_year":true,"femtoseconds_to_galactic_year":true,"femtoseconds_to_megayear":true,"femtoseconds_to_gigayear":true,"femtoseconds_to_shakes":true,"attoseconds_to_seconds":true,"attoseconds_to_milliseconds":true,"attoseconds_to_microseconds":true,"attoseconds_to_nanoseconds":true,"attoseconds_to_picoseconds":true,"attoseconds_to_minutes":true,"attoseconds_to_hours":true,"attoseconds_to_days":true,"attoseconds_to_weeks":true,"attoseconds_to_months":true,"attoseconds_to_years":true,"attoseconds_to_decades":true,"attoseconds_to_centuries":true,"attoseconds_to_millennia":true,"attoseconds_to_femtoseconds":true,"attoseconds_to_zeptoseconds":true,"attoseconds_to_yoctoseconds":true,"attoseconds_to_planck_time":true,"attoseconds_to_kiloseconds":true,"attoseconds_to_megaseconds":true,"attoseconds_to_gigaseconds":true,"attoseconds_to_teraseconds":true,"attoseconds_to_petaseconds":true,"attoseconds_to_exaseconds":true,"attoseconds_to_zettaseconds":true,"attoseconds_to_yottaseconds":true,"attoseconds_to_fortnights":true,"attoseconds_to_sidereal_day":true,"attoseconds_to_sidereal_year":true,"attoseconds_to_julian_year":true,"attoseconds_to_galactic_year":true,"attoseconds_to_megayear":true,"attoseconds_to_gigayear":true,"attoseconds_to_shakes":true,"zeptoseconds_to_seconds":true,"zeptoseconds_to_milliseconds":true,"zeptoseconds_to_microseconds":true,"zeptoseconds_to_nanoseconds":true,"zeptoseconds_to_picoseconds":true,"zeptoseconds_to_minutes":true,"zeptoseconds_to_hours":true,"zeptoseconds_to_days":true,"zeptoseconds_to_weeks":true,"zeptoseconds_to_months":true,"zeptoseconds_to_years":true,"zeptoseconds_to_decades":true,"zeptoseconds_to_centuries":true,"zeptoseconds_to_millennia":true,"zeptoseconds_to_femtoseconds":true,"zeptoseconds_to_attoseconds":true,"zeptoseconds_to_yoctoseconds":true,"zeptoseconds_to_planck_time":true,"zeptoseconds_to_kiloseconds":true,"zeptoseconds_to_megaseconds":true,"zeptoseconds_to_gigaseconds":true,"zeptoseconds_to_teraseconds":true,"zeptoseconds_to_petaseconds":true,"zeptoseconds_to_exaseconds":true,"zeptoseconds_to_zettaseconds":true,"zeptoseconds_to_yottaseconds":true,"zeptoseconds_to_fortnights":true,"zeptoseconds_to_sidereal_day":true,"zeptoseconds_to_sidereal_year":true,"zeptoseconds_to_julian_year":true,"zeptoseconds_to_galactic_year":true,"zeptoseconds_to_megayear":true,"zeptoseconds_to_gigayear":true,"zeptoseconds_to_shakes":true,"yoctoseconds_to_seconds":true,"yoctoseconds_to_milliseconds":true,"yoctoseconds_to_microseconds":true,"yoctoseconds_to_nanoseconds":true,"yoctoseconds_to_picoseconds":true,"yoctoseconds_to_minutes":true,"yoctoseconds_to_hours":true,"yoctoseconds_to_days":true,"yoctoseconds_to_weeks":true,"yoctoseconds_to_months":true,"yoctoseconds_to_years":true,"yoctoseconds_to_decades":true,"yoctoseconds_to_centuries":true,"yoctoseconds_to_millennia":true,"yoctoseconds_to_femtoseconds":true,"yoctoseconds_to_attoseconds":true,"yoctoseconds_to_zeptoseconds":true,"yoctoseconds_to_planck_time":true,"yoctoseconds_to_kiloseconds":true,"yoctoseconds_to_megaseconds":true,"yoctoseconds_to_gigaseconds":true,"yoctoseconds_to_teraseconds":true,"yoctoseconds_to_petaseconds":true,"yoctoseconds_to_exaseconds":true,"yoctoseconds_to_zettaseconds":true,"yoctoseconds_to_yottaseconds":true,"yoctoseconds_to_fortnights":true,"yoctoseconds_to_sidereal_day":true,"yoctoseconds_to_sidereal_year":true,"yoctoseconds_to_julian_year":true,"yoctoseconds_to_galactic_year":true,"yoctoseconds_to_megayear":true,"yoctoseconds_to_gigayear":true,"yoctoseconds_to_shakes":true,"planck_time_to_seconds":true,"planck_time_to_milliseconds":true,"planck_time_to_microseconds":true,"planck_time_to_nanoseconds":true,"planck_time_to_picoseconds":true,"planck_time_to_minutes":true,"planck_time_to_hours":true,"planck_time_to_days":true,"planck_time_to_weeks":true,"planck_time_to_months":true,"planck_time_to_years":true,"planck_time_to_decades":true,"planck_time_to_centuries":true,"planck_time_to_millennia":true,"planck_time_to_femtoseconds":true,"planck_time_to_attoseconds":true,"planck_time_to_zeptoseconds":true,"planck_time_to_yoctoseconds":true,"planck_time_to_kiloseconds":true,"planck_time_to_megaseconds":true,"planck_time_to_gigaseconds":true,"planck_time_to_teraseconds":true,"planck_time_to_petaseconds":true,"planck_time_to_exaseconds":true,"planck_time_to_zettaseconds":true,"planck_time_to_yottaseconds":true,"planck_time_to_fortnights":true,"planck_time_to_sidereal_day":true,"planck_time_to_sidereal_year":true,"planck_time_to_julian_year":true,"planck_time_to_galactic_year":true,"planck_time_to_megayear":true,"planck_time_to_gigayear":true,"planck_time_to_shakes":true,"kiloseconds_to_seconds":true,"kiloseconds_to_milliseconds":true,"kiloseconds_to_microseconds":true,"kiloseconds_to_nanoseconds":true,"kiloseconds_to_picoseconds":true,"kiloseconds_to_minutes":true,"kiloseconds_to_hours":true,"kiloseconds_to_days":true,"kiloseconds_to_weeks":true,"kiloseconds_to_months":true,"kiloseconds_to_years":true,"kiloseconds_to_decades":true,"kiloseconds_to_centuries":true,"kiloseconds_to_millennia":true,"kiloseconds_to_femtoseconds":true,"kiloseconds_to_attoseconds":true,"kiloseconds_to_zeptoseconds":true,"kiloseconds_to_yoctoseconds":true,"kiloseconds_to_planck_time":true,"kiloseconds_to_megaseconds":true,"kiloseconds_to_gigaseconds":true,"kiloseconds_to_teraseconds":true,"kiloseconds_to_petaseconds":true,"kiloseconds_to_exaseconds":true,"kiloseconds_to_zettaseconds":true,"kiloseconds_to_yottaseconds":true,"kiloseconds_to_fortnights":true,"kiloseconds_to_sidereal_day":true,"kiloseconds_to_sidereal_year":true,"kiloseconds_to_julian_year":true,"kiloseconds_to_galactic_year":true,"kiloseconds_to_megayear":true,"kiloseconds_to_gigayear":true,"kiloseconds_to_shakes":true,"megaseconds_to_seconds":true,"megaseconds_to_milliseconds":true,"megaseconds_to_microseconds":true,"megaseconds_to_nanoseconds":true,"megaseconds_to_picoseconds":true,"megaseconds_to_minutes":true,"megaseconds_to_hours":true,"megaseconds_to_days":true,"megaseconds_to_weeks":true,"megaseconds_to_months":true,"megaseconds_to_years":true,"megaseconds_to_decades":true,"megaseconds_to_centuries":true,"megaseconds_to_millennia":true,"megaseconds_to_femtoseconds":true,"megaseconds_to_attoseconds":true,"megaseconds_to_zeptoseconds":true,"megaseconds_to_yoctoseconds":true,"megaseconds_to_planck_time":true,"megaseconds_to_kiloseconds":true,"megaseconds_to_gigaseconds":true,"megaseconds_to_teraseconds":true,"megaseconds_to_petaseconds":true,"megaseconds_to_exaseconds":true,"megaseconds_to_zettaseconds":true,"megaseconds_to_yottaseconds":true,"megaseconds_to_fortnights":true,"megaseconds_to_sidereal_day":true,"megaseconds_to_sidereal_year":true,"megaseconds_to_julian_year":true,"megaseconds_to_galactic_year":true,"megaseconds_to_megayear":true,"megaseconds_to_gigayear":true,"megaseconds_to_shakes":true,"gigaseconds_to_seconds":true,"gigaseconds_to_milliseconds":true,"gigaseconds_to_microseconds":true,"gigaseconds_to_nanoseconds":true,"gigaseconds_to_picoseconds":true,"gigaseconds_to_minutes":true,"gigaseconds_to_hours":true,"gigaseconds_to_days":true,"gigaseconds_to_weeks":true,"gigaseconds_to_months":true,"gigaseconds_to_years":true,"gigaseconds_to_decades":true,"gigaseconds_to_centuries":true,"gigaseconds_to_millennia":true,"gigaseconds_to_femtoseconds":true,"gigaseconds_to_attoseconds":true,"gigaseconds_to_zeptoseconds":true,"gigaseconds_to_yoctoseconds":true,"gigaseconds_to_planck_time":true,"gigaseconds_to_kiloseconds":true,"gigaseconds_to_megaseconds":true,"gigaseconds_to_teraseconds":true,"gigaseconds_to_petaseconds":true,"gigaseconds_to_exaseconds":true,"gigaseconds_to_zettaseconds":true,"gigaseconds_to_yottaseconds":true,"gigaseconds_to_fortnights":true,"gigaseconds_to_sidereal_day":true,"gigaseconds_to_sidereal_year":true,"gigaseconds_to_julian_year":true,"gigaseconds_to_galactic_year":true,"gigaseconds_to_megayear":true,"gigaseconds_to_gigayear":true,"gigaseconds_to_shakes":true,"teraseconds_to_seconds":true,"teraseconds_to_milliseconds":true,"teraseconds_to_microseconds":true,"teraseconds_to_nanoseconds":true,"teraseconds_to_picoseconds":true,"teraseconds_to_minutes":true,"teraseconds_to_hours":true,"teraseconds_to_days":true,"teraseconds_to_weeks":true,"teraseconds_to_months":true,"teraseconds_to_years":true,"teraseconds_to_decades":true,"teraseconds_to_centuries":true,"teraseconds_to_millennia":true,"teraseconds_to_femtoseconds":true,"teraseconds_to_attoseconds":true,"teraseconds_to_zeptoseconds":true,"teraseconds_to_yoctoseconds":true,"teraseconds_to_planck_time":true,"teraseconds_to_kiloseconds":true,"teraseconds_to_megaseconds":true,"teraseconds_to_gigaseconds":true,"teraseconds_to_petaseconds":true,"teraseconds_to_exaseconds":true,"teraseconds_to_zettaseconds":true,"teraseconds_to_yottaseconds":true,"teraseconds_to_fortnights":true,"teraseconds_to_sidereal_day":true,"teraseconds_to_sidereal_year":true,"teraseconds_to_julian_year":true,"teraseconds_to_galactic_year":true,"teraseconds_to_megayear":true,"teraseconds_to_gigayear":true,"teraseconds_to_shakes":true,"petaseconds_to_seconds":true,"petaseconds_to_milliseconds":true,"petaseconds_to_microseconds":true,"petaseconds_to_nanoseconds":true,"petaseconds_to_picoseconds":true,"petaseconds_to_minutes":true,"petaseconds_to_hours":true,"petaseconds_to_days":true,"petaseconds_to_weeks":true,"petaseconds_to_months":true,"petaseconds_to_years":true,"petaseconds_to_decades":true,"petaseconds_to_centuries":true,"petaseconds_to_millennia":true,"petaseconds_to_femtoseconds":true,"petaseconds_to_attoseconds":true,"petaseconds_to_zeptoseconds":true,"petaseconds_to_yoctoseconds":true,"petaseconds_to_planck_time":true,"petaseconds_to_kiloseconds":true,"petaseconds_to_megaseconds":true,"petaseconds_to_gigaseconds":true,"petaseconds_to_teraseconds":true,"petaseconds_to_exaseconds":true,"petaseconds_to_zettaseconds":true,"petaseconds_to_yottaseconds":true,"petaseconds_to_fortnights":true,"petaseconds_to_sidereal_day":true,"petaseconds_to_sidereal_year":true,"petaseconds_to_julian_year":true,"petaseconds_to_galactic_year":true,"petaseconds_to_megayear":true,"petaseconds_to_gigayear":true,"petaseconds_to_shakes":true,"exaseconds_to_seconds":true,"exaseconds_to_milliseconds":true,"exaseconds_to_microseconds":true,"exaseconds_to_nanoseconds":true,"exaseconds_to_picoseconds":true,"exaseconds_to_minutes":true,"exaseconds_to_hours":true,"exaseconds_to_days":true,"exaseconds_to_weeks":true,"exaseconds_to_months":true,"exaseconds_to_years":true,"exaseconds_to_decades":true,"exaseconds_to_centuries":true,"exaseconds_to_millennia":true,"exaseconds_to_femtoseconds":true,"exaseconds_to_attoseconds":true,"exaseconds_to_zeptoseconds":true,"exaseconds_to_yoctoseconds":true,"exaseconds_to_planck_time":true,"exaseconds_to_kiloseconds":true,"exaseconds_to_megaseconds":true,"exaseconds_to_gigaseconds":true,"exaseconds_to_teraseconds":true,"exaseconds_to_petaseconds":true,"exaseconds_to_zettaseconds":true,"exaseconds_to_yottaseconds":true,"exaseconds_to_fortnights":true,"exaseconds_to_sidereal_day":true,"exaseconds_to_sidereal_year":true,"exaseconds_to_julian_year":true,"exaseconds_to_galactic_year":true,"exaseconds_to_megayear":true,"exaseconds_to_gigayear":true,"exaseconds_to_shakes":true,"zettaseconds_to_seconds":true,"zettaseconds_to_milliseconds":true,"zettaseconds_to_microseconds":true,"zettaseconds_to_nanoseconds":true,"zettaseconds_to_picoseconds":true,"zettaseconds_to_minutes":true,"zettaseconds_to_hours":true,"zettaseconds_to_days":true,"zettaseconds_to_weeks":true,"zettaseconds_to_months":true,"zettaseconds_to_years":true,"zettaseconds_to_decades":true,"zettaseconds_to_centuries":true,"zettaseconds_to_millennia":true,"zettaseconds_to_femtoseconds":true,"zettaseconds_to_attoseconds":true,"zettaseconds_to_zeptoseconds":true,"zettaseconds_to_yoctoseconds":true,"zettaseconds_to_planck_time":true,"zettaseconds_to_kiloseconds":true,"zettaseconds_to_megaseconds":true,"zettaseconds_to_gigaseconds":true,"zettaseconds_to_teraseconds":true,"zettaseconds_to_petaseconds":true,"zettaseconds_to_exaseconds":true,"zettaseconds_to_yottaseconds":true,"zettaseconds_to_fortnights":true,"zettaseconds_to_sidereal_day":true,"zettaseconds_to_sidereal_year":true,"zettaseconds_to_julian_year":true,"zettaseconds_to_galactic_year":true,"zettaseconds_to_megayear":true,"zettaseconds_to_gigayear":true,"zettaseconds_to_shakes":true,"yottaseconds_to_seconds":true,"yottaseconds_to_milliseconds":true,"yottaseconds_to_microseconds":true,"yottaseconds_to_nanoseconds":true,"yottaseconds_to_picoseconds":true,"yottaseconds_to_minutes":true,"yottaseconds_to_hours":true,"yottaseconds_to_days":true,"yottaseconds_to_weeks":true,"yottaseconds_to_months":true,"yottaseconds_to_years":true,"yottaseconds_to_decades":true,"yottaseconds_to_centuries":true,"yottaseconds_to_millennia":true,"yottaseconds_to_femtoseconds":true,"yottaseconds_to_attoseconds":true,"yottaseconds_to_zeptoseconds":true,"yottaseconds_to_yoctoseconds":true,"yottaseconds_to_planck_time":true,"yottaseconds_to_kiloseconds":true,"yottaseconds_to_megaseconds":true,"yottaseconds_to_gigaseconds":true,"yottaseconds_to_teraseconds":true,"yottaseconds_to_petaseconds":true,"yottaseconds_to_exaseconds":true,"yottaseconds_to_zettaseconds":true,"yottaseconds_to_fortnights":true,"yottaseconds_to_sidereal_day":true,"yottaseconds_to_sidereal_year":true,"yottaseconds_to_julian_year":true,"yottaseconds_to_galactic_year":true,"yottaseconds_to_megayear":true,"yottaseconds_to_gigayear":true,"yottaseconds_to_shakes":true,"fortnights_to_seconds":true,"fortnights_to_milliseconds":true,"fortnights_to_microseconds":true,"fortnights_to_nanoseconds":true,"fortnights_to_picoseconds":true,"fortnights_to_minutes":true,"fortnights_to_hours":true,"fortnights_to_days":true,"fortnights_to_weeks":true,"fortnights_to_months":true,"fortnights_to_years":true,"fortnights_to_decades":true,"fortnights_to_centuries":true,"fortnights_to_millennia":true,"fortnights_to_femtoseconds":true,"fortnights_to_attoseconds":true,"fortnights_to_zeptoseconds":true,"fortnights_to_yoctoseconds":true,"fortnights_to_planck_time":true,"fortnights_to_kiloseconds":true,"fortnights_to_megaseconds":true,"fortnights_to_gigaseconds":true,"fortnights_to_teraseconds":true,"fortnights_to_petaseconds":true,"fortnights_to_exaseconds":true,"fortnights_to_zettaseconds":true,"fortnights_to_yottaseconds":true,"fortnights_to_sidereal_day":true,"fortnights_to_sidereal_year":true,"fortnights_to_julian_year":true,"fortnights_to_galactic_year":true,"fortnights_to_megayear":true,"fortnights_to_gigayear":true,"fortnights_to_shakes":true,"sidereal_day_to_seconds":true,"sidereal_day_to_milliseconds":true,"sidereal_day_to_microseconds":true,"sidereal_day_to_nanoseconds":true,"sidereal_day_to_picoseconds":true,"sidereal_day_to_minutes":true,"sidereal_day_to_hours":true,"sidereal_day_to_days":true,"sidereal_day_to_weeks":true,"sidereal_day_to_months":true,"sidereal_day_to_years":true,"sidereal_day_to_decades":true,"sidereal_day_to_centuries":true,"sidereal_day_to_millennia":true,"sidereal_day_to_femtoseconds":true,"sidereal_day_to_attoseconds":true,"sidereal_day_to_zeptoseconds":true,"sidereal_day_to_yoctoseconds":true,"sidereal_day_to_planck_time":true,"sidereal_day_to_kiloseconds":true,"sidereal_day_to_megaseconds":true,"sidereal_day_to_gigaseconds":true,"sidereal_day_to_teraseconds":true,"sidereal_day_to_petaseconds":true,"sidereal_day_to_exaseconds":true,"sidereal_day_to_zettaseconds":true,"sidereal_day_to_yottaseconds":true,"sidereal_day_to_fortnights":true,"sidereal_day_to_sidereal_year":true,"sidereal_day_to_julian_year":true,"sidereal_day_to_galactic_year":true,"sidereal_day_to_megayear":true,"sidereal_day_to_gigayear":true,"sidereal_day_to_shakes":true,"sidereal_year_to_seconds":true,"sidereal_year_to_milliseconds":true,"sidereal_year_to_microseconds":true,"sidereal_year_to_nanoseconds":true,"sidereal_year_to_picoseconds":true,"sidereal_year_to_minutes":true,"sidereal_year_to_hours":true,"sidereal_year_to_days":true,"sidereal_year_to_weeks":true,"sidereal_year_to_months":true,"sidereal_year_to_years":true,"sidereal_year_to_decades":true,"sidereal_year_to_centuries":true,"sidereal_year_to_millennia":true,"sidereal_year_to_femtoseconds":true,"sidereal_year_to_attoseconds":true,"sidereal_year_to_zeptoseconds":true,"sidereal_year_to_yoctoseconds":true,"sidereal_year_to_planck_time":true,"sidereal_year_to_kiloseconds":true,"sidereal_year_to_megaseconds":true,"sidereal_year_to_gigaseconds":true,"sidereal_year_to_teraseconds":true,"sidereal_year_to_petaseconds":true,"sidereal_year_to_exaseconds":true,"sidereal_year_to_zettaseconds":true,"sidereal_year_to_yottaseconds":true,"sidereal_year_to_fortnights":true,"sidereal_year_to_sidereal_day":true,"sidereal_year_to_julian_year":true,"sidereal_year_to_galactic_year":true,"sidereal_year_to_megayear":true,"sidereal_year_to_gigayear":true,"sidereal_year_to_shakes":true,"julian_year_to_seconds":true,"julian_year_to_milliseconds":true,"julian_year_to_microseconds":true,"julian_year_to_nanoseconds":true,"julian_year_to_picoseconds":true,"julian_year_to_minutes":true,"julian_year_to_hours":true,"julian_year_to_days":true,"julian_year_to_weeks":true,"julian_year_to_months":true,"julian_year_to_years":true,"julian_year_to_decades":true,"julian_year_to_centuries":true,"julian_year_to_millennia":true,"julian_year_to_femtoseconds":true,"julian_year_to_attoseconds":true,"julian_year_to_zeptoseconds":true,"julian_year_to_yoctoseconds":true,"julian_year_to_planck_time":true,"julian_year_to_kiloseconds":true,"julian_year_to_megaseconds":true,"julian_year_to_gigaseconds":true,"julian_year_to_teraseconds":true,"julian_year_to_petaseconds":true,"julian_year_to_exaseconds":true,"julian_year_to_zettaseconds":true,"julian_year_to_yottaseconds":true,"julian_year_to_fortnights":true,"julian_year_to_sidereal_day":true,"julian_year_to_sidereal_year":true,"julian_year_to_galactic_year":true,"julian_year_to_megayear":true,"julian_year_to_gigayear":true,"julian_year_to_shakes":true,"galactic_year_to_seconds":true,"galactic_year_to_milliseconds":true,"galactic_year_to_microseconds":true,"galactic_year_to_nanoseconds":true,"galactic_year_to_picoseconds":true,"galactic_year_to_minutes":true,"galactic_year_to_hours":true,"galactic_year_to_days":true,"galactic_year_to_weeks":true,"galactic_year_to_months":true,"galactic_year_to_years":true,"galactic_year_to_decades":true,"galactic_year_to_centuries":true,"galactic_year_to_millennia":true,"galactic_year_to_femtoseconds":true,"galactic_year_to_attoseconds":true,"galactic_year_to_zeptoseconds":true,"galactic_year_to_yoctoseconds":true,"galactic_year_to_planck_time":true,"galactic_year_to_kiloseconds":true,"galactic_year_to_megaseconds":true,"galactic_year_to_gigaseconds":true,"galactic_year_to_teraseconds":true,"galactic_year_to_petaseconds":true,"galactic_year_to_exaseconds":true,"galactic_year_to_zettaseconds":true,"galactic_year_to_yottaseconds":true,"galactic_year_to_fortnights":true,"galactic_year_to_sidereal_day":true,"galactic_year_to_sidereal_year":true,"galactic_year_to_julian_year":true,"galactic_year_to_megayear":true,"galactic_year_to_gigayear":true,"galactic_year_to_shakes":true,"megayear_to_seconds":true,"megayear_to_milliseconds":true,"megayear_to_microseconds":true,"megayear_to_nanoseconds":true,"megayear_to_picoseconds":true,"megayear_to_minutes":true,"megayear_to_hours":true,"megayear_to_days":true,"megayear_to_weeks":true,"megayear_to_months":true,"megayear_to_years":true,"megayear_to_decades":true,"megayear_to_centuries":true,"megayear_to_millennia":true,"megayear_to_femtoseconds":true,"megayear_to_attoseconds":true,"megayear_to_zeptoseconds":true,"megayear_to_yoctoseconds":true,"megayear_to_planck_time":true,"megayear_to_kiloseconds":true,"megayear_to_megaseconds":true,"megayear_to_gigaseconds":true,"megayear_to_teraseconds":true,"megayear_to_petaseconds":true,"megayear_to_exaseconds":true,"megayear_to_zettaseconds":true,"megayear_to_yottaseconds":true,"megayear_to_fortnights":true,"megayear_to_sidereal_day":true,"megayear_to_sidereal_year":true,"megayear_to_julian_year":true,"megayear_to_galactic_year":true,"megayear_to_gigayear":true,"megayear_to_shakes":true,"gigayear_to_seconds":true,"gigayear_to_milliseconds":true,"gigayear_to_microseconds":true,"gigayear_to_nanoseconds":true,"gigayear_to_picoseconds":true,"gigayear_to_minutes":true,"gigayear_to_hours":true,"gigayear_to_days":true,"gigayear_to_weeks":true,"gigayear_to_months":true,"gigayear_to_years":true,"gigayear_to_decades":true,"gigayear_to_centuries":true,"gigayear_to_millennia":true,"gigayear_to_femtoseconds":true,"gigayear_to_attoseconds":true,"gigayear_to_zeptoseconds":true,"gigayear_to_yoctoseconds":true,"gigayear_to_planck_time":true,"gigayear_to_kiloseconds":true,"gigayear_to_megaseconds":true,"gigayear_to_gigaseconds":true,"gigayear_to_teraseconds":true,"gigayear_to_petaseconds":true,"gigayear_to_exaseconds":true,"gigayear_to_zettaseconds":true,"gigayear_to_yottaseconds":true,"gigayear_to_fortnights":true,"gigayear_to_sidereal_day":true,"gigayear_to_sidereal_year":true,"gigayear_to_julian_year":true,"gigayear_to_galactic_year":true,"gigayear_to_megayear":true,"gigayear_to_shakes":true,"shakes_to_seconds":true,"shakes_to_milliseconds":true,"shakes_to_microseconds":true,"shakes_to_nanoseconds":true,"shakes_to_picoseconds":true,"shakes_to_minutes":true,"shakes_to_hours":true,"shakes_to_days":true,"shakes_to_weeks":true,"shakes_to_months":true,"shakes_to_years":true,"shakes_to_decades":true,"shakes_to_centuries":true,"shakes_to_millennia":true,"shakes_to_femtoseconds":true,"shakes_to_attoseconds":true,"shakes_to_zeptoseconds":true,"shakes_to_yoctoseconds":true,"shakes_to_planck_time":true,"shakes_to_kiloseconds":true,"shakes_to_megaseconds":true,"shakes_to_gigaseconds":true,"shakes_to_teraseconds":true,"shakes_to_petaseconds":true,"shakes_to_exaseconds":true,"shakes_to_zettaseconds":true,"shakes_to_yottaseconds":true,"shakes_to_fortnights":true,"shakes_to_sidereal_day":true,"shakes_to_sidereal_year":true,"shakes_to_julian_year":true,"shakes_to_galactic_year":true,"shakes_to_megayear":true,"shakes_to_gigayear":true,"bits_to_nibbles":true,"bits_to_bytes":true,"bits_to_kilobits":true,"bits_to_kibibits":true,"bits_to_kibibytes":true,"bits_to_kilobytes":true,"bits_to_megabits":true,"bits_to_mebibits":true,"bits_to_megabytes":true,"bits_to_mebibytes":true,"bits_to_gigabits":true,"bits_to_gibibits":true,"bits_to_gigabytes":true,"bits_to_gibibytes":true,"bits_to_terabits":true,"bits_to_tebibits":true,"bits_to_terabytes":true,"bits_to_tebibytes":true,"bits_to_petabits":true,"bits_to_pebibits":true,"bits_to_petabytes":true,"bits_to_pebibytes":true,"bits_to_exabits":true,"bits_to_exbibits":true,"bits_to_exabytes":true,"bits_to_exbibytes":true,"bits_to_zettabits":true,"bits_to_zebibits":true,"bits_to_zettabytes":true,"bits_to_zebibytes":true,"bits_to_yottabits":true,"bits_to_yobibits":true,"bits_to_yottabytes":true,"bits_to_yobibytes":true,"bits_to_ronnabits":true,"bits_to_ronnabytes":true,"bits_to_quettabits":true,"bits_to_quettabytes":true,"nibbles_to_bits":true,"nibbles_to_bytes":true,"nibbles_to_kilobits":true,"nibbles_to_kibibits":true,"nibbles_to_kibibytes":true,"nibbles_to_kilobytes":true,"nibbles_to_megabits":true,"nibbles_to_mebibits":true,"nibbles_to_megabytes":true,"nibbles_to_mebibytes":true,"nibbles_to_gigabits":true,"nibbles_to_gibibits":true,"nibbles_to_gigabytes":true,"nibbles_to_gibibytes":true,"nibbles_to_terabits":true,"nibbles_to_tebibits":true,"nibbles_to_terabytes":true,"nibbles_to_tebibytes":true,"nibbles_to_petabits":true,"nibbles_to_pebibits":true,"nibbles_to_petabytes":true,"nibbles_to_pebibytes":true,"nibbles_to_exabits":true,"nibbles_to_exbibits":true,"nibbles_to_exabytes":true,"nibbles_to_exbibytes":true,"nibbles_to_zettabits":true,"nibbles_to_zebibits":true,"nibbles_to_zettabytes":true,"nibbles_to_zebibytes":true,"nibbles_to_yottabits":true,"nibbles_to_yobibits":true,"nibbles_to_yottabytes":true,"nibbles_to_yobibytes":true,"nibbles_to_ronnabits":true,"nibbles_to_ronnabytes":true,"nibbles_to_quettabits":true,"nibbles_to_quettabytes":true,"bytes_to_bits":true,"bytes_to_nibbles":true,"bytes_to_kilobits":true,"bytes_to_kibibits":true,"bytes_to_kibibytes":true,"bytes_to_kilobytes":true,"bytes_to_megabits":true,"bytes_to_mebibits":true,"bytes_to_megabytes":true,"bytes_to_mebibytes":true,"bytes_to_gigabits":true,"bytes_to_gibibits":true,"bytes_to_gigabytes":true,"bytes_to_gibibytes":true,"bytes_to_terabits":true,"bytes_to_tebibits":true,"bytes_to_terabytes":true,"bytes_to_tebibytes":true,"bytes_to_petabits":true,"bytes_to_pebibits":true,"bytes_to_petabytes":true,"bytes_to_pebibytes":true,"bytes_to_exabits":true,"bytes_to_exbibits":true,"bytes_to_exabytes":true,"bytes_to_exbibytes":true,"bytes_to_zettabits":true,"bytes_to_zebibits":true,"bytes_to_zettabytes":true,"bytes_to_zebibytes":true,"bytes_to_yottabits":true,"bytes_to_yobibits":true,"bytes_to_yottabytes":true,"bytes_to_yobibytes":true,"bytes_to_ronnabits":true,"bytes_to_ronnabytes":true,"bytes_to_quettabits":true,"bytes_to_quettabytes":true,"kilobits_to_bits":true,"kilobits_to_nibbles":true,"kilobits_to_bytes":true,"kilobits_to_kibibits":true,"kilobits_to_kibibytes":true,"kilobits_to_kilobytes":true,"kilobits_to_megabits":true,"kilobits_to_mebibits":true,"kilobits_to_megabytes":true,"kilobits_to_mebibytes":true,"kilobits_to_gigabits":true,"kilobits_to_gibibits":true,"kilobits_to_gigabytes":true,"kilobits_to_gibibytes":true,"kilobits_to_terabits":true,"kilobits_to_tebibits":true,"kilobits_to_terabytes":true,"kilobits_to_tebibytes":true,"kilobits_to_petabits":true,"kilobits_to_pebibits":true,"kilobits_to_petabytes":true,"kilobits_to_pebibytes":true,"kilobits_to_exabits":true,"kilobits_to_exbibits":true,"kilobits_to_exabytes":true,"kilobits_to_exbibytes":true,"kilobits_to_zettabits":true,"kilobits_to_zebibits":true,"kilobits_to_zettabytes":true,"kilobits_to_zebibytes":true,"kilobits_to_yottabits":true,"kilobits_to_yobibits":true,"kilobits_to_yottabytes":true,"kilobits_to_yobibytes":true,"kilobits_to_ronnabits":true,"kilobits_to_ronnabytes":true,"kilobits_to_quettabits":true,"kilobits_to_quettabytes":true,"kibibits_to_bits":true,"kibibits_to_nibbles":true,"kibibits_to_bytes":true,"kibibits_to_kilobits":true,"kibibits_to_kibibytes":true,"kibibits_to_kilobytes":true,"kibibits_to_megabits":true,"kibibits_to_mebibits":true,"kibibits_to_megabytes":true,"kibibits_to_mebibytes":true,"kibibits_to_gigabits":true,"kibibits_to_gibibits":true,"kibibits_to_gigabytes":true,"kibibits_to_gibibytes":true,"kibibits_to_terabits":true,"kibibits_to_tebibits":true,"kibibits_to_terabytes":true,"kibibits_to_tebibytes":true,"kibibits_to_petabits":true,"kibibits_to_pebibits":true,"kibibits_to_petabytes":true,"kibibits_to_pebibytes":true,"kibibits_to_exabits":true,"kibibits_to_exbibits":true,"kibibits_to_exabytes":true,"kibibits_to_exbibytes":true,"kibibits_to_zettabits":true,"kibibits_to_zebibits":true,"kibibits_to_zettabytes":true,"kibibits_to_zebibytes":true,"kibibits_to_yottabits":true,"kibibits_to_yobibits":true,"kibibits_to_yottabytes":true,"kibibits_to_yobibytes":true,"kibibits_to_ronnabits":true,"kibibits_to_ronnabytes":true,"kibibits_to_quettabits":true,"kibibits_to_quettabytes":true,"kibibytes_to_bits":true,"kibibytes_to_nibbles":true,"kibibytes_to_bytes":true,"kibibytes_to_kilobits":true,"kibibytes_to_kibibits":true,"kibibytes_to_kilobytes":true,"kibibytes_to_megabits":true,"kibibytes_to_mebibits":true,"kibibytes_to_megabytes":true,"kibibytes_to_mebibytes":true,"kibibytes_to_gigabits":true,"kibibytes_to_gibibits":true,"kibibytes_to_gigabytes":true,"kibibytes_to_gibibytes":true,"kibibytes_to_terabits":true,"kibibytes_to_tebibits":true,"kibibytes_to_terabytes":true,"kibibytes_to_tebibytes":true,"kibibytes_to_petabits":true,"kibibytes_to_pebibits":true,"kibibytes_to_petabytes":true,"kibibytes_to_pebibytes":true,"kibibytes_to_exabits":true,"kibibytes_to_exbibits":true,"kibibytes_to_exabytes":true,"kibibytes_to_exbibytes":true,"kibibytes_to_zettabits":true,"kibibytes_to_zebibits":true,"kibibytes_to_zettabytes":true,"kibibytes_to_zebibytes":true,"kibibytes_to_yottabits":true,"kibibytes_to_yobibits":true,"kibibytes_to_yottabytes":true,"kibibytes_to_yobibytes":true,"kibibytes_to_ronnabits":true,"kibibytes_to_ronnabytes":true,"kibibytes_to_quettabits":true,"kibibytes_to_quettabytes":true,"kilobytes_to_bits":true,"kilobytes_to_nibbles":true,"kilobytes_to_bytes":true,"kilobytes_to_kilobits":true,"kilobytes_to_kibibits":true,"kilobytes_to_kibibytes":true,"kilobytes_to_megabits":true,"kilobytes_to_mebibits":true,"kilobytes_to_megabytes":true,"kilobytes_to_mebibytes":true,"kilobytes_to_gigabits":true,"kilobytes_to_gibibits":true,"kilobytes_to_gigabytes":true,"kilobytes_to_gibibytes":true,"kilobytes_to_terabits":true,"kilobytes_to_tebibits":true,"kilobytes_to_terabytes":true,"kilobytes_to_tebibytes":true,"kilobytes_to_petabits":true,"kilobytes_to_pebibits":true,"kilobytes_to_petabytes":true,"kilobytes_to_pebibytes":true,"kilobytes_to_exabits":true,"kilobytes_to_exbibits":true,"kilobytes_to_exabytes":true,"kilobytes_to_exbibytes":true,"kilobytes_to_zettabits":true,"kilobytes_to_zebibits":true,"kilobytes_to_zettabytes":true,"kilobytes_to_zebibytes":true,"kilobytes_to_yottabits":true,"kilobytes_to_yobibits":true,"kilobytes_to_yottabytes":true,"kilobytes_to_yobibytes":true,"kilobytes_to_ronnabits":true,"kilobytes_to_ronnabytes":true,"kilobytes_to_quettabits":true,"kilobytes_to_quettabytes":true,"megabits_to_bits":true,"megabits_to_nibbles":true,"megabits_to_bytes":true,"megabits_to_kilobits":true,"megabits_to_kibibits":true,"megabits_to_kibibytes":true,"megabits_to_kilobytes":true,"megabits_to_mebibits":true,"megabits_to_megabytes":true,"megabits_to_mebibytes":true,"megabits_to_gigabits":true,"megabits_to_gibibits":true,"megabits_to_gigabytes":true,"megabits_to_gibibytes":true,"megabits_to_terabits":true,"megabits_to_tebibits":true,"megabits_to_terabytes":true,"megabits_to_tebibytes":true,"megabits_to_petabits":true,"megabits_to_pebibits":true,"megabits_to_petabytes":true,"megabits_to_pebibytes":true,"megabits_to_exabits":true,"megabits_to_exbibits":true,"megabits_to_exabytes":true,"megabits_to_exbibytes":true,"megabits_to_zettabits":true,"megabits_to_zebibits":true,"megabits_to_zettabytes":true,"megabits_to_zebibytes":true,"megabits_to_yottabits":true,"megabits_to_yobibits":true,"megabits_to_yottabytes":true,"megabits_to_yobibytes":true,"megabits_to_ronnabits":true,"megabits_to_ronnabytes":true,"megabits_to_quettabits":true,"megabits_to_quettabytes":true,"mebibits_to_bits":true,"mebibits_to_nibbles":true,"mebibits_to_bytes":true,"mebibits_to_kilobits":true,"mebibits_to_kibibits":true,"mebibits_to_kibibytes":true,"mebibits_to_kilobytes":true,"mebibits_to_megabits":true,"mebibits_to_megabytes":true,"mebibits_to_mebibytes":true,"mebibits_to_gigabits":true,"mebibits_to_gibibits":true,"mebibits_to_gigabytes":true,"mebibits_to_gibibytes":true,"mebibits_to_terabits":true,"mebibits_to_tebibits":true,"mebibits_to_terabytes":true,"mebibits_to_tebibytes":true,"mebibits_to_petabits":true,"mebibits_to_pebibits":true,"mebibits_to_petabytes":true,"mebibits_to_pebibytes":true,"mebibits_to_exabits":true,"mebibits_to_exbibits":true,"mebibits_to_exabytes":true,"mebibits_to_exbibytes":true,"mebibits_to_zettabits":true,"mebibits_to_zebibits":true,"mebibits_to_zettabytes":true,"mebibits_to_zebibytes":true,"mebibits_to_yottabits":true,"mebibits_to_yobibits":true,"mebibits_to_yottabytes":true,"mebibits_to_yobibytes":true,"mebibits_to_ronnabits":true,"mebibits_to_ronnabytes":true,"mebibits_to_quettabits":true,"mebibits_to_quettabytes":true,"megabytes_to_bits":true,"megabytes_to_nibbles":true,"megabytes_to_bytes":true,"megabytes_to_kilobits":true,"megabytes_to_kibibits":true,"megabytes_to_kibibytes":true,"megabytes_to_kilobytes":true,"megabytes_to_megabits":true,"megabytes_to_mebibits":true,"megabytes_to_mebibytes":true,"megabytes_to_gigabits":true,"megabytes_to_gibibits":true,"megabytes_to_gigabytes":true,"megabytes_to_gibibytes":true,"megabytes_to_terabits":true,"megabytes_to_tebibits":true,"megabytes_to_terabytes":true,"megabytes_to_tebibytes":true,"megabytes_to_petabits":true,"megabytes_to_pebibits":true,"megabytes_to_petabytes":true,"megabytes_to_pebibytes":true,"megabytes_to_exabits":true,"megabytes_to_exbibits":true,"megabytes_to_exabytes":true,"megabytes_to_exbibytes":true,"megabytes_to_zettabits":true,"megabytes_to_zebibits":true,"megabytes_to_zettabytes":true,"megabytes_to_zebibytes":true,"megabytes_to_yottabits":true,"megabytes_to_yobibits":true,"megabytes_to_yottabytes":true,"megabytes_to_yobibytes":true,"megabytes_to_ronnabits":true,"megabytes_to_ronnabytes":true,"megabytes_to_quettabits":true,"megabytes_to_quettabytes":true,"mebibytes_to_bits":true,"mebibytes_to_nibbles":true,"mebibytes_to_bytes":true,"mebibytes_to_kilobits":true,"mebibytes_to_kibibits":true,"mebibytes_to_kibibytes":true,"mebibytes_to_kilobytes":true,"mebibytes_to_megabits":true,"mebibytes_to_mebibits":true,"mebibytes_to_megabytes":true,"mebibytes_to_gigabits":true,"mebibytes_to_gibibits":true,"mebibytes_to_gigabytes":true,"mebibytes_to_gibibytes":true,"mebibytes_to_terabits":true,"mebibytes_to_tebibits":true,"mebibytes_to_terabytes":true,"mebibytes_to_tebibytes":true,"mebibytes_to_petabits":true,"mebibytes_to_pebibits":true,"mebibytes_to_petabytes":true,"mebibytes_to_pebibytes":true,"mebibytes_to_exabits":true,"mebibytes_to_exbibits":true,"mebibytes_to_exabytes":true,"mebibytes_to_exbibytes":true,"mebibytes_to_zettabits":true,"mebibytes_to_zebibits":true,"mebibytes_to_zettabytes":true,"mebibytes_to_zebibytes":true,"mebibytes_to_yottabits":true,"mebibytes_to_yobibits":true,"mebibytes_to_yottabytes":true,"mebibytes_to_yobibytes":true,"mebibytes_to_ronnabits":true,"mebibytes_to_ronnabytes":true,"mebibytes_to_quettabits":true,"mebibytes_to_quettabytes":true,"gigabits_to_bits":true,"gigabits_to_nibbles":true,"gigabits_to_bytes":true,"gigabits_to_kilobits":true,"gigabits_to_kibibits":true,"gigabits_to_kibibytes":true,"gigabits_to_kilobytes":true,"gigabits_to_megabits":true,"gigabits_to_mebibits":true,"gigabits_to_megabytes":true,"gigabits_to_mebibytes":true,"gigabits_to_gibibits":true,"gigabits_to_gigabytes":true,"gigabits_to_gibibytes":true,"gigabits_to_terabits":true,"gigabits_to_tebibits":true,"gigabits_to_terabytes":true,"gigabits_to_tebibytes":true,"gigabits_to_petabits":true,"gigabits_to_pebibits":true,"gigabits_to_petabytes":true,"gigabits_to_pebibytes":true,"gigabits_to_exabits":true,"gigabits_to_exbibits":true,"gigabits_to_exabytes":true,"gigabits_to_exbibytes":true,"gigabits_to_zettabits":true,"gigabits_to_zebibits":true,"gigabits_to_zettabytes":true,"gigabits_to_zebibytes":true,"gigabits_to_yottabits":true,"gigabits_to_yobibits":true,"gigabits_to_yottabytes":true,"gigabits_to_yobibytes":true,"gigabits_to_ronnabits":true,"gigabits_to_ronnabytes":true,"gigabits_to_quettabits":true,"gigabits_to_quettabytes":true,"gibibits_to_bits":true,"gibibits_to_nibbles":true,"gibibits_to_bytes":true,"gibibits_to_kilobits":true,"gibibits_to_kibibits":true,"gibibits_to_kibibytes":true,"gibibits_to_kilobytes":true,"gibibits_to_megabits":true,"gibibits_to_mebibits":true,"gibibits_to_megabytes":true,"gibibits_to_mebibytes":true,"gibibits_to_gigabits":true,"gibibits_to_gigabytes":true,"gibibits_to_gibibytes":true,"gibibits_to_terabits":true,"gibibits_to_tebibits":true,"gibibits_to_terabytes":true,"gibibits_to_tebibytes":true,"gibibits_to_petabits":true,"gibibits_to_pebibits":true,"gibibits_to_petabytes":true,"gibibits_to_pebibytes":true,"gibibits_to_exabits":true,"gibibits_to_exbibits":true,"gibibits_to_exabytes":true,"gibibits_to_exbibytes":true,"gibibits_to_zettabits":true,"gibibits_to_zebibits":true,"gibibits_to_zettabytes":true,"gibibits_to_zebibytes":true,"gibibits_to_yottabits":true,"gibibits_to_yobibits":true,"gibibits_to_yottabytes":true,"gibibits_to_yobibytes":true,"gibibits_to_ronnabits":true,"gibibits_to_ronnabytes":true,"gibibits_to_quettabits":true,"gibibits_to_quettabytes":true,"gigabytes_to_bits":true,"gigabytes_to_nibbles":true,"gigabytes_to_bytes":true,"gigabytes_to_kilobits":true,"gigabytes_to_kibibits":true,"gigabytes_to_kibibytes":true,"gigabytes_to_kilobytes":true,"gigabytes_to_megabits":true,"gigabytes_to_mebibits":true,"gigabytes_to_megabytes":true,"gigabytes_to_mebibytes":true,"gigabytes_to_gigabits":true,"gigabytes_to_gibibits":true,"gigabytes_to_gibibytes":true,"gigabytes_to_terabits":true,"gigabytes_to_tebibits":true,"gigabytes_to_terabytes":true,"gigabytes_to_tebibytes":true,"gigabytes_to_petabits":true,"gigabytes_to_pebibits":true,"gigabytes_to_petabytes":true,"gigabytes_to_pebibytes":true,"gigabytes_to_exabits":true,"gigabytes_to_exbibits":true,"gigabytes_to_exabytes":true,"gigabytes_to_exbibytes":true,"gigabytes_to_zettabits":true,"gigabytes_to_zebibits":true,"gigabytes_to_zettabytes":true,"gigabytes_to_zebibytes":true,"gigabytes_to_yottabits":true,"gigabytes_to_yobibits":true,"gigabytes_to_yottabytes":true,"gigabytes_to_yobibytes":true,"gigabytes_to_ronnabits":true,"gigabytes_to_ronnabytes":true,"gigabytes_to_quettabits":true,"gigabytes_to_quettabytes":true,"gibibytes_to_bits":true,"gibibytes_to_nibbles":true,"gibibytes_to_bytes":true,"gibibytes_to_kilobits":true,"gibibytes_to_kibibits":true,"gibibytes_to_kibibytes":true,"gibibytes_to_kilobytes":true,"gibibytes_to_megabits":true,"gibibytes_to_mebibits":true,"gibibytes_to_megabytes":true,"gibibytes_to_mebibytes":true,"gibibytes_to_gigabits":true,"gibibytes_to_gibibits":true,"gibibytes_to_gigabytes":true,"gibibytes_to_terabits":true,"gibibytes_to_tebibits":true,"gibibytes_to_terabytes":true,"gibibytes_to_tebibytes":true,"gibibytes_to_petabits":true,"gibibytes_to_pebibits":true,"gibibytes_to_petabytes":true,"gibibytes_to_pebibytes":true,"gibibytes_to_exabits":true,"gibibytes_to_exbibits":true,"gibibytes_to_exabytes":true,"gibibytes_to_exbibytes":true,"gibibytes_to_zettabits":true,"gibibytes_to_zebibits":true,"gibibytes_to_zettabytes":true,"gibibytes_to_zebibytes":true,"gibibytes_to_yottabits":true,"gibibytes_to_yobibits":true,"gibibytes_to_yottabytes":true,"gibibytes_to_yobibytes":true,"gibibytes_to_ronnabits":true,"gibibytes_to_ronnabytes":true,"gibibytes_to_quettabits":true,"gibibytes_to_quettabytes":true,"terabits_to_bits":true,"terabits_to_nibbles":true,"terabits_to_bytes":true,"terabits_to_kilobits":true,"terabits_to_kibibits":true,"terabits_to_kibibytes":true,"terabits_to_kilobytes":true,"terabits_to_megabits":true,"terabits_to_mebibits":true,"terabits_to_megabytes":true,"terabits_to_mebibytes":true,"terabits_to_gigabits":true,"terabits_to_gibibits":true,"terabits_to_gigabytes":true,"terabits_to_gibibytes":true,"terabits_to_tebibits":true,"terabits_to_terabytes":true,"terabits_to_tebibytes":true,"terabits_to_petabits":true,"terabits_to_pebibits":true,"terabits_to_petabytes":true,"terabits_to_pebibytes":true,"terabits_to_exabits":true,"terabits_to_exbibits":true,"terabits_to_exabytes":true,"terabits_to_exbibytes":true,"terabits_to_zettabits":true,"terabits_to_zebibits":true,"terabits_to_zettabytes":true,"terabits_to_zebibytes":true,"terabits_to_yottabits":true,"terabits_to_yobibits":true,"terabits_to_yottabytes":true,"terabits_to_yobibytes":true,"terabits_to_ronnabits":true,"terabits_to_ronnabytes":true,"terabits_to_quettabits":true,"terabits_to_quettabytes":true,"tebibits_to_bits":true,"tebibits_to_nibbles":true,"tebibits_to_bytes":true,"tebibits_to_kilobits":true,"tebibits_to_kibibits":true,"tebibits_to_kibibytes":true,"tebibits_to_kilobytes":true,"tebibits_to_megabits":true,"tebibits_to_mebibits":true,"tebibits_to_megabytes":true,"tebibits_to_mebibytes":true,"tebibits_to_gigabits":true,"tebibits_to_gibibits":true,"tebibits_to_gigabytes":true,"tebibits_to_gibibytes":true,"tebibits_to_terabits":true,"tebibits_to_terabytes":true,"tebibits_to_tebibytes":true,"tebibits_to_petabits":true,"tebibits_to_pebibits":true,"tebibits_to_petabytes":true,"tebibits_to_pebibytes":true,"tebibits_to_exabits":true,"tebibits_to_exbibits":true,"tebibits_to_exabytes":true,"tebibits_to_exbibytes":true,"tebibits_to_zettabits":true,"tebibits_to_zebibits":true,"tebibits_to_zettabytes":true,"tebibits_to_zebibytes":true,"tebibits_to_yottabits":true,"tebibits_to_yobibits":true,"tebibits_to_yottabytes":true,"tebibits_to_yobibytes":true,"tebibits_to_ronnabits":true,"tebibits_to_ronnabytes":true,"tebibits_to_quettabits":true,"tebibits_to_quettabytes":true,"terabytes_to_bits":true,"terabytes_to_nibbles":true,"terabytes_to_bytes":true,"terabytes_to_kilobits":true,"terabytes_to_kibibits":true,"terabytes_to_kibibytes":true,"terabytes_to_kilobytes":true,"terabytes_to_megabits":true,"terabytes_to_mebibits":true,"terabytes_to_megabytes":true,"terabytes_to_mebibytes":true,"terabytes_to_gigabits":true,"terabytes_to_gibibits":true,"terabytes_to_gigabytes":true,"terabytes_to_gibibytes":true,"terabytes_to_terabits":true,"terabytes_to_tebibits":true,"terabytes_to_tebibytes":true,"terabytes_to_petabits":true,"terabytes_to_pebibits":true,"terabytes_to_petabytes":true,"terabytes_to_pebibytes":true,"terabytes_to_exabits":true,"terabytes_to_exbibits":true,"terabytes_to_exabytes":true,"terabytes_to_exbibytes":true,"terabytes_to_zettabits":true,"terabytes_to_zebibits":true,"terabytes_to_zettabytes":true,"terabytes_to_zebibytes":true,"terabytes_to_yottabits":true,"terabytes_to_yobibits":true,"terabytes_to_yottabytes":true,"terabytes_to_yobibytes":true,"terabytes_to_ronnabits":true,"terabytes_to_ronnabytes":true,"terabytes_to_quettabits":true,"terabytes_to_quettabytes":true,"tebibytes_to_bits":true,"tebibytes_to_nibbles":true,"tebibytes_to_bytes":true,"tebibytes_to_kilobits":true,"tebibytes_to_kibibits":true,"tebibytes_to_kibibytes":true,"tebibytes_to_kilobytes":true,"tebibytes_to_megabits":true,"tebibytes_to_mebibits":true,"tebibytes_to_megabytes":true,"tebibytes_to_mebibytes":true,"tebibytes_to_gigabits":true,"tebibytes_to_gibibits":true,"tebibytes_to_gigabytes":true,"tebibytes_to_gibibytes":true,"tebibytes_to_terabits":true,"tebibytes_to_tebibits":true,"tebibytes_to_terabytes":true,"tebibytes_to_petabits":true,"tebibytes_to_pebibits":true,"tebibytes_to_petabytes":true,"tebibytes_to_pebibytes":true,"tebibytes_to_exabits":true,"tebibytes_to_exbibits":true,"tebibytes_to_exabytes":true,"tebibytes_to_exbibytes":true,"tebibytes_to_zettabits":true,"tebibytes_to_zebibits":true,"tebibytes_to_zettabytes":true,"tebibytes_to_zebibytes":true,"tebibytes_to_yottabits":true,"tebibytes_to_yobibits":true,"tebibytes_to_yottabytes":true,"tebibytes_to_yobibytes":true,"tebibytes_to_ronnabits":true,"tebibytes_to_ronnabytes":true,"tebibytes_to_quettabits":true,"tebibytes_to_quettabytes":true,"petabits_to_bits":true,"petabits_to_nibbles":true,"petabits_to_bytes":true,"petabits_to_kilobits":true,"petabits_to_kibibits":true,"petabits_to_kibibytes":true,"petabits_to_kilobytes":true,"petabits_to_megabits":true,"petabits_to_mebibits":true,"petabits_to_megabytes":true,"petabits_to_mebibytes":true,"petabits_to_gigabits":true,"petabits_to_gibibits":true,"petabits_to_gigabytes":true,"petabits_to_gibibytes":true,"petabits_to_terabits":true,"petabits_to_tebibits":true,"petabits_to_terabytes":true,"petabits_to_tebibytes":true,"petabits_to_pebibits":true,"petabits_to_petabytes":true,"petabits_to_pebibytes":true,"petabits_to_exabits":true,"petabits_to_exbibits":true,"petabits_to_exabytes":true,"petabits_to_exbibytes":true,"petabits_to_zettabits":true,"petabits_to_zebibits":true,"petabits_to_zettabytes":true,"petabits_to_zebibytes":true,"petabits_to_yottabits":true,"petabits_to_yobibits":true,"petabits_to_yottabytes":true,"petabits_to_yobibytes":true,"petabits_to_ronnabits":true,"petabits_to_ronnabytes":true,"petabits_to_quettabits":true,"petabits_to_quettabytes":true,"pebibits_to_bits":true,"pebibits_to_nibbles":true,"pebibits_to_bytes":true,"pebibits_to_kilobits":true,"pebibits_to_kibibits":true,"pebibits_to_kibibytes":true,"pebibits_to_kilobytes":true,"pebibits_to_megabits":true,"pebibits_to_mebibits":true,"pebibits_to_megabytes":true,"pebibits_to_mebibytes":true,"pebibits_to_gigabits":true,"pebibits_to_gibibits":true,"pebibits_to_gigabytes":true,"pebibits_to_gibibytes":true,"pebibits_to_terabits":true,"pebibits_to_tebibits":true,"pebibits_to_terabytes":true,"pebibits_to_tebibytes":true,"pebibits_to_petabits":true,"pebibits_to_petabytes":true,"pebibits_to_pebibytes":true,"pebibits_to_exabits":true,"pebibits_to_exbibits":true,"pebibits_to_exabytes":true,"pebibits_to_exbibytes":true,"pebibits_to_zettabits":true,"pebibits_to_zebibits":true,"pebibits_to_zettabytes":true,"pebibits_to_zebibytes":true,"pebibits_to_yottabits":true,"pebibits_to_yobibits":true,"pebibits_to_yottabytes":true,"pebibits_to_yobibytes":true,"pebibits_to_ronnabits":true,"pebibits_to_ronnabytes":true,"pebibits_to_quettabits":true,"pebibits_to_quettabytes":true,"petabytes_to_bits":true,"petabytes_to_nibbles":true,"petabytes_to_bytes":true,"petabytes_to_kilobits":true,"petabytes_to_kibibits":true,"petabytes_to_kibibytes":true,"petabytes_to_kilobytes":true,"petabytes_to_megabits":true,"petabytes_to_mebibits":true,"petabytes_to_megabytes":true,"petabytes_to_mebibytes":true,"petabytes_to_gigabits":true,"petabytes_to_gibibits":true,"petabytes_to_gigabytes":true,"petabytes_to_gibibytes":true,"petabytes_to_terabits":true,"petabytes_to_tebibits":true,"petabytes_to_terabytes":true,"petabytes_to_tebibytes":true,"petabytes_to_petabits":true,"petabytes_to_pebibits":true,"petabytes_to_pebibytes":true,"petabytes_to_exabits":true,"petabytes_to_exbibits":true,"petabytes_to_exabytes":true,"petabytes_to_exbibytes":true,"petabytes_to_zettabits":true,"petabytes_to_zebibits":true,"petabytes_to_zettabytes":true,"petabytes_to_zebibytes":true,"petabytes_to_yottabits":true,"petabytes_to_yobibits":true,"petabytes_to_yottabytes":true,"petabytes_to_yobibytes":true,"petabytes_to_ronnabits":true,"petabytes_to_ronnabytes":true,"petabytes_to_quettabits":true,"petabytes_to_quettabytes":true,"pebibytes_to_bits":true,"pebibytes_to_nibbles":true,"pebibytes_to_bytes":true,"pebibytes_to_kilobits":true,"pebibytes_to_kibibits":true,"pebibytes_to_kibibytes":true,"pebibytes_to_kilobytes":true,"pebibytes_to_megabits":true,"pebibytes_to_mebibits":true,"pebibytes_to_megabytes":true,"pebibytes_to_mebibytes":true,"pebibytes_to_gigabits":true,"pebibytes_to_gibibits":true,"pebibytes_to_gigabytes":true,"pebibytes_to_gibibytes":true,"pebibytes_to_terabits":true,"pebibytes_to_tebibits":true,"pebibytes_to_terabytes":true,"pebibytes_to_tebibytes":true,"pebibytes_to_petabits":true,"pebibytes_to_pebibits":true,"pebibytes_to_petabytes":true,"pebibytes_to_exabits":true,"pebibytes_to_exbibits":true,"pebibytes_to_exabytes":true,"pebibytes_to_exbibytes":true,"pebibytes_to_zettabits":true,"pebibytes_to_zebibits":true,"pebibytes_to_zettabytes":true,"pebibytes_to_zebibytes":true,"pebibytes_to_yottabits":true,"pebibytes_to_yobibits":true,"pebibytes_to_yottabytes":true,"pebibytes_to_yobibytes":true,"pebibytes_to_ronnabits":true,"pebibytes_to_ronnabytes":true,"pebibytes_to_quettabits":true,"pebibytes_to_quettabytes":true,"exabits_to_bits":true,"exabits_to_nibbles":true,"exabits_to_bytes":true,"exabits_to_kilobits":true,"exabits_to_kibibits":true,"exabits_to_kibibytes":true,"exabits_to_kilobytes":true,"exabits_to_megabits":true,"exabits_to_mebibits":true,"exabits_to_megabytes":true,"exabits_to_mebibytes":true,"exabits_to_gigabits":true,"exabits_to_gibibits":true,"exabits_to_gigabytes":true,"exabits_to_gibibytes":true,"exabits_to_terabits":true,"exabits_to_tebibits":true,"exabits_to_terabytes":true,"exabits_to_tebibytes":true,"exabits_to_petabits":true,"exabits_to_pebibits":true,"exabits_to_petabytes":true,"exabits_to_pebibytes":true,"exabits_to_exbibits":true,"exabits_to_exabytes":true,"exabits_to_exbibytes":true,"exabits_to_zettabits":true,"exabits_to_zebibits":true,"exabits_to_zettabytes":true,"exabits_to_zebibytes":true,"exabits_to_yottabits":true,"exabits_to_yobibits":true,"exabits_to_yottabytes":true,"exabits_to_yobibytes":true,"exabits_to_ronnabits":true,"exabits_to_ronnabytes":true,"exabits_to_quettabits":true,"exabits_to_quettabytes":true,"exbibits_to_bits":true,"exbibits_to_nibbles":true,"exbibits_to_bytes":true,"exbibits_to_kilobits":true,"exbibits_to_kibibits":true,"exbibits_to_kibibytes":true,"exbibits_to_kilobytes":true,"exbibits_to_megabits":true,"exbibits_to_mebibits":true,"exbibits_to_megabytes":true,"exbibits_to_mebibytes":true,"exbibits_to_gigabits":true,"exbibits_to_gibibits":true,"exbibits_to_gigabytes":true,"exbibits_to_gibibytes":true,"exbibits_to_terabits":true,"exbibits_to_tebibits":true,"exbibits_to_terabytes":true,"exbibits_to_tebibytes":true,"exbibits_to_petabits":true,"exbibits_to_pebibits":true,"exbibits_to_petabytes":true,"exbibits_to_pebibytes":true,"exbibits_to_exabits":true,"exbibits_to_exabytes":true,"exbibits_to_exbibytes":true,"exbibits_to_zettabits":true,"exbibits_to_zebibits":true,"exbibits_to_zettabytes":true,"exbibits_to_zebibytes":true,"exbibits_to_yottabits":true,"exbibits_to_yobibits":true,"exbibits_to_yottabytes":true,"exbibits_to_yobibytes":true,"exbibits_to_ronnabits":true,"exbibits_to_ronnabytes":true,"exbibits_to_quettabits":true,"exbibits_to_quettabytes":true,"exabytes_to_bits":true,"exabytes_to_nibbles":true,"exabytes_to_bytes":true,"exabytes_to_kilobits":true,"exabytes_to_kibibits":true,"exabytes_to_kibibytes":true,"exabytes_to_kilobytes":true,"exabytes_to_megabits":true,"exabytes_to_mebibits":true,"exabytes_to_megabytes":true,"exabytes_to_mebibytes":true,"exabytes_to_gigabits":true,"exabytes_to_gibibits":true,"exabytes_to_gigabytes":true,"exabytes_to_gibibytes":true,"exabytes_to_terabits":true,"exabytes_to_tebibits":true,"exabytes_to_terabytes":true,"exabytes_to_tebibytes":true,"exabytes_to_petabits":true,"exabytes_to_pebibits":true,"exabytes_to_petabytes":true,"exabytes_to_pebibytes":true,"exabytes_to_exabits":true,"exabytes_to_exbibits":true,"exabytes_to_exbibytes":true,"exabytes_to_zettabits":true,"exabytes_to_zebibits":true,"exabytes_to_zettabytes":true,"exabytes_to_zebibytes":true,"exabytes_to_yottabits":true,"exabytes_to_yobibits":true,"exabytes_to_yottabytes":true,"exabytes_to_yobibytes":true,"exabytes_to_ronnabits":true,"exabytes_to_ronnabytes":true,"exabytes_to_quettabits":true,"exabytes_to_quettabytes":true,"exbibytes_to_bits":true,"exbibytes_to_nibbles":true,"exbibytes_to_bytes":true,"exbibytes_to_kilobits":true,"exbibytes_to_kibibits":true,"exbibytes_to_kibibytes":true,"exbibytes_to_kilobytes":true,"exbibytes_to_megabits":true,"exbibytes_to_mebibits":true,"exbibytes_to_megabytes":true,"exbibytes_to_mebibytes":true,"exbibytes_to_gigabits":true,"exbibytes_to_gibibits":true,"exbibytes_to_gigabytes":true,"exbibytes_to_gibibytes":true,"exbibytes_to_terabits":true,"exbibytes_to_tebibits":true,"exbibytes_to_terabytes":true,"exbibytes_to_tebibytes":true,"exbibytes_to_petabits":true,"exbibytes_to_pebibits":true,"exbibytes_to_petabytes":true,"exbibytes_to_pebibytes":true,"exbibytes_to_exabits":true,"exbibytes_to_exbibits":true,"exbibytes_to_exabytes":true,"exbibytes_to_zettabits":true,"exbibytes_to_zebibits":true,"exbibytes_to_zettabytes":true,"exbibytes_to_zebibytes":true,"exbibytes_to_yottabits":true,"exbibytes_to_yobibits":true,"exbibytes_to_yottabytes":true,"exbibytes_to_yobibytes":true,"exbibytes_to_ronnabits":true,"exbibytes_to_ronnabytes":true,"exbibytes_to_quettabits":true,"exbibytes_to_quettabytes":true,"zettabits_to_bits":true,"zettabits_to_nibbles":true,"zettabits_to_bytes":true,"zettabits_to_kilobits":true,"zettabits_to_kibibits":true,"zettabits_to_kibibytes":true,"zettabits_to_kilobytes":true,"zettabits_to_megabits":true,"zettabits_to_mebibits":true,"zettabits_to_megabytes":true,"zettabits_to_mebibytes":true,"zettabits_to_gigabits":true,"zettabits_to_gibibits":true,"zettabits_to_gigabytes":true,"zettabits_to_gibibytes":true,"zettabits_to_terabits":true,"zettabits_to_tebibits":true,"zettabits_to_terabytes":true,"zettabits_to_tebibytes":true,"zettabits_to_petabits":true,"zettabits_to_pebibits":true,"zettabits_to_petabytes":true,"zettabits_to_pebibytes":true,"zettabits_to_exabits":true,"zettabits_to_exbibits":true,"zettabits_to_exabytes":true,"zettabits_to_exbibytes":true,"zettabits_to_zebibits":true,"zettabits_to_zettabytes":true,"zettabits_to_zebibytes":true,"zettabits_to_yottabits":true,"zettabits_to_yobibits":true,"zettabits_to_yottabytes":true,"zettabits_to_yobibytes":true,"zettabits_to_ronnabits":true,"zettabits_to_ronnabytes":true,"zettabits_to_quettabits":true,"zettabits_to_quettabytes":true,"zebibits_to_bits":true,"zebibits_to_nibbles":true,"zebibits_to_bytes":true,"zebibits_to_kilobits":true,"zebibits_to_kibibits":true,"zebibits_to_kibibytes":true,"zebibits_to_kilobytes":true,"zebibits_to_megabits":true,"zebibits_to_mebibits":true,"zebibits_to_megabytes":true,"zebibits_to_mebibytes":true,"zebibits_to_gigabits":true,"zebibits_to_gibibits":true,"zebibits_to_gigabytes":true,"zebibits_to_gibibytes":true,"zebibits_to_terabits":true,"zebibits_to_tebibits":true,"zebibits_to_terabytes":true,"zebibits_to_tebibytes":true,"zebibits_to_petabits":true,"zebibits_to_pebibits":true,"zebibits_to_petabytes":true,"zebibits_to_pebibytes":true,"zebibits_to_exabits":true,"zebibits_to_exbibits":true,"zebibits_to_exabytes":true,"zebibits_to_exbibytes":true,"zebibits_to_zettabits":true,"zebibits_to_zettabytes":true,"zebibits_to_zebibytes":true,"zebibits_to_yottabits":true,"zebibits_to_yobibits":true,"zebibits_to_yottabytes":true,"zebibits_to_yobibytes":true,"zebibits_to_ronnabits":true,"zebibits_to_ronnabytes":true,"zebibits_to_quettabits":true,"zebibits_to_quettabytes":true,"zettabytes_to_bits":true,"zettabytes_to_nibbles":true,"zettabytes_to_bytes":true,"zettabytes_to_kilobits":true,"zettabytes_to_kibibits":true,"zettabytes_to_kibibytes":true,"zettabytes_to_kilobytes":true,"zettabytes_to_megabits":true,"zettabytes_to_mebibits":true,"zettabytes_to_megabytes":true,"zettabytes_to_mebibytes":true,"zettabytes_to_gigabits":true,"zettabytes_to_gibibits":true,"zettabytes_to_gigabytes":true,"zettabytes_to_gibibytes":true,"zettabytes_to_terabits":true,"zettabytes_to_tebibits":true,"zettabytes_to_terabytes":true,"zettabytes_to_tebibytes":true,"zettabytes_to_petabits":true,"zettabytes_to_pebibits":true,"zettabytes_to_petabytes":true,"zettabytes_to_pebibytes":true,"zettabytes_to_exabits":true,"zettabytes_to_exbibits":true,"zettabytes_to_exabytes":true,"zettabytes_to_exbibytes":true,"zettabytes_to_zettabits":true,"zettabytes_to_zebibits":true,"zettabytes_to_zebibytes":true,"zettabytes_to_yottabits":true,"zettabytes_to_yobibits":true,"zettabytes_to_yottabytes":true,"zettabytes_to_yobibytes":true,"zettabytes_to_ronnabits":true,"zettabytes_to_ronnabytes":true,"zettabytes_to_quettabits":true,"zettabytes_to_quettabytes":true,"zebibytes_to_bits":true,"zebibytes_to_nibbles":true,"zebibytes_to_bytes":true,"zebibytes_to_kilobits":true,"zebibytes_to_kibibits":true,"zebibytes_to_kibibytes":true,"zebibytes_to_kilobytes":true,"zebibytes_to_megabits":true,"zebibytes_to_mebibits":true,"zebibytes_to_megabytes":true,"zebibytes_to_mebibytes":true,"zebibytes_to_gigabits":true,"zebibytes_to_gibibits":true,"zebibytes_to_gigabytes":true,"zebibytes_to_gibibytes":true,"zebibytes_to_terabits":true,"zebibytes_to_tebibits":true,"zebibytes_to_terabytes":true,"zebibytes_to_tebibytes":true,"zebibytes_to_petabits":true,"zebibytes_to_pebibits":true,"zebibytes_to_petabytes":true,"zebibytes_to_pebibytes":true,"zebibytes_to_exabits":true,"zebibytes_to_exbibits":true,"zebibytes_to_exabytes":true,"zebibytes_to_exbibytes":true,"zebibytes_to_zettabits":true,"zebibytes_to_zebibits":true,"zebibytes_to_zettabytes":true,"zebibytes_to_yottabits":true,"zebibytes_to_yobibits":true,"zebibytes_to_yottabytes":true,"zebibytes_to_yobibytes":true,"zebibytes_to_ronnabits":true,"zebibytes_to_ronnabytes":true,"zebibytes_to_quettabits":true,"zebibytes_to_quettabytes":true,"yottabits_to_bits":true,"yottabits_to_nibbles":true,"yottabits_to_bytes":true,"yottabits_to_kilobits":true,"yottabits_to_kibibits":true,"yottabits_to_kibibytes":true,"yottabits_to_kilobytes":true,"yottabits_to_megabits":true,"yottabits_to_mebibits":true,"yottabits_to_megabytes":true,"yottabits_to_mebibytes":true,"yottabits_to_gigabits":true,"yottabits_to_gibibits":true,"yottabits_to_gigabytes":true,"yottabits_to_gibibytes":true,"yottabits_to_terabits":true,"yottabits_to_tebibits":true,"yottabits_to_terabytes":true,"yottabits_to_tebibytes":true,"yottabits_to_petabits":true,"yottabits_to_pebibits":true,"yottabits_to_petabytes":true,"yottabits_to_pebibytes":true,"yottabits_to_exabits":true,"yottabits_to_exbibits":true,"yottabits_to_exabytes":true,"yottabits_to_exbibytes":true,"yottabits_to_zettabits":true,"yottabits_to_zebibits":true,"yottabits_to_zettabytes":true,"yottabits_to_zebibytes":true,"yottabits_to_yobibits":true,"yottabits_to_yottabytes":true,"yottabits_to_yobibytes":true,"yottabits_to_ronnabits":true,"yottabits_to_ronnabytes":true,"yottabits_to_quettabits":true,"yottabits_to_quettabytes":true,"yobibits_to_bits":true,"yobibits_to_nibbles":true,"yobibits_to_bytes":true,"yobibits_to_kilobits":true,"yobibits_to_kibibits":true,"yobibits_to_kibibytes":true,"yobibits_to_kilobytes":true,"yobibits_to_megabits":true,"yobibits_to_mebibits":true,"yobibits_to_megabytes":true,"yobibits_to_mebibytes":true,"yobibits_to_gigabits":true,"yobibits_to_gibibits":true,"yobibits_to_gigabytes":true,"yobibits_to_gibibytes":true,"yobibits_to_terabits":true,"yobibits_to_tebibits":true,"yobibits_to_terabytes":true,"yobibits_to_tebibytes":true,"yobibits_to_petabits":true,"yobibits_to_pebibits":true,"yobibits_to_petabytes":true,"yobibits_to_pebibytes":true,"yobibits_to_exabits":true,"yobibits_to_exbibits":true,"yobibits_to_exabytes":true,"yobibits_to_exbibytes":true,"yobibits_to_zettabits":true,"yobibits_to_zebibits":true,"yobibits_to_zettabytes":true,"yobibits_to_zebibytes":true,"yobibits_to_yottabits":true,"yobibits_to_yottabytes":true,"yobibits_to_yobibytes":true,"yobibits_to_ronnabits":true,"yobibits_to_ronnabytes":true,"yobibits_to_quettabits":true,"yobibits_to_quettabytes":true,"yottabytes_to_bits":true,"yottabytes_to_nibbles":true,"yottabytes_to_bytes":true,"yottabytes_to_kilobits":true,"yottabytes_to_kibibits":true,"yottabytes_to_kibibytes":true,"yottabytes_to_kilobytes":true,"yottabytes_to_megabits":true,"yottabytes_to_mebibits":true,"yottabytes_to_megabytes":true,"yottabytes_to_mebibytes":true,"yottabytes_to_gigabits":true,"yottabytes_to_gibibits":true,"yottabytes_to_gigabytes":true,"yottabytes_to_gibibytes":true,"yottabytes_to_terabits":true,"yottabytes_to_tebibits":true,"yottabytes_to_terabytes":true,"yottabytes_to_tebibytes":true,"yottabytes_to_petabits":true,"yottabytes_to_pebibits":true,"yottabytes_to_petabytes":true,"yottabytes_to_pebibytes":true,"yottabytes_to_exabits":true,"yottabytes_to_exbibits":true,"yottabytes_to_exabytes":true,"yottabytes_to_exbibytes":true,"yottabytes_to_zettabits":true,"yottabytes_to_zebibits":true,"yottabytes_to_zettabytes":true,"yottabytes_to_zebibytes":true,"yottabytes_to_yottabits":true,"yottabytes_to_yobibits":true,"yottabytes_to_yobibytes":true,"yottabytes_to_ronnabits":true,"yottabytes_to_ronnabytes":true,"yottabytes_to_quettabits":true,"yottabytes_to_quettabytes":true,"yobibytes_to_bits":true,"yobibytes_to_nibbles":true,"yobibytes_to_bytes":true,"yobibytes_to_kilobits":true,"yobibytes_to_kibibits":true,"yobibytes_to_kibibytes":true,"yobibytes_to_kilobytes":true,"yobibytes_to_megabits":true,"yobibytes_to_mebibits":true,"yobibytes_to_megabytes":true,"yobibytes_to_mebibytes":true,"yobibytes_to_gigabits":true,"yobibytes_to_gibibits":true,"yobibytes_to_gigabytes":true,"yobibytes_to_gibibytes":true,"yobibytes_to_terabits":true,"yobibytes_to_tebibits":true,"yobibytes_to_terabytes":true,"yobibytes_to_tebibytes":true,"yobibytes_to_petabits":true,"yobibytes_to_pebibits":true,"yobibytes_to_petabytes":true,"yobibytes_to_pebibytes":true,"yobibytes_to_exabits":true,"yobibytes_to_exbibits":true,"yobibytes_to_exabytes":true,"yobibytes_to_exbibytes":true,"yobibytes_to_zettabits":true,"yobibytes_to_zebibits":true,"yobibytes_to_zettabytes":true,"yobibytes_to_zebibytes":true,"yobibytes_to_yottabits":true,"yobibytes_to_yobibits":true,"yobibytes_to_yottabytes":true,"yobibytes_to_ronnabits":true,"yobibytes_to_ronnabytes":true,"yobibytes_to_quettabits":true,"yobibytes_to_quettabytes":true,"ronnabits_to_bits":true,"ronnabits_to_nibbles":true,"ronnabits_to_bytes":true,"ronnabits_to_kilobits":true,"ronnabits_to_kibibits":true,"ronnabits_to_kibibytes":true,"ronnabits_to_kilobytes":true,"ronnabits_to_megabits":true,"ronnabits_to_mebibits":true,"ronnabits_to_megabytes":true,"ronnabits_to_mebibytes":true,"ronnabits_to_gigabits":true,"ronnabits_to_gibibits":true,"ronnabits_to_gigabytes":true,"ronnabits_to_gibibytes":true,"ronnabits_to_terabits":true,"ronnabits_to_tebibits":true,"ronnabits_to_terabytes":true,"ronnabits_to_tebibytes":true,"ronnabits_to_petabits":true,"ronnabits_to_pebibits":true,"ronnabits_to_petabytes":true,"ronnabits_to_pebibytes":true,"ronnabits_to_exabits":true,"ronnabits_to_exbibits":true,"ronnabits_to_exabytes":true,"ronnabits_to_exbibytes":true,"ronnabits_to_zettabits":true,"ronnabits_to_zebibits":true,"ronnabits_to_zettabytes":true,"ronnabits_to_zebibytes":true,"ronnabits_to_yottabits":true,"ronnabits_to_yobibits":true,"ronnabits_to_yottabytes":true,"ronnabits_to_yobibytes":true,"ronnabits_to_ronnabytes":true,"ronnabits_to_quettabits":true,"ronnabits_to_quettabytes":true,"ronnabytes_to_bits":true,"ronnabytes_to_nibbles":true,"ronnabytes_to_bytes":true,"ronnabytes_to_kilobits":true,"ronnabytes_to_kibibits":true,"ronnabytes_to_kibibytes":true,"ronnabytes_to_kilobytes":true,"ronnabytes_to_megabits":true,"ronnabytes_to_mebibits":true,"ronnabytes_to_megabytes":true,"ronnabytes_to_mebibytes":true,"ronnabytes_to_gigabits":true,"ronnabytes_to_gibibits":true,"ronnabytes_to_gigabytes":true,"ronnabytes_to_gibibytes":true,"ronnabytes_to_terabits":true,"ronnabytes_to_tebibits":true,"ronnabytes_to_terabytes":true,"ronnabytes_to_tebibytes":true,"ronnabytes_to_petabits":true,"ronnabytes_to_pebibits":true,"ronnabytes_to_petabytes":true,"ronnabytes_to_pebibytes":true,"ronnabytes_to_exabits":true,"ronnabytes_to_exbibits":true,"ronnabytes_to_exabytes":true,"ronnabytes_to_exbibytes":true,"ronnabytes_to_zettabits":true,"ronnabytes_to_zebibits":true,"ronnabytes_to_zettabytes":true,"ronnabytes_to_zebibytes":true,"ronnabytes_to_yottabits":true,"ronnabytes_to_yobibits":true,"ronnabytes_to_yottabytes":true,"ronnabytes_to_yobibytes":true,"ronnabytes_to_ronnabits":true,"ronnabytes_to_quettabits":true,"ronnabytes_to_quettabytes":true,"quettabits_to_bits":true,"quettabits_to_nibbles":true,"quettabits_to_bytes":true,"quettabits_to_kilobits":true,"quettabits_to_kibibits":true,"quettabits_to_kibibytes":true,"quettabits_to_kilobytes":true,"quettabits_to_megabits":true,"quettabits_to_mebibits":true,"quettabits_to_megabytes":true,"quettabits_to_mebibytes":true,"quettabits_to_gigabits":true,"quettabits_to_gibibits":true,"quettabits_to_gigabytes":true,"quettabits_to_gibibytes":true,"quettabits_to_terabits":true,"quettabits_to_tebibits":true,"quettabits_to_terabytes":true,"quettabits_to_tebibytes":true,"quettabits_to_petabits":true,"quettabits_to_pebibits":true,"quettabits_to_petabytes":true,"quettabits_to_pebibytes":true,"quettabits_to_exabits":true,"quettabits_to_exbibits":true,"quettabits_to_exabytes":true,"quettabits_to_exbibytes":true,"quettabits_to_zettabits":true,"quettabits_to_zebibits":true,"quettabits_to_zettabytes":true,"quettabits_to_zebibytes":true,"quettabits_to_yottabits":true,"quettabits_to_yobibits":true,"quettabits_to_yottabytes":true,"quettabits_to_yobibytes":true,"quettabits_to_ronnabits":true,"quettabits_to_ronnabytes":true,"quettabits_to_quettabytes":true,"quettabytes_to_bits":true,"quettabytes_to_nibbles":true,"quettabytes_to_bytes":true,"quettabytes_to_kilobits":true,"quettabytes_to_kibibits":true,"quettabytes_to_kibibytes":true,"quettabytes_to_kilobytes":true,"quettabytes_to_megabits":true,"quettabytes_to_mebibits":true,"quettabytes_to_megabytes":true,"quettabytes_to_mebibytes":true,"quettabytes_to_gigabits":true,"quettabytes_to_gibibits":true,"quettabytes_to_gigabytes":true,"quettabytes_to_gibibytes":true,"quettabytes_to_terabits":true,"quettabytes_to_tebibits":true,"quettabytes_to_terabytes":true,"quettabytes_to_tebibytes":true,"quettabytes_to_petabits":true,"quettabytes_to_pebibits":true,"quettabytes_to_petabytes":true,"quettabytes_to_pebibytes":true,"quettabytes_to_exabits":true,"quettabytes_to_exbibits":true,"quettabytes_to_exabytes":true,"quettabytes_to_exbibytes":true,"quettabytes_to_zettabits":true,"quettabytes_to_zebibits":true,"quettabytes_to_zettabytes":true,"quettabytes_to_zebibytes":true,"quettabytes_to_yottabits":true,"quettabytes_to_yobibits":true,"quettabytes_to_yottabytes":true,"quettabytes_to_yobibytes":true,"quettabytes_to_ronnabits":true,"quettabytes_to_ronnabytes":true,"quettabytes_to_quettabits":true,"hex_to_hexa":true,"hex_to_rgb":true,"hex_to_rgba":true,"hex_to_hsv":true,"hex_to_hsl":true,"hex_to_hsla":true,"hexa_to_hex":true,"hexa_to_rgb":true,"hexa_to_rgba":true,"hexa_to_hsv":true,"hexa_to_hsl":true,"hexa_to_hsla":true,"rgb_to_hex":true,"rgb_to_hexa":true,"rgb_to_rgba":true,"rgb_to_hsv":true,"rgb_to_hsl":true,"rgb_to_hsla":true,"rgba_to_hex":true,"rgba_to_hexa":true,"rgba_to_rgb":true,"rgba_to_hsv":true,"rgba_to_hsl":true,"rgba_to_hsla":true,"hsv_to_hex":true,"hsv_to_hexa":true,"hsv_to_rgb":true,"hsv_to_rgba":true,"hsv_to_hsl":true,"hsv_to_hsla":true,"hsl_to_hex":true,"hsl_to_hexa":true,"hsl_to_rgb":true,"hsl_to_rgba":true,"hsl_to_hsv":true,"hsl_to_hsla":true,"hsla_to_hex":true,"hsla_to_hexa":true,"hsla_to_rgb":true,"hsla_to_rgba":true,"hsla_to_hsv":true,"hsla_to_hsl":true,"nanometers_to_micrometers":true,"nanometers_to_millimeters":true,"nanometers_to_centimeters":true,"nanometers_to_inches":true,"nanometers_to_feet":true,"nanometers_to_yards":true,"nanometers_to_meters":true,"nanometers_to_kilometers":true,"nanometers_to_miles":true,"nanometers_to_lightyears":true,"micrometers_to_nanometers":true,"micrometers_to_millimeters":true,"micrometers_to_centimeters":true,"micrometers_to_inches":true,"micrometers_to_feet":true,"micrometers_to_yards":true,"micrometers_to_meters":true,"micrometers_to_kilometers":true,"micrometers_to_miles":true,"micrometers_to_lightyears":true,"millimeters_to_nanometers":true,"millimeters_to_micrometers":true,"millimeters_to_centimeters":true,"millimeters_to_inches":true,"millimeters_to_feet":true,"millimeters_to_yards":true,"millimeters_to_meters":true,"millimeters_to_kilometers":true,"millimeters_to_miles":true,"millimeters_to_lightyears":true,"centimeters_to_nanometers":true,"centimeters_to_micrometers":true,"centimeters_to_millimeters":true,"centimeters_to_inches":true,"centimeters_to_feet":true,"centimeters_to_yards":true,"centimeters_to_meters":true,"centimeters_to_kilometers":true,"centimeters_to_miles":true,"centimeters_to_lightyears":true,"inches_to_nanometers":true,"inches_to_micrometers":true,"inches_to_millimeters":true,"inches_to_centimeters":true,"inches_to_feet":true,"inches_to_yards":true,"inches_to_meters":true,"inches_to_kilometers":true,"inches_to_miles":true,"inches_to_lightyears":true,"feet_to_nanometers":true,"feet_to_micrometers":true,"feet_to_millimeters":true,"feet_to_centimeters":true,"feet_to_inches":true,"feet_to_yards":true,"feet_to_meters":true,"feet_to_kilometers":true,"feet_to_miles":true,"feet_to_lightyears":true,"yards_to_nanometers":true,"yards_to_micrometers":true,"yards_to_millimeters":true,"yards_to_centimeters":true,"yards_to_inches":true,"yards_to_feet":true,"yards_to_meters":true,"yards_to_kilometers":true,"yards_to_miles":true,"yards_to_lightyears":true,"meters_to_nanometers":true,"meters_to_micrometers":true,"meters_to_millimeters":true,"meters_to_centimeters":true,"meters_to_inches":true,"meters_to_feet":true,"meters_to_yards":true,"meters_to_kilometers":true,"meters_to_miles":true,"meters_to_lightyears":true,"kilometers_to_nanometers":true,"kilometers_to_micrometers":true,"kilometers_to_millimeters":true,"kilometers_to_centimeters":true,"kilometers_to_inches":true,"kilometers_to_feet":true,"kilometers_to_yards":true,"kilometers_to_meters":true,"kilometers_to_miles":true,"kilometers_to_lightyears":true,"miles_to_nanometers":true,"miles_to_micrometers":true,"miles_to_millimeters":true,"miles_to_centimeters":true,"miles_to_inches":true,"miles_to_feet":true,"miles_to_yards":true,"miles_to_meters":true,"miles_to_kilometers":true,"miles_to_lightyears":true,"lightyears_to_nanometers":true,"lightyears_to_micrometers":true,"lightyears_to_millimeters":true,"lightyears_to_centimeters":true,"lightyears_to_inches":true,"lightyears_to_feet":true,"lightyears_to_yards":true,"lightyears_to_meters":true,"lightyears_to_kilometers":true,"lightyears_to_miles":true,"micrograms_to_milligrams":true,"micrograms_to_grams":true,"micrograms_to_ounces":true,"micrograms_to_pounds":true,"micrograms_to_kilograms":true,"micrograms_to_stones":true,"micrograms_to_us_tons":true,"micrograms_to_imperial_tons":true,"micrograms_to_tonnes":true,"micrograms_to_nanograms":true,"micrograms_to_centigrams":true,"micrograms_to_decigrams":true,"micrograms_to_megagrams":true,"micrograms_to_drams":true,"micrograms_to_grains":true,"micrograms_to_carats":true,"milligrams_to_micrograms":true,"milligrams_to_grams":true,"milligrams_to_ounces":true,"milligrams_to_pounds":true,"milligrams_to_kilograms":true,"milligrams_to_stones":true,"milligrams_to_us_tons":true,"milligrams_to_imperial_tons":true,"milligrams_to_tonnes":true,"milligrams_to_nanograms":true,"milligrams_to_centigrams":true,"milligrams_to_decigrams":true,"milligrams_to_megagrams":true,"milligrams_to_drams":true,"milligrams_to_grains":true,"milligrams_to_carats":true,"grams_to_micrograms":true,"grams_to_milligrams":true,"grams_to_ounces":true,"grams_to_pounds":true,"grams_to_kilograms":true,"grams_to_stones":true,"grams_to_us_tons":true,"grams_to_imperial_tons":true,"grams_to_tonnes":true,"grams_to_nanograms":true,"grams_to_centigrams":true,"grams_to_decigrams":true,"grams_to_megagrams":true,"grams_to_drams":true,"grams_to_grains":true,"grams_to_carats":true,"ounces_to_micrograms":true,"ounces_to_milligrams":true,"ounces_to_grams":true,"ounces_to_pounds":true,"ounces_to_kilograms":true,"ounces_to_stones":true,"ounces_to_us_tons":true,"ounces_to_imperial_tons":true,"ounces_to_tonnes":true,"ounces_to_nanograms":true,"ounces_to_centigrams":true,"ounces_to_decigrams":true,"ounces_to_megagrams":true,"ounces_to_drams":true,"ounces_to_grains":true,"ounces_to_carats":true,"pounds_to_micrograms":true,"pounds_to_milligrams":true,"pounds_to_grams":true,"pounds_to_ounces":true,"pounds_to_kilograms":true,"pounds_to_stones":true,"pounds_to_us_tons":true,"pounds_to_imperial_tons":true,"pounds_to_tonnes":true,"pounds_to_nanograms":true,"pounds_to_centigrams":true,"pounds_to_decigrams":true,"pounds_to_megagrams":true,"pounds_to_drams":true,"pounds_to_grains":true,"pounds_to_carats":true,"kilograms_to_micrograms":true,"kilograms_to_milligrams":true,"kilograms_to_grams":true,"kilograms_to_ounces":true,"kilograms_to_pounds":true,"kilograms_to_stones":true,"kilograms_to_us_tons":true,"kilograms_to_imperial_tons":true,"kilograms_to_tonnes":true,"kilograms_to_nanograms":true,"kilograms_to_centigrams":true,"kilograms_to_decigrams":true,"kilograms_to_megagrams":true,"kilograms_to_drams":true,"kilograms_to_grains":true,"kilograms_to_carats":true,"stones_to_micrograms":true,"stones_to_milligrams":true,"stones_to_grams":true,"stones_to_ounces":true,"stones_to_pounds":true,"stones_to_kilograms":true,"stones_to_us_tons":true,"stones_to_imperial_tons":true,"stones_to_tonnes":true,"stones_to_nanograms":true,"stones_to_centigrams":true,"stones_to_decigrams":true,"stones_to_megagrams":true,"stones_to_drams":true,"stones_to_grains":true,"stones_to_carats":true,"us_tons_to_micrograms":true,"us_tons_to_milligrams":true,"us_tons_to_grams":true,"us_tons_to_ounces":true,"us_tons_to_pounds":true,"us_tons_to_kilograms":true,"us_tons_to_stones":true,"us_tons_to_imperial_tons":true,"us_tons_to_tonnes":true,"us_tons_to_nanograms":true,"us_tons_to_centigrams":true,"us_tons_to_decigrams":true,"us_tons_to_megagrams":true,"us_tons_to_drams":true,"us_tons_to_grains":true,"us_tons_to_carats":true,"imperial_tons_to_micrograms":true,"imperial_tons_to_milligrams":true,"imperial_tons_to_grams":true,"imperial_tons_to_ounces":true,"imperial_tons_to_pounds":true,"imperial_tons_to_kilograms":true,"imperial_tons_to_stones":true,"imperial_tons_to_us_tons":true,"imperial_tons_to_tonnes":true,"imperial_tons_to_nanograms":true,"imperial_tons_to_centigrams":true,"imperial_tons_to_decigrams":true,"imperial_tons_to_megagrams":true,"imperial_tons_to_drams":true,"imperial_tons_to_grains":true,"imperial_tons_to_carats":true,"tonnes_to_micrograms":true,"tonnes_to_milligrams":true,"tonnes_to_grams":true,"tonnes_to_ounces":true,"tonnes_to_pounds":true,"tonnes_to_kilograms":true,"tonnes_to_stones":true,"tonnes_to_us_tons":true,"tonnes_to_imperial_tons":true,"tonnes_to_nanograms":true,"tonnes_to_centigrams":true,"tonnes_to_decigrams":true,"tonnes_to_megagrams":true,"tonnes_to_drams":true,"tonnes_to_grains":true,"tonnes_to_carats":true,"nanograms_to_micrograms":true,"nanograms_to_milligrams":true,"nanograms_to_grams":true,"nanograms_to_ounces":true,"nanograms_to_pounds":true,"nanograms_to_kilograms":true,"nanograms_to_stones":true,"nanograms_to_us_tons":true,"nanograms_to_imperial_tons":true,"nanograms_to_tonnes":true,"nanograms_to_centigrams":true,"nanograms_to_decigrams":true,"nanograms_to_megagrams":true,"nanograms_to_drams":true,"nanograms_to_grains":true,"nanograms_to_carats":true,"centigrams_to_micrograms":true,"centigrams_to_milligrams":true,"centigrams_to_grams":true,"centigrams_to_ounces":true,"centigrams_to_pounds":true,"centigrams_to_kilograms":true,"centigrams_to_stones":true,"centigrams_to_us_tons":true,"centigrams_to_imperial_tons":true,"centigrams_to_tonnes":true,"centigrams_to_nanograms":true,"centigrams_to_decigrams":true,"centigrams_to_megagrams":true,"centigrams_to_drams":true,"centigrams_to_grains":true,"centigrams_to_carats":true,"decigrams_to_micrograms":true,"decigrams_to_milligrams":true,"decigrams_to_grams":true,"decigrams_to_ounces":true,"decigrams_to_pounds":true,"decigrams_to_kilograms":true,"decigrams_to_stones":true,"decigrams_to_us_tons":true,"decigrams_to_imperial_tons":true,"decigrams_to_tonnes":true,"decigrams_to_nanograms":true,"decigrams_to_centigrams":true,"decigrams_to_megagrams":true,"decigrams_to_drams":true,"decigrams_to_grains":true,"decigrams_to_carats":true,"megagrams_to_micrograms":true,"megagrams_to_milligrams":true,"megagrams_to_grams":true,"megagrams_to_ounces":true,"megagrams_to_pounds":true,"megagrams_to_kilograms":true,"megagrams_to_stones":true,"megagrams_to_us_tons":true,"megagrams_to_imperial_tons":true,"megagrams_to_tonnes":true,"megagrams_to_nanograms":true,"megagrams_to_centigrams":true,"megagrams_to_decigrams":true,"megagrams_to_drams":true,"megagrams_to_grains":true,"megagrams_to_carats":true,"drams_to_micrograms":true,"drams_to_milligrams":true,"drams_to_grams":true,"drams_to_ounces":true,"drams_to_pounds":true,"drams_to_kilograms":true,"drams_to_stones":true,"drams_to_us_tons":true,"drams_to_imperial_tons":true,"drams_to_tonnes":true,"drams_to_nanograms":true,"drams_to_centigrams":true,"drams_to_decigrams":true,"drams_to_megagrams":true,"drams_to_grains":true,"drams_to_carats":true,"grains_to_micrograms":true,"grains_to_milligrams":true,"grains_to_grams":true,"grains_to_ounces":true,"grains_to_pounds":true,"grains_to_kilograms":true,"grains_to_stones":true,"grains_to_us_tons":true,"grains_to_imperial_tons":true,"grains_to_tonnes":true,"grains_to_nanograms":true,"grains_to_centigrams":true,"grains_to_decigrams":true,"grains_to_megagrams":true,"grains_to_drams":true,"grains_to_carats":true,"carats_to_micrograms":true,"carats_to_milligrams":true,"carats_to_grams":true,"carats_to_ounces":true,"carats_to_pounds":true,"carats_to_kilograms":true,"carats_to_stones":true,"carats_to_us_tons":true,"carats_to_imperial_tons":true,"carats_to_tonnes":true,"carats_to_nanograms":true,"carats_to_centigrams":true,"carats_to_decigrams":true,"carats_to_megagrams":true,"carats_to_drams":true,"carats_to_grains":true,"cubic_meters_to_cubic_kilometers":true,"cubic_meters_to_cubic_centimeters":true,"cubic_meters_to_cubic_millimeters":true,"cubic_meters_to_liters":true,"cubic_meters_to_milliliters":true,"cubic_meters_to_us_gallons":true,"cubic_meters_to_us_quarts":true,"cubic_meters_to_us_pints":true,"cubic_meters_to_us_cups":true,"cubic_meters_to_us_fluid_ounces":true,"cubic_meters_to_us_tablespoons":true,"cubic_meters_to_us_teaspoons":true,"cubic_meters_to_imperial_gallons":true,"cubic_meters_to_imperial_quarts":true,"cubic_meters_to_imperial_pints":true,"cubic_meters_to_imperial_fluid_ounces":true,"cubic_meters_to_imperial_tablespoons":true,"cubic_meters_to_imperial_teaspoons":true,"cubic_meters_to_cubic_miles":true,"cubic_meters_to_cubic_yards":true,"cubic_meters_to_cubic_feet":true,"cubic_meters_to_cubic_inches":true,"cubic_kilometers_to_cubic_meters":true,"cubic_kilometers_to_cubic_centimeters":true,"cubic_kilometers_to_cubic_millimeters":true,"cubic_kilometers_to_liters":true,"cubic_kilometers_to_milliliters":true,"cubic_kilometers_to_us_gallons":true,"cubic_kilometers_to_us_quarts":true,"cubic_kilometers_to_us_pints":true,"cubic_kilometers_to_us_cups":true,"cubic_kilometers_to_us_fluid_ounces":true,"cubic_kilometers_to_us_tablespoons":true,"cubic_kilometers_to_us_teaspoons":true,"cubic_kilometers_to_imperial_gallons":true,"cubic_kilometers_to_imperial_quarts":true,"cubic_kilometers_to_imperial_pints":true,"cubic_kilometers_to_imperial_fluid_ounces":true,"cubic_kilometers_to_imperial_tablespoons":true,"cubic_kilometers_to_imperial_teaspoons":true,"cubic_kilometers_to_cubic_miles":true,"cubic_kilometers_to_cubic_yards":true,"cubic_kilometers_to_cubic_feet":true,"cubic_kilometers_to_cubic_inches":true,"cubic_centimeters_to_cubic_meters":true,"cubic_centimeters_to_cubic_kilometers":true,"cubic_centimeters_to_cubic_millimeters":true,"cubic_centimeters_to_liters":true,"cubic_centimeters_to_milliliters":true,"cubic_centimeters_to_us_gallons":true,"cubic_centimeters_to_us_quarts":true,"cubic_centimeters_to_us_pints":true,"cubic_centimeters_to_us_cups":true,"cubic_centimeters_to_us_fluid_ounces":true,"cubic_centimeters_to_us_tablespoons":true,"cubic_centimeters_to_us_teaspoons":true,"cubic_centimeters_to_imperial_gallons":true,"cubic_centimeters_to_imperial_quarts":true,"cubic_centimeters_to_imperial_pints":true,"cubic_centimeters_to_imperial_fluid_ounces":true,"cubic_centimeters_to_imperial_tablespoons":true,"cubic_centimeters_to_imperial_teaspoons":true,"cubic_centimeters_to_cubic_miles":true,"cubic_centimeters_to_cubic_yards":true,"cubic_centimeters_to_cubic_feet":true,"cubic_centimeters_to_cubic_inches":true,"cubic_millimeters_to_cubic_meters":true,"cubic_millimeters_to_cubic_kilometers":true,"cubic_millimeters_to_cubic_centimeters":true,"cubic_millimeters_to_liters":true,"cubic_millimeters_to_milliliters":true,"cubic_millimeters_to_us_gallons":true,"cubic_millimeters_to_us_quarts":true,"cubic_millimeters_to_us_pints":true,"cubic_millimeters_to_us_cups":true,"cubic_millimeters_to_us_fluid_ounces":true,"cubic_millimeters_to_us_tablespoons":true,"cubic_millimeters_to_us_teaspoons":true,"cubic_millimeters_to_imperial_gallons":true,"cubic_millimeters_to_imperial_quarts":true,"cubic_millimeters_to_imperial_pints":true,"cubic_millimeters_to_imperial_fluid_ounces":true,"cubic_millimeters_to_imperial_tablespoons":true,"cubic_millimeters_to_imperial_teaspoons":true,"cubic_millimeters_to_cubic_miles":true,"cubic_millimeters_to_cubic_yards":true,"cubic_millimeters_to_cubic_feet":true,"cubic_millimeters_to_cubic_inches":true,"liters_to_cubic_meters":true,"liters_to_cubic_kilometers":true,"liters_to_cubic_centimeters":true,"liters_to_cubic_millimeters":true,"liters_to_milliliters":true,"liters_to_us_gallons":true,"liters_to_us_quarts":true,"liters_to_us_pints":true,"liters_to_us_cups":true,"liters_to_us_fluid_ounces":true,"liters_to_us_tablespoons":true,"liters_to_us_teaspoons":true,"liters_to_imperial_gallons":true,"liters_to_imperial_quarts":true,"liters_to_imperial_pints":true,"liters_to_imperial_fluid_ounces":true,"liters_to_imperial_tablespoons":true,"liters_to_imperial_teaspoons":true,"liters_to_cubic_miles":true,"liters_to_cubic_yards":true,"liters_to_cubic_feet":true,"liters_to_cubic_inches":true,"milliliters_to_cubic_meters":true,"milliliters_to_cubic_kilometers":true,"milliliters_to_cubic_centimeters":true,"milliliters_to_cubic_millimeters":true,"milliliters_to_liters":true,"milliliters_to_us_gallons":true,"milliliters_to_us_quarts":true,"milliliters_to_us_pints":true,"milliliters_to_us_cups":true,"milliliters_to_us_fluid_ounces":true,"milliliters_to_us_tablespoons":true,"milliliters_to_us_teaspoons":true,"milliliters_to_imperial_gallons":true,"milliliters_to_imperial_quarts":true,"milliliters_to_imperial_pints":true,"milliliters_to_imperial_fluid_ounces":true,"milliliters_to_imperial_tablespoons":true,"milliliters_to_imperial_teaspoons":true,"milliliters_to_cubic_miles":true,"milliliters_to_cubic_yards":true,"milliliters_to_cubic_feet":true,"milliliters_to_cubic_inches":true,"us_gallons_to_cubic_meters":true,"us_gallons_to_cubic_kilometers":true,"us_gallons_to_cubic_centimeters":true,"us_gallons_to_cubic_millimeters":true,"us_gallons_to_liters":true,"us_gallons_to_milliliters":true,"us_gallons_to_us_quarts":true,"us_gallons_to_us_pints":true,"us_gallons_to_us_cups":true,"us_gallons_to_us_fluid_ounces":true,"us_gallons_to_us_tablespoons":true,"us_gallons_to_us_teaspoons":true,"us_gallons_to_imperial_gallons":true,"us_gallons_to_imperial_quarts":true,"us_gallons_to_imperial_pints":true,"us_gallons_to_imperial_fluid_ounces":true,"us_gallons_to_imperial_tablespoons":true,"us_gallons_to_imperial_teaspoons":true,"us_gallons_to_cubic_miles":true,"us_gallons_to_cubic_yards":true,"us_gallons_to_cubic_feet":true,"us_gallons_to_cubic_inches":true,"us_quarts_to_cubic_meters":true,"us_quarts_to_cubic_kilometers":true,"us_quarts_to_cubic_centimeters":true,"us_quarts_to_cubic_millimeters":true,"us_quarts_to_liters":true,"us_quarts_to_milliliters":true,"us_quarts_to_us_gallons":true,"us_quarts_to_us_pints":true,"us_quarts_to_us_cups":true,"us_quarts_to_us_fluid_ounces":true,"us_quarts_to_us_tablespoons":true,"us_quarts_to_us_teaspoons":true,"us_quarts_to_imperial_gallons":true,"us_quarts_to_imperial_quarts":true,"us_quarts_to_imperial_pints":true,"us_quarts_to_imperial_fluid_ounces":true,"us_quarts_to_imperial_tablespoons":true,"us_quarts_to_imperial_teaspoons":true,"us_quarts_to_cubic_miles":true,"us_quarts_to_cubic_yards":true,"us_quarts_to_cubic_feet":true,"us_quarts_to_cubic_inches":true,"us_pints_to_cubic_meters":true,"us_pints_to_cubic_kilometers":true,"us_pints_to_cubic_centimeters":true,"us_pints_to_cubic_millimeters":true,"us_pints_to_liters":true,"us_pints_to_milliliters":true,"us_pints_to_us_gallons":true,"us_pints_to_us_quarts":true,"us_pints_to_us_cups":true,"us_pints_to_us_fluid_ounces":true,"us_pints_to_us_tablespoons":true,"us_pints_to_us_teaspoons":true,"us_pints_to_imperial_gallons":true,"us_pints_to_imperial_quarts":true,"us_pints_to_imperial_pints":true,"us_pints_to_imperial_fluid_ounces":true,"us_pints_to_imperial_tablespoons":true,"us_pints_to_imperial_teaspoons":true,"us_pints_to_cubic_miles":true,"us_pints_to_cubic_yards":true,"us_pints_to_cubic_feet":true,"us_pints_to_cubic_inches":true,"us_cups_to_cubic_meters":true,"us_cups_to_cubic_kilometers":true,"us_cups_to_cubic_centimeters":true,"us_cups_to_cubic_millimeters":true,"us_cups_to_liters":true,"us_cups_to_milliliters":true,"us_cups_to_us_gallons":true,"us_cups_to_us_quarts":true,"us_cups_to_us_pints":true,"us_cups_to_us_fluid_ounces":true,"us_cups_to_us_tablespoons":true,"us_cups_to_us_teaspoons":true,"us_cups_to_imperial_gallons":true,"us_cups_to_imperial_quarts":true,"us_cups_to_imperial_pints":true,"us_cups_to_imperial_fluid_ounces":true,"us_cups_to_imperial_tablespoons":true,"us_cups_to_imperial_teaspoons":true,"us_cups_to_cubic_miles":true,"us_cups_to_cubic_yards":true,"us_cups_to_cubic_feet":true,"us_cups_to_cubic_inches":true,"us_fluid_ounces_to_cubic_meters":true,"us_fluid_ounces_to_cubic_kilometers":true,"us_fluid_ounces_to_cubic_centimeters":true,"us_fluid_ounces_to_cubic_millimeters":true,"us_fluid_ounces_to_liters":true,"us_fluid_ounces_to_milliliters":true,"us_fluid_ounces_to_us_gallons":true,"us_fluid_ounces_to_us_quarts":true,"us_fluid_ounces_to_us_pints":true,"us_fluid_ounces_to_us_cups":true,"us_fluid_ounces_to_us_tablespoons":true,"us_fluid_ounces_to_us_teaspoons":true,"us_fluid_ounces_to_imperial_gallons":true,"us_fluid_ounces_to_imperial_quarts":true,"us_fluid_ounces_to_imperial_pints":true,"us_fluid_ounces_to_imperial_fluid_ounces":true,"us_fluid_ounces_to_imperial_tablespoons":true,"us_fluid_ounces_to_imperial_teaspoons":true,"us_fluid_ounces_to_cubic_miles":true,"us_fluid_ounces_to_cubic_yards":true,"us_fluid_ounces_to_cubic_feet":true,"us_fluid_ounces_to_cubic_inches":true,"us_tablespoons_to_cubic_meters":true,"us_tablespoons_to_cubic_kilometers":true,"us_tablespoons_to_cubic_centimeters":true,"us_tablespoons_to_cubic_millimeters":true,"us_tablespoons_to_liters":true,"us_tablespoons_to_milliliters":true,"us_tablespoons_to_us_gallons":true,"us_tablespoons_to_us_quarts":true,"us_tablespoons_to_us_pints":true,"us_tablespoons_to_us_cups":true,"us_tablespoons_to_us_fluid_ounces":true,"us_tablespoons_to_us_teaspoons":true,"us_tablespoons_to_imperial_gallons":true,"us_tablespoons_to_imperial_quarts":true,"us_tablespoons_to_imperial_pints":true,"us_tablespoons_to_imperial_fluid_ounces":true,"us_tablespoons_to_imperial_tablespoons":true,"us_tablespoons_to_imperial_teaspoons":true,"us_tablespoons_to_cubic_miles":true,"us_tablespoons_to_cubic_yards":true,"us_tablespoons_to_cubic_feet":true,"us_tablespoons_to_cubic_inches":true,"us_teaspoons_to_cubic_meters":true,"us_teaspoons_to_cubic_kilometers":true,"us_teaspoons_to_cubic_centimeters":true,"us_teaspoons_to_cubic_millimeters":true,"us_teaspoons_to_liters":true,"us_teaspoons_to_milliliters":true,"us_teaspoons_to_us_gallons":true,"us_teaspoons_to_us_quarts":true,"us_teaspoons_to_us_pints":true,"us_teaspoons_to_us_cups":true,"us_teaspoons_to_us_fluid_ounces":true,"us_teaspoons_to_us_tablespoons":true,"us_teaspoons_to_imperial_gallons":true,"us_teaspoons_to_imperial_quarts":true,"us_teaspoons_to_imperial_pints":true,"us_teaspoons_to_imperial_fluid_ounces":true,"us_teaspoons_to_imperial_tablespoons":true,"us_teaspoons_to_imperial_teaspoons":true,"us_teaspoons_to_cubic_miles":true,"us_teaspoons_to_cubic_yards":true,"us_teaspoons_to_cubic_feet":true,"us_teaspoons_to_cubic_inches":true,"imperial_gallons_to_cubic_meters":true,"imperial_gallons_to_cubic_kilometers":true,"imperial_gallons_to_cubic_centimeters":true,"imperial_gallons_to_cubic_millimeters":true,"imperial_gallons_to_liters":true,"imperial_gallons_to_milliliters":true,"imperial_gallons_to_us_gallons":true,"imperial_gallons_to_us_quarts":true,"imperial_gallons_to_us_pints":true,"imperial_gallons_to_us_cups":true,"imperial_gallons_to_us_fluid_ounces":true,"imperial_gallons_to_us_tablespoons":true,"imperial_gallons_to_us_teaspoons":true,"imperial_gallons_to_imperial_quarts":true,"imperial_gallons_to_imperial_pints":true,"imperial_gallons_to_imperial_fluid_ounces":true,"imperial_gallons_to_imperial_tablespoons":true,"imperial_gallons_to_imperial_teaspoons":true,"imperial_gallons_to_cubic_miles":true,"imperial_gallons_to_cubic_yards":true,"imperial_gallons_to_cubic_feet":true,"imperial_gallons_to_cubic_inches":true,"imperial_quarts_to_cubic_meters":true,"imperial_quarts_to_cubic_kilometers":true,"imperial_quarts_to_cubic_centimeters":true,"imperial_quarts_to_cubic_millimeters":true,"imperial_quarts_to_liters":true,"imperial_quarts_to_milliliters":true,"imperial_quarts_to_us_gallons":true,"imperial_quarts_to_us_quarts":true,"imperial_quarts_to_us_pints":true,"imperial_quarts_to_us_cups":true,"imperial_quarts_to_us_fluid_ounces":true,"imperial_quarts_to_us_tablespoons":true,"imperial_quarts_to_us_teaspoons":true,"imperial_quarts_to_imperial_gallons":true,"imperial_quarts_to_imperial_pints":true,"imperial_quarts_to_imperial_fluid_ounces":true,"imperial_quarts_to_imperial_tablespoons":true,"imperial_quarts_to_imperial_teaspoons":true,"imperial_quarts_to_cubic_miles":true,"imperial_quarts_to_cubic_yards":true,"imperial_quarts_to_cubic_feet":true,"imperial_quarts_to_cubic_inches":true,"imperial_pints_to_cubic_meters":true,"imperial_pints_to_cubic_kilometers":true,"imperial_pints_to_cubic_centimeters":true,"imperial_pints_to_cubic_millimeters":true,"imperial_pints_to_liters":true,"imperial_pints_to_milliliters":true,"imperial_pints_to_us_gallons":true,"imperial_pints_to_us_quarts":true,"imperial_pints_to_us_pints":true,"imperial_pints_to_us_cups":true,"imperial_pints_to_us_fluid_ounces":true,"imperial_pints_to_us_tablespoons":true,"imperial_pints_to_us_teaspoons":true,"imperial_pints_to_imperial_gallons":true,"imperial_pints_to_imperial_quarts":true,"imperial_pints_to_imperial_fluid_ounces":true,"imperial_pints_to_imperial_tablespoons":true,"imperial_pints_to_imperial_teaspoons":true,"imperial_pints_to_cubic_miles":true,"imperial_pints_to_cubic_yards":true,"imperial_pints_to_cubic_feet":true,"imperial_pints_to_cubic_inches":true,"imperial_fluid_ounces_to_cubic_meters":true,"imperial_fluid_ounces_to_cubic_kilometers":true,"imperial_fluid_ounces_to_cubic_centimeters":true,"imperial_fluid_ounces_to_cubic_millimeters":true,"imperial_fluid_ounces_to_liters":true,"imperial_fluid_ounces_to_milliliters":true,"imperial_fluid_ounces_to_us_gallons":true,"imperial_fluid_ounces_to_us_quarts":true,"imperial_fluid_ounces_to_us_pints":true,"imperial_fluid_ounces_to_us_cups":true,"imperial_fluid_ounces_to_us_fluid_ounces":true,"imperial_fluid_ounces_to_us_tablespoons":true,"imperial_fluid_ounces_to_us_teaspoons":true,"imperial_fluid_ounces_to_imperial_gallons":true,"imperial_fluid_ounces_to_imperial_quarts":true,"imperial_fluid_ounces_to_imperial_pints":true,"imperial_fluid_ounces_to_imperial_tablespoons":true,"imperial_fluid_ounces_to_imperial_teaspoons":true,"imperial_fluid_ounces_to_cubic_miles":true,"imperial_fluid_ounces_to_cubic_yards":true,"imperial_fluid_ounces_to_cubic_feet":true,"imperial_fluid_ounces_to_cubic_inches":true,"imperial_tablespoons_to_cubic_meters":true,"imperial_tablespoons_to_cubic_kilometers":true,"imperial_tablespoons_to_cubic_centimeters":true,"imperial_tablespoons_to_cubic_millimeters":true,"imperial_tablespoons_to_liters":true,"imperial_tablespoons_to_milliliters":true,"imperial_tablespoons_to_us_gallons":true,"imperial_tablespoons_to_us_quarts":true,"imperial_tablespoons_to_us_pints":true,"imperial_tablespoons_to_us_cups":true,"imperial_tablespoons_to_us_fluid_ounces":true,"imperial_tablespoons_to_us_tablespoons":true,"imperial_tablespoons_to_us_teaspoons":true,"imperial_tablespoons_to_imperial_gallons":true,"imperial_tablespoons_to_imperial_quarts":true,"imperial_tablespoons_to_imperial_pints":true,"imperial_tablespoons_to_imperial_fluid_ounces":true,"imperial_tablespoons_to_imperial_teaspoons":true,"imperial_tablespoons_to_cubic_miles":true,"imperial_tablespoons_to_cubic_yards":true,"imperial_tablespoons_to_cubic_feet":true,"imperial_tablespoons_to_cubic_inches":true,"imperial_teaspoons_to_cubic_meters":true,"imperial_teaspoons_to_cubic_kilometers":true,"imperial_teaspoons_to_cubic_centimeters":true,"imperial_teaspoons_to_cubic_millimeters":true,"imperial_teaspoons_to_liters":true,"imperial_teaspoons_to_milliliters":true,"imperial_teaspoons_to_us_gallons":true,"imperial_teaspoons_to_us_quarts":true,"imperial_teaspoons_to_us_pints":true,"imperial_teaspoons_to_us_cups":true,"imperial_teaspoons_to_us_fluid_ounces":true,"imperial_teaspoons_to_us_tablespoons":true,"imperial_teaspoons_to_us_teaspoons":true,"imperial_teaspoons_to_imperial_gallons":true,"imperial_teaspoons_to_imperial_quarts":true,"imperial_teaspoons_to_imperial_pints":true,"imperial_teaspoons_to_imperial_fluid_ounces":true,"imperial_teaspoons_to_imperial_tablespoons":true,"imperial_teaspoons_to_cubic_miles":true,"imperial_teaspoons_to_cubic_yards":true,"imperial_teaspoons_to_cubic_feet":true,"imperial_teaspoons_to_cubic_inches":true,"cubic_miles_to_cubic_meters":true,"cubic_miles_to_cubic_kilometers":true,"cubic_miles_to_cubic_centimeters":true,"cubic_miles_to_cubic_millimeters":true,"cubic_miles_to_liters":true,"cubic_miles_to_milliliters":true,"cubic_miles_to_us_gallons":true,"cubic_miles_to_us_quarts":true,"cubic_miles_to_us_pints":true,"cubic_miles_to_us_cups":true,"cubic_miles_to_us_fluid_ounces":true,"cubic_miles_to_us_tablespoons":true,"cubic_miles_to_us_teaspoons":true,"cubic_miles_to_imperial_gallons":true,"cubic_miles_to_imperial_quarts":true,"cubic_miles_to_imperial_pints":true,"cubic_miles_to_imperial_fluid_ounces":true,"cubic_miles_to_imperial_tablespoons":true,"cubic_miles_to_imperial_teaspoons":true,"cubic_miles_to_cubic_yards":true,"cubic_miles_to_cubic_feet":true,"cubic_miles_to_cubic_inches":true,"cubic_yards_to_cubic_meters":true,"cubic_yards_to_cubic_kilometers":true,"cubic_yards_to_cubic_centimeters":true,"cubic_yards_to_cubic_millimeters":true,"cubic_yards_to_liters":true,"cubic_yards_to_milliliters":true,"cubic_yards_to_us_gallons":true,"cubic_yards_to_us_quarts":true,"cubic_yards_to_us_pints":true,"cubic_yards_to_us_cups":true,"cubic_yards_to_us_fluid_ounces":true,"cubic_yards_to_us_tablespoons":true,"cubic_yards_to_us_teaspoons":true,"cubic_yards_to_imperial_gallons":true,"cubic_yards_to_imperial_quarts":true,"cubic_yards_to_imperial_pints":true,"cubic_yards_to_imperial_fluid_ounces":true,"cubic_yards_to_imperial_tablespoons":true,"cubic_yards_to_imperial_teaspoons":true,"cubic_yards_to_cubic_miles":true,"cubic_yards_to_cubic_feet":true,"cubic_yards_to_cubic_inches":true,"cubic_feet_to_cubic_meters":true,"cubic_feet_to_cubic_kilometers":true,"cubic_feet_to_cubic_centimeters":true,"cubic_feet_to_cubic_millimeters":true,"cubic_feet_to_liters":true,"cubic_feet_to_milliliters":true,"cubic_feet_to_us_gallons":true,"cubic_feet_to_us_quarts":true,"cubic_feet_to_us_pints":true,"cubic_feet_to_us_cups":true,"cubic_feet_to_us_fluid_ounces":true,"cubic_feet_to_us_tablespoons":true,"cubic_feet_to_us_teaspoons":true,"cubic_feet_to_imperial_gallons":true,"cubic_feet_to_imperial_quarts":true,"cubic_feet_to_imperial_pints":true,"cubic_feet_to_imperial_fluid_ounces":true,"cubic_feet_to_imperial_tablespoons":true,"cubic_feet_to_imperial_teaspoons":true,"cubic_feet_to_cubic_miles":true,"cubic_feet_to_cubic_yards":true,"cubic_feet_to_cubic_inches":true,"cubic_inches_to_cubic_meters":true,"cubic_inches_to_cubic_kilometers":true,"cubic_inches_to_cubic_centimeters":true,"cubic_inches_to_cubic_millimeters":true,"cubic_inches_to_liters":true,"cubic_inches_to_milliliters":true,"cubic_inches_to_us_gallons":true,"cubic_inches_to_us_quarts":true,"cubic_inches_to_us_pints":true,"cubic_inches_to_us_cups":true,"cubic_inches_to_us_fluid_ounces":true,"cubic_inches_to_us_tablespoons":true,"cubic_inches_to_us_teaspoons":true,"cubic_inches_to_imperial_gallons":true,"cubic_inches_to_imperial_quarts":true,"cubic_inches_to_imperial_pints":true,"cubic_inches_to_imperial_fluid_ounces":true,"cubic_inches_to_imperial_tablespoons":true,"cubic_inches_to_imperial_teaspoons":true,"cubic_inches_to_cubic_miles":true,"cubic_inches_to_cubic_yards":true,"cubic_inches_to_cubic_feet":true,"square_meters_to_square_kilometers":true,"square_meters_to_square_centimeters":true,"square_meters_to_square_millimeters":true,"square_meters_to_square_micrometers":true,"square_meters_to_hectares":true,"square_meters_to_square_miles":true,"square_meters_to_square_yards":true,"square_meters_to_square_feet":true,"square_meters_to_square_inches":true,"square_meters_to_acres":true,"square_meters_to_square_decimeters":true,"square_meters_to_square_nanometers":true,"square_meters_to_ares":true,"square_kilometers_to_square_meters":true,"square_kilometers_to_square_centimeters":true,"square_kilometers_to_square_millimeters":true,"square_kilometers_to_square_micrometers":true,"square_kilometers_to_hectares":true,"square_kilometers_to_square_miles":true,"square_kilometers_to_square_yards":true,"square_kilometers_to_square_feet":true,"square_kilometers_to_square_inches":true,"square_kilometers_to_acres":true,"square_kilometers_to_square_decimeters":true,"square_kilometers_to_square_nanometers":true,"square_kilometers_to_ares":true,"square_centimeters_to_square_meters":true,"square_centimeters_to_square_kilometers":true,"square_centimeters_to_square_millimeters":true,"square_centimeters_to_square_micrometers":true,"square_centimeters_to_hectares":true,"square_centimeters_to_square_miles":true,"square_centimeters_to_square_yards":true,"square_centimeters_to_square_feet":true,"square_centimeters_to_square_inches":true,"square_centimeters_to_acres":true,"square_centimeters_to_square_decimeters":true,"square_centimeters_to_square_nanometers":true,"square_centimeters_to_ares":true,"square_millimeters_to_square_meters":true,"square_millimeters_to_square_kilometers":true,"square_millimeters_to_square_centimeters":true,"square_millimeters_to_square_micrometers":true,"square_millimeters_to_hectares":true,"square_millimeters_to_square_miles":true,"square_millimeters_to_square_yards":true,"square_millimeters_to_square_feet":true,"square_millimeters_to_square_inches":true,"square_millimeters_to_acres":true,"square_millimeters_to_square_decimeters":true,"square_millimeters_to_square_nanometers":true,"square_millimeters_to_ares":true,"square_micrometers_to_square_meters":true,"square_micrometers_to_square_kilometers":true,"square_micrometers_to_square_centimeters":true,"square_micrometers_to_square_millimeters":true,"square_micrometers_to_hectares":true,"square_micrometers_to_square_miles":true,"square_micrometers_to_square_yards":true,"square_micrometers_to_square_feet":true,"square_micrometers_to_square_inches":true,"square_micrometers_to_acres":true,"square_micrometers_to_square_decimeters":true,"square_micrometers_to_square_nanometers":true,"square_micrometers_to_ares":true,"hectares_to_square_meters":true,"hectares_to_square_kilometers":true,"hectares_to_square_centimeters":true,"hectares_to_square_millimeters":true,"hectares_to_square_micrometers":true,"hectares_to_square_miles":true,"hectares_to_square_yards":true,"hectares_to_square_feet":true,"hectares_to_square_inches":true,"hectares_to_acres":true,"hectares_to_square_decimeters":true,"hectares_to_square_nanometers":true,"hectares_to_ares":true,"square_miles_to_square_meters":true,"square_miles_to_square_kilometers":true,"square_miles_to_square_centimeters":true,"square_miles_to_square_millimeters":true,"square_miles_to_square_micrometers":true,"square_miles_to_hectares":true,"square_miles_to_square_yards":true,"square_miles_to_square_feet":true,"square_miles_to_square_inches":true,"square_miles_to_acres":true,"square_miles_to_square_decimeters":true,"square_miles_to_square_nanometers":true,"square_miles_to_ares":true,"square_yards_to_square_meters":true,"square_yards_to_square_kilometers":true,"square_yards_to_square_centimeters":true,"square_yards_to_square_millimeters":true,"square_yards_to_square_micrometers":true,"square_yards_to_hectares":true,"square_yards_to_square_miles":true,"square_yards_to_square_feet":true,"square_yards_to_square_inches":true,"square_yards_to_acres":true,"square_yards_to_square_decimeters":true,"square_yards_to_square_nanometers":true,"square_yards_to_ares":true,"square_feet_to_square_meters":true,"square_feet_to_square_kilometers":true,"square_feet_to_square_centimeters":true,"square_feet_to_square_millimeters":true,"square_feet_to_square_micrometers":true,"square_feet_to_hectares":true,"square_feet_to_square_miles":true,"square_feet_to_square_yards":true,"square_feet_to_square_inches":true,"square_feet_to_acres":true,"square_feet_to_square_decimeters":true,"square_feet_to_square_nanometers":true,"square_feet_to_ares":true,"square_inches_to_square_meters":true,"square_inches_to_square_kilometers":true,"square_inches_to_square_centimeters":true,"square_inches_to_square_millimeters":true,"square_inches_to_square_micrometers":true,"square_inches_to_hectares":true,"square_inches_to_square_miles":true,"square_inches_to_square_yards":true,"square_inches_to_square_feet":true,"square_inches_to_acres":true,"square_inches_to_square_decimeters":true,"square_inches_to_square_nanometers":true,"square_inches_to_ares":true,"acres_to_square_meters":true,"acres_to_square_kilometers":true,"acres_to_square_centimeters":true,"acres_to_square_millimeters":true,"acres_to_square_micrometers":true,"acres_to_hectares":true,"acres_to_square_miles":true,"acres_to_square_yards":true,"acres_to_square_feet":true,"acres_to_square_inches":true,"acres_to_square_decimeters":true,"acres_to_square_nanometers":true,"acres_to_ares":true,"square_decimeters_to_square_meters":true,"square_decimeters_to_square_kilometers":true,"square_decimeters_to_square_centimeters":true,"square_decimeters_to_square_millimeters":true,"square_decimeters_to_square_micrometers":true,"square_decimeters_to_hectares":true,"square_decimeters_to_square_miles":true,"square_decimeters_to_square_yards":true,"square_decimeters_to_square_feet":true,"square_decimeters_to_square_inches":true,"square_decimeters_to_acres":true,"square_decimeters_to_square_nanometers":true,"square_decimeters_to_ares":true,"square_nanometers_to_square_meters":true,"square_nanometers_to_square_kilometers":true,"square_nanometers_to_square_centimeters":true,"square_nanometers_to_square_millimeters":true,"square_nanometers_to_square_micrometers":true,"square_nanometers_to_hectares":true,"square_nanometers_to_square_miles":true,"square_nanometers_to_square_yards":true,"square_nanometers_to_square_feet":true,"square_nanometers_to_square_inches":true,"square_nanometers_to_acres":true,"square_nanometers_to_square_decimeters":true,"square_nanometers_to_ares":true,"ares_to_square_meters":true,"ares_to_square_kilometers":true,"ares_to_square_centimeters":true,"ares_to_square_millimeters":true,"ares_to_square_micrometers":true,"ares_to_hectares":true,"ares_to_square_miles":true,"ares_to_square_yards":true,"ares_to_square_feet":true,"ares_to_square_inches":true,"ares_to_acres":true,"ares_to_square_decimeters":true,"ares_to_square_nanometers":true,"newton_to_kilonewton":true,"newton_to_gram_force":true,"newton_to_kilogram_force":true,"newton_to_ton_force_metric":true,"newton_to_exanewton":true,"newton_to_petanewton":true,"newton_to_teranewton":true,"newton_to_giganewton":true,"newton_to_meganewton":true,"newton_to_hectonewton":true,"newton_to_dekanewton":true,"newton_to_decinewton":true,"newton_to_centinewton":true,"newton_to_millinewton":true,"newton_to_micronewton":true,"newton_to_nanonewton":true,"newton_to_piconewton":true,"newton_to_femtonewton":true,"newton_to_attonewton":true,"newton_to_dyne":true,"newton_to_joule_meter":true,"newton_to_joule_centimeter":true,"newton_to_ton_force_short":true,"newton_to_ton_force_long":true,"newton_to_kip_force":true,"newton_to_kilopound_force":true,"newton_to_pound_force":true,"newton_to_ounce_force":true,"newton_to_poundal":true,"newton_to_pound_foot_square_second":true,"newton_to_pond":true,"newton_to_kilopond":true,"kilonewton_to_newton":true,"kilonewton_to_gram_force":true,"kilonewton_to_kilogram_force":true,"kilonewton_to_ton_force_metric":true,"kilonewton_to_exanewton":true,"kilonewton_to_petanewton":true,"kilonewton_to_teranewton":true,"kilonewton_to_giganewton":true,"kilonewton_to_meganewton":true,"kilonewton_to_hectonewton":true,"kilonewton_to_dekanewton":true,"kilonewton_to_decinewton":true,"kilonewton_to_centinewton":true,"kilonewton_to_millinewton":true,"kilonewton_to_micronewton":true,"kilonewton_to_nanonewton":true,"kilonewton_to_piconewton":true,"kilonewton_to_femtonewton":true,"kilonewton_to_attonewton":true,"kilonewton_to_dyne":true,"kilonewton_to_joule_meter":true,"kilonewton_to_joule_centimeter":true,"kilonewton_to_ton_force_short":true,"kilonewton_to_ton_force_long":true,"kilonewton_to_kip_force":true,"kilonewton_to_kilopound_force":true,"kilonewton_to_pound_force":true,"kilonewton_to_ounce_force":true,"kilonewton_to_poundal":true,"kilonewton_to_pound_foot_square_second":true,"kilonewton_to_pond":true,"kilonewton_to_kilopond":true,"gram_force_to_newton":true,"gram_force_to_kilonewton":true,"gram_force_to_kilogram_force":true,"gram_force_to_ton_force_metric":true,"gram_force_to_exanewton":true,"gram_force_to_petanewton":true,"gram_force_to_teranewton":true,"gram_force_to_giganewton":true,"gram_force_to_meganewton":true,"gram_force_to_hectonewton":true,"gram_force_to_dekanewton":true,"gram_force_to_decinewton":true,"gram_force_to_centinewton":true,"gram_force_to_millinewton":true,"gram_force_to_micronewton":true,"gram_force_to_nanonewton":true,"gram_force_to_piconewton":true,"gram_force_to_femtonewton":true,"gram_force_to_attonewton":true,"gram_force_to_dyne":true,"gram_force_to_joule_meter":true,"gram_force_to_joule_centimeter":true,"gram_force_to_ton_force_short":true,"gram_force_to_ton_force_long":true,"gram_force_to_kip_force":true,"gram_force_to_kilopound_force":true,"gram_force_to_pound_force":true,"gram_force_to_ounce_force":true,"gram_force_to_poundal":true,"gram_force_to_pound_foot_square_second":true,"gram_force_to_pond":true,"gram_force_to_kilopond":true,"kilogram_force_to_newton":true,"kilogram_force_to_kilonewton":true,"kilogram_force_to_gram_force":true,"kilogram_force_to_ton_force_metric":true,"kilogram_force_to_exanewton":true,"kilogram_force_to_petanewton":true,"kilogram_force_to_teranewton":true,"kilogram_force_to_giganewton":true,"kilogram_force_to_meganewton":true,"kilogram_force_to_hectonewton":true,"kilogram_force_to_dekanewton":true,"kilogram_force_to_decinewton":true,"kilogram_force_to_centinewton":true,"kilogram_force_to_millinewton":true,"kilogram_force_to_micronewton":true,"kilogram_force_to_nanonewton":true,"kilogram_force_to_piconewton":true,"kilogram_force_to_femtonewton":true,"kilogram_force_to_attonewton":true,"kilogram_force_to_dyne":true,"kilogram_force_to_joule_meter":true,"kilogram_force_to_joule_centimeter":true,"kilogram_force_to_ton_force_short":true,"kilogram_force_to_ton_force_long":true,"kilogram_force_to_kip_force":true,"kilogram_force_to_kilopound_force":true,"kilogram_force_to_pound_force":true,"kilogram_force_to_ounce_force":true,"kilogram_force_to_poundal":true,"kilogram_force_to_pound_foot_square_second":true,"kilogram_force_to_pond":true,"kilogram_force_to_kilopond":true,"ton_force_metric_to_newton":true,"ton_force_metric_to_kilonewton":true,"ton_force_metric_to_gram_force":true,"ton_force_metric_to_kilogram_force":true,"ton_force_metric_to_exanewton":true,"ton_force_metric_to_petanewton":true,"ton_force_metric_to_teranewton":true,"ton_force_metric_to_giganewton":true,"ton_force_metric_to_meganewton":true,"ton_force_metric_to_hectonewton":true,"ton_force_metric_to_dekanewton":true,"ton_force_metric_to_decinewton":true,"ton_force_metric_to_centinewton":true,"ton_force_metric_to_millinewton":true,"ton_force_metric_to_micronewton":true,"ton_force_metric_to_nanonewton":true,"ton_force_metric_to_piconewton":true,"ton_force_metric_to_femtonewton":true,"ton_force_metric_to_attonewton":true,"ton_force_metric_to_dyne":true,"ton_force_metric_to_joule_meter":true,"ton_force_metric_to_joule_centimeter":true,"ton_force_metric_to_ton_force_short":true,"ton_force_metric_to_ton_force_long":true,"ton_force_metric_to_kip_force":true,"ton_force_metric_to_kilopound_force":true,"ton_force_metric_to_pound_force":true,"ton_force_metric_to_ounce_force":true,"ton_force_metric_to_poundal":true,"ton_force_metric_to_pound_foot_square_second":true,"ton_force_metric_to_pond":true,"ton_force_metric_to_kilopond":true,"exanewton_to_newton":true,"exanewton_to_kilonewton":true,"exanewton_to_gram_force":true,"exanewton_to_kilogram_force":true,"exanewton_to_ton_force_metric":true,"exanewton_to_petanewton":true,"exanewton_to_teranewton":true,"exanewton_to_giganewton":true,"exanewton_to_meganewton":true,"exanewton_to_hectonewton":true,"exanewton_to_dekanewton":true,"exanewton_to_decinewton":true,"exanewton_to_centinewton":true,"exanewton_to_millinewton":true,"exanewton_to_micronewton":true,"exanewton_to_nanonewton":true,"exanewton_to_piconewton":true,"exanewton_to_femtonewton":true,"exanewton_to_attonewton":true,"exanewton_to_dyne":true,"exanewton_to_joule_meter":true,"exanewton_to_joule_centimeter":true,"exanewton_to_ton_force_short":true,"exanewton_to_ton_force_long":true,"exanewton_to_kip_force":true,"exanewton_to_kilopound_force":true,"exanewton_to_pound_force":true,"exanewton_to_ounce_force":true,"exanewton_to_poundal":true,"exanewton_to_pound_foot_square_second":true,"exanewton_to_pond":true,"exanewton_to_kilopond":true,"petanewton_to_newton":true,"petanewton_to_kilonewton":true,"petanewton_to_gram_force":true,"petanewton_to_kilogram_force":true,"petanewton_to_ton_force_metric":true,"petanewton_to_exanewton":true,"petanewton_to_teranewton":true,"petanewton_to_giganewton":true,"petanewton_to_meganewton":true,"petanewton_to_hectonewton":true,"petanewton_to_dekanewton":true,"petanewton_to_decinewton":true,"petanewton_to_centinewton":true,"petanewton_to_millinewton":true,"petanewton_to_micronewton":true,"petanewton_to_nanonewton":true,"petanewton_to_piconewton":true,"petanewton_to_femtonewton":true,"petanewton_to_attonewton":true,"petanewton_to_dyne":true,"petanewton_to_joule_meter":true,"petanewton_to_joule_centimeter":true,"petanewton_to_ton_force_short":true,"petanewton_to_ton_force_long":true,"petanewton_to_kip_force":true,"petanewton_to_kilopound_force":true,"petanewton_to_pound_force":true,"petanewton_to_ounce_force":true,"petanewton_to_poundal":true,"petanewton_to_pound_foot_square_second":true,"petanewton_to_pond":true,"petanewton_to_kilopond":true,"teranewton_to_newton":true,"teranewton_to_kilonewton":true,"teranewton_to_gram_force":true,"teranewton_to_kilogram_force":true,"teranewton_to_ton_force_metric":true,"teranewton_to_exanewton":true,"teranewton_to_petanewton":true,"teranewton_to_giganewton":true,"teranewton_to_meganewton":true,"teranewton_to_hectonewton":true,"teranewton_to_dekanewton":true,"teranewton_to_decinewton":true,"teranewton_to_centinewton":true,"teranewton_to_millinewton":true,"teranewton_to_micronewton":true,"teranewton_to_nanonewton":true,"teranewton_to_piconewton":true,"teranewton_to_femtonewton":true,"teranewton_to_attonewton":true,"teranewton_to_dyne":true,"teranewton_to_joule_meter":true,"teranewton_to_joule_centimeter":true,"teranewton_to_ton_force_short":true,"teranewton_to_ton_force_long":true,"teranewton_to_kip_force":true,"teranewton_to_kilopound_force":true,"teranewton_to_pound_force":true,"teranewton_to_ounce_force":true,"teranewton_to_poundal":true,"teranewton_to_pound_foot_square_second":true,"teranewton_to_pond":true,"teranewton_to_kilopond":true,"giganewton_to_newton":true,"giganewton_to_kilonewton":true,"giganewton_to_gram_force":true,"giganewton_to_kilogram_force":true,"giganewton_to_ton_force_metric":true,"giganewton_to_exanewton":true,"giganewton_to_petanewton":true,"giganewton_to_teranewton":true,"giganewton_to_meganewton":true,"giganewton_to_hectonewton":true,"giganewton_to_dekanewton":true,"giganewton_to_decinewton":true,"giganewton_to_centinewton":true,"giganewton_to_millinewton":true,"giganewton_to_micronewton":true,"giganewton_to_nanonewton":true,"giganewton_to_piconewton":true,"giganewton_to_femtonewton":true,"giganewton_to_attonewton":true,"giganewton_to_dyne":true,"giganewton_to_joule_meter":true,"giganewton_to_joule_centimeter":true,"giganewton_to_ton_force_short":true,"giganewton_to_ton_force_long":true,"giganewton_to_kip_force":true,"giganewton_to_kilopound_force":true,"giganewton_to_pound_force":true,"giganewton_to_ounce_force":true,"giganewton_to_poundal":true,"giganewton_to_pound_foot_square_second":true,"giganewton_to_pond":true,"giganewton_to_kilopond":true,"meganewton_to_newton":true,"meganewton_to_kilonewton":true,"meganewton_to_gram_force":true,"meganewton_to_kilogram_force":true,"meganewton_to_ton_force_metric":true,"meganewton_to_exanewton":true,"meganewton_to_petanewton":true,"meganewton_to_teranewton":true,"meganewton_to_giganewton":true,"meganewton_to_hectonewton":true,"meganewton_to_dekanewton":true,"meganewton_to_decinewton":true,"meganewton_to_centinewton":true,"meganewton_to_millinewton":true,"meganewton_to_micronewton":true,"meganewton_to_nanonewton":true,"meganewton_to_piconewton":true,"meganewton_to_femtonewton":true,"meganewton_to_attonewton":true,"meganewton_to_dyne":true,"meganewton_to_joule_meter":true,"meganewton_to_joule_centimeter":true,"meganewton_to_ton_force_short":true,"meganewton_to_ton_force_long":true,"meganewton_to_kip_force":true,"meganewton_to_kilopound_force":true,"meganewton_to_pound_force":true,"meganewton_to_ounce_force":true,"meganewton_to_poundal":true,"meganewton_to_pound_foot_square_second":true,"meganewton_to_pond":true,"meganewton_to_kilopond":true,"hectonewton_to_newton":true,"hectonewton_to_kilonewton":true,"hectonewton_to_gram_force":true,"hectonewton_to_kilogram_force":true,"hectonewton_to_ton_force_metric":true,"hectonewton_to_exanewton":true,"hectonewton_to_petanewton":true,"hectonewton_to_teranewton":true,"hectonewton_to_giganewton":true,"hectonewton_to_meganewton":true,"hectonewton_to_dekanewton":true,"hectonewton_to_decinewton":true,"hectonewton_to_centinewton":true,"hectonewton_to_millinewton":true,"hectonewton_to_micronewton":true,"hectonewton_to_nanonewton":true,"hectonewton_to_piconewton":true,"hectonewton_to_femtonewton":true,"hectonewton_to_attonewton":true,"hectonewton_to_dyne":true,"hectonewton_to_joule_meter":true,"hectonewton_to_joule_centimeter":true,"hectonewton_to_ton_force_short":true,"hectonewton_to_ton_force_long":true,"hectonewton_to_kip_force":true,"hectonewton_to_kilopound_force":true,"hectonewton_to_pound_force":true,"hectonewton_to_ounce_force":true,"hectonewton_to_poundal":true,"hectonewton_to_pound_foot_square_second":true,"hectonewton_to_pond":true,"hectonewton_to_kilopond":true,"dekanewton_to_newton":true,"dekanewton_to_kilonewton":true,"dekanewton_to_gram_force":true,"dekanewton_to_kilogram_force":true,"dekanewton_to_ton_force_metric":true,"dekanewton_to_exanewton":true,"dekanewton_to_petanewton":true,"dekanewton_to_teranewton":true,"dekanewton_to_giganewton":true,"dekanewton_to_meganewton":true,"dekanewton_to_hectonewton":true,"dekanewton_to_decinewton":true,"dekanewton_to_centinewton":true,"dekanewton_to_millinewton":true,"dekanewton_to_micronewton":true,"dekanewton_to_nanonewton":true,"dekanewton_to_piconewton":true,"dekanewton_to_femtonewton":true,"dekanewton_to_attonewton":true,"dekanewton_to_dyne":true,"dekanewton_to_joule_meter":true,"dekanewton_to_joule_centimeter":true,"dekanewton_to_ton_force_short":true,"dekanewton_to_ton_force_long":true,"dekanewton_to_kip_force":true,"dekanewton_to_kilopound_force":true,"dekanewton_to_pound_force":true,"dekanewton_to_ounce_force":true,"dekanewton_to_poundal":true,"dekanewton_to_pound_foot_square_second":true,"dekanewton_to_pond":true,"dekanewton_to_kilopond":true,"decinewton_to_newton":true,"decinewton_to_kilonewton":true,"decinewton_to_gram_force":true,"decinewton_to_kilogram_force":true,"decinewton_to_ton_force_metric":true,"decinewton_to_exanewton":true,"decinewton_to_petanewton":true,"decinewton_to_teranewton":true,"decinewton_to_giganewton":true,"decinewton_to_meganewton":true,"decinewton_to_hectonewton":true,"decinewton_to_dekanewton":true,"decinewton_to_centinewton":true,"decinewton_to_millinewton":true,"decinewton_to_micronewton":true,"decinewton_to_nanonewton":true,"decinewton_to_piconewton":true,"decinewton_to_femtonewton":true,"decinewton_to_attonewton":true,"decinewton_to_dyne":true,"decinewton_to_joule_meter":true,"decinewton_to_joule_centimeter":true,"decinewton_to_ton_force_short":true,"decinewton_to_ton_force_long":true,"decinewton_to_kip_force":true,"decinewton_to_kilopound_force":true,"decinewton_to_pound_force":true,"decinewton_to_ounce_force":true,"decinewton_to_poundal":true,"decinewton_to_pound_foot_square_second":true,"decinewton_to_pond":true,"decinewton_to_kilopond":true,"centinewton_to_newton":true,"centinewton_to_kilonewton":true,"centinewton_to_gram_force":true,"centinewton_to_kilogram_force":true,"centinewton_to_ton_force_metric":true,"centinewton_to_exanewton":true,"centinewton_to_petanewton":true,"centinewton_to_teranewton":true,"centinewton_to_giganewton":true,"centinewton_to_meganewton":true,"centinewton_to_hectonewton":true,"centinewton_to_dekanewton":true,"centinewton_to_decinewton":true,"centinewton_to_millinewton":true,"centinewton_to_micronewton":true,"centinewton_to_nanonewton":true,"centinewton_to_piconewton":true,"centinewton_to_femtonewton":true,"centinewton_to_attonewton":true,"centinewton_to_dyne":true,"centinewton_to_joule_meter":true,"centinewton_to_joule_centimeter":true,"centinewton_to_ton_force_short":true,"centinewton_to_ton_force_long":true,"centinewton_to_kip_force":true,"centinewton_to_kilopound_force":true,"centinewton_to_pound_force":true,"centinewton_to_ounce_force":true,"centinewton_to_poundal":true,"centinewton_to_pound_foot_square_second":true,"centinewton_to_pond":true,"centinewton_to_kilopond":true,"millinewton_to_newton":true,"millinewton_to_kilonewton":true,"millinewton_to_gram_force":true,"millinewton_to_kilogram_force":true,"millinewton_to_ton_force_metric":true,"millinewton_to_exanewton":true,"millinewton_to_petanewton":true,"millinewton_to_teranewton":true,"millinewton_to_giganewton":true,"millinewton_to_meganewton":true,"millinewton_to_hectonewton":true,"millinewton_to_dekanewton":true,"millinewton_to_decinewton":true,"millinewton_to_centinewton":true,"millinewton_to_micronewton":true,"millinewton_to_nanonewton":true,"millinewton_to_piconewton":true,"millinewton_to_femtonewton":true,"millinewton_to_attonewton":true,"millinewton_to_dyne":true,"millinewton_to_joule_meter":true,"millinewton_to_joule_centimeter":true,"millinewton_to_ton_force_short":true,"millinewton_to_ton_force_long":true,"millinewton_to_kip_force":true,"millinewton_to_kilopound_force":true,"millinewton_to_pound_force":true,"millinewton_to_ounce_force":true,"millinewton_to_poundal":true,"millinewton_to_pound_foot_square_second":true,"millinewton_to_pond":true,"millinewton_to_kilopond":true,"micronewton_to_newton":true,"micronewton_to_kilonewton":true,"micronewton_to_gram_force":true,"micronewton_to_kilogram_force":true,"micronewton_to_ton_force_metric":true,"micronewton_to_exanewton":true,"micronewton_to_petanewton":true,"micronewton_to_teranewton":true,"micronewton_to_giganewton":true,"micronewton_to_meganewton":true,"micronewton_to_hectonewton":true,"micronewton_to_dekanewton":true,"micronewton_to_decinewton":true,"micronewton_to_centinewton":true,"micronewton_to_millinewton":true,"micronewton_to_nanonewton":true,"micronewton_to_piconewton":true,"micronewton_to_femtonewton":true,"micronewton_to_attonewton":true,"micronewton_to_dyne":true,"micronewton_to_joule_meter":true,"micronewton_to_joule_centimeter":true,"micronewton_to_ton_force_short":true,"micronewton_to_ton_force_long":true,"micronewton_to_kip_force":true,"micronewton_to_kilopound_force":true,"micronewton_to_pound_force":true,"micronewton_to_ounce_force":true,"micronewton_to_poundal":true,"micronewton_to_pound_foot_square_second":true,"micronewton_to_pond":true,"micronewton_to_kilopond":true,"nanonewton_to_newton":true,"nanonewton_to_kilonewton":true,"nanonewton_to_gram_force":true,"nanonewton_to_kilogram_force":true,"nanonewton_to_ton_force_metric":true,"nanonewton_to_exanewton":true,"nanonewton_to_petanewton":true,"nanonewton_to_teranewton":true,"nanonewton_to_giganewton":true,"nanonewton_to_meganewton":true,"nanonewton_to_hectonewton":true,"nanonewton_to_dekanewton":true,"nanonewton_to_decinewton":true,"nanonewton_to_centinewton":true,"nanonewton_to_millinewton":true,"nanonewton_to_micronewton":true,"nanonewton_to_piconewton":true,"nanonewton_to_femtonewton":true,"nanonewton_to_attonewton":true,"nanonewton_to_dyne":true,"nanonewton_to_joule_meter":true,"nanonewton_to_joule_centimeter":true,"nanonewton_to_ton_force_short":true,"nanonewton_to_ton_force_long":true,"nanonewton_to_kip_force":true,"nanonewton_to_kilopound_force":true,"nanonewton_to_pound_force":true,"nanonewton_to_ounce_force":true,"nanonewton_to_poundal":true,"nanonewton_to_pound_foot_square_second":true,"nanonewton_to_pond":true,"nanonewton_to_kilopond":true,"piconewton_to_newton":true,"piconewton_to_kilonewton":true,"piconewton_to_gram_force":true,"piconewton_to_kilogram_force":true,"piconewton_to_ton_force_metric":true,"piconewton_to_exanewton":true,"piconewton_to_petanewton":true,"piconewton_to_teranewton":true,"piconewton_to_giganewton":true,"piconewton_to_meganewton":true,"piconewton_to_hectonewton":true,"piconewton_to_dekanewton":true,"piconewton_to_decinewton":true,"piconewton_to_centinewton":true,"piconewton_to_millinewton":true,"piconewton_to_micronewton":true,"piconewton_to_nanonewton":true,"piconewton_to_femtonewton":true,"piconewton_to_attonewton":true,"piconewton_to_dyne":true,"piconewton_to_joule_meter":true,"piconewton_to_joule_centimeter":true,"piconewton_to_ton_force_short":true,"piconewton_to_ton_force_long":true,"piconewton_to_kip_force":true,"piconewton_to_kilopound_force":true,"piconewton_to_pound_force":true,"piconewton_to_ounce_force":true,"piconewton_to_poundal":true,"piconewton_to_pound_foot_square_second":true,"piconewton_to_pond":true,"piconewton_to_kilopond":true,"femtonewton_to_newton":true,"femtonewton_to_kilonewton":true,"femtonewton_to_gram_force":true,"femtonewton_to_kilogram_force":true,"femtonewton_to_ton_force_metric":true,"femtonewton_to_exanewton":true,"femtonewton_to_petanewton":true,"femtonewton_to_teranewton":true,"femtonewton_to_giganewton":true,"femtonewton_to_meganewton":true,"femtonewton_to_hectonewton":true,"femtonewton_to_dekanewton":true,"femtonewton_to_decinewton":true,"femtonewton_to_centinewton":true,"femtonewton_to_millinewton":true,"femtonewton_to_micronewton":true,"femtonewton_to_nanonewton":true,"femtonewton_to_piconewton":true,"femtonewton_to_attonewton":true,"femtonewton_to_dyne":true,"femtonewton_to_joule_meter":true,"femtonewton_to_joule_centimeter":true,"femtonewton_to_ton_force_short":true,"femtonewton_to_ton_force_long":true,"femtonewton_to_kip_force":true,"femtonewton_to_kilopound_force":true,"femtonewton_to_pound_force":true,"femtonewton_to_ounce_force":true,"femtonewton_to_poundal":true,"femtonewton_to_pound_foot_square_second":true,"femtonewton_to_pond":true,"femtonewton_to_kilopond":true,"attonewton_to_newton":true,"attonewton_to_kilonewton":true,"attonewton_to_gram_force":true,"attonewton_to_kilogram_force":true,"attonewton_to_ton_force_metric":true,"attonewton_to_exanewton":true,"attonewton_to_petanewton":true,"attonewton_to_teranewton":true,"attonewton_to_giganewton":true,"attonewton_to_meganewton":true,"attonewton_to_hectonewton":true,"attonewton_to_dekanewton":true,"attonewton_to_decinewton":true,"attonewton_to_centinewton":true,"attonewton_to_millinewton":true,"attonewton_to_micronewton":true,"attonewton_to_nanonewton":true,"attonewton_to_piconewton":true,"attonewton_to_femtonewton":true,"attonewton_to_dyne":true,"attonewton_to_joule_meter":true,"attonewton_to_joule_centimeter":true,"attonewton_to_ton_force_short":true,"attonewton_to_ton_force_long":true,"attonewton_to_kip_force":true,"attonewton_to_kilopound_force":true,"attonewton_to_pound_force":true,"attonewton_to_ounce_force":true,"attonewton_to_poundal":true,"attonewton_to_pound_foot_square_second":true,"attonewton_to_pond":true,"attonewton_to_kilopond":true,"dyne_to_newton":true,"dyne_to_kilonewton":true,"dyne_to_gram_force":true,"dyne_to_kilogram_force":true,"dyne_to_ton_force_metric":true,"dyne_to_exanewton":true,"dyne_to_petanewton":true,"dyne_to_teranewton":true,"dyne_to_giganewton":true,"dyne_to_meganewton":true,"dyne_to_hectonewton":true,"dyne_to_dekanewton":true,"dyne_to_decinewton":true,"dyne_to_centinewton":true,"dyne_to_millinewton":true,"dyne_to_micronewton":true,"dyne_to_nanonewton":true,"dyne_to_piconewton":true,"dyne_to_femtonewton":true,"dyne_to_attonewton":true,"dyne_to_joule_meter":true,"dyne_to_joule_centimeter":true,"dyne_to_ton_force_short":true,"dyne_to_ton_force_long":true,"dyne_to_kip_force":true,"dyne_to_kilopound_force":true,"dyne_to_pound_force":true,"dyne_to_ounce_force":true,"dyne_to_poundal":true,"dyne_to_pound_foot_square_second":true,"dyne_to_pond":true,"dyne_to_kilopond":true,"joule_meter_to_newton":true,"joule_meter_to_kilonewton":true,"joule_meter_to_gram_force":true,"joule_meter_to_kilogram_force":true,"joule_meter_to_ton_force_metric":true,"joule_meter_to_exanewton":true,"joule_meter_to_petanewton":true,"joule_meter_to_teranewton":true,"joule_meter_to_giganewton":true,"joule_meter_to_meganewton":true,"joule_meter_to_hectonewton":true,"joule_meter_to_dekanewton":true,"joule_meter_to_decinewton":true,"joule_meter_to_centinewton":true,"joule_meter_to_millinewton":true,"joule_meter_to_micronewton":true,"joule_meter_to_nanonewton":true,"joule_meter_to_piconewton":true,"joule_meter_to_femtonewton":true,"joule_meter_to_attonewton":true,"joule_meter_to_dyne":true,"joule_meter_to_joule_centimeter":true,"joule_meter_to_ton_force_short":true,"joule_meter_to_ton_force_long":true,"joule_meter_to_kip_force":true,"joule_meter_to_kilopound_force":true,"joule_meter_to_pound_force":true,"joule_meter_to_ounce_force":true,"joule_meter_to_poundal":true,"joule_meter_to_pound_foot_square_second":true,"joule_meter_to_pond":true,"joule_meter_to_kilopond":true,"joule_centimeter_to_newton":true,"joule_centimeter_to_kilonewton":true,"joule_centimeter_to_gram_force":true,"joule_centimeter_to_kilogram_force":true,"joule_centimeter_to_ton_force_metric":true,"joule_centimeter_to_exanewton":true,"joule_centimeter_to_petanewton":true,"joule_centimeter_to_teranewton":true,"joule_centimeter_to_giganewton":true,"joule_centimeter_to_meganewton":true,"joule_centimeter_to_hectonewton":true,"joule_centimeter_to_dekanewton":true,"joule_centimeter_to_decinewton":true,"joule_centimeter_to_centinewton":true,"joule_centimeter_to_millinewton":true,"joule_centimeter_to_micronewton":true,"joule_centimeter_to_nanonewton":true,"joule_centimeter_to_piconewton":true,"joule_centimeter_to_femtonewton":true,"joule_centimeter_to_attonewton":true,"joule_centimeter_to_dyne":true,"joule_centimeter_to_joule_meter":true,"joule_centimeter_to_ton_force_short":true,"joule_centimeter_to_ton_force_long":true,"joule_centimeter_to_kip_force":true,"joule_centimeter_to_kilopound_force":true,"joule_centimeter_to_pound_force":true,"joule_centimeter_to_ounce_force":true,"joule_centimeter_to_poundal":true,"joule_centimeter_to_pound_foot_square_second":true,"joule_centimeter_to_pond":true,"joule_centimeter_to_kilopond":true,"ton_force_short_to_newton":true,"ton_force_short_to_kilonewton":true,"ton_force_short_to_gram_force":true,"ton_force_short_to_kilogram_force":true,"ton_force_short_to_ton_force_metric":true,"ton_force_short_to_exanewton":true,"ton_force_short_to_petanewton":true,"ton_force_short_to_teranewton":true,"ton_force_short_to_giganewton":true,"ton_force_short_to_meganewton":true,"ton_force_short_to_hectonewton":true,"ton_force_short_to_dekanewton":true,"ton_force_short_to_decinewton":true,"ton_force_short_to_centinewton":true,"ton_force_short_to_millinewton":true,"ton_force_short_to_micronewton":true,"ton_force_short_to_nanonewton":true,"ton_force_short_to_piconewton":true,"ton_force_short_to_femtonewton":true,"ton_force_short_to_attonewton":true,"ton_force_short_to_dyne":true,"ton_force_short_to_joule_meter":true,"ton_force_short_to_joule_centimeter":true,"ton_force_short_to_ton_force_long":true,"ton_force_short_to_kip_force":true,"ton_force_short_to_kilopound_force":true,"ton_force_short_to_pound_force":true,"ton_force_short_to_ounce_force":true,"ton_force_short_to_poundal":true,"ton_force_short_to_pound_foot_square_second":true,"ton_force_short_to_pond":true,"ton_force_short_to_kilopond":true,"ton_force_long_to_newton":true,"ton_force_long_to_kilonewton":true,"ton_force_long_to_gram_force":true,"ton_force_long_to_kilogram_force":true,"ton_force_long_to_ton_force_metric":true,"ton_force_long_to_exanewton":true,"ton_force_long_to_petanewton":true,"ton_force_long_to_teranewton":true,"ton_force_long_to_giganewton":true,"ton_force_long_to_meganewton":true,"ton_force_long_to_hectonewton":true,"ton_force_long_to_dekanewton":true,"ton_force_long_to_decinewton":true,"ton_force_long_to_centinewton":true,"ton_force_long_to_millinewton":true,"ton_force_long_to_micronewton":true,"ton_force_long_to_nanonewton":true,"ton_force_long_to_piconewton":true,"ton_force_long_to_femtonewton":true,"ton_force_long_to_attonewton":true,"ton_force_long_to_dyne":true,"ton_force_long_to_joule_meter":true,"ton_force_long_to_joule_centimeter":true,"ton_force_long_to_ton_force_short":true,"ton_force_long_to_kip_force":true,"ton_force_long_to_kilopound_force":true,"ton_force_long_to_pound_force":true,"ton_force_long_to_ounce_force":true,"ton_force_long_to_poundal":true,"ton_force_long_to_pound_foot_square_second":true,"ton_force_long_to_pond":true,"ton_force_long_to_kilopond":true,"kip_force_to_newton":true,"kip_force_to_kilonewton":true,"kip_force_to_gram_force":true,"kip_force_to_kilogram_force":true,"kip_force_to_ton_force_metric":true,"kip_force_to_exanewton":true,"kip_force_to_petanewton":true,"kip_force_to_teranewton":true,"kip_force_to_giganewton":true,"kip_force_to_meganewton":true,"kip_force_to_hectonewton":true,"kip_force_to_dekanewton":true,"kip_force_to_decinewton":true,"kip_force_to_centinewton":true,"kip_force_to_millinewton":true,"kip_force_to_micronewton":true,"kip_force_to_nanonewton":true,"kip_force_to_piconewton":true,"kip_force_to_femtonewton":true,"kip_force_to_attonewton":true,"kip_force_to_dyne":true,"kip_force_to_joule_meter":true,"kip_force_to_joule_centimeter":true,"kip_force_to_ton_force_short":true,"kip_force_to_ton_force_long":true,"kip_force_to_kilopound_force":true,"kip_force_to_pound_force":true,"kip_force_to_ounce_force":true,"kip_force_to_poundal":true,"kip_force_to_pound_foot_square_second":true,"kip_force_to_pond":true,"kip_force_to_kilopond":true,"kilopound_force_to_newton":true,"kilopound_force_to_kilonewton":true,"kilopound_force_to_gram_force":true,"kilopound_force_to_kilogram_force":true,"kilopound_force_to_ton_force_metric":true,"kilopound_force_to_exanewton":true,"kilopound_force_to_petanewton":true,"kilopound_force_to_teranewton":true,"kilopound_force_to_giganewton":true,"kilopound_force_to_meganewton":true,"kilopound_force_to_hectonewton":true,"kilopound_force_to_dekanewton":true,"kilopound_force_to_decinewton":true,"kilopound_force_to_centinewton":true,"kilopound_force_to_millinewton":true,"kilopound_force_to_micronewton":true,"kilopound_force_to_nanonewton":true,"kilopound_force_to_piconewton":true,"kilopound_force_to_femtonewton":true,"kilopound_force_to_attonewton":true,"kilopound_force_to_dyne":true,"kilopound_force_to_joule_meter":true,"kilopound_force_to_joule_centimeter":true,"kilopound_force_to_ton_force_short":true,"kilopound_force_to_ton_force_long":true,"kilopound_force_to_kip_force":true,"kilopound_force_to_pound_force":true,"kilopound_force_to_ounce_force":true,"kilopound_force_to_poundal":true,"kilopound_force_to_pound_foot_square_second":true,"kilopound_force_to_pond":true,"kilopound_force_to_kilopond":true,"pound_force_to_newton":true,"pound_force_to_kilonewton":true,"pound_force_to_gram_force":true,"pound_force_to_kilogram_force":true,"pound_force_to_ton_force_metric":true,"pound_force_to_exanewton":true,"pound_force_to_petanewton":true,"pound_force_to_teranewton":true,"pound_force_to_giganewton":true,"pound_force_to_meganewton":true,"pound_force_to_hectonewton":true,"pound_force_to_dekanewton":true,"pound_force_to_decinewton":true,"pound_force_to_centinewton":true,"pound_force_to_millinewton":true,"pound_force_to_micronewton":true,"pound_force_to_nanonewton":true,"pound_force_to_piconewton":true,"pound_force_to_femtonewton":true,"pound_force_to_attonewton":true,"pound_force_to_dyne":true,"pound_force_to_joule_meter":true,"pound_force_to_joule_centimeter":true,"pound_force_to_ton_force_short":true,"pound_force_to_ton_force_long":true,"pound_force_to_kip_force":true,"pound_force_to_kilopound_force":true,"pound_force_to_ounce_force":true,"pound_force_to_poundal":true,"pound_force_to_pound_foot_square_second":true,"pound_force_to_pond":true,"pound_force_to_kilopond":true,"ounce_force_to_newton":true,"ounce_force_to_kilonewton":true,"ounce_force_to_gram_force":true,"ounce_force_to_kilogram_force":true,"ounce_force_to_ton_force_metric":true,"ounce_force_to_exanewton":true,"ounce_force_to_petanewton":true,"ounce_force_to_teranewton":true,"ounce_force_to_giganewton":true,"ounce_force_to_meganewton":true,"ounce_force_to_hectonewton":true,"ounce_force_to_dekanewton":true,"ounce_force_to_decinewton":true,"ounce_force_to_centinewton":true,"ounce_force_to_millinewton":true,"ounce_force_to_micronewton":true,"ounce_force_to_nanonewton":true,"ounce_force_to_piconewton":true,"ounce_force_to_femtonewton":true,"ounce_force_to_attonewton":true,"ounce_force_to_dyne":true,"ounce_force_to_joule_meter":true,"ounce_force_to_joule_centimeter":true,"ounce_force_to_ton_force_short":true,"ounce_force_to_ton_force_long":true,"ounce_force_to_kip_force":true,"ounce_force_to_kilopound_force":true,"ounce_force_to_pound_force":true,"ounce_force_to_poundal":true,"ounce_force_to_pound_foot_square_second":true,"ounce_force_to_pond":true,"ounce_force_to_kilopond":true,"poundal_to_newton":true,"poundal_to_kilonewton":true,"poundal_to_gram_force":true,"poundal_to_kilogram_force":true,"poundal_to_ton_force_metric":true,"poundal_to_exanewton":true,"poundal_to_petanewton":true,"poundal_to_teranewton":true,"poundal_to_giganewton":true,"poundal_to_meganewton":true,"poundal_to_hectonewton":true,"poundal_to_dekanewton":true,"poundal_to_decinewton":true,"poundal_to_centinewton":true,"poundal_to_millinewton":true,"poundal_to_micronewton":true,"poundal_to_nanonewton":true,"poundal_to_piconewton":true,"poundal_to_femtonewton":true,"poundal_to_attonewton":true,"poundal_to_dyne":true,"poundal_to_joule_meter":true,"poundal_to_joule_centimeter":true,"poundal_to_ton_force_short":true,"poundal_to_ton_force_long":true,"poundal_to_kip_force":true,"poundal_to_kilopound_force":true,"poundal_to_pound_force":true,"poundal_to_ounce_force":true,"poundal_to_pound_foot_square_second":true,"poundal_to_pond":true,"poundal_to_kilopond":true,"pound_foot_square_second_to_newton":true,"pound_foot_square_second_to_kilonewton":true,"pound_foot_square_second_to_gram_force":true,"pound_foot_square_second_to_kilogram_force":true,"pound_foot_square_second_to_ton_force_metric":true,"pound_foot_square_second_to_exanewton":true,"pound_foot_square_second_to_petanewton":true,"pound_foot_square_second_to_teranewton":true,"pound_foot_square_second_to_giganewton":true,"pound_foot_square_second_to_meganewton":true,"pound_foot_square_second_to_hectonewton":true,"pound_foot_square_second_to_dekanewton":true,"pound_foot_square_second_to_decinewton":true,"pound_foot_square_second_to_centinewton":true,"pound_foot_square_second_to_millinewton":true,"pound_foot_square_second_to_micronewton":true,"pound_foot_square_second_to_nanonewton":true,"pound_foot_square_second_to_piconewton":true,"pound_foot_square_second_to_femtonewton":true,"pound_foot_square_second_to_attonewton":true,"pound_foot_square_second_to_dyne":true,"pound_foot_square_second_to_joule_meter":true,"pound_foot_square_second_to_joule_centimeter":true,"pound_foot_square_second_to_ton_force_short":true,"pound_foot_square_second_to_ton_force_long":true,"pound_foot_square_second_to_kip_force":true,"pound_foot_square_second_to_kilopound_force":true,"pound_foot_square_second_to_pound_force":true,"pound_foot_square_second_to_ounce_force":true,"pound_foot_square_second_to_poundal":true,"pound_foot_square_second_to_pond":true,"pound_foot_square_second_to_kilopond":true,"pond_to_newton":true,"pond_to_kilonewton":true,"pond_to_gram_force":true,"pond_to_kilogram_force":true,"pond_to_ton_force_metric":true,"pond_to_exanewton":true,"pond_to_petanewton":true,"pond_to_teranewton":true,"pond_to_giganewton":true,"pond_to_meganewton":true,"pond_to_hectonewton":true,"pond_to_dekanewton":true,"pond_to_decinewton":true,"pond_to_centinewton":true,"pond_to_millinewton":true,"pond_to_micronewton":true,"pond_to_nanonewton":true,"pond_to_piconewton":true,"pond_to_femtonewton":true,"pond_to_attonewton":true,"pond_to_dyne":true,"pond_to_joule_meter":true,"pond_to_joule_centimeter":true,"pond_to_ton_force_short":true,"pond_to_ton_force_long":true,"pond_to_kip_force":true,"pond_to_kilopound_force":true,"pond_to_pound_force":true,"pond_to_ounce_force":true,"pond_to_poundal":true,"pond_to_pound_foot_square_second":true,"pond_to_kilopond":true,"kilopond_to_newton":true,"kilopond_to_kilonewton":true,"kilopond_to_gram_force":true,"kilopond_to_kilogram_force":true,"kilopond_to_ton_force_metric":true,"kilopond_to_exanewton":true,"kilopond_to_petanewton":true,"kilopond_to_teranewton":true,"kilopond_to_giganewton":true,"kilopond_to_meganewton":true,"kilopond_to_hectonewton":true,"kilopond_to_dekanewton":true,"kilopond_to_decinewton":true,"kilopond_to_centinewton":true,"kilopond_to_millinewton":true,"kilopond_to_micronewton":true,"kilopond_to_nanonewton":true,"kilopond_to_piconewton":true,"kilopond_to_femtonewton":true,"kilopond_to_attonewton":true,"kilopond_to_dyne":true,"kilopond_to_joule_meter":true,"kilopond_to_joule_centimeter":true,"kilopond_to_ton_force_short":true,"kilopond_to_ton_force_long":true,"kilopond_to_kip_force":true,"kilopond_to_kilopound_force":true,"kilopond_to_pound_force":true,"kilopond_to_ounce_force":true,"kilopond_to_poundal":true,"kilopond_to_pound_foot_square_second":true,"kilopond_to_pond":true},"removable_branding":false,"exclusive_personal_api_keys":false,"documents_model":"gpt-4o","documents_per_month_limit":-1,"words_per_month_limit":-1,"images_api":"dall-e-2","images_per_month_limit":-1,"transcriptions_per_month_limit":-1,"transcriptions_file_size_limit":2,"chats_model":"gpt-4o-mini","chats_per_month_limit":-1,"chat_messages_per_chat_limit":-1,"chat_image_size_limit":2,"syntheses_api":"openai_audio","syntheses_per_month_limit":-1,"synthesized_characters_per_month_limit":-1}', NOW(),'',NOW(), '{"default_results_per_page":100,"default_order_type":"ASC","openai_api_key":"","clipdrop_api_key":"","aws_access_key":"","aws_secret_access_key":"","aws_region":""}');

-- SEPARATOR --

CREATE TABLE `users_logs` (
`id` bigint unsigned NOT NULL AUTO_INCREMENT,
`user_id` bigint unsigned DEFAULT NULL,
`type` varchar(64) DEFAULT NULL,
`ip` varchar(64) DEFAULT NULL,
`device_type` varchar(16) DEFAULT NULL,
`os_name` varchar(16) DEFAULT NULL,
`continent_code` varchar(8) DEFAULT NULL,
`country_code` varchar(8) DEFAULT NULL,
`city_name` varchar(32) DEFAULT NULL,
`browser_language` varchar(32) DEFAULT NULL,
`browser_name` varchar(32) DEFAULT NULL,
`datetime` datetime DEFAULT NULL,
PRIMARY KEY (`id`),
KEY `users_logs_user_id` (`user_id`),
KEY `users_logs_ip_type_datetime_index` (`ip`,`type`,`datetime`),
CONSTRAINT `users_logs_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- SEPARATOR --

CREATE TABLE `plans` (
`plan_id` int unsigned NOT NULL AUTO_INCREMENT,
`name` varchar(64) NOT NULL DEFAULT '',
`description` varchar(256) NOT NULL DEFAULT '',
`translations` text NOT NULL,
`prices` text NOT NULL,
`trial_days` int unsigned NOT NULL DEFAULT '0',
`settings` longtext NOT NULL,
`taxes_ids` text,
`color` varchar(16) DEFAULT NULL,
`status` tinyint NOT NULL,
`order` int unsigned DEFAULT '0',
`datetime` datetime NOT NULL,
PRIMARY KEY (`plan_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- SEPARATOR --

CREATE TABLE `pages_categories` (
`pages_category_id` bigint unsigned NOT NULL AUTO_INCREMENT,
`url` varchar(256) NOT NULL,
`title` varchar(256) NOT NULL DEFAULT '',
`description` varchar(256) DEFAULT NULL,
`icon` varchar(32) DEFAULT NULL,
`order` int NOT NULL DEFAULT '0',
`language` varchar(32) DEFAULT NULL,
`datetime` datetime DEFAULT NULL,
`last_datetime` datetime DEFAULT NULL,
PRIMARY KEY (`pages_category_id`),
KEY `url` (`url`),
KEY `pages_categories_url_language_index` (`url`,`language`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;

-- SEPARATOR --

CREATE TABLE `pages` (
`page_id` bigint unsigned NOT NULL AUTO_INCREMENT,
`pages_category_id` bigint unsigned DEFAULT NULL,
`url` varchar(256) NOT NULL,
`title` varchar(256) NOT NULL DEFAULT '',
`description` varchar(256) DEFAULT NULL,
`icon` varchar(32) DEFAULT NULL,
`keywords` varchar(256) CHARACTER SET utf8mb4 DEFAULT NULL,
`editor` varchar(16) DEFAULT NULL,
`content` longtext,
`type` varchar(16) DEFAULT '',
`position` varchar(16) NOT NULL DEFAULT '',
`language` varchar(32) DEFAULT NULL,
`open_in_new_tab` tinyint DEFAULT '1',
`order` int DEFAULT '0',
`total_views` bigint unsigned DEFAULT '0',
`is_published` tinyint DEFAULT '1',
`datetime` datetime DEFAULT NULL,
`last_datetime` datetime DEFAULT NULL,
PRIMARY KEY (`page_id`),
KEY `pages_pages_category_id_index` (`pages_category_id`),
KEY `pages_url_index` (`url`),
KEY `pages_is_published_index` (`is_published`),
KEY `pages_language_index` (`language`),
CONSTRAINT `pages_ibfk_1` FOREIGN KEY (`pages_category_id`) REFERENCES `pages_categories` (`pages_category_id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- SEPARATOR --

INSERT INTO `pages` (`pages_category_id`, `url`, `title`, `description`, `content`, `type`, `position`, `order`, `total_views`, `datetime`, `last_datetime`) VALUES
(NULL, 'https://altumcode.com/', 'Software by AltumCode', '', '', 'external', 'bottom', 1, 0, NOW(), NOW()),
(NULL, 'https://altumco.de/66toolkit', 'Built with 66toolkit', '', '', 'external', 'bottom', 0, 0, NOW(), NOW());

-- SEPARATOR --

CREATE TABLE `blog_posts_categories` (
`blog_posts_category_id` bigint unsigned NOT NULL AUTO_INCREMENT,
`url` varchar(256) NOT NULL,
`title` varchar(256) NOT NULL DEFAULT '',
`description` varchar(256) DEFAULT NULL,
`order` int NOT NULL DEFAULT '0',
`language` varchar(32) DEFAULT NULL,
`datetime` datetime DEFAULT NULL,
`last_datetime` datetime DEFAULT NULL,
PRIMARY KEY (`blog_posts_category_id`),
KEY `url` (`url`),
KEY `blog_posts_categories_url_language_index` (`url`,`language`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;

-- SEPARATOR --

CREATE TABLE `blog_posts` (
`blog_post_id` bigint unsigned NOT NULL AUTO_INCREMENT,
`blog_posts_category_id` bigint unsigned DEFAULT NULL,
`url` varchar(256) NOT NULL,
`title` varchar(256) NOT NULL DEFAULT '',
`description` varchar(256) DEFAULT NULL,
`keywords` varchar(256) CHARACTER SET utf8mb4 DEFAULT NULL,
`image` varchar(40) CHARACTER SET utf8mb4 DEFAULT NULL,
`image_description` varchar(256) DEFAULT NULL,
`editor` varchar(16) DEFAULT NULL,
`content` longtext,
`language` varchar(32) DEFAULT NULL,
`total_views` bigint unsigned DEFAULT '0',
`average_rating` float unsigned NOT NULL DEFAULT '0',
`total_ratings` bigint unsigned NOT NULL DEFAULT '0',
`is_published` tinyint DEFAULT '1',
`datetime` datetime DEFAULT NULL,
`last_datetime` datetime DEFAULT NULL,
PRIMARY KEY (`blog_post_id`),
KEY `blog_post_id_index` (`blog_post_id`),
KEY `blog_post_url_index` (`url`),
KEY `blog_posts_category_id` (`blog_posts_category_id`),
KEY `blog_posts_is_published_index` (`is_published`),
KEY `blog_posts_language_index` (`language`),
CONSTRAINT `blog_posts_ibfk_1` FOREIGN KEY (`blog_posts_category_id`) REFERENCES `blog_posts_categories` (`blog_posts_category_id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- SEPARATOR --

CREATE TABLE `blog_posts_ratings` (
`id` bigint unsigned NOT NULL AUTO_INCREMENT,
`blog_post_id` bigint unsigned DEFAULT NULL,
`user_id` bigint unsigned DEFAULT NULL,
`ip_binary` varbinary(16) DEFAULT NULL,
`rating` tinyint(1) DEFAULT NULL,
`datetime` datetime DEFAULT NULL,
PRIMARY KEY (`id`),
UNIQUE KEY `blog_posts_ratings_blog_post_id_ip_binary_idx` (`blog_post_id`,`ip_binary`) USING BTREE,
KEY `user_id` (`user_id`),
CONSTRAINT `blog_posts_ratings_ibfk_1` FOREIGN KEY (`blog_post_id`) REFERENCES `blog_posts` (`blog_post_id`) ON DELETE CASCADE ON UPDATE CASCADE,
CONSTRAINT `blog_posts_ratings_ibfk_2` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- SEPARATOR --

CREATE TABLE `broadcasts` (
`broadcast_id` bigint unsigned NOT NULL AUTO_INCREMENT,
`name` varchar(64) DEFAULT NULL,
`subject` varchar(128) DEFAULT NULL,
`content` text,
`segment` varchar(64) DEFAULT NULL,
`settings` text COLLATE utf8mb4_unicode_ci,
`users_ids` longtext CHARACTER SET utf8mb4,
`sent_users_ids` longtext,
`sent_emails` int unsigned DEFAULT '0',
`total_emails` int unsigned DEFAULT '0',
`status` varchar(16) DEFAULT NULL,
`views` bigint unsigned DEFAULT '0',
`clicks` bigint unsigned DEFAULT '0',
`last_sent_email_datetime` datetime DEFAULT NULL,
`datetime` datetime DEFAULT NULL,
`last_datetime` datetime DEFAULT NULL,
PRIMARY KEY (`broadcast_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- SEPARATOR --

CREATE TABLE `broadcasts_statistics` (
`id` bigint unsigned NOT NULL AUTO_INCREMENT,
`user_id` bigint unsigned DEFAULT NULL,
`broadcast_id` bigint unsigned DEFAULT NULL,
`type` varchar(16) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
`target` varchar(2048) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
`datetime` datetime DEFAULT NULL,
PRIMARY KEY (`id`),
KEY `broadcast_id` (`broadcast_id`),
KEY `broadcasts_statistics_user_id_broadcast_id_type_index` (`broadcast_id`,`user_id`,`type`),
CONSTRAINT `broadcasts_statistics_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`) ON DELETE CASCADE ON UPDATE CASCADE,
CONSTRAINT `broadcasts_statistics_ibfk_2` FOREIGN KEY (`broadcast_id`) REFERENCES `broadcasts` (`broadcast_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- SEPARATOR --

CREATE TABLE `internal_notifications` (
`internal_notification_id` bigint unsigned NOT NULL AUTO_INCREMENT,
`user_id` bigint unsigned DEFAULT NULL,
`for_who` varchar(16) DEFAULT NULL,
`from_who` varchar(16) DEFAULT NULL,
`icon` varchar(64) DEFAULT NULL,
`title` varchar(128) DEFAULT NULL,
`description` varchar(1024) DEFAULT NULL,
`url` varchar(512) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
`is_read` tinyint unsigned DEFAULT '0',
`datetime` datetime DEFAULT NULL,
`read_datetime` datetime DEFAULT NULL,
PRIMARY KEY (`internal_notification_id`),
KEY `user_id` (`user_id`),
KEY `users_notifications_for_who_idx` (`for_who`) USING BTREE,
CONSTRAINT `internal_notifications_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- SEPARATOR --

CREATE TABLE `settings` (
`id` int NOT NULL AUTO_INCREMENT,
`key` varchar(64) NOT NULL DEFAULT '',
`value` longtext NOT NULL,
PRIMARY KEY (`id`),
UNIQUE KEY `key` (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- SEPARATOR --

SET @cron_key = MD5(RAND());

-- SEPARATOR --

INSERT INTO `settings` (`key`, `value`) VALUES
('main', '{"title":"Your title","default_language":"english","default_theme_style":"light","default_timezone":"UTC","index_url":"","terms_and_conditions_url":"","privacy_policy_url":"","not_found_url":"","ai_scraping_is_allowed":true,"se_indexing":true,"display_index_plans":true,"display_index_testimonials":true,"display_index_faq":true,"display_index_latest_blog_posts":true,"default_results_per_page":100,"default_order_type":"DESC","auto_language_detection_is_enabled":true,"blog_is_enabled":false,"api_is_enabled":true,"theme_style_change_is_enabled":true,"logo_light":"","logo_dark":"","logo_email":"","opengraph":"","favicon":"","openai_api_key":"","openai_model":"gpt-4o","force_https_is_enabled":false,"broadcasts_statistics_is_enabled":true,"breadcrumbs_is_enabled":true,"display_pagination_when_no_pages":false,"chart_cache":12,"chart_days":30}'),
('languages', '{"english":{"status":"active"}}'),
('users', '{"email_confirmation":false,"welcome_email_is_enabled":false,"register_is_enabled":true,"register_only_social_logins":false,"register_social_login_require_password":false,"register_display_newsletter_checkbox":false,"login_rememberme_checkbox_is_checked":true,"login_rememberme_cookie_days":90,"auto_delete_unconfirmed_users":3,"auto_delete_inactive_users":30,"user_deletion_reminder":0,"blacklisted_domains":[],"blacklisted_countries":[],"login_lockout_is_enabled":true,"login_lockout_max_retries":3,"login_lockout_time":10,"lost_password_lockout_is_enabled":true,"lost_password_lockout_max_retries":3,"lost_password_lockout_time":10,"resend_activation_lockout_is_enabled":true,"resend_activation_lockout_max_retries":3,"resend_activation_lockout_time":10,"register_lockout_is_enabled":true,"register_lockout_max_registrations":3,"register_lockout_time":10}'),
('ads', '{"ad_blocker_detector_is_enabled":true,"ad_blocker_detector_lock_is_enabled":false,"ad_blocker_detector_delay":5,"header":"","footer":"","header_biolink":"","footer_biolink":"","header_splash":"","footer_splash":""}'),
('captcha', '{\"type\":\"basic\",\"recaptcha_public_key\":\"\",\"recaptcha_private_key\":\"\",\"login_is_enabled\":0,\"register_is_enabled\":0,\"lost_password_is_enabled\":0,\"resend_activation_is_enabled\":0}'),
('cron', concat('{\"key\":\"', @cron_key, '\"}')),
('email_notifications', '{"emails":"","new_user":false,"delete_user":false,"new_payment":false,"new_domain":false,"new_affiliate_withdrawal":false,"contact":false}'),
('internal_notifications', '{"users_is_enabled":true,"admins_is_enabled":true,"new_user":true,"delete_user":true,"new_newsletter_subscriber":true,"new_payment":true,"new_affiliate_withdrawal":true}'),
('content', '{"blog_is_enabled":true,"blog_share_is_enabled":true,"blog_search_widget_is_enabled":false,"blog_categories_widget_is_enabled":true,"blog_popular_widget_is_enabled":true,"blog_views_is_enabled":true,"pages_is_enabled":true,"pages_share_is_enabled":true,"pages_popular_widget_is_enabled":true,"pages_views_is_enabled":true}'),
('sso', '{"is_enabled":true,"display_menu_items":true,"websites":{}}'),
('facebook', '{"is_enabled":false,"app_id":"","app_secret":""}'),
('google', '{"is_enabled":false,"client_id":"","client_secret":""}'),
('twitter', '{"is_enabled":false,"consumer_api_key":"","consumer_api_secret":""}'),
('discord', '{"is_enabled":false,"client_id":"","client_secret":""}'),
('linkedin', '{"is_enabled":false,"client_id":"","client_secret":""}'),
('microsoft', '{"is_enabled":false,"client_id":"","client_secret":""}'),
('plan_custom', '{"plan_id":"custom","name":"Custom","description":"Contact us for enterprise pricing.","price":"Custom","custom_button_url":"mailto:sample@example.com","color":null,"status":2,"settings":{}}'),
('plan_free', '{"plan_id":"free","name":"Free","description":"","price":"Free","color":null,"status":1,"settings":{"teams_limit":0,"team_members_limit":0,"api_is_enabled":true,"affiliate_is_enabled":false,"no_ads":true,"export": {"pdf": true,"csv": true,"json": true},"enabled_tools":{"dns_lookup":true,"ip_lookup":true,"reverse_ip_lookup":true,"ssl_lookup":true,"whois_lookup":true,"ping":true,"http_headers_lookup":true,"safe_url_checker":true,"google_cache_checker":true,"url_redirect_checker":true,"password_strength_checker":true,"meta_tags_checker":true,"website_hosting_checker":true,"file_mime_type_checker":true,"gravatar_checker":true,"text_separator":true,"email_extractor":true,"url_extractor":true,"text_size_calculator":true,"duplicate_lines_remover":true,"text_to_speech":true,"idn_punnycode_converter":true,"case_converter":true,"character_counter":true,"list_randomizer":true,"reverse_words":true,"reverse_letters":true,"emojis_remover":true,"reverse_list":true,"list_alphabetizer":true,"upside_down_text_generator":true,"old_english_text_generator":true,"cursive_text_generator":true,"base64_encoder":true,"base64_decoder":true,"base64_to_image":true,"image_to_base64":true,"url_encoder":true,"url_decoder":true,"color_converter":true,"binary_converter":true,"hex_converter":true,"ascii_converter":true,"decimal_converter":true,"octal_converter":true,"morse_converter":true,"number_to_words_converter":true,"paypal_link_generator":true,"signature_generator":true,"mailto_link_generator":true,"utm_link_generator":true,"whatsapp_link_generator":true,"youtube_timestamp_link_generator":true,"slug_generator":true,"lorem_ipsum_generator":true,"password_generator":true,"random_number_generator":true,"uuid_v4_generator":true,"bcrypt_generator":true,"md2_generator":true,"md4_generator":true,"md5_generator":true,"whirlpool_generator":true,"sha1_generator":true,"sha224_generator":true,"sha256_generator":true,"sha384_generator":true,"sha512_generator":true,"sha512_224_generator":true,"sha512_256_generator":true,"sha3_224_generator":true,"sha3_256_generator":true,"sha3_384_generator":true,"sha3_512_generator":true,"html_minifier":true,"css_minifier":true,"js_minifier":true,"json_validator_beautifier":true,"sql_beautifier":true,"html_entity_converter":true,"bbcode_to_html":true,"markdown_to_html":true,"html_tags_remover":true,"user_agent_parser":true,"url_parser":true,"png_to_jpg":true,"png_to_webp":true,"png_to_bmp":true,"png_to_gif":true,"png_to_ico":true,"jpg_to_png":true,"jpg_to_webp":true,"jpg_to_gif":true,"jpg_to_ico":true,"jpg_to_bmp":true,"webp_to_jpg":true,"webp_to_gif":true,"webp_to_png":true,"webp_to_bmp":true,"webp_to_ico":true,"bmp_to_jpg":true,"bmp_to_gif":true,"bmp_to_png":true,"bmp_to_webp":true,"bmp_to_ico":true,"ico_to_jpg":true,"ico_to_gif":true,"ico_to_png":true,"ico_to_webp":true,"ico_to_bmp":true,"gif_to_jpg":true,"gif_to_ico":true,"gif_to_png":true,"gif_to_webp":true,"gif_to_bmp":true,"heic_to_png":true,"heic_to_gif":true,"heic_to_jpg":true,"youtube_thumbnail_downloader":true,"image_optimizer":true,"qr_code_reader":true,"exif_reader":true,"color_picker":true,"hex_to_hexa":true,"hex_to_rgb":true,"hex_to_rgba":true,"hex_to_hsv":true,"hex_to_hsl":true,"hex_to_hsla":true,"hexa_to_hex":true,"hexa_to_rgb":true,"hexa_to_rgba":true,"hexa_to_hsv":true,"hexa_to_hsl":true,"hexa_to_hsla":true,"rgb_to_hex":true,"rgb_to_hexa":true,"rgb_to_rgba":true,"rgb_to_hsv":true,"rgb_to_hsl":true,"rgb_to_hsla":true,"rgba_to_hex":true,"rgba_to_hexa":true,"rgba_to_rgb":true,"rgba_to_hsv":true,"rgba_to_hsl":true,"rgba_to_hsla":true,"hsv_to_hex":true,"hsv_to_hexa":true,"hsv_to_rgb":true,"hsv_to_rgba":true,"hsv_to_hsl":true,"hsv_to_hsla":true,"hsl_to_hex":true,"hsl_to_hexa":true,"hsl_to_rgb":true,"hsl_to_rgba":true,"hsl_to_hsv":true,"hsl_to_hsla":true,"hsla_to_hex":true,"hsla_to_hexa":true,"hsla_to_rgb":true,"hsla_to_rgba":true,"hsla_to_hsv":true,"hsla_to_hsl":true,"celsius_to_fahrenheit":true,"celsius_to_kelvin":true,"fahrenheit_to_celsius":true,"fahrenheit_to_kelvin":true,"kelvin_to_celsius":true,"kelvin_to_fahrenheit":true,"miles_to_kilometers":true,"kilometers_to_miles":true,"miles_per_hour_to_kilometers_per_hour":true,"kilometers_per_hour_to_miles_per_hour":true,"kilograms_to_pounds":true,"pounds_to_kilograms":true,"number_to_roman_numerals":true,"roman_numerals_to_number":true,"liters_to_gallons_us":true,"liters_to_gallons_imperial":true,"gallons_us_to_liters":true,"gallons_imperial_to_liters":true,"unix_timestamp_to_date":true,"date_to_unix_timestamp":true,"seconds_to_minutes":true,"seconds_to_hours":true,"seconds_to_days":true,"seconds_to_weeks":true,"seconds_to_months":true,"seconds_to_years":true,"minutes_to_seconds":true,"minutes_to_hours":true,"minutes_to_days":true,"minutes_to_weeks":true,"minutes_to_months":true,"minutes_to_years":true,"hours_to_seconds":true,"hours_to_minutes":true,"hours_to_days":true,"hours_to_weeks":true,"hours_to_months":true,"hours_to_years":true,"days_to_seconds":true,"days_to_minutes":true,"days_to_hours":true,"days_to_weeks":true,"days_to_months":true,"days_to_years":true,"weeks_to_seconds":true,"weeks_to_minutes":true,"weeks_to_hours":true,"weeks_to_days":true,"weeks_to_months":true,"weeks_to_years":true,"months_to_seconds":true,"months_to_minutes":true,"months_to_hours":true,"months_to_days":true,"months_to_weeks":true,"months_to_years":true,"years_to_seconds":true,"years_to_minutes":true,"years_to_hours":true,"years_to_days":true,"years_to_weeks":true,"years_to_months":true,"bits_to_nibbles":true,"bits_to_bytes":true,"bits_to_kilobits":true,"bits_to_kibibits":true,"bits_to_kibibytes":true,"bits_to_kilobytes":true,"bits_to_megabits":true,"bits_to_mebibits":true,"bits_to_megabytes":true,"bits_to_mebibytes":true,"bits_to_gigabits":true,"bits_to_gibibits":true,"bits_to_gigabytes":true,"bits_to_gibibytes":true,"bits_to_terabits":true,"bits_to_tebibits":true,"bits_to_terabytes":true,"bits_to_tebibytes":true,"bits_to_petabits":true,"bits_to_petabytes":true,"bits_to_pebibytes":true,"bits_to_pebibits":true,"bits_to_exabits":true,"bits_to_exbibits":true,"bits_to_exabytes":true,"bits_to_exbibytes":true,"bits_to_zettabits":true,"bits_to_zebibits":true,"bits_to_zettabytes":true,"bits_to_zebibytes":true,"bits_to_yottabits":true,"bits_to_yobibits":true,"bits_to_yottabytes":true,"bits_to_yobibytes":true,"nibbles_to_bits":true,"nibbles_to_bytes":true,"nibbles_to_kilobits":true,"nibbles_to_kibibits":true,"nibbles_to_kilobytes":true,"nibbles_to_kibibytes":true,"nibbles_to_megabits":true,"nibbles_to_mebibits":true,"nibbles_to_megabytes":true,"nibbles_to_mebibytes":true,"nibbles_to_gigabits":true,"nibbles_to_gibibits":true,"nibbles_to_gigabytes":true,"nibbles_to_gibibytes":true,"nibbles_to_terabits":true,"nibbles_to_tebibits":true,"nibbles_to_terabytes":true,"nibbles_to_tebibytes":true,"nibbles_to_petabits":true,"nibbles_to_petabytes":true,"nibbles_to_pebibytes":true,"nibbles_to_pebibits":true,"nibbles_to_exabits":true,"nibbles_to_exbibits":true,"nibbles_to_exabytes":true,"nibbles_to_exbibytes":true,"nibbles_to_zettabits":true,"nibbles_to_zebibits":true,"nibbles_to_zettabytes":true,"nibbles_to_zebibytes":true,"nibbles_to_yottabits":true,"nibbles_to_yobibits":true,"nibbles_to_yottabytes":true,"nibbles_to_yobibytes":true,"bytes_to_bits":true,"bytes_to_nibbles":true,"bytes_to_kilobits":true,"bytes_to_kibibits":true,"bytes_to_kilobytes":true,"bytes_to_kibibytes":true,"bytes_to_megabits":true,"bytes_to_mebibits":true,"bytes_to_megabytes":true,"bytes_to_mebibytes":true,"bytes_to_gigabits":true,"bytes_to_gibibits":true,"bytes_to_gigabytes":true,"bytes_to_gibibytes":true,"bytes_to_terabits":true,"bytes_to_tebibits":true,"bytes_to_terabytes":true,"bytes_to_tebibytes":true,"bytes_to_petabits":true,"bytes_to_petabytes":true,"bytes_to_pebibytes":true,"bytes_to_pebibits":true,"bytes_to_exabits":true,"bytes_to_exbibits":true,"bytes_to_exabytes":true,"bytes_to_exbibytes":true,"bytes_to_zettabits":true,"bytes_to_zebibits":true,"bytes_to_zettabytes":true,"bytes_to_zebibytes":true,"bytes_to_yottabits":true,"bytes_to_yobibits":true,"bytes_to_yottabytes":true,"bytes_to_yobibytes":true}}}'),
('plan_guest', '{"plan_id":"guest","name":"Guest","description":"","price":"Free","color":null,"status":1,"settings":{"teams_limit":0,"team_members_limit":0,"api_is_enabled":true,"affiliate_is_enabled":false,"no_ads":true,"export": {"pdf": true,"csv": true,"json": true},"enabled_tools":{"dns_lookup":true,"ip_lookup":true,"reverse_ip_lookup":true,"ssl_lookup":true,"whois_lookup":true,"ping":true,"http_headers_lookup":true,"safe_url_checker":true,"google_cache_checker":true,"url_redirect_checker":true,"password_strength_checker":true,"meta_tags_checker":true,"website_hosting_checker":true,"file_mime_type_checker":true,"gravatar_checker":true,"text_separator":true,"email_extractor":true,"url_extractor":true,"text_size_calculator":true,"duplicate_lines_remover":true,"text_to_speech":true,"idn_punnycode_converter":true,"case_converter":true,"character_counter":true,"list_randomizer":true,"reverse_words":true,"reverse_letters":true,"emojis_remover":true,"reverse_list":true,"list_alphabetizer":true,"upside_down_text_generator":true,"old_english_text_generator":true,"cursive_text_generator":true,"base64_encoder":true,"base64_decoder":true,"base64_to_image":true,"image_to_base64":true,"url_encoder":true,"url_decoder":true,"color_converter":true,"binary_converter":true,"hex_converter":true,"ascii_converter":true,"decimal_converter":true,"octal_converter":true,"morse_converter":true,"number_to_words_converter":true,"paypal_link_generator":true,"signature_generator":true,"mailto_link_generator":true,"utm_link_generator":true,"whatsapp_link_generator":true,"youtube_timestamp_link_generator":true,"slug_generator":true,"lorem_ipsum_generator":true,"password_generator":true,"random_number_generator":true,"uuid_v4_generator":true,"bcrypt_generator":true,"md2_generator":true,"md4_generator":true,"md5_generator":true,"whirlpool_generator":true,"sha1_generator":true,"sha224_generator":true,"sha256_generator":true,"sha384_generator":true,"sha512_generator":true,"sha512_224_generator":true,"sha512_256_generator":true,"sha3_224_generator":true,"sha3_256_generator":true,"sha3_384_generator":true,"sha3_512_generator":true,"html_minifier":true,"css_minifier":true,"js_minifier":true,"json_validator_beautifier":true,"sql_beautifier":true,"html_entity_converter":true,"bbcode_to_html":true,"markdown_to_html":true,"html_tags_remover":true,"user_agent_parser":true,"url_parser":true,"png_to_jpg":true,"png_to_webp":true,"png_to_bmp":true,"png_to_gif":true,"png_to_ico":true,"jpg_to_png":true,"jpg_to_webp":true,"jpg_to_gif":true,"jpg_to_ico":true,"jpg_to_bmp":true,"webp_to_jpg":true,"webp_to_gif":true,"webp_to_png":true,"webp_to_bmp":true,"webp_to_ico":true,"bmp_to_jpg":true,"bmp_to_gif":true,"bmp_to_png":true,"bmp_to_webp":true,"bmp_to_ico":true,"ico_to_jpg":true,"ico_to_gif":true,"ico_to_png":true,"ico_to_webp":true,"ico_to_bmp":true,"gif_to_jpg":true,"gif_to_ico":true,"gif_to_png":true,"gif_to_webp":true,"gif_to_bmp":true,"heic_to_png":true,"heic_to_gif":true,"heic_to_jpg":true,"youtube_thumbnail_downloader":true,"image_optimizer":true,"qr_code_reader":true,"exif_reader":true,"color_picker":true,"hex_to_hexa":true,"hex_to_rgb":true,"hex_to_rgba":true,"hex_to_hsv":true,"hex_to_hsl":true,"hex_to_hsla":true,"hexa_to_hex":true,"hexa_to_rgb":true,"hexa_to_rgba":true,"hexa_to_hsv":true,"hexa_to_hsl":true,"hexa_to_hsla":true,"rgb_to_hex":true,"rgb_to_hexa":true,"rgb_to_rgba":true,"rgb_to_hsv":true,"rgb_to_hsl":true,"rgb_to_hsla":true,"rgba_to_hex":true,"rgba_to_hexa":true,"rgba_to_rgb":true,"rgba_to_hsv":true,"rgba_to_hsl":true,"rgba_to_hsla":true,"hsv_to_hex":true,"hsv_to_hexa":true,"hsv_to_rgb":true,"hsv_to_rgba":true,"hsv_to_hsl":true,"hsv_to_hsla":true,"hsl_to_hex":true,"hsl_to_hexa":true,"hsl_to_rgb":true,"hsl_to_rgba":true,"hsl_to_hsv":true,"hsl_to_hsla":true,"hsla_to_hex":true,"hsla_to_hexa":true,"hsla_to_rgb":true,"hsla_to_rgba":true,"hsla_to_hsv":true,"hsla_to_hsl":true,"celsius_to_fahrenheit":true,"celsius_to_kelvin":true,"fahrenheit_to_celsius":true,"fahrenheit_to_kelvin":true,"kelvin_to_celsius":true,"kelvin_to_fahrenheit":true,"miles_to_kilometers":true,"kilometers_to_miles":true,"miles_per_hour_to_kilometers_per_hour":true,"kilometers_per_hour_to_miles_per_hour":true,"kilograms_to_pounds":true,"pounds_to_kilograms":true,"number_to_roman_numerals":true,"roman_numerals_to_number":true,"liters_to_gallons_us":true,"liters_to_gallons_imperial":true,"gallons_us_to_liters":true,"gallons_imperial_to_liters":true,"unix_timestamp_to_date":true,"date_to_unix_timestamp":true,"seconds_to_minutes":true,"seconds_to_hours":true,"seconds_to_days":true,"seconds_to_weeks":true,"seconds_to_months":true,"seconds_to_years":true,"minutes_to_seconds":true,"minutes_to_hours":true,"minutes_to_days":true,"minutes_to_weeks":true,"minutes_to_months":true,"minutes_to_years":true,"hours_to_seconds":true,"hours_to_minutes":true,"hours_to_days":true,"hours_to_weeks":true,"hours_to_months":true,"hours_to_years":true,"days_to_seconds":true,"days_to_minutes":true,"days_to_hours":true,"days_to_weeks":true,"days_to_months":true,"days_to_years":true,"weeks_to_seconds":true,"weeks_to_minutes":true,"weeks_to_hours":true,"weeks_to_days":true,"weeks_to_months":true,"weeks_to_years":true,"months_to_seconds":true,"months_to_minutes":true,"months_to_hours":true,"months_to_days":true,"months_to_weeks":true,"months_to_years":true,"years_to_seconds":true,"years_to_minutes":true,"years_to_hours":true,"years_to_days":true,"years_to_weeks":true,"years_to_months":true,"bits_to_nibbles":true,"bits_to_bytes":true,"bits_to_kilobits":true,"bits_to_kibibits":true,"bits_to_kibibytes":true,"bits_to_kilobytes":true,"bits_to_megabits":true,"bits_to_mebibits":true,"bits_to_megabytes":true,"bits_to_mebibytes":true,"bits_to_gigabits":true,"bits_to_gibibits":true,"bits_to_gigabytes":true,"bits_to_gibibytes":true,"bits_to_terabits":true,"bits_to_tebibits":true,"bits_to_terabytes":true,"bits_to_tebibytes":true,"bits_to_petabits":true,"bits_to_petabytes":true,"bits_to_pebibytes":true,"bits_to_pebibits":true,"bits_to_exabits":true,"bits_to_exbibits":true,"bits_to_exabytes":true,"bits_to_exbibytes":true,"bits_to_zettabits":true,"bits_to_zebibits":true,"bits_to_zettabytes":true,"bits_to_zebibytes":true,"bits_to_yottabits":true,"bits_to_yobibits":true,"bits_to_yottabytes":true,"bits_to_yobibytes":true,"nibbles_to_bits":true,"nibbles_to_bytes":true,"nibbles_to_kilobits":true,"nibbles_to_kibibits":true,"nibbles_to_kilobytes":true,"nibbles_to_kibibytes":true,"nibbles_to_megabits":true,"nibbles_to_mebibits":true,"nibbles_to_megabytes":true,"nibbles_to_mebibytes":true,"nibbles_to_gigabits":true,"nibbles_to_gibibits":true,"nibbles_to_gigabytes":true,"nibbles_to_gibibytes":true,"nibbles_to_terabits":true,"nibbles_to_tebibits":true,"nibbles_to_terabytes":true,"nibbles_to_tebibytes":true,"nibbles_to_petabits":true,"nibbles_to_petabytes":true,"nibbles_to_pebibytes":true,"nibbles_to_pebibits":true,"nibbles_to_exabits":true,"nibbles_to_exbibits":true,"nibbles_to_exabytes":true,"nibbles_to_exbibytes":true,"nibbles_to_zettabits":true,"nibbles_to_zebibits":true,"nibbles_to_zettabytes":true,"nibbles_to_zebibytes":true,"nibbles_to_yottabits":true,"nibbles_to_yobibits":true,"nibbles_to_yottabytes":true,"nibbles_to_yobibytes":true,"bytes_to_bits":true,"bytes_to_nibbles":true,"bytes_to_kilobits":true,"bytes_to_kibibits":true,"bytes_to_kilobytes":true,"bytes_to_kibibytes":true,"bytes_to_megabits":true,"bytes_to_mebibits":true,"bytes_to_megabytes":true,"bytes_to_mebibytes":true,"bytes_to_gigabits":true,"bytes_to_gibibits":true,"bytes_to_gigabytes":true,"bytes_to_gibibytes":true,"bytes_to_terabits":true,"bytes_to_tebibits":true,"bytes_to_terabytes":true,"bytes_to_tebibytes":true,"bytes_to_petabits":true,"bytes_to_petabytes":true,"bytes_to_pebibytes":true,"bytes_to_pebibits":true,"bytes_to_exabits":true,"bytes_to_exbibits":true,"bytes_to_exabytes":true,"bytes_to_exbibytes":true,"bytes_to_zettabits":true,"bytes_to_zebibits":true,"bytes_to_zettabytes":true,"bytes_to_zebibytes":true,"bytes_to_yottabits":true,"bytes_to_yobibits":true,"bytes_to_yottabytes":true,"bytes_to_yobibytes":true}}}'),
('payment', '{"is_enabled":false,"type":"both","default_payment_frequency":"monthly","currencies":{"USD":{"code":"USD","symbol":"$","default_payment_processor":"offline_payment"}},"default_currency":"USD","codes_is_enabled":true,"taxes_and_billing_is_enabled":true,"invoice_is_enabled":true,"user_plan_expiry_reminder":0,"user_plan_expiry_checker_is_enabled":0,"currency_exchange_api_key":""}'),
('paypal', '{\"is_enabled\":\"0\",\"mode\":\"sandbox\",\"client_id\":\"\",\"secret\":\"\"}'),
('stripe', '{\"is_enabled\":\"0\",\"publishable_key\":\"\",\"secret_key\":\"\",\"webhook_secret\":\"\"}'),
('offline_payment', '{\"is_enabled\":\"0\",\"instructions\":\"Your offline payment instructions go here..\"}'),
('coinbase', '{"is_enabled":false,"api_key":"","webhook_secret":"","currencies":["USD"]}'),
('payu', '{"is_enabled":false,"mode":"sandbox","merchant_pos_id":"","signature_key":"","oauth_client_id":"","oauth_client_secret":"","currencies":["USD"]}'),
('iyzico', '{"is_enabled":false,"mode":"live","api_key":"","secret_key":"","currencies":["USD"]}'),
('paystack', '{"is_enabled":false,"public_key":"","secret_key":"","currencies":["USD"]}'),
('razorpay', '{"is_enabled":false,"key_id":"","key_secret":"","webhook_secret":"","currencies":["USD"]}'),
('mollie', '{"is_enabled":false,"api_key":""}'),
('yookassa', '{"is_enabled":false,"shop_id":"","secret_key":""}'),
('crypto_com', '{"is_enabled":false,"publishable_key":"","secret_key":"","webhook_secret":""}'),
('paddle', '{"is_enabled":false,"mode":"sandbox","vendor_id":"","api_key":"","public_key":"","currencies":["USD"]}'),
('mercadopago', '{"is_enabled":false,"access_token":"","currencies":["USD"]}'),
('midtrans', '{"is_enabled":false,"server_key":"","mode":"sandbox","currencies":["USD"]}'),
('flutterwave', '{"is_enabled":false,"secret_key":"","currencies":["USD"]}'),
('lemonsqueezy', '{"is_enabled":false,"api_key":"","signing_secret":"","store_id":"","one_time_monthly_variant_id":"","one_time_annual_variant_id":"","one_time_lifetime_variant_id":"","recurring_monthly_variant_id":"","recurring_annual_variant_id":"","currencies":["USD"]}'),
('myfatoorah', '{"is_enabled":1,"api_endpoint":"apitest.myfatoorah.com","api_key":"","secret_key":"","currencies":["KWD"]}'),
('smtp', '{"from_name":"AltumCode","from":"","reply_to_name":"","reply_to":"","cc":"","bcc":"","host":"","encryption":"tls","port":"","auth":0,"username":"","password":"","display_socials":false,"company_details":""}'),
('theme', '{"light_is_enabled": false, "dark_is_enabled": false}'),
('custom', '{"body_content":"","head_js":"","head_css":""}'),
('socials', '{"threads":"","youtube":"","facebook":"","x":"","instagram":"","tiktok":"","linkedin":"","whatsapp":"","email":""}'),
('announcements', '{"guests_is_enabled":0,"guests_id":"035cc337f6de075434bc24807b7ad9af","guests_content":"","guests_text_color":"#000000","guests_background_color":"#000000","users_is_enabled":0,"users_id":"035cc337f6de075434bc24807b7ad9af","users_content":"","users_text_color":"#000000","users_background_color":"#000000","translations":{"english":{"guests_content":"","users_content":""}}}'),
('business', '{\"brand_name\":\"66toolkit\",\"invoice_nr_prefix\":\"INVOICE-\",\"name\":\"\",\"address\":\"\",\"city\":\"\",\"county\":\"\",\"zip\":\"\",\"country\":\"AF\",\"email\":\"\",\"phone\":\"\",\"tax_type\":\"\",\"tax_id\":\"\",\"custom_key_one\":\"\",\"custom_value_one\":\"\",\"custom_key_two\":\"\",\"custom_value_two\":\"\"}'),
('webhooks', '{"user_new":"","user_delete":"","payment_new":"","code_redeemed":"","contact":"","cron_start":"","cron_end":"","domain_new":"","domain_update":""}'),
('tools', '{"available_tools":{"dns_lookup":true,"ip_lookup":true,"reverse_ip_lookup":true,"ssl_lookup":true,"whois_lookup":true,"ping":true,"http_headers_lookup":true,"safe_url_checker":true,"google_cache_checker":true,"url_redirect_checker":true,"password_strength_checker":true,"meta_tags_checker":true,"website_hosting_checker":true,"file_mime_type_checker":true,"gravatar_checker":true,"text_separator":true,"email_extractor":true,"url_extractor":true,"text_size_calculator":true,"duplicate_lines_remover":true,"text_to_speech":true,"idn_punnycode_converter":true,"case_converter":true,"character_counter":true,"list_randomizer":true,"reverse_words":true,"reverse_letters":true,"emojis_remover":true,"reverse_list":true,"list_alphabetizer":true,"upside_down_text_generator":true,"old_english_text_generator":true,"cursive_text_generator":true,"base64_encoder":true,"base64_decoder":true,"base64_to_image":true,"image_to_base64":true,"url_encoder":true,"url_decoder":true,"color_converter":true,"binary_converter":true,"hex_converter":true,"ascii_converter":true,"decimal_converter":true,"octal_converter":true,"morse_converter":true,"number_to_words_converter":true,"paypal_link_generator":true,"signature_generator":true,"mailto_link_generator":true,"utm_link_generator":true,"whatsapp_link_generator":true,"youtube_timestamp_link_generator":true,"slug_generator":true,"lorem_ipsum_generator":true,"password_generator":true,"random_number_generator":true,"uuid_v4_generator":true,"bcrypt_generator":true,"md2_generator":true,"md4_generator":true,"md5_generator":true,"whirlpool_generator":true,"sha1_generator":true,"sha224_generator":true,"sha256_generator":true,"sha384_generator":true,"sha512_generator":true,"sha512_224_generator":true,"sha512_256_generator":true,"sha3_224_generator":true,"sha3_256_generator":true,"sha3_384_generator":true,"sha3_512_generator":true,"html_minifier":true,"css_minifier":true,"js_minifier":true,"json_validator_beautifier":true,"sql_beautifier":true,"html_entity_converter":true,"bbcode_to_html":true,"markdown_to_html":true,"html_tags_remover":true,"user_agent_parser":true,"url_parser":true,"png_to_jpg":true,"png_to_webp":true,"png_to_bmp":true,"png_to_gif":true,"png_to_ico":true,"jpg_to_png":true,"jpg_to_webp":true,"jpg_to_gif":true,"jpg_to_ico":true,"jpg_to_bmp":true,"webp_to_jpg":true,"webp_to_gif":true,"webp_to_png":true,"webp_to_bmp":true,"webp_to_ico":true,"bmp_to_jpg":true,"bmp_to_gif":true,"bmp_to_png":true,"bmp_to_webp":true,"bmp_to_ico":true,"ico_to_jpg":true,"ico_to_gif":true,"ico_to_png":true,"ico_to_webp":true,"ico_to_bmp":true,"gif_to_jpg":true,"gif_to_ico":true,"gif_to_png":true,"gif_to_webp":true,"gif_to_bmp":true,"heic_to_png":true,"heic_to_gif":true,"heic_to_jpg":true,"youtube_thumbnail_downloader":true,"image_optimizer":true,"qr_code_reader":true,"exif_reader":true,"color_picker":true,"hex_to_hexa":true,"hex_to_rgb":true,"hex_to_rgba":true,"hex_to_hsv":true,"hex_to_hsl":true,"hex_to_hsla":true,"hexa_to_hex":true,"hexa_to_rgb":true,"hexa_to_rgba":true,"hexa_to_hsv":true,"hexa_to_hsl":true,"hexa_to_hsla":true,"rgb_to_hex":true,"rgb_to_hexa":true,"rgb_to_rgba":true,"rgb_to_hsv":true,"rgb_to_hsl":true,"rgb_to_hsla":true,"rgba_to_hex":true,"rgba_to_hexa":true,"rgba_to_rgb":true,"rgba_to_hsv":true,"rgba_to_hsl":true,"rgba_to_hsla":true,"hsv_to_hex":true,"hsv_to_hexa":true,"hsv_to_rgb":true,"hsv_to_rgba":true,"hsv_to_hsl":true,"hsv_to_hsla":true,"hsl_to_hex":true,"hsl_to_hexa":true,"hsl_to_rgb":true,"hsl_to_rgba":true,"hsl_to_hsv":true,"hsl_to_hsla":true,"hsla_to_hex":true,"hsla_to_hexa":true,"hsla_to_rgb":true,"hsla_to_rgba":true,"hsla_to_hsv":true,"hsla_to_hsl":true,"celsius_to_fahrenheit":true,"celsius_to_kelvin":true,"fahrenheit_to_celsius":true,"fahrenheit_to_kelvin":true,"kelvin_to_celsius":true,"kelvin_to_fahrenheit":true,"miles_to_kilometers":true,"kilometers_to_miles":true,"miles_per_hour_to_kilometers_per_hour":true,"kilometers_per_hour_to_miles_per_hour":true,"kilograms_to_pounds":true,"pounds_to_kilograms":true,"number_to_roman_numerals":true,"roman_numerals_to_number":true,"liters_to_gallons_us":true,"liters_to_gallons_imperial":true,"gallons_us_to_liters":true,"gallons_imperial_to_liters":true,"unix_timestamp_to_date":true,"date_to_unix_timestamp":true,"seconds_to_minutes":true,"seconds_to_hours":true,"seconds_to_days":true,"seconds_to_weeks":true,"seconds_to_months":true,"seconds_to_years":true,"minutes_to_seconds":true,"minutes_to_hours":true,"minutes_to_days":true,"minutes_to_weeks":true,"minutes_to_months":true,"minutes_to_years":true,"hours_to_seconds":true,"hours_to_minutes":true,"hours_to_days":true,"hours_to_weeks":true,"hours_to_months":true,"hours_to_years":true,"days_to_seconds":true,"days_to_minutes":true,"days_to_hours":true,"days_to_weeks":true,"days_to_months":true,"days_to_years":true,"weeks_to_seconds":true,"weeks_to_minutes":true,"weeks_to_hours":true,"weeks_to_days":true,"weeks_to_months":true,"weeks_to_years":true,"months_to_seconds":true,"months_to_minutes":true,"months_to_hours":true,"months_to_days":true,"months_to_weeks":true,"months_to_years":true,"years_to_seconds":true,"years_to_minutes":true,"years_to_hours":true,"years_to_days":true,"years_to_weeks":true,"years_to_months":true,"bits_to_nibbles":true,"bits_to_bytes":true,"bits_to_kilobits":true,"bits_to_kibibits":true,"bits_to_kibibytes":true,"bits_to_kilobytes":true,"bits_to_megabits":true,"bits_to_mebibits":true,"bits_to_megabytes":true,"bits_to_mebibytes":true,"bits_to_gigabits":true,"bits_to_gibibits":true,"bits_to_gigabytes":true,"bits_to_gibibytes":true,"bits_to_terabits":true,"bits_to_tebibits":true,"bits_to_terabytes":true,"bits_to_tebibytes":true,"bits_to_petabits":true,"bits_to_petabytes":true,"bits_to_pebibytes":true,"bits_to_pebibits":true,"bits_to_exabits":true,"bits_to_exbibits":true,"bits_to_exabytes":true,"bits_to_exbibytes":true,"bits_to_zettabits":true,"bits_to_zebibits":true,"bits_to_zettabytes":true,"bits_to_zebibytes":true,"bits_to_yottabits":true,"bits_to_yobibits":true,"bits_to_yottabytes":true,"bits_to_yobibytes":true,"nibbles_to_bits":true,"nibbles_to_bytes":true,"nibbles_to_kilobits":true,"nibbles_to_kibibits":true,"nibbles_to_kilobytes":true,"nibbles_to_kibibytes":true,"nibbles_to_megabits":true,"nibbles_to_mebibits":true,"nibbles_to_megabytes":true,"nibbles_to_mebibytes":true,"nibbles_to_gigabits":true,"nibbles_to_gibibits":true,"nibbles_to_gigabytes":true,"nibbles_to_gibibytes":true,"nibbles_to_terabits":true,"nibbles_to_tebibits":true,"nibbles_to_terabytes":true,"nibbles_to_tebibytes":true,"nibbles_to_petabits":true,"nibbles_to_petabytes":true,"nibbles_to_pebibytes":true,"nibbles_to_pebibits":true,"nibbles_to_exabits":true,"nibbles_to_exbibits":true,"nibbles_to_exabytes":true,"nibbles_to_exbibytes":true,"nibbles_to_zettabits":true,"nibbles_to_zebibits":true,"nibbles_to_zettabytes":true,"nibbles_to_zebibytes":true,"nibbles_to_yottabits":true,"nibbles_to_yobibits":true,"nibbles_to_yottabytes":true,"nibbles_to_yobibytes":true,"bytes_to_bits":true,"bytes_to_nibbles":true,"bytes_to_kilobits":true,"bytes_to_kibibits":true,"bytes_to_kilobytes":true,"bytes_to_kibibytes":true,"bytes_to_megabits":true,"bytes_to_mebibits":true,"bytes_to_megabytes":true,"bytes_to_mebibytes":true,"bytes_to_gigabits":true,"bytes_to_gibibits":true,"bytes_to_gigabytes":true,"bytes_to_gibibytes":true,"bytes_to_terabits":true,"bytes_to_tebibits":true,"bytes_to_terabytes":true,"bytes_to_tebibytes":true,"bytes_to_petabits":true,"bytes_to_petabytes":true,"bytes_to_pebibytes":true,"bytes_to_pebibits":true,"bytes_to_exabits":true,"bytes_to_exbibits":true,"bytes_to_exabytes":true,"bytes_to_exbibytes":true,"bytes_to_zettabits":true,"bytes_to_zebibits":true,"bytes_to_zettabytes":true,"bytes_to_zebibytes":true,"bytes_to_yottabits":true,"bytes_to_yobibits":true,"bytes_to_yottabytes":true,"bytes_to_yobibytes":true},"google_safe_browsing_is_enabled":false,"google_safe_browsing_api_key":""}'),
('cookie_consent', '{"is_enabled":false,"logging_is_enabled":false,"necessary_is_enabled":true,"analytics_is_enabled":true,"targeting_is_enabled":true,"layout":"bar","position_y":"middle","position_x":"center"}'),
('license', '{\"license\":\"Extended License\",\"type\":\"Extended License\"}'),
('product_info', '{\"version\":\"34.0.0\", \"code\":\"3400\"}');

-- SEPARATOR --

CREATE TABLE `projects` (
`project_id` bigint unsigned NOT NULL AUTO_INCREMENT,
`user_id` bigint unsigned DEFAULT NULL,
`name` varchar(128) DEFAULT NULL,
`color` varchar(16) DEFAULT '#000',
`last_datetime` datetime DEFAULT NULL,
`datetime` datetime DEFAULT NULL,
PRIMARY KEY (`project_id`),
UNIQUE KEY `project_id` (`project_id`),
KEY `user_id` (`user_id`),
CONSTRAINT `projects_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- SEPARATOR --

CREATE TABLE `tools_usage` (
`id` bigint unsigned NOT NULL AUTO_INCREMENT,
`tool_id` varchar(64) DEFAULT NULL,
`total_views` bigint unsigned DEFAULT '0',
`total_submissions` bigint unsigned DEFAULT '0',
`total_ratings` bigint unsigned DEFAULT '0',
`average_rating` float unsigned DEFAULT '0',
`data` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
PRIMARY KEY (`id`),
UNIQUE KEY `tools_usage_tool_id_idx` (`tool_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- SEPARATOR --

CREATE TABLE `tools_ratings` (
`id` bigint unsigned NOT NULL AUTO_INCREMENT,
`tool_id` varchar(64) DEFAULT NULL,
`user_id` bigint unsigned DEFAULT NULL,
`ip_binary` varbinary(16) DEFAULT '0',
`rating` tinyint(1) DEFAULT '0',
`datetime` datetime DEFAULT NULL,
PRIMARY KEY (`id`),
UNIQUE KEY `tools_usage_tool_id_idx` (`tool_id`) USING BTREE,
UNIQUE KEY `tools_ratings_tool_id_ip_binary_idx` (`tool_id`,`ip_binary`) USING BTREE,
KEY `user_id` (`user_id`),
CONSTRAINT `tools_ratings_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- SEPARATOR --

CREATE TABLE `codes` (
  `code_id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `name` varchar(64) DEFAULT NULL,
  `type` varchar(16) DEFAULT NULL,
  `days` int(11) UNSIGNED DEFAULT NULL,
  `code` varchar(32) NOT NULL DEFAULT '',
  `discount` int(11) UNSIGNED NOT NULL,
  `quantity` int(11) UNSIGNED NOT NULL DEFAULT '1',
  `redeemed` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `plans_ids` text DEFAULT NULL,
  `datetime` datetime NOT NULL,
  PRIMARY KEY (`code_id`),
  KEY `type` (`type`),
  KEY `code` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- SEPARATOR --

CREATE TABLE `payments` (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) UNSIGNED DEFAULT NULL,
  `plan_id` int(10) UNSIGNED DEFAULT NULL,
  `processor` varchar(16) DEFAULT NULL,
  `type` varchar(16) DEFAULT NULL,
  `frequency` varchar(16) DEFAULT NULL,
  `payment_id` varchar(128) DEFAULT NULL,
  `email` varchar(256) DEFAULT NULL,
  `name` varchar(256) DEFAULT NULL,
  `plan` text,
  `billing` text,
  `business` text,
  `taxes_ids` text,
  `base_amount` float DEFAULT NULL,
  `total_amount` float DEFAULT NULL,
  `total_amount_default_currency` float DEFAULT NULL,
  `code` varchar(32) DEFAULT NULL,
  `discount_amount` float DEFAULT NULL,
  `currency` varchar(4) DEFAULT NULL,
  `payment_proof` varchar(40) DEFAULT NULL,
  `status` tinyint(4) DEFAULT '1',
  `datetime` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `payments_user_id` (`user_id`),
  KEY `plan_id` (`plan_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- SEPARATOR --

CREATE TABLE `redeemed_codes` (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `code_id` int(10) UNSIGNED NOT NULL,
  `user_id` bigint(20) UNSIGNED NOT NULL,
  `datetime` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `code_id` (`code_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- SEPARATOR --

CREATE TABLE `taxes` (
  `tax_id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `name` varchar(64) DEFAULT NULL,
  `description` varchar(256) DEFAULT NULL,
  `value` int(11) DEFAULT NULL,
  `value_type` enum('percentage','fixed') DEFAULT NULL,
  `type` enum('inclusive','exclusive') DEFAULT NULL,
  `billing_type` enum('personal','business','both') DEFAULT NULL,
  `countries` text,
  `datetime` datetime DEFAULT NULL,
  PRIMARY KEY (`tax_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- SEPARATOR --

ALTER TABLE `payments`
  ADD CONSTRAINT `payments_plans_plan_id_fk` FOREIGN KEY (`plan_id`) REFERENCES `plans` (`plan_id`) ON DELETE SET NULL ON UPDATE CASCADE,
  ADD CONSTRAINT `payments_users_user_id_fk` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`) ON DELETE SET NULL ON UPDATE CASCADE;

-- SEPARATOR --

ALTER TABLE `redeemed_codes`
  ADD CONSTRAINT `redeemed_codes_ibfk_1` FOREIGN KEY (`code_id`) REFERENCES `codes` (`code_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `redeemed_codes_ibfk_2` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`) ON DELETE CASCADE ON UPDATE CASCADE;

-- SEPARATOR --

CREATE TABLE `affiliates_commissions` (
  `affiliate_commission_id` bigint(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `user_id` bigint(11) UNSIGNED DEFAULT NULL,
  `referred_user_id` bigint(11) UNSIGNED DEFAULT NULL,
  `payment_id` bigint(11) UNSIGNED DEFAULT NULL,
  `amount` float DEFAULT NULL,
  `currency` varchar(4) DEFAULT NULL,
  `is_withdrawn` tinyint(4) UNSIGNED DEFAULT '0',
  `datetime` datetime DEFAULT NULL,
  PRIMARY KEY (`affiliate_commission_id`),
  UNIQUE KEY `affiliate_commission_id` (`affiliate_commission_id`),
  KEY `user_id` (`user_id`),
  KEY `referred_user_id` (`referred_user_id`),
  KEY `payment_id` (`payment_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- SEPARATOR --

CREATE TABLE `affiliates_withdrawals` (
  `affiliate_withdrawal_id` bigint(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `user_id` bigint(11) UNSIGNED DEFAULT NULL,
  `amount` float DEFAULT NULL,
  `currency` varchar(4) DEFAULT NULL,
  `note` varchar(1024) DEFAULT NULL,
  `affiliate_commissions_ids` text,
  `is_paid` tinyint(4) UNSIGNED DEFAULT NULL,
  `datetime` datetime DEFAULT NULL,
  PRIMARY KEY (`affiliate_withdrawal_id`),
  UNIQUE KEY `affiliate_withdrawal_id` (`affiliate_withdrawal_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- SEPARATOR --

ALTER TABLE `affiliates_commissions`
  ADD CONSTRAINT `affiliates_commissions_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `affiliates_commissions_ibfk_2` FOREIGN KEY (`referred_user_id`) REFERENCES `users` (`user_id`) ON DELETE SET NULL ON UPDATE CASCADE,
  ADD CONSTRAINT `affiliates_commissions_ibfk_3` FOREIGN KEY (`payment_id`) REFERENCES `payments` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;


