<?php defined('ALTUMCODE') || die() ?>

<div class="container">
    <?= \Altum\Alerts::output_alerts() ?>

    <?php if(settings()->main->breadcrumbs_is_enabled): ?>
<nav aria-label="breadcrumb">
        <ol class="custom-breadcrumbs small">
            <li><a href="<?= url() ?>"><?= l('tools.breadcrumb') ?></a> <i class="fas fa-fw fa-angle-right"></i></li>
            <?php if(settings()->tools->categories_pages_is_enabled): ?>
            <li><a href="<?= url(str_replace('_', '-', \Altum\Router::$data['tools'][$data->tool]['category'])) ?>"><?= sprintf(l('tools_categories.breadcrumb'), l('tools.' . \Altum\Router::$data['tools'][$data->tool]['category'])) ?></a> <i class="fas fa-fw fa-angle-right"></i></li>
            <?php endif ?>
            <li class="active" aria-current="page"><?= l('tools.color_converter.name') ?></li>
        </ol>
    </nav>
<?php endif ?>

    <div class="row mb-4">
        <div class="col-12 col-lg d-flex align-items-center mb-3 mb-lg-0 text-truncate">
            <h1 class="h4 m-0 text-truncate"><?= l('tools.color_converter.name') ?></h1>

            <div class="ml-2">
                <span data-toggle="tooltip" title="<?= l('tools.color_converter.description') ?>">
                    <i class="fas fa-fw fa-info-circle text-muted"></i>
                </span>
            </div>
        </div>

        <?= $this->views['ratings'] ?>
    </div>

    <div class="card">
        <div class="card-body">

            <form action="" method="post" role="form">
                <input type="hidden" name="token" value="<?= \Altum\Csrf::get() ?>" />

                <div class="form-group">
                    <label for="color"><i class="fas fa-fw fa-palette fa-sm text-muted mr-1"></i> <?= l('tools.color_converter.color') ?></label>
                    <input type="text" id="color" name="color" class="form-control <?= \Altum\Alerts::has_field_errors('color') ? 'is-invalid' : null ?>" value="<?= $data->values['color'] ?>" required="required" />
                    <?= \Altum\Alerts::output_field_error('color') ?>
                    <small class="form-text text-muted"><?= l('tools.color_converter.color_help') ?></small>
                </div>

                <button type="submit" name="submit" class="btn btn-block btn-primary"><?= l('global.submit') ?></button>
            </form>

        </div>
    </div>

    <?php if(isset($data->result)): ?>
        <div class="mt-4">
            <div class="table-responsive table-custom-container">
                <table class="table table-custom">
                    <tbody>
                    <tr>
                        <td class="font-weight-bold">
                            <i class="fas fa-palette fa-fw fa-sm mr-1"></i> <?= l('tools.color_converter.color') ?>
                        </td>
                        <td style="background: <?= $data->result['hex'] ?>">
                        </td>
                        <td style="background: <?= $data->result['hex'] ?>">
                        </td>
                    </tr>

                    <?php foreach(['hex', 'hexa', 'rgb', 'rgba', 'hsv', 'hsl', 'hsla'] as $color_type): ?>
                    <tr>
                        <td class="font-weight-bold">
                            <?= l('tools.color_converter.' . $color_type) ?>
                        </td>
                        <td class="text-nowrap">
                            <?= $data->result[$color_type] ?>
                        </td>
                        <td>
                            <div class="d-flex justify-content-end">
                                <button
                                        type="button"
                                        class="btn btn-link text-secondary"
                                        data-toggle="tooltip"
                                        title="<?= l('global.clipboard_copy') ?>"
                                        aria-label="<?= l('global.clipboard_copy') ?>"
                                        data-copy="<?= l('global.clipboard_copy') ?>"
                                        data-copied="<?= l('global.clipboard_copied') ?>"
                                        data-clipboard-text="<?= $data->result[$color_type] ?>"
                                >
                                    <i class="fas fa-fw fa-sm fa-copy"></i>
                                </button>
                            </div>
                        </td>
                    </tr>
                    <?php endforeach ?>
                    </tbody>
                </table>
            </div>
        </div>
    <?php endif ?>

    <?= $this->views['extra_content'] ?>

    <?= $this->views['similar_tools'] ?>

    <?= $this->views['popular_tools'] ?>
</div>

<?php include_view(THEME_PATH . 'views/partials/clipboard_js.php') ?>
