<?php defined('ALTUMCODE') || die() ?>

<div class="container">
    <?= \Altum\Alerts::output_alerts() ?>

    <?php if(settings()->main->breadcrumbs_is_enabled): ?>
<nav aria-label="breadcrumb">
        <ol class="custom-breadcrumbs small">
            <li><a href="<?= url() ?>"><?= l('tools.breadcrumb') ?></a> <i class="fas fa-fw fa-angle-right"></i></li>
            <?php if(settings()->tools->categories_pages_is_enabled): ?>
            <li><a href="<?= url(str_replace('_', '-', \Altum\Router::$data['tools'][$data->tool]['category'])) ?>"><?= sprintf(l('tools_categories.breadcrumb'), l('tools.' . \Altum\Router::$data['tools'][$data->tool]['category'])) ?></a> <i class="fas fa-fw fa-angle-right"></i></li>
            <?php endif ?>
            <li class="active" aria-current="page"><?= l('tools.palindrome_checker.name') ?></li>
        </ol>
    </nav>
<?php endif ?>

    <div class="row mb-4">
        <div class="col-12 col-lg d-flex align-items-center mb-3 mb-lg-0 text-truncate">
            <h1 class="h4 m-0 text-truncate"><?= l('tools.palindrome_checker.name') ?></h1>

            <div class="ml-2">
                <span data-toggle="tooltip" title="<?= l('tools.palindrome_checker.description') ?>">
                    <i class="fas fa-fw fa-info-circle text-muted"></i>
                </span>
            </div>
        </div>

        <?= $this->views['ratings'] ?>
    </div>

    <div class="card">
        <div class="card-body">

            <form id="tool_form" action="" method="post" role="form" enctype="multipart/form-data">
                <input type="hidden" name="token" value="<?= \Altum\Csrf::get() ?>" />

                <div class="form-group">
                    <label for="text"><i class="fas fa-fw fa-paragraph fa-sm text-muted mr-1"></i> <?= l('tools.text') ?></label>
                    <textarea id="text" name="text" class="form-control <?= \Altum\Alerts::has_field_errors('text') ? 'is-invalid' : null ?>" required="required"><?= $data->values['text'] ?></textarea>
                    <?= \Altum\Alerts::output_field_error('text') ?>
                </div>

                <button type="submit" name="submit" class="btn btn-block btn-primary" data-is-ajax><?= l('global.submit') ?></button>
            </form>

        </div>
    </div>

    <div id="result_wrapper" class="mt-4 d-none">
        <div class="card">
            <div class="card-body">

                <div class="form-group">
                    <div class="d-flex justify-content-between align-items-center">
                        <label for="result"><?= l('tools.result') ?></label>
                        <div>
                            <button
                                    type="button"
                                    class="btn btn-link text-secondary"
                                    data-toggle="tooltip"
                                    title="<?= l('global.clipboard_copy') ?>"
                                    aria-label="<?= l('global.clipboard_copy') ?>"
                                    data-copy="<?= l('global.clipboard_copy') ?>"
                                    data-copied="<?= l('global.clipboard_copied') ?>"
                                    data-clipboard-target="#result"
                                    data-clipboard-text
                            >
                                <i class="fas fa-fw fa-sm fa-copy"></i>
                            </button>
                        </div>
                    </div>
                    <textarea id="result" class="form-control"></textarea>
                </div>

            </div>
        </div>
    </div>

    <?= $this->views['extra_content'] ?>

    <?= $this->views['similar_tools'] ?>

    <?= $this->views['popular_tools'] ?>
</div>

<?php include_view(THEME_PATH . 'views/partials/clipboard_js.php') ?>


<?php ob_start() ?>
<script>
    'use strict';

    let is_palindrome = (s,i) => {
        return (i=i||0)<0||i>=s.length>>1||s[i]==s[s.length-1-i]&&is_palindrome(s,++i);
    }

    let check = () => {
        const text = document.getElementById('text').value;

        if(!text) {
            /* Hide result wrapper */
            document.querySelector('#result_wrapper').classList.add('d-none');
            return;
        }

        pause_submit_button(document.querySelector('[type="submit"][name="submit"]'));

        /* Display result wrapper */
        document.querySelector('#result_wrapper').classList.remove('d-none');

        /* Result */
        let result = is_palindrome(text) ? <?= json_encode(l('global.yes')) ?> : <?= json_encode(l('global.no')) ?>;

        document.querySelector('#result').value = result;

        enable_submit_button(document.querySelector('[type="submit"][name="submit"]'));
    }

    ['change', 'paste', 'keyup'].forEach(event_type => {
        document.getElementById('text').addEventListener(event_type, check);
    });

    document.querySelector('#tool_form').addEventListener('submit', event => {
        event.preventDefault();
        check();
    });

    check();
</script>
<?php \Altum\Event::add_content(ob_get_clean(), 'javascript') ?>
